/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.peermanager.messaging.bittorrent;

import com.aelitis.azureus.core.networkmanager.RawMessage;
import com.aelitis.azureus.core.networkmanager.impl.RawMessageImpl;
import com.aelitis.azureus.core.peermanager.messaging.Message;
import com.aelitis.azureus.core.peermanager.messaging.MessageException;
import com.aelitis.azureus.core.peermanager.messaging.MessageManager;
import com.aelitis.azureus.core.peermanager.messaging.bittorrent.BTBitfield;
import com.aelitis.azureus.core.peermanager.messaging.bittorrent.BTCancel;
import com.aelitis.azureus.core.peermanager.messaging.bittorrent.BTChoke;
import com.aelitis.azureus.core.peermanager.messaging.bittorrent.BTHandshake;
import com.aelitis.azureus.core.peermanager.messaging.bittorrent.BTHave;
import com.aelitis.azureus.core.peermanager.messaging.bittorrent.BTInterested;
import com.aelitis.azureus.core.peermanager.messaging.bittorrent.BTKeepAlive;
import com.aelitis.azureus.core.peermanager.messaging.bittorrent.BTPiece;
import com.aelitis.azureus.core.peermanager.messaging.bittorrent.BTRequest;
import com.aelitis.azureus.core.peermanager.messaging.bittorrent.BTUnchoke;
import com.aelitis.azureus.core.peermanager.messaging.bittorrent.BTUninterested;
import java.util.HashMap;
import java.util.Map;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DirectByteBuffer;
import org.gudy.azureus2.core3.util.DirectByteBufferPool;

public class BTMessageFactory {
    private static final LogIDs LOGID = LogIDs.PEER;
    private static final Map legacy_data = new HashMap();

    public static void init() {
        try {
            MessageManager.getSingleton().registerMessageType(new BTBitfield(null));
            MessageManager.getSingleton().registerMessageType(new BTCancel(-1, -1, -1));
            MessageManager.getSingleton().registerMessageType(new BTChoke());
            MessageManager.getSingleton().registerMessageType(new BTHandshake(new byte[0], new byte[0], true));
            MessageManager.getSingleton().registerMessageType(new BTHave(-1));
            MessageManager.getSingleton().registerMessageType(new BTInterested());
            MessageManager.getSingleton().registerMessageType(new BTKeepAlive());
            MessageManager.getSingleton().registerMessageType(new BTPiece(-1, -1, null));
            MessageManager.getSingleton().registerMessageType(new BTRequest(-1, -1, -1));
            MessageManager.getSingleton().registerMessageType(new BTUnchoke());
            MessageManager.getSingleton().registerMessageType(new BTUninterested());
        }
        catch (MessageException me) {
            me.printStackTrace();
        }
    }

    public static Message createBTMessage(DirectByteBuffer stream_payload) throws MessageException {
        byte id = stream_payload.get((byte)11);
        switch (id) {
            case 0: {
                return MessageManager.getSingleton().createMessage("BT_CHOKE", stream_payload);
            }
            case 1: {
                return MessageManager.getSingleton().createMessage("BT_UNCHOKE", stream_payload);
            }
            case 2: {
                return MessageManager.getSingleton().createMessage("BT_INTERESTED", stream_payload);
            }
            case 3: {
                return MessageManager.getSingleton().createMessage("BT_UNINTERESTED", stream_payload);
            }
            case 4: {
                return MessageManager.getSingleton().createMessage("BT_HAVE", stream_payload);
            }
            case 5: {
                return MessageManager.getSingleton().createMessage("BT_BITFIELD", stream_payload);
            }
            case 6: {
                return MessageManager.getSingleton().createMessage("BT_REQUEST", stream_payload);
            }
            case 7: {
                return MessageManager.getSingleton().createMessage("BT_PIECE", stream_payload);
            }
            case 8: {
                return MessageManager.getSingleton().createMessage("BT_CANCEL", stream_payload);
            }
            case 20: {
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent(LOGID, 1, "Old extended messaging hello received, ignoring and faking as keep-alive."));
                }
                return MessageManager.getSingleton().createMessage("BT_KEEP_ALIVE", null);
            }
        }
        System.out.println("Unknown BT message id [" + id + "]");
        throw new MessageException("Unknown BT message id [" + id + "]");
    }

    public static RawMessage createBTRawMessage(Message base_message) {
        if (base_message instanceof RawMessage) {
            return (RawMessage)base_message;
        }
        LegacyData ld = (LegacyData)legacy_data.get(base_message.getID());
        if (ld == null) {
            Debug.out("legacy message type id not found for [" + base_message.getID() + "]");
            return null;
        }
        DirectByteBuffer[] payload = base_message.getData();
        int payload_size = 0;
        for (int i = 0; i < payload.length; ++i) {
            payload_size += payload[i].remaining((byte)11);
        }
        DirectByteBuffer header = DirectByteBufferPool.getBuffer((byte)21, 5);
        header.putInt((byte)11, 1 + payload_size);
        header.put((byte)11, ld.bt_id);
        header.flip((byte)11);
        DirectByteBuffer[] raw_buffs = new DirectByteBuffer[payload.length + 1];
        raw_buffs[0] = header;
        for (int i = 0; i < payload.length; ++i) {
            raw_buffs[i + 1] = payload[i];
        }
        return new RawMessageImpl(base_message, raw_buffs, ld.priority, ld.is_no_delay, ld.to_remove);
    }

    static {
        legacy_data.put("BT_CHOKE", new LegacyData(2, true, new Message[]{new BTUnchoke(), new BTPiece(-1, -1, null)}, 0));
        legacy_data.put("BT_UNCHOKE", new LegacyData(1, true, new Message[]{new BTChoke()}, 1));
        legacy_data.put("BT_INTERESTED", new LegacyData(2, true, new Message[]{new BTUninterested()}, 2));
        legacy_data.put("BT_UNINTERESTED", new LegacyData(1, false, new Message[]{new BTInterested()}, 3));
        legacy_data.put("BT_HAVE", new LegacyData(0, false, null, 4));
        legacy_data.put("BT_BITFIELD", new LegacyData(2, true, null, 5));
        legacy_data.put("BT_REQUEST", new LegacyData(1, true, null, 6));
        legacy_data.put("BT_PIECE", new LegacyData(0, false, null, 7));
        legacy_data.put("BT_CANCEL", new LegacyData(2, true, null, 8));
    }

    protected static class LegacyData {
        protected final int priority;
        protected final boolean is_no_delay;
        protected final Message[] to_remove;
        protected final byte bt_id;

        protected LegacyData(int prio, boolean no_delay, Message[] remove, byte btid) {
            this.priority = prio;
            this.is_no_delay = no_delay;
            this.to_remove = remove;
            this.bt_id = btid;
        }
    }
}

