/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.networkmanager.impl;

import com.aelitis.azureus.core.networkmanager.LimitedRateGroup;
import com.aelitis.azureus.core.networkmanager.NetworkConnection;
import com.aelitis.azureus.core.networkmanager.NetworkManager;
import com.aelitis.azureus.core.networkmanager.impl.ByteBucket;
import com.aelitis.azureus.core.networkmanager.impl.EntityHandler;
import com.aelitis.azureus.core.networkmanager.impl.NetworkManagerUtilities;
import com.aelitis.azureus.core.networkmanager.impl.RateHandler;
import java.util.HashMap;
import org.gudy.azureus2.core3.util.AEMonitor;

public class TransferProcessor {
    public static final int TYPE_UPLOAD = 0;
    public static final int TYPE_DOWNLOAD = 1;
    private final LimitedRateGroup max_rate;
    private final ByteBucket main_bucket;
    private final EntityHandler main_controller;
    private final HashMap group_buckets = new HashMap();
    private final HashMap connections = new HashMap();
    private final AEMonitor connections_mon;

    public TransferProcessor(int processor_type, LimitedRateGroup max_rate_limit) {
        this.max_rate = max_rate_limit;
        this.connections_mon = new AEMonitor("TransferProcessor:" + processor_type);
        this.main_bucket = new ByteBucket(this.max_rate.getRateLimitBytesPerSecond());
        this.main_controller = new EntityHandler(processor_type, new RateHandler(){

            public int getCurrentNumBytesAllowed() {
                if (TransferProcessor.this.main_bucket.getRate() != TransferProcessor.this.max_rate.getRateLimitBytesPerSecond()) {
                    TransferProcessor.this.main_bucket.setRate(TransferProcessor.this.max_rate.getRateLimitBytesPerSecond());
                }
                return TransferProcessor.this.main_bucket.getAvailableByteCount();
            }

            public void bytesProcessed(int num_bytes_written) {
                TransferProcessor.this.main_bucket.setBytesUsed(num_bytes_written);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerPeerConnection(NetworkConnection connection, LimitedRateGroup group) {
        ConnectionData conn_data = new ConnectionData();
        try {
            this.connections_mon.enter();
            GroupData group_data = (GroupData)this.group_buckets.get(group);
            if (group_data == null) {
                int limit = NetworkManagerUtilities.getGroupRateLimit(group);
                group_data = new GroupData(new ByteBucket(limit));
                this.group_buckets.put(group, group_data);
            }
            group_data.group_size++;
            conn_data.group = group;
            conn_data.group_data = group_data;
            conn_data.state = 0;
            this.connections.put(connection, conn_data);
        }
        finally {
            this.connections_mon.exit();
        }
        this.main_controller.registerPeerConnection(connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deregisterPeerConnection(NetworkConnection connection) {
        try {
            this.connections_mon.enter();
            ConnectionData conn_data = (ConnectionData)this.connections.remove(connection);
            if (conn_data != null) {
                if (conn_data.group_data.group_size == 1) {
                    this.group_buckets.remove(conn_data.group);
                } else {
                    conn_data.group_data.group_size--;
                }
            }
        }
        finally {
            this.connections_mon.exit();
        }
        this.main_controller.cancelPeerConnection(connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void upgradePeerConnection(NetworkConnection connection) {
        ConnectionData connection_data = null;
        try {
            this.connections_mon.enter();
            connection_data = (ConnectionData)this.connections.get(connection);
        }
        finally {
            this.connections_mon.exit();
        }
        if (connection_data != null && connection_data.state == 0) {
            final ConnectionData conn_data = connection_data;
            this.main_controller.upgradePeerConnection(connection, new RateHandler(){

                public int getCurrentNumBytesAllowed() {
                    if (TransferProcessor.this.main_bucket.getRate() != TransferProcessor.this.max_rate.getRateLimitBytesPerSecond()) {
                        TransferProcessor.this.main_bucket.setRate(TransferProcessor.this.max_rate.getRateLimitBytesPerSecond());
                    }
                    int group_rate = NetworkManagerUtilities.getGroupRateLimit(conn_data.group);
                    if (conn_data.group_data.bucket.getRate() != group_rate) {
                        conn_data.group_data.bucket.setRate(group_rate);
                    }
                    int group_allowed = conn_data.group_data.bucket.getAvailableByteCount();
                    int global_allowed = TransferProcessor.this.main_bucket.getAvailableByteCount();
                    if ((global_allowed -= NetworkManager.getTcpMssSize()) < 0) {
                        global_allowed = 0;
                    }
                    int allowed = group_allowed > global_allowed ? global_allowed : group_allowed;
                    return allowed;
                }

                public void bytesProcessed(int num_bytes_written) {
                    conn_data.group_data.bucket.setBytesUsed(num_bytes_written);
                    TransferProcessor.this.main_bucket.setBytesUsed(num_bytes_written);
                }
            });
            conn_data.state = 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void downgradePeerConnection(NetworkConnection connection) {
        ConnectionData conn_data = null;
        try {
            this.connections_mon.enter();
            conn_data = (ConnectionData)this.connections.get(connection);
        }
        finally {
            this.connections_mon.exit();
        }
        if (conn_data != null && conn_data.state == 1) {
            this.main_controller.downgradePeerConnection(connection);
            conn_data.state = 0;
        }
    }

    private static class GroupData {
        private final ByteBucket bucket;
        private int group_size = 0;

        private GroupData(ByteBucket bucket) {
            this.bucket = bucket;
        }
    }

    private static class ConnectionData {
        private static final int STATE_NORMAL = 0;
        private static final int STATE_UPGRADED = 1;
        private int state;
        private LimitedRateGroup group;
        private GroupData group_data;

        private ConnectionData() {
        }
    }
}

