/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.networkmanager.impl;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.Key;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.crypto.engines.RC4Engine;
import org.bouncycastle.crypto.params.KeyParameter;
import org.gudy.azureus2.core3.util.Debug;

public class TCPTransportCipher {
    private static boolean internal_rc4 = true;
    private Cipher cipher;
    private RC4Engine rc4_engine;

    protected TCPTransportCipher(String algorithm, int mode, SecretKeySpec key_spec, AlgorithmParameterSpec params) throws Exception {
        this.cipher = Cipher.getInstance(algorithm);
        this.cipher.init(mode, (Key)key_spec, params);
    }

    TCPTransportCipher(String algorithm, int mode, SecretKeySpec key_spec) throws Exception {
        if (algorithm.equals("RC4")) {
            if (!internal_rc4) {
                try {
                    this.cipher = Cipher.getInstance(algorithm);
                    this.cipher.init(mode, key_spec);
                }
                catch (Throwable e) {
                    internal_rc4 = true;
                }
            }
            if (internal_rc4) {
                this.rc4_engine = new RC4Engine();
                KeyParameter params = new KeyParameter(key_spec.getEncoded());
                this.rc4_engine.init(mode == 1, params);
            }
            byte[] temp = new byte[1024];
            temp = this.update(temp);
        } else {
            this.cipher = Cipher.getInstance(algorithm);
            this.cipher.init(mode, key_spec);
        }
    }

    protected byte[] update(byte[] data) {
        return this.update(data, 0, data.length);
    }

    protected byte[] update(byte[] data, int offset, int length) {
        byte[] result;
        if (length == 0) {
            result = new byte[]{};
        } else if (this.cipher != null) {
            result = this.cipher.update(data, offset, length);
        } else {
            result = new byte[length];
            this.rc4_engine.processBytes(data, offset, length, result, 0);
        }
        return result;
    }

    protected void update(ByteBuffer source_buffer, ByteBuffer target_buffer) throws IOException {
        try {
            int offset;
            byte[] source_bytes;
            int length = source_buffer.remaining();
            if (source_buffer.hasArray()) {
                source_bytes = source_buffer.array();
                offset = source_buffer.arrayOffset() + source_buffer.position();
            } else {
                source_bytes = new byte[length];
                offset = 0;
                source_buffer.get(source_bytes);
            }
            byte[] target_bytes = this.update(source_bytes, offset, length);
            source_buffer.position(source_buffer.limit());
            target_buffer.put(target_bytes);
        }
        catch (Throwable e) {
            throw new IOException(Debug.getNestedExceptionMessage(e));
        }
    }

    public String getName() {
        if (this.cipher != null) {
            String s = this.cipher.getAlgorithm();
            int pos = s.indexOf("/");
            if (pos != -1) {
                s = s.substring(0, pos);
            }
            s = s.equals("RC4") ? "RC4-160" : s + "-" + this.cipher.getBlockSize() * 8;
            return s;
        }
        return "RC4-160";
    }
}

