/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.instancemanager.impl;

import com.aelitis.azureus.core.instancemanager.AZInstance;
import com.aelitis.azureus.core.instancemanager.AZInstanceManagerListener;
import com.aelitis.azureus.core.instancemanager.AZInstanceTracked;
import com.aelitis.azureus.core.instancemanager.impl.AZInstanceManagerImpl;
import java.net.InetAddress;
import org.gudy.azureus2.core3.logging.LogAlert;
import org.gudy.azureus2.core3.logging.Logger;

public class AZPortClashHandler
implements AZInstanceManagerListener {
    private AZInstance my_instance;
    private int last_warned_tcp;
    private int last_warned_udp;

    protected AZPortClashHandler(AZInstanceManagerImpl inst_man) {
        this.my_instance = inst_man.getMyInstance();
        inst_man.addListener(this);
    }

    protected void check(AZInstance instance) {
        if (instance == this.my_instance) {
            return;
        }
        InetAddress my_ext = this.my_instance.getExternalAddress();
        InetAddress other_ext = instance.getExternalAddress();
        if (my_ext.isLoopbackAddress() || other_ext.isLoopbackAddress() || my_ext.equals(other_ext)) {
            int my_udp;
            String warning = null;
            int my_tcp = this.my_instance.getTrackerClientPort();
            if (my_tcp != 0 && my_tcp != this.last_warned_tcp && my_tcp == instance.getTrackerClientPort()) {
                warning = "TCP " + my_tcp;
                this.last_warned_tcp = my_tcp;
            }
            if ((my_udp = this.my_instance.getDHTPort()) != 0 && my_udp != this.last_warned_udp && my_udp == instance.getDHTPort()) {
                warning = (warning == null ? "" : warning + ", ") + "UDP " + my_udp;
                this.last_warned_udp = my_udp;
            }
            if (warning != null) {
                Logger.logTextResource(new LogAlert(true, 1, "azinstancehandler.alert.portclash"), new String[]{warning, String.valueOf(10000), String.valueOf(65535)});
            }
        }
    }

    public void instanceFound(AZInstance instance) {
        this.check(instance);
    }

    public void instanceChanged(AZInstance instance) {
        this.check(instance);
    }

    public void instanceLost(AZInstance instance) {
    }

    public void instanceTracked(AZInstanceTracked instance) {
    }
}

