/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.instancemanager.impl;

import com.aelitis.azureus.core.instancemanager.impl.AZInstanceImpl;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SystemTime;

public class AZOtherInstanceImpl
extends AZInstanceImpl {
    private String id;
    private List internal_addresses = new ArrayList();
    private InetAddress external_address;
    private int tcp_port;
    private int udp_port;
    private long alive_time;

    protected static AZOtherInstanceImpl decode(InetAddress internal_address, Map map) {
        String id = new String((byte[])map.get("id"));
        String int_ip = new String((byte[])map.get("iip"));
        String ext_ip = new String((byte[])map.get("eip"));
        int tcp = ((Long)map.get("tp")).intValue();
        int udp = ((Long)map.get("dp")).intValue();
        try {
            if (!int_ip.equals("0.0.0.0")) {
                internal_address = InetAddress.getByName(int_ip);
            }
            InetAddress external_address = InetAddress.getByName(ext_ip);
            return new AZOtherInstanceImpl(id, internal_address, external_address, tcp, udp);
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
            return null;
        }
    }

    protected AZOtherInstanceImpl(String _id, InetAddress _internal_address, InetAddress _external_address, int _tcp_port, int _udp_port) {
        this.id = _id;
        this.internal_addresses.add(_internal_address);
        this.external_address = _external_address;
        this.tcp_port = _tcp_port;
        this.udp_port = _udp_port;
        this.alive_time = SystemTime.getCurrentTime();
    }

    protected boolean update(AZOtherInstanceImpl new_inst) {
        this.alive_time = SystemTime.getCurrentTime();
        InetAddress new_address = new_inst.getInternalAddress();
        boolean same = true;
        if (!this.internal_addresses.contains(new_address)) {
            same = false;
            ArrayList<InetAddress> new_addresses = new ArrayList<InetAddress>(this.internal_addresses);
            new_addresses.add(0, new_address);
            this.internal_addresses = new_addresses;
        }
        same = same && this.external_address.equals(new_inst.external_address) && this.tcp_port == new_inst.tcp_port && this.udp_port == new_inst.udp_port;
        this.external_address = new_inst.external_address;
        this.tcp_port = new_inst.tcp_port;
        this.udp_port = new_inst.udp_port;
        return !same;
    }

    public String getID() {
        return this.id;
    }

    public InetAddress getInternalAddress() {
        return (InetAddress)this.internal_addresses.get(0);
    }

    protected List getInternalAddresses() {
        return this.internal_addresses;
    }

    public InetAddress getExternalAddress() {
        return this.external_address;
    }

    public int getTrackerClientPort() {
        return this.tcp_port;
    }

    public int getDHTPort() {
        return this.udp_port;
    }

    protected long getAliveTime() {
        long now = SystemTime.getCurrentTime();
        if (now < this.alive_time) {
            this.alive_time = now;
        }
        return this.alive_time;
    }
}

