/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.diskmanager.access.impl;

import com.aelitis.azureus.core.diskmanager.access.DiskAccessController;
import com.aelitis.azureus.core.diskmanager.access.DiskAccessRequest;
import com.aelitis.azureus.core.diskmanager.access.DiskAccessRequestListener;
import com.aelitis.azureus.core.diskmanager.access.impl.DiskAccessControllerInstance;
import com.aelitis.azureus.core.diskmanager.access.impl.DiskAccessRequestImpl;
import com.aelitis.azureus.core.diskmanager.cache.CacheFile;
import org.gudy.azureus2.core3.util.DirectByteBuffer;

public class DiskAccessControllerImpl
implements DiskAccessController {
    private DiskAccessControllerInstance read_dispatcher;
    private DiskAccessControllerInstance write_dispatcher;

    public DiskAccessControllerImpl(int _max_read_threads, int _max_read_mb, int _max_write_threads, int _max_write_mb) {
        this.read_dispatcher = new DiskAccessControllerInstance("read", _max_read_threads, _max_read_mb);
        this.write_dispatcher = new DiskAccessControllerInstance("write", _max_write_threads, _max_write_mb);
    }

    public DiskAccessRequest queueReadRequest(CacheFile file, long offset, DirectByteBuffer buffer, short cache_policy, DiskAccessRequestListener listener) {
        DiskAccessRequestImpl request2 = new DiskAccessRequestImpl(file, offset, buffer, listener, 1, cache_policy);
        this.read_dispatcher.queueRequest(request2);
        return request2;
    }

    public DiskAccessRequest queueWriteRequest(CacheFile file, long offset, DirectByteBuffer buffer, boolean free_buffer, DiskAccessRequestListener listener) {
        DiskAccessRequestImpl request2 = new DiskAccessRequestImpl(file, offset, buffer, listener, free_buffer ? (short)3 : 2, 0);
        this.write_dispatcher.queueRequest(request2);
        return request2;
    }
}

