/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.dht.transport.util;

import com.aelitis.azureus.core.dht.transport.DHTTransportContact;
import com.aelitis.azureus.core.dht.transport.DHTTransportFindValueReply;
import com.aelitis.azureus.core.dht.transport.DHTTransportFullStats;
import com.aelitis.azureus.core.dht.transport.DHTTransportRequestHandler;
import com.aelitis.azureus.core.dht.transport.DHTTransportValue;
import com.aelitis.azureus.core.dht.transport.util.DHTTransportStatsImpl;

public class DHTTransportRequestCounter
implements DHTTransportRequestHandler {
    private DHTTransportRequestHandler delegate;
    private DHTTransportStatsImpl stats;

    public DHTTransportRequestCounter(DHTTransportRequestHandler _delegate, DHTTransportStatsImpl _stats) {
        this.delegate = _delegate;
        this.stats = _stats;
    }

    public void pingRequest(DHTTransportContact contact) {
        this.stats.pingReceived();
        this.delegate.pingRequest(contact);
    }

    public DHTTransportFullStats statsRequest(DHTTransportContact contact) {
        this.stats.statsReceived();
        return this.delegate.statsRequest(contact);
    }

    public byte[] storeRequest(DHTTransportContact contact, byte[][] keys, DHTTransportValue[][] value_sets) {
        this.stats.storeReceived();
        return this.delegate.storeRequest(contact, keys, value_sets);
    }

    public DHTTransportContact[] findNodeRequest(DHTTransportContact contact, byte[] id) {
        this.stats.findNodeReceived();
        return this.delegate.findNodeRequest(contact, id);
    }

    public DHTTransportFindValueReply findValueRequest(DHTTransportContact contact, byte[] key, int max, byte flags) {
        this.stats.findValueReceived();
        return this.delegate.findValueRequest(contact, key, max, flags);
    }

    public void contactImported(DHTTransportContact contact) {
        this.delegate.contactImported(contact);
    }

    public void contactRemoved(DHTTransportContact contact) {
        this.delegate.contactRemoved(contact);
    }

    public int getTransportEstimatedDHTSize() {
        return this.delegate.getTransportEstimatedDHTSize();
    }

    public void setTransportEstimatedDHTSize(int size) {
        this.delegate.setTransportEstimatedDHTSize(size);
    }
}

