/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.dht.db.impl;

import com.aelitis.azureus.core.dht.DHTStorageKey;
import com.aelitis.azureus.core.dht.db.impl.DHTDBImpl;
import com.aelitis.azureus.core.dht.db.impl.DHTDBValueImpl;
import com.aelitis.azureus.core.dht.impl.DHTLog;
import com.aelitis.azureus.core.dht.transport.DHTTransportContact;
import com.aelitis.azureus.core.util.bloom.BloomFilter;
import com.aelitis.azureus.core.util.bloom.BloomFilterFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.HashWrapper;

public class DHTDBMapping {
    private static final boolean TRACE_ADDS = false;
    private DHTDBImpl db;
    private HashWrapper key;
    private DHTStorageKey adapter_key;
    private Map direct_originator_map = new LinkedHashMap(16, 0.75f, true);
    private Map indirect_originator_value_map = new LinkedHashMap(16, 0.75f, true);
    private int hits;
    private int direct_data_size;
    private int indirect_data_size;
    private int local_size;
    private byte diversification_state = 1;
    private static final int IP_COUNT_BLOOM_SIZE_INCREASE_CHUNK = 50;
    private BloomFilter ip_count_bloom_filter = BloomFilterFactory.createAddRemove4Bit(50);

    protected DHTDBMapping(DHTDBImpl _db, HashWrapper _key, boolean _local) {
        this.db = _db;
        this.key = _key;
        try {
            if (this.db.getAdapter() != null) {
                this.adapter_key = this.db.getAdapter().keyCreated(this.key, _local);
                if (this.adapter_key != null) {
                    this.diversification_state = this.adapter_key.getDiversificationType();
                }
            }
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
    }

    protected HashWrapper getKey() {
        return this.key;
    }

    protected void updateLocalContact(DHTTransportContact contact) {
        ArrayList<DHTDBValueImpl> changed = new ArrayList<DHTDBValueImpl>();
        Iterator it = this.direct_originator_map.values().iterator();
        while (it.hasNext()) {
            DHTDBValueImpl value = (DHTDBValueImpl)it.next();
            if (!value.isLocal()) continue;
            value.setOriginatorAndSender(contact);
            changed.add(value);
            this.direct_data_size -= value.getValue().length;
            this.local_size -= value.getValue().length;
            it.remove();
            this.informDeleted(value);
        }
        for (int i = 0; i < changed.size(); ++i) {
            this.add((DHTDBValueImpl)changed.get(i));
        }
    }

    protected void add(DHTDBValueImpl new_value) {
        DHTTransportContact originator = new_value.getOriginator();
        DHTTransportContact sender = new_value.getSender();
        HashWrapper originator_id = new HashWrapper(originator.getID());
        boolean direct = Arrays.equals(originator.getID(), sender.getID());
        if (direct) {
            this.addDirectValue(originator_id, new_value);
            Iterator it = this.indirect_originator_value_map.entrySet().iterator();
            ArrayList<HashWrapper> to_remove = new ArrayList<HashWrapper>();
            while (it.hasNext()) {
                Map.Entry entry2 = it.next();
                HashWrapper existing_key = (HashWrapper)entry2.getKey();
                DHTDBValueImpl existing_value = (DHTDBValueImpl)entry2.getValue();
                if (!Arrays.equals(existing_value.getOriginator().getID(), originator.getID())) continue;
                to_remove.add(existing_key);
            }
            for (int i = 0; i < to_remove.size(); ++i) {
                this.removeIndirectValue((HashWrapper)to_remove.get(i));
            }
        } else {
            if (this.direct_originator_map.get(originator_id) != null) {
                return;
            }
            HashWrapper originator_value_id = this.getOriginatorValueID(new_value);
            DHTDBValueImpl existing_value = (DHTDBValueImpl)this.indirect_originator_value_map.get(originator_value_id);
            if (existing_value != null) {
                this.addIndirectValue(originator_value_id, new_value);
            } else if (this.diversification_state == 1) {
                this.addIndirectValue(originator_value_id, new_value);
            }
        }
    }

    private HashWrapper getOriginatorValueID(DHTDBValueImpl value) {
        DHTTransportContact originator = value.getOriginator();
        byte[] originator_id = originator.getID();
        return new HashWrapper(originator_id);
    }

    protected void addHit() {
        ++this.hits;
    }

    protected int getHits() {
        return this.hits;
    }

    protected int getIndirectSize() {
        return this.indirect_data_size;
    }

    protected int getDirectSize() {
        return this.direct_data_size - this.local_size;
    }

    protected int getLocalSize() {
        return this.local_size;
    }

    protected DHTDBValueImpl[] get(DHTTransportContact by_who, int max) {
        ArrayList<DHTDBValueImpl> res = new ArrayList<DHTDBValueImpl>();
        HashSet<HashWrapper> duplicate_check = new HashSet<HashWrapper>();
        Map[] maps = new Map[]{this.direct_originator_map, this.indirect_originator_value_map};
        for (int i = 0; i < maps.length; ++i) {
            ArrayList<HashWrapper> keys_used = new ArrayList<HashWrapper>();
            Map map = maps[i];
            Iterator it = map.entrySet().iterator();
            while (it.hasNext() && (max == 0 || res.size() < max)) {
                Map.Entry entry2 = it.next();
                HashWrapper entry_key = (HashWrapper)entry2.getKey();
                DHTDBValueImpl entry_value = (DHTDBValueImpl)entry2.getValue();
                HashWrapper x = new HashWrapper(entry_value.getValue());
                if (duplicate_check.contains(x)) continue;
                duplicate_check.add(x);
                if (entry_value.getValue().length <= 0) continue;
                res.add(entry_value);
                keys_used.add(entry_key);
            }
            for (int j = 0; j < keys_used.size(); ++j) {
                map.get(keys_used.get(j));
            }
        }
        this.informRead(by_who);
        DHTDBValueImpl[] v = new DHTDBValueImpl[res.size()];
        res.toArray(v);
        return v;
    }

    protected DHTDBValueImpl get(DHTTransportContact originator) {
        HashWrapper originator_id = new HashWrapper(originator.getID());
        DHTDBValueImpl res = (DHTDBValueImpl)this.direct_originator_map.get(originator_id);
        return res;
    }

    protected DHTDBValueImpl remove(DHTTransportContact originator) {
        HashWrapper originator_id = new HashWrapper(originator.getID());
        DHTDBValueImpl res = this.removeDirectValue(originator_id);
        return res;
    }

    protected int getValueCount() {
        return this.direct_originator_map.size() + this.indirect_originator_value_map.size();
    }

    protected Iterator getValues() {
        return new valueIterator(true, true);
    }

    protected Iterator getDirectValues() {
        return new valueIterator(true, false);
    }

    protected Iterator getIndirectValues() {
        return new valueIterator(false, true);
    }

    protected byte getDiversificationType() {
        return this.diversification_state;
    }

    protected void addDirectValue(HashWrapper value_key, DHTDBValueImpl value) {
        DHTDBValueImpl old = this.direct_originator_map.put(value_key, value);
        if (old != null) {
            int old_version = old.getVersion();
            int new_version = value.getVersion();
            if (old_version != -1 && new_version != -1 && old_version >= new_version) {
                if (old_version == new_version) {
                    old.reset();
                }
                this.direct_originator_map.put(value_key, old);
                return;
            }
            this.direct_data_size -= old.getValue().length;
            if (old.isLocal()) {
                this.local_size -= old.getValue().length;
            }
        }
        this.direct_data_size += value.getValue().length;
        if (value.isLocal()) {
            this.local_size += value.getValue().length;
        }
        if (old == null) {
            this.informAdded(value);
        } else {
            this.informUpdated(old, value);
        }
    }

    protected DHTDBValueImpl removeDirectValue(HashWrapper value_key) {
        DHTDBValueImpl old = (DHTDBValueImpl)this.direct_originator_map.remove(value_key);
        if (old != null) {
            this.direct_data_size -= old.getValue().length;
            if (old.isLocal()) {
                this.local_size -= old.getValue().length;
            }
            this.informDeleted(old);
        }
        return old;
    }

    protected void addIndirectValue(HashWrapper value_key, DHTDBValueImpl value) {
        DHTDBValueImpl old = this.indirect_originator_value_map.put(value_key, value);
        if (old != null) {
            int old_version = old.getVersion();
            int new_version = value.getVersion();
            if (old_version != -1 && new_version != -1 && old_version >= new_version) {
                if (old_version == new_version) {
                    old.reset();
                }
                this.indirect_originator_value_map.put(value_key, old);
                return;
            }
            if ((old_version == -1 || new_version == -1) && old.getCreationTime() > value.getCreationTime() + 30000L) {
                this.indirect_originator_value_map.put(value_key, old);
                return;
            }
            this.indirect_data_size -= old.getValue().length;
            if (old.isLocal()) {
                this.local_size -= old.getValue().length;
            }
        }
        this.indirect_data_size += value.getValue().length;
        if (value.isLocal()) {
            this.local_size += value.getValue().length;
        }
        if (old == null) {
            this.informAdded(value);
        } else {
            this.informUpdated(old, value);
        }
    }

    protected void removeIndirectValue(HashWrapper value_key) {
        DHTDBValueImpl old = (DHTDBValueImpl)this.indirect_originator_value_map.remove(value_key);
        if (old != null) {
            this.indirect_data_size -= old.getValue().length;
            if (old.isLocal()) {
                this.local_size -= old.getValue().length;
            }
            this.informDeleted(old);
        }
    }

    protected void destroy() {
        try {
            if (this.adapter_key != null) {
                Iterator it = this.getValues();
                while (it.hasNext()) {
                    it.next();
                    it.remove();
                }
                this.db.getAdapter().keyDeleted(this.adapter_key);
            }
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
    }

    private void informDeleted(DHTDBValueImpl value) {
        boolean direct;
        boolean bl = direct = !value.isLocal() && Arrays.equals(value.getOriginator().getID(), value.getSender().getID());
        if (direct) {
            this.removeFromBloom(value);
        }
        try {
            if (this.adapter_key != null) {
                this.db.getAdapter().valueDeleted(this.adapter_key, value);
                this.diversification_state = this.adapter_key.getDiversificationType();
            }
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
    }

    private void informAdded(DHTDBValueImpl value) {
        boolean direct;
        boolean bl = direct = !value.isLocal() && Arrays.equals(value.getOriginator().getID(), value.getSender().getID());
        if (direct) {
            this.addToBloom(value);
        }
        try {
            if (this.adapter_key != null) {
                this.db.getAdapter().valueAdded(this.adapter_key, value);
                this.diversification_state = this.adapter_key.getDiversificationType();
            }
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
    }

    private void informUpdated(DHTDBValueImpl old_value, DHTDBValueImpl new_value) {
        boolean new_direct;
        boolean old_direct = !old_value.isLocal() && Arrays.equals(old_value.getOriginator().getID(), old_value.getSender().getID());
        boolean bl = new_direct = !new_value.isLocal() && Arrays.equals(new_value.getOriginator().getID(), new_value.getSender().getID());
        if (new_direct && !old_direct) {
            this.addToBloom(new_value);
        }
        try {
            if (this.adapter_key != null) {
                this.db.getAdapter().valueUpdated(this.adapter_key, old_value, new_value);
                this.diversification_state = this.adapter_key.getDiversificationType();
            }
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
    }

    private void informRead(DHTTransportContact contact) {
        try {
            if (this.adapter_key != null && contact != null) {
                this.db.getAdapter().keyRead(this.adapter_key, contact);
                this.diversification_state = this.adapter_key.getDiversificationType();
            }
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
    }

    protected void addToBloom(DHTDBValueImpl value) {
        DHTTransportContact originator = value.getOriginator();
        int hit_count = this.ip_count_bloom_filter.add(originator.getAddress().getAddress().getAddress());
        if (this.ip_count_bloom_filter.getSize() / this.ip_count_bloom_filter.getEntryCount() < 10) {
            this.rebuildIPBloomFilter(true);
        }
        if (hit_count >= 15) {
            this.db.banContact(originator, "local flood on '" + DHTLog.getFullString(this.key.getBytes()) + "'");
        }
    }

    protected void removeFromBloom(DHTDBValueImpl value) {
        DHTTransportContact originator = value.getOriginator();
        int hit_count = this.ip_count_bloom_filter.remove(originator.getAddress().getAddress().getAddress());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void rebuildIPBloomFilter(boolean increase_size) {
        BloomFilter new_filter = increase_size ? BloomFilterFactory.createAddRemove4Bit(this.ip_count_bloom_filter.getSize() + 50) : BloomFilterFactory.createAddRemove4Bit(this.ip_count_bloom_filter.getSize());
        try {
            Iterator it = this.getDirectValues();
            int max_hits = 0;
            while (it.hasNext()) {
                int hits;
                DHTDBValueImpl val = (DHTDBValueImpl)it.next();
                if (val.isLocal() || (hits = new_filter.add(val.getOriginator().getAddress().getAddress().getAddress())) <= max_hits) continue;
                max_hits = hits;
            }
        }
        finally {
            this.ip_count_bloom_filter = new_filter;
        }
    }

    protected class valueIterator
    implements Iterator {
        private List maps = new ArrayList(2);
        private int map_index = 0;
        private Map map;
        private Iterator it;
        private DHTDBValueImpl value;

        protected valueIterator(boolean direct, boolean indirect) {
            if (direct) {
                this.maps.add(DHTDBMapping.this.direct_originator_map);
            }
            if (indirect) {
                this.maps.add(DHTDBMapping.this.indirect_originator_value_map);
            }
        }

        public boolean hasNext() {
            if (this.it != null && this.it.hasNext()) {
                return true;
            }
            while (this.map_index < this.maps.size()) {
                this.map = (Map)this.maps.get(this.map_index++);
                this.it = this.map.values().iterator();
                if (!this.it.hasNext()) continue;
                return true;
            }
            return false;
        }

        public Object next() {
            if (this.hasNext()) {
                this.value = (DHTDBValueImpl)this.it.next();
                return this.value;
            }
            throw new NoSuchElementException();
        }

        public void remove() {
            if (this.it == null) {
                throw new IllegalStateException();
            }
            if (this.value != null) {
                if (this.value.isLocal()) {
                    DHTDBMapping.this.local_size -= this.value.getValue().length;
                }
                if (this.map == DHTDBMapping.this.indirect_originator_value_map) {
                    DHTDBMapping.this.indirect_data_size -= this.value.getValue().length;
                } else {
                    DHTDBMapping.this.direct_data_size -= this.value.getValue().length;
                }
                this.it.remove();
                DHTDBMapping.this.informDeleted(this.value);
            } else {
                this.it.remove();
            }
        }
    }
}

