/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.clientmessageservice.impl;

import com.aelitis.azureus.core.clientmessageservice.ClientMessageService;
import com.aelitis.azureus.core.clientmessageservice.impl.ClientConnection;
import com.aelitis.azureus.core.clientmessageservice.impl.ClientMessage;
import com.aelitis.azureus.core.clientmessageservice.impl.ClientMessageHandler;
import com.aelitis.azureus.core.clientmessageservice.impl.NonBlockingReadWriteService;
import com.aelitis.azureus.core.networkmanager.TCPTransport;
import com.aelitis.azureus.core.networkmanager.TransportFactory;
import com.aelitis.azureus.core.peermanager.messaging.MessageException;
import com.aelitis.azureus.core.peermanager.messaging.azureus.AZMessageFactory;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Map;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.Debug;

public class AEClientService
implements ClientMessageService {
    private final String address;
    private final int port;
    private final String msg_type_id;
    private ClientConnection conn;
    private final AESemaphore read_block = new AESemaphore("AEClientService:R");
    private final AESemaphore write_block = new AESemaphore("AEClientService:W");
    private final ArrayList received_messages = new ArrayList();
    private final NonBlockingReadWriteService rw_service;
    private Throwable error;

    public AEClientService(String server_address, int server_port, String _msg_type_id) {
        this(server_address, server_port, 30, _msg_type_id);
    }

    public AEClientService(String server_address, int server_port, int timeout, String _msg_type_id) {
        this.address = server_address;
        this.port = server_port;
        this.msg_type_id = _msg_type_id;
        try {
            AZMessageFactory.registerGenericMapPayloadMessageType(this.msg_type_id);
        }
        catch (MessageException me) {
            // empty catch block
        }
        this.rw_service = new NonBlockingReadWriteService(this.msg_type_id, timeout, 0, new NonBlockingReadWriteService.ServiceListener(){

            public void messageReceived(ClientMessage message) {
                AEClientService.this.received_messages.add(message.getPayload());
                AEClientService.this.read_block.release();
            }

            public void connectionError(ClientConnection connection) {
                AEClientService.this.error = new IOException("connection error");
                AEClientService.this.read_block.release();
                AEClientService.this.write_block.release();
            }
        });
    }

    private void connect() throws IOException {
        final TCPTransport transport = TransportFactory.createTCPTransport(false, false, null);
        transport.establishOutboundConnection(new InetSocketAddress(this.address, this.port), new TCPTransport.ConnectListener(){

            public void connectAttemptStarted() {
            }

            public void connectSuccess() {
                AEClientService.this.conn = new ClientConnection(transport);
                AEClientService.this.read_block.release();
            }

            public void connectFailure(Throwable failure_msg) {
                AEClientService.this.error = failure_msg;
                AEClientService.this.read_block.release();
            }
        });
        this.read_block.reserve();
        if (this.error != null) {
            this.close();
            throw new IOException("connect op failed: " + this.error.getMessage() == null ? "[]" : this.error.getMessage());
        }
        this.rw_service.addClientConnection(this.conn);
    }

    public void sendMessage(Map message) throws IOException {
        if (this.conn == null) {
            this.connect();
        }
        ClientMessage client_msg = new ClientMessage(this.msg_type_id, this.conn, message, new ClientMessageHandler(){

            public String getMessageTypeID() {
                return AEClientService.this.msg_type_id;
            }

            public void processMessage(ClientMessage message) {
                Debug.out("ERROR: should never be called");
            }

            public void sendAttemptCompleted(ClientMessage message, boolean success) {
                if (!success) {
                    AEClientService.this.error = new IOException("message send attempt failed");
                }
                AEClientService.this.write_block.release();
            }
        });
        this.rw_service.sendMessage(client_msg);
        this.write_block.reserve();
        if (this.error != null) {
            this.close();
            throw new IOException("send op failed: " + this.error.getMessage() == null ? "[]" : this.error.getMessage());
        }
    }

    public Map receiveMessage() throws IOException {
        if (this.conn == null) {
            this.connect();
        }
        if (!this.received_messages.isEmpty()) {
            Map recv_msg = (Map)this.received_messages.remove(0);
            return recv_msg;
        }
        this.read_block.reserve();
        if (this.error != null) {
            this.close();
            throw new IOException("receive op failed: " + this.error.getMessage() == null ? "[]" : this.error.getMessage());
        }
        Map recv_msg = (Map)this.received_messages.remove(0);
        return recv_msg;
    }

    public void close() {
        if (this.conn != null) {
            this.rw_service.removeClientConnection(this.conn);
            this.conn.close();
        }
        this.rw_service.destroy();
    }
}

