/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.wizards.sendtorrent;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.global.GlobalManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.TOTorrentException;
import org.gudy.azureus2.core3.util.Base32;
import org.gudy.azureus2.core3.util.UrlUtils;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.mainwindow.ClipboardCopy;
import org.gudy.azureus2.ui.swt.wizard.AbstractWizardPanel;
import org.gudy.azureus2.ui.swt.wizard.IWizardPanel;
import org.gudy.azureus2.ui.swt.wizard.Wizard;
import org.gudy.azureus2.ui.swt.wizards.sendtorrent.SendTorrentWizard;

public class SendTorrentFinishPanel
extends AbstractWizardPanel {
    public SendTorrentFinishPanel(Wizard wizard, IWizardPanel previousPanel) {
        super(wizard, previousPanel);
    }

    public void show() {
        SendTorrentWizard sendWiz = (SendTorrentWizard)this.wizard;
        TOTorrent[] torrents = sendWiz.getTorrents();
        final String[] names = new String[torrents.length];
        this.wizard.setTitle(MessageText.getString("sendTorrent.finish.title"));
        Composite rootPanel = this.wizard.getPanel();
        GridLayout layout = new GridLayout();
        rootPanel.setLayout((Layout)layout);
        Composite panel = new Composite(rootPanel, 0);
        GridData gridData = new GridData(1808);
        panel.setLayoutData((Object)gridData);
        layout = new GridLayout();
        layout.numColumns = sendWiz.getShareByMode() == 0 ? 2 : 1;
        panel.setLayout((Layout)layout);
        Label lblInstructions = new Label(panel, 64);
        gridData = new GridData(768);
        gridData.horizontalSpan = layout.numColumns;
        lblInstructions.setLayoutData((Object)gridData);
        if (sendWiz.getShareByMode() == 0) {
            Messages.setLanguageText((Widget)lblInstructions, "sendTorrent.finish.byEmail");
        } else {
            Messages.setLanguageText((Widget)lblInstructions, "sendTorrent.finish.byHTML");
        }
        final Text txtCode = new Text(panel, 74);
        gridData = new GridData(1808);
        gridData.horizontalSpan = layout.numColumns;
        txtCode.setLayoutData((Object)gridData);
        txtCode.setBackground(panel.getBackground());
        Button btnToClipboard = new Button(panel, 8);
        if (sendWiz.getShareByMode() != 0) {
            gridData.horizontalSpan = layout.numColumns;
        }
        Messages.setLanguageText((Widget)btnToClipboard, "sendTorrent.finish.button.toClipboard");
        btnToClipboard.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ClipboardCopy.copyToClipBoard(txtCode.getText());
            }
        });
        sendWiz.switchToClose();
        GlobalManager gm = sendWiz.getAzureusCore().getGlobalManager();
        for (int i = 0; i < torrents.length; ++i) {
            DownloadManager downloadManager;
            TOTorrent torrent = torrents[i];
            names[i] = null;
            if (gm != null && (downloadManager = gm.getDownloadManager(torrent)) != null) {
                names[i] = downloadManager.getDisplayName();
            }
            if (names[i] != null) continue;
            names[i] = new String(torrent.getName());
        }
        if (sendWiz.getShareByMode() == 0) {
            final String[] urls = new String[torrents.length];
            String s = "";
            for (int i = 0; i < torrents.length; ++i) {
                TOTorrent torrent = torrents[i];
                if (i > 0) {
                    s = s + "\n";
                }
                try {
                    urls[i] = "http://getazureus.com/getContent.php?magnet=";
                    int n = i;
                    urls[n] = urls[n] + Base32.encode(torrent.getHash());
                    int n2 = i;
                    urls[n2] = urls[n2] + "&name=" + UrlUtils.encode(names[i]);
                    s = s + urls[i];
                    continue;
                }
                catch (TOTorrentException e1) {
                    e1.printStackTrace();
                }
            }
            txtCode.setText(s);
            Button btnStartEMail = new Button(panel, 8);
            Messages.setLanguageText((Widget)btnStartEMail, "sendTorrent.finish.button.startEMail");
            btnStartEMail.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    String body;
                    String prefix = names.length == 1 ? "sendTorrent.one.email." : "sendTorrent.multi.email.";
                    String allNames = names[0];
                    for (int i = 1; i < names.length; ++i) {
                        allNames = allNames + ", " + names[i];
                    }
                    String subject = MessageText.getString(prefix + "subject", new String[]{allNames});
                    if (names.length == 1) {
                        body = MessageText.getString(prefix + "body", new String[]{names[0], urls[0]});
                    } else {
                        body = MessageText.getString(prefix + "body.top", "") == "" ? "" : MessageText.getString(prefix + "body.top", new String[]{allNames, txtCode.getText()});
                        if (MessageText.getString(prefix + "body.eachTorrent", "") != "") {
                            for (int i = 0; i < names.length; ++i) {
                                body = body + MessageText.getString(prefix + "body.eachTorrent", new String[]{names[i], urls[i]});
                            }
                        }
                        if (MessageText.getString(prefix + "body.bottom", "") != "") {
                            body = body + MessageText.getString(prefix + "body.bottom", new String[]{allNames, txtCode.getText()});
                        }
                    }
                    Program.launch((String)("mailto:?subject=" + UrlUtils.encode(subject) + "&body=" + UrlUtils.encode(body)));
                }
            });
        } else {
            String s = "";
            for (int i = 0; i < torrents.length; ++i) {
                TOTorrent torrent = torrents[i];
                if (i > 0) {
                    s = s + "<br>\n";
                }
                try {
                    s = s + "<script language=\"javascript\" src=\"http://getazureus.com/js/azdetect.js\"></script>\n";
                    s = s + "<a href=\"javascript:detectAndLoadMagnet('" + Base32.encode(torrent.getHash()) + "');\">\n";
                    s = s + "<img src=\"http://getazureus.com/js/az.png\" border=\"0\">\n";
                    s = s + "Download " + names[i] + "</a>\n";
                }
                catch (TOTorrentException e1) {
                    e1.printStackTrace();
                }
                txtCode.setText(s);
            }
        }
    }

    public void finish() {
        this.wizard.getWizardWindow().close();
    }
}

