/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.ui.UIFunctions;
import com.aelitis.azureus.ui.UIFunctionsManager;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.URL;
import java.util.Arrays;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Widget;
import org.gudy.azureus2.core3.category.Category;
import org.gudy.azureus2.core3.category.CategoryManager;
import org.gudy.azureus2.core3.category.CategoryManagerListener;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.tracker.host.TRHostListener;
import org.gudy.azureus2.core3.tracker.host.TRHostTorrent;
import org.gudy.azureus2.core3.tracker.host.TRHostTorrentRemovalVetoException;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.TorrentUtils;
import org.gudy.azureus2.plugins.torrent.TorrentAttribute;
import org.gudy.azureus2.pluginsimpl.local.torrent.TorrentManagerImpl;
import org.gudy.azureus2.ui.swt.Alerts;
import org.gudy.azureus2.ui.swt.CategoryAdderWindow;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.mainwindow.Colors;
import org.gudy.azureus2.ui.swt.mainwindow.SWTThread;
import org.gudy.azureus2.ui.swt.views.TableView;
import org.gudy.azureus2.ui.swt.views.table.TableColumnCore;
import org.gudy.azureus2.ui.swt.views.table.TableRowCore;
import org.gudy.azureus2.ui.swt.views.tableitems.mytracker.AnnounceCountItem;
import org.gudy.azureus2.ui.swt.views.tableitems.mytracker.AverageBytesInItem;
import org.gudy.azureus2.ui.swt.views.tableitems.mytracker.AverageBytesOutItem;
import org.gudy.azureus2.ui.swt.views.tableitems.mytracker.BadNATCountItem;
import org.gudy.azureus2.ui.swt.views.tableitems.mytracker.CategoryItem;
import org.gudy.azureus2.ui.swt.views.tableitems.mytracker.CompletedCountItem;
import org.gudy.azureus2.ui.swt.views.tableitems.mytracker.DateAddedItem;
import org.gudy.azureus2.ui.swt.views.tableitems.mytracker.DownloadedItem;
import org.gudy.azureus2.ui.swt.views.tableitems.mytracker.LeftItem;
import org.gudy.azureus2.ui.swt.views.tableitems.mytracker.NameItem;
import org.gudy.azureus2.ui.swt.views.tableitems.mytracker.PassiveItem;
import org.gudy.azureus2.ui.swt.views.tableitems.mytracker.PeerCountItem;
import org.gudy.azureus2.ui.swt.views.tableitems.mytracker.ScrapeCountItem;
import org.gudy.azureus2.ui.swt.views.tableitems.mytracker.SeedCountItem;
import org.gudy.azureus2.ui.swt.views.tableitems.mytracker.StatusItem;
import org.gudy.azureus2.ui.swt.views.tableitems.mytracker.TotalBytesInItem;
import org.gudy.azureus2.ui.swt.views.tableitems.mytracker.TotalBytesOutItem;
import org.gudy.azureus2.ui.swt.views.tableitems.mytracker.TrackerItem;
import org.gudy.azureus2.ui.swt.views.tableitems.mytracker.UploadedItem;

public class MyTrackerView
extends TableView
implements TRHostListener,
CategoryManagerListener {
    private static final TableColumnCore[] basicItems = new TableColumnCore[]{new NameItem(), new TrackerItem(), new StatusItem(), new CategoryItem(), new PassiveItem(), new SeedCountItem(), new PeerCountItem(), new BadNATCountItem(), new AnnounceCountItem(), new ScrapeCountItem(), new CompletedCountItem(), new UploadedItem(), new DownloadedItem(), new LeftItem(), new TotalBytesInItem(), new AverageBytesInItem(), new TotalBytesOutItem(), new AverageBytesOutItem(), new DateAddedItem()};
    protected static final TorrentAttribute category_attribute = TorrentManagerImpl.getSingleton().getAttribute("Category");
    private AzureusCore azureus_core;
    private Menu menuCategory;
    private boolean start;
    private boolean stop;
    private boolean remove;

    public MyTrackerView(AzureusCore _azureus_core) {
        super("MyTracker", "MyTrackerView", basicItems, "name", 268503042);
        this.azureus_core = _azureus_core;
    }

    public void initialize(Composite composite0) {
        super.initialize(composite0);
        this.azureus_core.getTrackerHost().addListener(this);
        Table table = this.getTable();
        table.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent mEvent) {
                UIFunctions uiFunctions;
                TRHostTorrent torrent = (TRHostTorrent)MyTrackerView.this.getFirstSelectedDataSource();
                if (torrent == null) {
                    return;
                }
                DownloadManager dm = MyTrackerView.this.azureus_core.getGlobalManager().getDownloadManager(torrent.getTorrent());
                if (dm != null && (uiFunctions = UIFunctionsManager.getUIFunctions()) != null) {
                    uiFunctions.openManagerView(dm);
                }
            }
        });
    }

    public void tableStructureChanged() {
        this.azureus_core.getTrackerHost().removeListener(this);
        super.tableStructureChanged();
        this.azureus_core.getTrackerHost().addListener(this);
    }

    public void fillMenu(Menu menu) {
        this.menuCategory = new Menu((Decorations)this.getComposite().getShell(), 4);
        MenuItem itemCategory = new MenuItem(menu, 64);
        Messages.setLanguageText((Widget)itemCategory, "MyTorrentsView.menu.setCategory");
        itemCategory.setMenu(this.menuCategory);
        this.addCategorySubMenu();
        new MenuItem(menu, 2);
        MenuItem itemStart = new MenuItem(menu, 8);
        Messages.setLanguageText((Widget)itemStart, "MyTorrentsView.menu.start");
        Utils.setMenuItemImage(itemStart, "start");
        MenuItem itemStop = new MenuItem(menu, 8);
        Messages.setLanguageText((Widget)itemStop, "MyTorrentsView.menu.stop");
        Utils.setMenuItemImage(itemStop, "stop");
        MenuItem itemRemove = new MenuItem(menu, 8);
        Messages.setLanguageText((Widget)itemRemove, "MyTorrentsView.menu.remove");
        Utils.setMenuItemImage(itemRemove, "delete");
        Object[] hostTorrents = this.getSelectedDataSources();
        itemStart.setEnabled(false);
        itemStop.setEnabled(false);
        itemRemove.setEnabled(false);
        if (hostTorrents.length > 0) {
            boolean start_ok = true;
            boolean stop_ok = true;
            boolean remove_ok = true;
            for (int i = 0; i < hostTorrents.length; ++i) {
                TRHostTorrent host_torrent = (TRHostTorrent)hostTorrents[i];
                int status = host_torrent.getStatus();
                if (status != 1) {
                    start_ok = false;
                }
                if (status == 2) continue;
                stop_ok = false;
            }
            itemStart.setEnabled(start_ok);
            itemStop.setEnabled(stop_ok);
            itemRemove.setEnabled(remove_ok);
        }
        itemStart.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                MyTrackerView.this.startSelectedTorrents();
            }
        });
        itemStop.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                MyTrackerView.this.stopSelectedTorrents();
            }
        });
        itemRemove.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                MyTrackerView.this.removeSelectedTorrents();
            }
        });
        new MenuItem(menu, 2);
        super.fillMenu(menu);
    }

    public void torrentAdded(TRHostTorrent host_torrent) {
        this.addDataSource(host_torrent);
    }

    public void torrentChanged(TRHostTorrent t) {
    }

    public void torrentRemoved(TRHostTorrent host_torrent) {
        this.removeDataSource(host_torrent);
    }

    public boolean handleExternalRequest(InetSocketAddress client, String user, String url, URL absolute_url, String header, InputStream is, OutputStream os) throws IOException {
        return false;
    }

    public void refresh(boolean bForceSort) {
        if (this.getComposite() == null || this.getComposite().isDisposed()) {
            return;
        }
        this.computePossibleActions();
        UIFunctions uiFunctions = UIFunctionsManager.getUIFunctions();
        if (uiFunctions != null) {
            uiFunctions.refreshIconBar();
        }
        TableRowCore[] rows = this.getRows();
        for (int x = 0; x < rows.length; ++x) {
            TRHostTorrent host_torrent;
            if (rows[x] == null || (host_torrent = (TRHostTorrent)rows[x].getDataSource(true)) == null) continue;
            long uploaded = host_torrent.getTotalUploaded();
            long downloaded = host_torrent.getTotalDownloaded();
            long left = host_torrent.getTotalLeft();
            int seed_count = host_torrent.getSeedCount();
            host_torrent.setData("GUI_PeerCount", new Long(host_torrent.getLeecherCount()));
            host_torrent.setData("GUI_SeedCount", new Long(seed_count));
            host_torrent.setData("GUI_BadNATCount", new Long(host_torrent.getBadNATCount()));
            host_torrent.setData("GUI_Uploaded", new Long(uploaded));
            host_torrent.setData("GUI_Downloaded", new Long(downloaded));
            host_torrent.setData("GUI_Left", new Long(left));
            if (seed_count == 0 || rows[x].getForeground().equals((Object)Colors.blues[7])) continue;
            rows[x].setForeground(Colors.blues[7]);
        }
        super.refresh(bForceSort);
    }

    public void delete() {
        super.delete();
        this.azureus_core.getTrackerHost().removeListener(this);
    }

    private void computePossibleActions() {
        this.remove = false;
        this.stop = false;
        this.start = false;
        Object[] hostTorrents = this.getSelectedDataSources();
        if (hostTorrents.length > 0) {
            this.remove = true;
            for (int i = 0; i < hostTorrents.length; ++i) {
                TRHostTorrent host_torrent = (TRHostTorrent)hostTorrents[i];
                int status = host_torrent.getStatus();
                if (status == 1) {
                    this.start = true;
                }
                if (status != 2) continue;
                this.stop = true;
            }
        }
    }

    public boolean isEnabled(String itemKey) {
        if (itemKey.equals("start")) {
            return this.start;
        }
        if (itemKey.equals("stop")) {
            return this.stop;
        }
        if (itemKey.equals("remove")) {
            return this.remove;
        }
        return false;
    }

    public void itemActivated(String itemKey) {
        if (itemKey.equals("start")) {
            this.startSelectedTorrents();
            return;
        }
        if (itemKey.equals("stop")) {
            this.stopSelectedTorrents();
            return;
        }
        if (itemKey.equals("remove")) {
            this.removeSelectedTorrents();
            return;
        }
    }

    private void stopSelectedTorrents() {
        this.runForSelectedRows(new TableView.GroupTableRowRunner(){

            public void run(TableRowCore row) {
                TRHostTorrent torrent = (TRHostTorrent)row.getDataSource(true);
                if (torrent.getStatus() == 2) {
                    torrent.stop();
                }
            }
        });
    }

    private void startSelectedTorrents() {
        this.runForSelectedRows(new TableView.GroupTableRowRunner(){

            public void run(TableRowCore row) {
                TRHostTorrent torrent = (TRHostTorrent)row.getDataSource(true);
                if (torrent.getStatus() == 1) {
                    torrent.start();
                }
            }
        });
    }

    private void removeSelectedTorrents() {
        this.runForSelectedRows(new TableView.GroupTableRowRunner(){

            public void run(TableRowCore row) {
                TRHostTorrent torrent = (TRHostTorrent)row.getDataSource(true);
                try {
                    torrent.remove();
                }
                catch (TRHostTorrentRemovalVetoException f) {
                    Alerts.showErrorMessageBoxUsingResourceString("globalmanager.download.remove.veto", f);
                }
            }
        });
    }

    private void addCategorySubMenu() {
        int i;
        MenuItem[] items = this.menuCategory.getItems();
        for (i = 0; i < items.length; ++i) {
            items[i].dispose();
        }
        Object[] categories = CategoryManager.getCategories();
        Arrays.sort(categories);
        if (categories.length > 0) {
            MenuItem itemCategory;
            Category catUncat = CategoryManager.getCategory(2);
            if (catUncat != null) {
                itemCategory = new MenuItem(this.menuCategory, 8);
                Messages.setLanguageText((Widget)itemCategory, catUncat.getName());
                itemCategory.setData("Category", (Object)catUncat);
                itemCategory.addListener(13, new Listener(){

                    public void handleEvent(Event event2) {
                        MenuItem item = (MenuItem)event2.widget;
                        MyTrackerView.this.assignSelectedToCategory((Category)item.getData("Category"));
                    }
                });
                new MenuItem(this.menuCategory, 2);
            }
            for (i = 0; i < categories.length; ++i) {
                if (categories[i].getType() != 0) continue;
                itemCategory = new MenuItem(this.menuCategory, 8);
                itemCategory.setText(categories[i].getName());
                itemCategory.setData("Category", categories[i]);
                itemCategory.addListener(13, new Listener(){

                    public void handleEvent(Event event2) {
                        MenuItem item = (MenuItem)event2.widget;
                        MyTrackerView.this.assignSelectedToCategory((Category)item.getData("Category"));
                    }
                });
            }
            new MenuItem(this.menuCategory, 2);
        }
        MenuItem itemAddCategory = new MenuItem(this.menuCategory, 8);
        Messages.setLanguageText((Widget)itemAddCategory, "MyTorrentsView.menu.setCategory.add");
        itemAddCategory.addListener(13, new Listener(){

            public void handleEvent(Event event2) {
                MyTrackerView.this.addCategory();
            }
        });
    }

    public void categoryAdded(Category category) {
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                MyTrackerView.this.addCategorySubMenu();
            }
        });
    }

    public void categoryRemoved(Category category) {
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                MyTrackerView.this.addCategorySubMenu();
            }
        });
    }

    private void addCategory() {
        CategoryAdderWindow adderWindow = new CategoryAdderWindow(SWTThread.getInstance().getDisplay());
        Category newCategory = adderWindow.getNewCategory();
        if (newCategory != null) {
            this.assignSelectedToCategory(newCategory);
        }
    }

    private void assignSelectedToCategory(final Category category) {
        this.runForSelectedRows(new TableView.GroupTableRowRunner(){

            public void run(TableRowCore row) {
                TRHostTorrent tr_torrent = (TRHostTorrent)row.getDataSource(true);
                TOTorrent torrent = tr_torrent.getTorrent();
                DownloadManager dm = MyTrackerView.this.azureus_core.getGlobalManager().getDownloadManager(torrent);
                if (dm != null) {
                    dm.getDownloadState().setCategory(category);
                } else {
                    String cat_str = category == null ? null : (category == CategoryManager.getCategory(2) ? null : category.getName());
                    TorrentUtils.setPluginStringProperty(torrent, "azcoreplugins.category", cat_str);
                    try {
                        TorrentUtils.writeToFile(torrent);
                    }
                    catch (Throwable e) {
                        Debug.printStackTrace(e);
                    }
                }
            }
        });
    }
}

