/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.pluginsinstaller;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;
import org.gudy.azureus2.core3.html.HTMLUtils;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AEThread;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.installer.StandardPlugin;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.pluginsinstaller.IPWInstallModePanel;
import org.gudy.azureus2.ui.swt.pluginsinstaller.InstallPluginWizard;
import org.gudy.azureus2.ui.swt.wizard.AbstractWizardPanel;
import org.gudy.azureus2.ui.swt.wizard.IWizardPanel;
import org.gudy.azureus2.ui.swt.wizard.Wizard;

public class IPWListPanel
extends AbstractWizardPanel {
    Table pluginList;
    StyledText txtDescription;

    public IPWListPanel(Wizard wizard, IWizardPanel previous) {
        super(wizard, previous);
    }

    public void show() {
        this.wizard.setTitle(MessageText.getString("installPluginsWizard.list.title"));
        this.wizard.setErrorMessage("");
        Composite rootPanel = this.wizard.getPanel();
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        rootPanel.setLayout((Layout)layout);
        Composite panel = new Composite(rootPanel, 0);
        GridData gridData = new GridData(772);
        panel.setLayoutData((Object)gridData);
        layout = new GridLayout();
        layout.numColumns = 1;
        panel.setLayout((Layout)layout);
        final Label lblStatus = new Label(panel, 0);
        GridData data = new GridData(768);
        lblStatus.setLayoutData((Object)data);
        Messages.setLanguageText((Widget)lblStatus, "installPluginsWizard.list.loading");
        this.pluginList = new Table(panel, 68132);
        this.pluginList.setHeaderVisible(true);
        data = new GridData(768);
        data.heightHint = 120;
        this.pluginList.setLayoutData((Object)data);
        TableColumn tcName = new TableColumn(this.pluginList, 16384);
        Messages.setLanguageText((Widget)tcName, "installPluginsWizard.list.name");
        tcName.setWidth(200);
        TableColumn tcVersion = new TableColumn(this.pluginList, 16384);
        Messages.setLanguageText((Widget)tcVersion, "installPluginsWizard.list.version");
        tcVersion.setWidth(150);
        Label lblDescription = new Label(panel, 0);
        Messages.setLanguageText((Widget)lblDescription, "installPluginsWizard.list.description");
        this.txtDescription = new StyledText(panel, 2824);
        this.txtDescription.setWordWrap(true);
        this.txtDescription.setEditable(false);
        data = new GridData(768);
        data.heightHint = 100;
        this.txtDescription.setLayoutData((Object)data);
        AEThread listLoader = new AEThread("Plugin List Loader"){

            public void runSupport() {
                StandardPlugin[] plugins;
                try {
                    plugins = ((InstallPluginWizard)IPWListPanel.this.wizard).getStandardPlugins();
                    Arrays.sort(plugins, new Comparator(){

                        public int compare(Object o1, Object o2) {
                            return ((StandardPlugin)o1).getName().compareToIgnoreCase(((StandardPlugin)o2).getName());
                        }
                    });
                }
                catch (Exception e) {
                    Debug.printStackTrace(e);
                    IPWListPanel.this.wizard.getDisplay().asyncExec((Runnable)new AERunnable(){

                        public void runSupport() {
                            IPWListPanel.this.txtDescription.setText(Debug.getNestedExceptionMessage(e));
                        }
                    });
                    return;
                }
                IPWListPanel.this.wizard.getDisplay().asyncExec((Runnable)new AERunnable(){

                    public void runSupport() {
                        lblStatus.setText(((InstallPluginWizard)IPWListPanel.this.wizard).getListTitleText());
                        List selected_plugins = ((InstallPluginWizard)IPWListPanel.this.wizard).getPluginList();
                        for (int i = 0; i < plugins.length; ++i) {
                            StandardPlugin plugin = plugins[i];
                            if (plugin.getAlreadyInstalledPlugin() != null) continue;
                            if (IPWListPanel.this.pluginList == null || IPWListPanel.this.pluginList.isDisposed()) {
                                return;
                            }
                            TableItem item = new TableItem(IPWListPanel.this.pluginList, 0);
                            item.setData((Object)plugin);
                            item.setText(0, plugin.getName());
                            boolean selected = false;
                            for (int j = 0; j < selected_plugins.size(); ++j) {
                                if (((StandardPlugin)selected_plugins.get(j)).getId() != plugin.getId()) continue;
                                selected = true;
                            }
                            item.setChecked(selected);
                            item.setText(1, plugin.getVersion());
                        }
                        if (plugins.length == 1 && IPWListPanel.this.pluginList.getItemCount() > 0) {
                            IPWListPanel.this.pluginList.select(0);
                            IPWListPanel.this.loadPluginDetails(IPWListPanel.this.pluginList.getItem(0));
                        }
                    }
                });
            }
        };
        listLoader.setDaemon(true);
        listLoader.start();
        this.pluginList.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                if (IPWListPanel.this.pluginList.getSelectionCount() > 0) {
                    IPWListPanel.this.loadPluginDetails(IPWListPanel.this.pluginList.getSelection()[0]);
                }
                IPWListPanel.this.updateList();
            }
        });
    }

    protected void loadPluginDetails(final TableItem selected_item) {
        this.txtDescription.setText(MessageText.getString("installPluginsWizard.details.loading"));
        final StandardPlugin plugin = (StandardPlugin)selected_item.getData();
        AEThread detailsLoader = new AEThread("Detail Loader"){

            public void runSupport() {
                final String description = HTMLUtils.convertListToString(HTMLUtils.convertHTMLToText(plugin.getDescription(), ""));
                IPWListPanel.this.wizard.getDisplay().asyncExec((Runnable)new AERunnable(){

                    public void runSupport() {
                        if (IPWListPanel.this.pluginList == null || IPWListPanel.this.pluginList.isDisposed() || IPWListPanel.this.pluginList.getSelectionCount() == 0) {
                            return;
                        }
                        if (IPWListPanel.this.pluginList.getSelection()[0] != selected_item) {
                            return;
                        }
                        if (IPWListPanel.this.txtDescription == null || IPWListPanel.this.txtDescription.isDisposed()) {
                            return;
                        }
                        IPWListPanel.this.txtDescription.setText(description);
                    }
                });
            }
        };
        detailsLoader.setDaemon(true);
        detailsLoader.start();
    }

    public boolean isNextEnabled() {
        return ((InstallPluginWizard)this.wizard).getPluginList().size() > 0;
    }

    public IWizardPanel getNextPanel() {
        return new IPWInstallModePanel(this.wizard, this);
    }

    public void updateList() {
        ArrayList<Object> list = new ArrayList<Object>();
        TableItem[] items = this.pluginList.getItems();
        for (int i = 0; i < items.length; ++i) {
            if (!items[i].getChecked()) continue;
            list.add(items[i].getData());
        }
        ((InstallPluginWizard)this.wizard).setPluginList(list);
        ((InstallPluginWizard)this.wizard).setNextEnabled(this.isNextEnabled());
    }
}

