/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.torrent;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.TOTorrentFactory;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.torrent.Torrent;
import org.gudy.azureus2.plugins.torrent.TorrentDownloader;
import org.gudy.azureus2.plugins.torrent.TorrentException;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloader;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloaderAdapter;
import org.gudy.azureus2.pluginsimpl.local.torrent.TorrentImpl;
import org.gudy.azureus2.pluginsimpl.local.torrent.TorrentManagerImpl;
import org.gudy.azureus2.pluginsimpl.local.utils.resourcedownloader.ResourceDownloaderFactoryImpl;

public class TorrentDownloaderImpl
implements TorrentDownloader {
    private static final LogIDs LOGID = LogIDs.PLUGIN;
    protected TorrentManagerImpl manager;
    protected URL url;
    protected ResourceDownloader downloader;
    protected boolean encoding_requested;
    protected String requested_encoding;
    protected boolean set_encoding;

    protected TorrentDownloaderImpl(TorrentManagerImpl _manager, URL _url) {
        this.manager = _manager;
        this.url = _url;
        this.downloader = ResourceDownloaderFactoryImpl.getSingleton().create(this.url);
    }

    protected TorrentDownloaderImpl(TorrentManagerImpl _manager, URL _url, String _user_name, String _password) {
        this.manager = _manager;
        this.url = _url;
        this.set_encoding = true;
        this.downloader = ResourceDownloaderFactoryImpl.getSingleton().create(this.url, _user_name, _password);
        this.downloader.addListener(new ResourceDownloaderAdapter(){

            public void reportActivity(ResourceDownloader downloader, String activity) {
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent(LOGID, "TorrentDownloader:" + activity));
                }
            }
        });
    }

    public Torrent download() throws TorrentException {
        InputStream is = null;
        try {
            is = this.downloader.download();
            TOTorrent torrent = TOTorrentFactory.deserialiseFromBEncodedInputStream(is);
            if (this.encoding_requested) {
                this.manager.tryToSetTorrentEncoding(torrent, this.requested_encoding);
            } else if (this.set_encoding) {
                this.manager.tryToSetDefaultTorrentEncoding(torrent);
            }
            TorrentImpl torrentImpl = new TorrentImpl(torrent);
            return torrentImpl;
        }
        catch (TorrentException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new TorrentException("TorrentDownloader: download fails", e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    Debug.printStackTrace(e);
                }
            }
        }
    }

    public Torrent download(String encoding) throws TorrentException {
        this.encoding_requested = true;
        this.requested_encoding = encoding;
        return this.download();
    }
}

