/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreFactory;
import java.util.List;
import java.util.Properties;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.Plugin;
import org.gudy.azureus2.plugins.PluginException;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.PluginManager;
import org.gudy.azureus2.plugins.installer.PluginInstaller;
import org.gudy.azureus2.pluginsimpl.local.PluginInitializer;
import org.gudy.azureus2.pluginsimpl.local.PluginInterfaceImpl;
import org.gudy.azureus2.pluginsimpl.local.installer.PluginInstallerImpl;
import org.gudy.azureus2.ui.swt.Main;

public class PluginManagerImpl
extends PluginManager {
    protected static boolean running = false;
    protected static PluginManagerImpl singleton;
    protected static AEMonitor class_mon;
    protected static AzureusCore azureus_core;
    protected PluginInitializer pi;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static PluginManagerImpl getSingleton(PluginInitializer pi) {
        try {
            class_mon.enter();
            if (singleton == null) {
                singleton = new PluginManagerImpl(pi);
            }
            PluginManagerImpl pluginManagerImpl = singleton;
            return pluginManagerImpl;
        }
        finally {
            class_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PluginManager startAzureus(int ui_type, Properties properties) {
        try {
            class_mon.enter();
            if (running) {
                throw new RuntimeException("Azureus is already running");
            }
            running = true;
        }
        finally {
            class_mon.exit();
        }
        if (ui_type == 0) {
            try {
                azureus_core = AzureusCoreFactory.create();
                azureus_core.start();
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
                throw new RuntimeException("Azureus failed to start", e);
            }
        } else if (ui_type == 1) {
            String mi;
            if (properties != null && (mi = (String)properties.get("MULTI_INSTANCE")) != null && mi.equalsIgnoreCase("true")) {
                System.setProperty("MULTI_INSTANCE", "true");
            }
            Main.main(new String[0]);
        }
        if (azureus_core == null) {
            throw new RuntimeException("Azureus core failed to initialise");
        }
        return azureus_core.getPluginManager();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void stopAzureus() throws PluginException {
        try {
            class_mon.enter();
            if (!running) {
                throw new RuntimeException("Azureus is not running");
            }
            try {
                azureus_core.requestStop();
            }
            catch (Throwable e) {
                throw new PluginException("PluginManager: Azureus close action failed", e);
            }
            running = false;
        }
        finally {
            class_mon.exit();
        }
    }

    public static void restartAzureus() throws PluginException {
        if (!running) {
            throw new RuntimeException("Azureus is not running");
        }
        try {
            azureus_core.requestRestart();
        }
        catch (Throwable e) {
            throw new PluginException("PluginManager: Azureus restart action failed", e);
        }
        running = false;
    }

    public static void setStartDetails(AzureusCore _core) {
        azureus_core = _core;
        running = true;
    }

    public static void registerPlugin(Class plugin_class) {
        PluginInitializer.queueRegistration(plugin_class);
    }

    public static void registerPlugin(Plugin plugin, String id) {
        PluginInitializer.queueRegistration(plugin, id);
    }

    public PluginInterface getPluginInterfaceByID(String id) {
        PluginInterface[] p = this.getPluginInterfaces();
        for (int i = 0; i < p.length; ++i) {
            if (!p[i].getPluginID().equalsIgnoreCase(id)) continue;
            return p[i];
        }
        return null;
    }

    public PluginInterface getPluginInterfaceByClass(Class c) {
        PluginInterface[] p = this.getPluginInterfaces();
        for (int i = 0; i < p.length; ++i) {
            if (!p[i].getPlugin().getClass().equals(c)) continue;
            return p[i];
        }
        return null;
    }

    public PluginInterface getPluginInterfaceByClass(String class_name) {
        PluginInterface[] p = this.getPluginInterfaces();
        for (int i = 0; i < p.length; ++i) {
            if (!p[i].getPlugin().getClass().getName().equals(class_name)) continue;
            return p[i];
        }
        return null;
    }

    public PluginInterface[] getPluginInterfaces() {
        List l = PluginInitializer.getPluginInterfaces();
        PluginInterface[] res = new PluginInterface[l.size()];
        l.toArray(res);
        return res;
    }

    public PluginInterface getDefaultPluginInterface() {
        return PluginInitializer.getDefaultInterface();
    }

    protected PluginManagerImpl(PluginInitializer _pi) {
        this.pi = _pi;
    }

    public PluginInterface[] getPlugins() {
        return this.pi.getPlugins();
    }

    public void firePluginEvent(int ev) {
        PluginInitializer.fireEvent(ev);
    }

    public PluginInstaller getPluginInstaller() {
        return PluginInstallerImpl.getSingleton(this);
    }

    public void refreshPluginList() {
        List loadedPlugins = this.pi.loadPlugins(this.pi.getAzureusCore(), true);
        for (PluginInterfaceImpl plugin : loadedPlugins) {
            if (plugin.isOperational()) continue;
            try {
                this.pi.reloadPlugin(plugin);
            }
            catch (PluginException e) {
                e.printStackTrace();
            }
        }
    }

    static {
        class_mon = new AEMonitor("PluginManager");
    }
}

