/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.tracker.protocol;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.HostNameToIPResolver;

public class PRHelpers {
    public static int addressToInt(String address) throws UnknownHostException {
        InetAddress i_address = HostNameToIPResolver.syncResolve(address);
        byte[] bytes = i_address.getAddress();
        int resp = bytes[0] << 24 & 0xFF000000 | bytes[1] << 16 & 0xFF0000 | bytes[2] << 8 & 0xFF00 | bytes[3] & 0xFF;
        return resp;
    }

    public static int addressToInt(InetAddress i_address) {
        byte[] bytes = i_address.getAddress();
        int resp = bytes[0] << 24 & 0xFF000000 | bytes[1] << 16 & 0xFF0000 | bytes[2] << 8 & 0xFF00 | bytes[3] & 0xFF;
        return resp;
    }

    public static String intToAddress(int value) {
        byte[] bytes = new byte[]{(byte)(value >> 24), (byte)(value >> 16), (byte)(value >> 8), (byte)value};
        try {
            String res = InetAddress.getByAddress(bytes).getHostAddress();
            return res;
        }
        catch (UnknownHostException e) {
            Debug.printStackTrace(e);
            return null;
        }
    }

    public static void addressTo4ByteArray(String address, byte[] buffer, int offset) throws UnknownHostException {
        InetAddress i_address = HostNameToIPResolver.syncResolve(address);
        byte[] bytes = i_address.getAddress();
        System.arraycopy(bytes, 0, buffer, offset, 4);
    }

    public static String DNSToIPAddress(String dns_name) throws UnknownHostException {
        return HostNameToIPResolver.syncResolve(dns_name).getHostAddress();
    }
}

