/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.tracker.client.impl.bt;

import java.net.URL;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.tracker.client.TRTrackerAnnouncer;
import org.gudy.azureus2.core3.tracker.client.TRTrackerScraperResponse;
import org.gudy.azureus2.core3.tracker.client.impl.TRTrackerScraperImpl;
import org.gudy.azureus2.core3.tracker.client.impl.TRTrackerScraperResponseImpl;
import org.gudy.azureus2.core3.tracker.client.impl.bt.TrackerChecker;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.plugins.download.DownloadScrapeResult;

public class TRTrackerBTScraperImpl {
    protected static TRTrackerBTScraperImpl singleton;
    protected static AEMonitor class_mon;
    private TRTrackerScraperImpl scraper;
    private TrackerChecker tracker_checker;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TRTrackerBTScraperImpl create(TRTrackerScraperImpl _scraper) {
        try {
            class_mon.enter();
            if (singleton == null) {
                singleton = new TRTrackerBTScraperImpl(_scraper);
            }
            TRTrackerBTScraperImpl tRTrackerBTScraperImpl = singleton;
            return tRTrackerBTScraperImpl;
        }
        finally {
            class_mon.exit();
        }
    }

    protected TRTrackerBTScraperImpl(TRTrackerScraperImpl _scraper) {
        this.scraper = _scraper;
        this.tracker_checker = new TrackerChecker(this);
    }

    protected TRTrackerScraperImpl getScraper() {
        return this.scraper;
    }

    public void setScrape(TOTorrent torrent, URL url, DownloadScrapeResult result) {
        TRTrackerScraperResponseImpl resp;
        if (torrent != null && result != null && (resp = this.tracker_checker.getHashData(torrent, url)) != null && resp.getStatus() == 1) {
            resp.setSeedsPeers(result.getSeedCount(), result.getNonSeedCount());
            resp.setScrapeStartTime(result.getScrapeStartTime());
            resp.setStatus(result.getResponseType() == 1 ? 2 : 1, result.getStatus() + " (" + result.getURL() + ")");
            this.scraper.scrapeReceived(resp);
        }
    }

    public TRTrackerScraperResponse scrape(TOTorrent torrent, URL target_url, boolean force) {
        if (torrent == null) {
            return null;
        }
        if (force) {
            this.tracker_checker.syncUpdate(torrent, target_url);
        }
        TRTrackerScraperResponseImpl res = this.tracker_checker.getHashData(torrent, target_url);
        return res;
    }

    public TRTrackerScraperResponse scrape(TRTrackerAnnouncer tracker_client) {
        TRTrackerScraperResponseImpl res = this.tracker_checker.getHashData(tracker_client);
        return res;
    }

    public void remove(TOTorrent torrent) {
        this.tracker_checker.removeHash(torrent);
    }

    static {
        class_mon = new AEMonitor("TRTrackerBTScraper");
    }
}

