/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.peermanager.messaging.advanced;

import java.nio.ByteBuffer;
import org.gudy.azureus2.core3.util.DirectByteBuffer;
import org.gudy.azureus2.core3.util.DirectByteBufferPool;

public class ADVHeaderReader {
    private static final byte SS = 11;
    private static final int SHORT_HEADER_SIZE = 2;
    private static final int LONG_HEADER_SIZE = 4;
    private final DirectByteBuffer short_header_buff = DirectByteBufferPool.getBuffer((byte)12, 2);
    private final DirectByteBuffer long_header_buff = DirectByteBufferPool.getBuffer((byte)12, 4);
    private boolean reading_handshake = true;
    private boolean reading_short_header = false;
    private int message_length;
    private int message_id;
    private int message_sub_id;

    protected ADVHeaderReader() {
    }

    public ByteBuffer getReadBuffer() {
        if (this.reading_short_header) {
            return this.short_header_buff.getBuffer((byte)11);
        }
        return this.long_header_buff.getBuffer((byte)11);
    }

    public boolean isHeaderReadComplete() {
        boolean completed = false;
        if (this.reading_short_header) {
            this.short_header_buff.limit((byte)11, 2);
            if (this.short_header_buff.position((byte)11) == 2) {
                completed = true;
            }
        } else {
            this.long_header_buff.limit((byte)11, 4);
            if (this.long_header_buff.position((byte)11) == 4) {
                completed = true;
            }
        }
        if (completed) {
            if (this.reading_short_header) {
                this.message_length = this.short_header_buff.get((byte)11, 0);
                System.out.println("NOTE: short message length = " + this.message_length);
                if (this.message_length == 255) {
                    this.reading_short_header = false;
                    completed = false;
                } else {
                    this.message_id = this.short_header_buff.get((byte)11, 1) >>> 4;
                    this.message_sub_id = this.short_header_buff.get((byte)11, 1) & 0xF;
                }
            } else if (this.reading_handshake) {
                this.long_header_buff.position((byte)11, 0);
                this.message_length = this.long_header_buff.getInt((byte)11);
                System.out.println("NOTE: handshake message length = " + this.message_length);
                this.message_id = -1;
                this.reading_handshake = false;
                this.reading_short_header = true;
            } else {
                this.message_length = this.short_header_buff.get((byte)11, 1) << 20 | this.long_header_buff.get((byte)11, 0) << 12 | this.long_header_buff.get((byte)11, 1) << 4 | this.long_header_buff.get((byte)11, 2) >>> 4;
                System.out.println("NOTE: long message length = " + this.message_length);
                this.message_id = this.long_header_buff.get((byte)11, 2) << 4 | this.long_header_buff.get((byte)11, 3) >> 4;
                this.message_sub_id = this.long_header_buff.get((byte)11, 3) & 0xF;
                this.reading_short_header = true;
            }
        }
        if (completed) {
            this.short_header_buff.position((byte)11, 0);
            this.long_header_buff.position((byte)11, 0);
        }
        return completed;
    }

    public int getMessageLength() {
        return this.message_length;
    }

    public int getMessageID() {
        return this.message_id;
    }

    public int getMessageSubID() {
        return this.message_sub_id;
    }

    public void destroy() {
        this.short_header_buff.returnToPool();
        this.long_header_buff.returnToPool();
    }
}

