/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TreeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.internal.carbon.CGPoint;
import org.eclipse.swt.internal.carbon.DataBrowserCallbacks;
import org.eclipse.swt.internal.carbon.DataBrowserCustomCallbacks;
import org.eclipse.swt.internal.carbon.DataBrowserListViewColumnDesc;
import org.eclipse.swt.internal.carbon.DataBrowserListViewHeaderDesc;
import org.eclipse.swt.internal.carbon.HMHelpContentRec;
import org.eclipse.swt.internal.carbon.OS;
import org.eclipse.swt.internal.carbon.Point;
import org.eclipse.swt.internal.carbon.Rect;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.TypedListener;

public class Tree
extends Composite {
    TreeItem[] items;
    TreeColumn[] columns;
    TreeColumn sortColumn;
    int[] childIds;
    GC paintGC;
    int sortDirection;
    int columnCount;
    int column_id;
    int idCount;
    int anchorFirst;
    int anchorLast;
    int headerHeight;
    int itemHeight;
    boolean ignoreRedraw;
    boolean ignoreSelect;
    boolean wasSelected;
    boolean ignoreExpand;
    boolean wasExpanded;
    boolean inClearAll;
    boolean drawBackground;
    Rectangle imageBounds;
    TreeItem showItem;
    int lastHittest;
    int visibleCount;
    static final int CHECK_COLUMN_ID = 1024;
    static final int COLUMN_ID = 1025;
    static final int GRID_WIDTH = 1;
    static final int ICON_AND_TEXT_GAP = 4;
    static final int CELL_CONTENT_INSET = 12;
    static final int BORDER_INSET = 1;
    static final int DISCLOSURE_COLUMN_EDGE_INSET = 8;
    static final int DISCLOSURE_TRIANGLE_AND_CONTENT_GAP = 8;

    public Tree(Composite parent, int style) {
        super(parent, Tree.checkStyle(style));
    }

    void _addListener(int eventType, Listener listener) {
        super._addListener(eventType, listener);
        int i = 0;
        while (i < this.items.length) {
            if (this.items[i] != null) {
                this.items[i].width = -1;
            }
            ++i;
        }
    }

    int _getId() {
        return this._getIds(1)[0];
    }

    int[] _getIds(int count) {
        int i;
        int[] newIds = new int[count];
        int index = 0;
        if ((this.style & 0x10000000) == 0) {
            int i2 = 0;
            while (i2 < this.items.length) {
                if (this.items[i2] == null) {
                    newIds[index++] = i2 + 1;
                    if (index == count) {
                        return newIds;
                    }
                }
                ++i2;
            }
            int next = this.items.length;
            while (index < count) {
                newIds[index++] = next + 1;
                ++next;
            }
            return newIds;
        }
        boolean[] reserved = new boolean[this.items.length];
        if (this.childIds != null) {
            i = 0;
            while (i < this.childIds.length) {
                int usedId = this.childIds[i];
                if (usedId != 0) {
                    if (usedId > reserved.length) {
                        boolean[] newReserved = new boolean[usedId + 4];
                        System.arraycopy(reserved, 0, newReserved, 0, reserved.length);
                        reserved = newReserved;
                    }
                    reserved[usedId - 1] = true;
                }
                ++i;
            }
        }
        i = 0;
        while (i < this.items.length) {
            if (this.items[i] != null) {
                reserved[i] = true;
                int[] ids = this.items[i].childIds;
                if (ids != null) {
                    int j = 0;
                    while (j < ids.length) {
                        int usedId = ids[j];
                        if (usedId != 0) {
                            if (usedId > reserved.length) {
                                boolean[] newReserved = new boolean[usedId + 4];
                                System.arraycopy(reserved, 0, newReserved, 0, reserved.length);
                                reserved = newReserved;
                            }
                            reserved[usedId - 1] = true;
                        }
                        ++j;
                    }
                }
            }
            ++i;
        }
        i = 0;
        while (i < reserved.length) {
            if (!reserved[i]) {
                newIds[index++] = i + 1;
                if (index == count) {
                    return newIds;
                }
            }
            ++i;
        }
        int next = reserved.length;
        while (index < count) {
            newIds[index++] = next + 1;
            ++next;
        }
        return newIds;
    }

    TreeItem _getItem(int id, boolean create) {
        int i;
        TreeItem item;
        if (id < 1) {
            return null;
        }
        TreeItem treeItem = item = id - 1 < this.items.length ? this.items[id - 1] : null;
        if (item != null || (this.style & 0x10000000) == 0 || !create) {
            return item;
        }
        if (this.childIds != null) {
            i = 0;
            while (i < this.childIds.length) {
                if (this.childIds[i] == id) {
                    return this._getItem(null, i);
                }
                ++i;
            }
        }
        i = 0;
        while (i < this.items.length) {
            TreeItem parentItem = this.items[i];
            if (parentItem != null && parentItem.childIds != null) {
                int[] ids = parentItem.childIds;
                int j = 0;
                while (j < ids.length) {
                    if (ids[j] == id) {
                        return this._getItem(parentItem, j);
                    }
                    ++j;
                }
            }
            ++i;
        }
        return null;
    }

    TreeItem _getItem(TreeItem parentItem, int index) {
        TreeItem item;
        int count = this.getItemCount(parentItem);
        if (index < 0 || index >= count) {
            return null;
        }
        int[] ids = parentItem == null ? this.childIds : parentItem.childIds;
        int id = ids[index];
        if (id == 0) {
            ids[index] = id = this._getId();
        }
        if (id > this.items.length) {
            TreeItem[] newItems = new TreeItem[id + 4];
            System.arraycopy(this.items, 0, newItems, 0, this.items.length);
            this.items = newItems;
        }
        if ((item = this.items[id - 1]) != null || (this.style & 0x10000000) == 0) {
            return item;
        }
        item = new TreeItem(this, parentItem, 0, index, false);
        item.id = id;
        this.items[id - 1] = item;
        return item;
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    public void addTreeListener(TreeListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(17, typedListener);
        this.addListener(18, typedListener);
    }

    int calculateWidth(int[] ids, GC gc) {
        if (ids == null) {
            return 0;
        }
        int width = 0;
        int i = 0;
        while (i < ids.length) {
            TreeItem item = this._getItem(ids[i], false);
            if (item != null) {
                width = Math.max(width, item.calculateWidth(0, gc));
                if (item._getExpanded()) {
                    width = Math.max(width, this.calculateWidth(item.childIds, gc));
                }
            }
            ++i;
        }
        return width;
    }

    int callPaintEventHandler(int control, int damageRgn, int visibleRgn, int theEvent, int nextHandler) {
        GC currentGC = this.paintGC;
        if (currentGC == null) {
            GCData data = new GCData();
            data.paintEvent = theEvent;
            data.visibleRgn = visibleRgn;
            this.paintGC = GC.carbon_new(this, data);
        }
        this.drawBackground = OS.HIVIEW && this.findBackgroundControl() != null;
        int result = super.callPaintEventHandler(control, damageRgn, visibleRgn, theEvent, nextHandler);
        if (this.getItemCount() == 0 && this.drawBackground) {
            this.drawBackground = false;
            Rectangle rect = this.getClientArea();
            int headerHeight = this.getHeaderHeight();
            rect.y += headerHeight;
            rect.height -= headerHeight;
            this.fillBackground(this.handle, this.paintGC.handle, rect);
        }
        if (currentGC == null) {
            this.paintGC.dispose();
            this.paintGC = null;
        }
        return result;
    }

    boolean checkData(TreeItem item, boolean redraw) {
        if (item.cached) {
            return true;
        }
        if ((this.style & 0x10000000) != 0) {
            item.cached = true;
            Event event = new Event();
            TreeItem parentItem = item.getParentItem();
            event.item = item;
            event.index = parentItem == null ? this.indexOf(item) : parentItem.indexOf(item);
            this.ignoreRedraw = true;
            this.sendEvent(36, event);
            this.ignoreRedraw = false;
            if (this.isDisposed() || item.isDisposed()) {
                return false;
            }
            if (redraw && !this.setScrollWidth(item)) {
                item.redraw(0);
            }
        }
        return true;
    }

    static int checkStyle(int style) {
        return Tree.checkBits(style |= 0x300, 4, 2, 0, 0, 0, 0);
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    void clear(TreeItem parentItem, int index, boolean all) {
        int[] ids = parentItem == null ? this.childIds : parentItem.childIds;
        TreeItem item = this._getItem(ids[index], false);
        if (item != null) {
            item.clear();
            if (all) {
                this.clearAll(item, true);
            } else {
                int container = parentItem == null ? 0 : parentItem.id;
                OS.UpdateDataBrowserItems(this.handle, container, 1, new int[]{item.id}, 0, 0);
            }
        }
    }

    void clearAll(TreeItem parentItem, boolean all) {
        boolean update = !this.inClearAll;
        int count = this.getItemCount(parentItem);
        if (count == 0) {
            return;
        }
        this.inClearAll = true;
        int[] ids = parentItem == null ? this.childIds : parentItem.childIds;
        int i = 0;
        while (i < count) {
            TreeItem item = this._getItem(ids[i], false);
            if (item != null) {
                item.clear();
                if (all) {
                    this.clearAll(item, true);
                }
            }
            ++i;
        }
        if (update) {
            OS.UpdateDataBrowserItems(this.handle, 0, 0, null, 0, 0);
            this.inClearAll = false;
        }
    }

    public void clear(int index, boolean all) {
        this.checkWidget();
        int count = this.getItemCount(null);
        if (index < 0 || index >= count) {
            this.error(6);
        }
        this.clear(null, index, all);
    }

    public void clearAll(boolean all) {
        this.checkWidget();
        this.clearAll(null, all);
    }

    public org.eclipse.swt.graphics.Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        int width = 0;
        if (wHint == -1) {
            if (this.columnCount != 0) {
                int i = 0;
                while (i < this.columnCount) {
                    width += this.columns[i].getWidth();
                    ++i;
                }
            } else {
                int columnWidth = 0;
                GC gc = new GC(this);
                int i = 0;
                while (i < this.items.length) {
                    TreeItem item = this.items[i];
                    if (item != null && item.parentItem == null) {
                        columnWidth = Math.max(columnWidth, this.items[i].calculateWidth(0, gc));
                    }
                    ++i;
                }
                gc.dispose();
                width += columnWidth + this.getInsetWidth(this.column_id, true);
            }
            if ((this.style & 0x20) != 0) {
                width += this.getCheckColumnWidth();
            }
        } else {
            width = wHint;
        }
        if (width <= 0) {
            width = 64;
        }
        int height = 0;
        height = hHint == -1 ? this.getItemCount() * this.getItemHeight() + this.getHeaderHeight() : hHint;
        if (height <= 0) {
            height = 64;
        }
        Rectangle rect = this.computeTrim(0, 0, width, height);
        return new org.eclipse.swt.graphics.Point(rect.width, rect.height);
    }

    public Rectangle computeTrim(int x, int y, int width, int height) {
        this.checkWidget();
        int border = this.getBorder();
        Rect rect = new Rect();
        OS.GetDataBrowserScrollBarInset(this.handle, rect);
        return new Rectangle(x -= rect.left + border, y -= rect.top + border, width += rect.left + rect.right + border + border, height += rect.top + rect.bottom + border + border);
    }

    boolean contains(int shellX, int shellY) {
        int y;
        int x;
        if (OS.HIVIEW) {
            CGPoint pt = new CGPoint();
            int[] contentView = new int[1];
            OS.HIViewFindByID(OS.HIViewGetRoot(OS.GetControlOwner(this.handle)), OS.kHIViewWindowContentID(), contentView);
            OS.HIViewConvertPoint(pt, this.handle, contentView[0]);
            x = shellX - (int)pt.x;
            y = shellY - (int)pt.y;
        } else {
            Rect controlBounds = new Rect();
            OS.GetControlBounds(this.handle, controlBounds);
            x = shellX - controlBounds.left;
            y = shellY - controlBounds.top;
        }
        if (y < this.getHeaderHeight()) {
            return false;
        }
        return this.getClientArea().contains(x, y);
    }

    void createHandle() {
        this.column_id = 1025;
        int[] outControl = new int[1];
        int window = OS.GetControlOwner(this.parent.handle);
        OS.CreateDataBrowserControl(window, null, 1819505782, outControl);
        OS.SetAutomaticControlDragTrackingEnabledForWindow(window, true);
        if (outControl[0] == 0) {
            this.error(2);
        }
        this.handle = outControl[0];
        if (!this.drawFocusRing()) {
            OS.SetControlData(this.handle, 0, 1651663986, 1, new byte[1]);
        }
        int selectionFlags = (this.style & 4) != 0 ? 66 : 8;
        OS.SetDataBrowserSelectionFlags(this.handle, selectionFlags);
        short[] height = new short[1];
        OS.GetDataBrowserListViewHeaderBtnHeight(this.handle, height);
        this.headerHeight = height[0];
        OS.SetDataBrowserListViewHeaderBtnHeight(this.handle, (short)0);
        OS.SetDataBrowserHasScrollBars(this.handle, (this.style & 0x100) != 0, (this.style & 0x200) != 0);
        if (OS.VERSION >= 4160) {
            int inset = 4;
            OS.DataBrowserSetMetric(this.handle, 1, false, inset);
            OS.DataBrowserSetMetric(this.handle, 3, false, inset);
            OS.DataBrowserSetMetric(this.handle, 4, false, inset);
            OS.DataBrowserSetMetric(this.handle, 2, false, inset);
        }
        int position = 0;
        if ((this.style & 0x20) != 0) {
            DataBrowserListViewColumnDesc checkColumn = new DataBrowserListViewColumnDesc();
            checkColumn.headerBtnDesc_version = 0;
            checkColumn.propertyDesc_propertyID = 1024;
            checkColumn.propertyDesc_propertyType = 1667785336;
            checkColumn.propertyDesc_propertyFlags = 1;
            int checkWidth = this.getCheckColumnWidth();
            checkColumn.headerBtnDesc_minimumWidth = (short)checkWidth;
            checkColumn.headerBtnDesc_maximumWidth = (short)checkWidth;
            checkColumn.headerBtnDesc_initialOrder = 1;
            OS.AddDataBrowserListViewColumn(this.handle, checkColumn, position++);
        }
        DataBrowserListViewColumnDesc column = new DataBrowserListViewColumnDesc();
        column.headerBtnDesc_version = 0;
        column.propertyDesc_propertyID = this.column_id;
        column.propertyDesc_propertyType = 0x3F3F3F3F;
        column.propertyDesc_propertyFlags = 327680;
        column.headerBtnDesc_maximumWidth = Short.MAX_VALUE;
        column.headerBtnDesc_initialOrder = 1;
        OS.AddDataBrowserListViewColumn(this.handle, column, position);
        OS.SetDataBrowserListViewDisclosureColumn(this.handle, this.column_id, false);
        OS.SetDataBrowserTableViewNamedColumnWidth(this.handle, this.column_id, (short)0);
        if (OS.HIVIEW) {
            OS.HIViewSetDrawingEnabled(this.handle, false);
        }
        int size = 50;
        Rect rect = new Rect();
        rect.right = rect.bottom = (short)size;
        OS.SetControlBounds(this.handle, rect);
        int bpl = size * 4;
        int[] gWorld = new int[1];
        int data = OS.NewPtr(bpl * size);
        OS.NewGWorldFromPtr(gWorld, 32, rect, 0, 0, 0, data, bpl);
        int[] curPort = new int[1];
        int[] curGWorld = new int[1];
        OS.GetGWorld(curPort, curGWorld);
        OS.SetGWorld(gWorld[0], curGWorld[0]);
        OS.DrawControlInCurrentPort(this.handle);
        OS.SetGWorld(curPort[0], curGWorld[0]);
        OS.DisposeGWorld(gWorld[0]);
        OS.DisposePtr(data);
        rect.bottom = 0;
        rect.right = 0;
        OS.SetControlBounds(this.handle, rect);
        if (OS.HIVIEW) {
            OS.HIViewSetDrawingEnabled(this.handle, true);
        }
    }

    void createItem(TreeColumn column, int index) {
        if (index < 0 || index > this.columnCount) {
            this.error(6);
        }
        if (index == 0) {
            column.style &= 0xFEFDBFFF;
            column.style |= 0x4000;
        }
        column.id = this.column_id + this.idCount++;
        int position = index + ((this.style & 0x20) != 0 ? 1 : 0);
        if (this.columnCount != 0) {
            DataBrowserListViewColumnDesc desc = new DataBrowserListViewColumnDesc();
            desc.headerBtnDesc_version = 0;
            desc.propertyDesc_propertyID = column.id;
            desc.propertyDesc_propertyType = 0x3F3F3F3F;
            desc.propertyDesc_propertyFlags = 327680;
            desc.headerBtnDesc_maximumWidth = Short.MAX_VALUE;
            desc.headerBtnDesc_initialOrder = 1;
            desc.headerBtnDesc_btnFontStyle_just = (short)-2;
            if ((this.style & 0x1000000) != 0) {
                desc.headerBtnDesc_btnFontStyle_just = 1;
            }
            if ((this.style & 0x20000) != 0) {
                desc.headerBtnDesc_btnFontStyle_just = (short)-1;
            }
            desc.headerBtnDesc_btnFontStyle_flags = (short)(desc.headerBtnDesc_btnFontStyle_flags | 0x40);
            OS.AddDataBrowserListViewColumn(this.handle, desc, position);
            OS.SetDataBrowserTableViewNamedColumnWidth(this.handle, column.id, (short)0);
            if (index == 0) {
                int[] disclosure = new int[1];
                boolean[] expandableRows = new boolean[1];
                OS.GetDataBrowserListViewDisclosureColumn(this.handle, disclosure, expandableRows);
                OS.SetDataBrowserListViewDisclosureColumn(this.handle, column.id, expandableRows[0]);
            }
        }
        if (this.columnCount == this.columns.length) {
            TreeColumn[] newColumns = new TreeColumn[this.columnCount + 4];
            System.arraycopy(this.columns, 0, newColumns, 0, this.columns.length);
            this.columns = newColumns;
        }
        System.arraycopy(this.columns, index, this.columns, index + 1, this.columnCount++ - index);
        this.columns[index] = column;
        if (this.columnCount > 1) {
            int i = 0;
            while (i < this.items.length) {
                TreeItem item = this.items[i];
                if (item != null) {
                    Font[] cellFont;
                    Color[] cellForeground;
                    Color[] cellBackground;
                    Image[] images;
                    String[] strings = item.strings;
                    if (strings != null) {
                        String[] temp = new String[this.columnCount];
                        System.arraycopy(strings, 0, temp, 0, index);
                        System.arraycopy(strings, index, temp, index + 1, this.columnCount - index - 1);
                        temp[index] = "";
                        item.strings = temp;
                    }
                    if (index == 0) {
                        item.text = "";
                    }
                    if ((images = item.images) != null) {
                        Image[] temp = new Image[this.columnCount];
                        System.arraycopy(images, 0, temp, 0, index);
                        System.arraycopy(images, index, temp, index + 1, this.columnCount - index - 1);
                        item.images = temp;
                    }
                    if (index == 0) {
                        item.image = null;
                    }
                    if ((cellBackground = item.cellBackground) != null) {
                        Color[] temp = new Color[this.columnCount];
                        System.arraycopy(cellBackground, 0, temp, 0, index);
                        System.arraycopy(cellBackground, index, temp, index + 1, this.columnCount - index - 1);
                        item.cellBackground = temp;
                    }
                    if ((cellForeground = item.cellForeground) != null) {
                        Color[] temp = new Color[this.columnCount];
                        System.arraycopy(cellForeground, 0, temp, 0, index);
                        System.arraycopy(cellForeground, index, temp, index + 1, this.columnCount - index - 1);
                        item.cellForeground = temp;
                    }
                    if ((cellFont = item.cellFont) != null) {
                        Font[] temp = new Font[this.columnCount];
                        System.arraycopy(cellFont, 0, temp, 0, index);
                        System.arraycopy(cellFont, index, temp, index + 1, this.columnCount - index - 1);
                        item.cellFont = temp;
                    }
                }
                ++i;
            }
        }
    }

    void createItem(TreeItem item, TreeItem parentItem, int index) {
        int[] ids;
        int id;
        int count = this.getItemCount(parentItem);
        if (index == -1) {
            index = count;
        }
        if (index < 0 || index > count) {
            this.error(6);
        }
        if ((id = this._getId()) > this.items.length) {
            TreeItem[] newItems = new TreeItem[id + 4];
            System.arraycopy(this.items, 0, newItems, 0, this.items.length);
            this.items = newItems;
        }
        item.id = id;
        this.items[id - 1] = item;
        int[] nArray = ids = parentItem == null ? this.childIds : parentItem.childIds;
        if (ids == null || count + 1 > ids.length) {
            int[] newIds = new int[count + 4];
            if (ids != null) {
                System.arraycopy(ids, 0, newIds, 0, ids.length);
            }
            ids = newIds;
            if (parentItem == null) {
                this.childIds = ids;
            } else {
                parentItem.childIds = ids;
            }
        }
        System.arraycopy(ids, index, ids, index + 1, ids.length - index - 1);
        ids[index] = id;
        if (parentItem != null) {
            ++parentItem.itemCount;
        }
        if (parentItem == null || parentItem.getExpanded()) {
            int parentID;
            int n = parentID = parentItem == null ? 0 : parentItem.id;
            if (OS.AddDataBrowserItems(this.handle, parentID, 1, new int[]{item.id}, 0) != 0) {
                this.items[id - 1] = null;
                System.arraycopy(ids, index + 1, ids, index, ids.length - index - 1);
                this.error(14);
            }
            ++this.visibleCount;
        } else if (parentItem != null && parentItem.itemCount == 1) {
            parentItem.redraw(0);
        }
    }

    ScrollBar createScrollBar(int style) {
        return this.createStandardBar(style);
    }

    void createWidget() {
        super.createWidget();
        this.items = new TreeItem[4];
        this.columns = new TreeColumn[4];
        this.itemHeight = -1;
    }

    Color defaultBackground() {
        return this.display.getSystemColor(25);
    }

    Color defaultForeground() {
        return this.display.getSystemColor(24);
    }

    int defaultThemeFont() {
        if (this.display.smallFonts) {
            return 1;
        }
        return 3;
    }

    public void deselectAll() {
        this.checkWidget();
        this.ignoreSelect = true;
        int[] selectionFlags = null;
        if ((this.style & 4) != 0) {
            selectionFlags = new int[1];
            OS.GetDataBrowserSelectionFlags(this.handle, selectionFlags);
            OS.SetDataBrowserSelectionFlags(this.handle, selectionFlags[0] & 0xFFFFFFBF);
        }
        OS.SetDataBrowserSelectedItems(this.handle, 0, null, 3);
        if ((this.style & 4) != 0) {
            OS.SetDataBrowserSelectionFlags(this.handle, selectionFlags[0]);
        }
        this.ignoreSelect = false;
    }

    void destroyItem(TreeColumn column) {
        int index = 0;
        while (index < this.columnCount) {
            if (this.columns[index] == column) break;
            ++index;
        }
        int i = 0;
        while (i < this.items.length) {
            TreeItem item = this.items[i];
            if (item != null) {
                if (this.columnCount <= 1) {
                    item.strings = null;
                    item.images = null;
                    item.cellBackground = null;
                    item.cellForeground = null;
                    item.cellFont = null;
                } else {
                    Object[] temp;
                    if (item.strings != null) {
                        String[] strings = item.strings;
                        if (index == 0) {
                            item.text = strings[1] != null ? strings[1] : "";
                        }
                        temp = new String[this.columnCount - 1];
                        System.arraycopy(strings, 0, temp, 0, index);
                        System.arraycopy(strings, index + 1, temp, index, this.columnCount - 1 - index);
                        item.strings = temp;
                    } else if (index == 0) {
                        item.text = "";
                    }
                    if (item.images != null) {
                        Image[] images = item.images;
                        if (index == 0) {
                            item.image = images[1];
                        }
                        temp = new Image[this.columnCount - 1];
                        System.arraycopy(images, 0, temp, 0, index);
                        System.arraycopy(images, index + 1, temp, index, this.columnCount - 1 - index);
                        item.images = temp;
                    } else if (index == 0) {
                        item.image = null;
                    }
                    if (item.cellBackground != null) {
                        Color[] cellBackground = item.cellBackground;
                        temp = new Color[this.columnCount - 1];
                        System.arraycopy(cellBackground, 0, temp, 0, index);
                        System.arraycopy(cellBackground, index + 1, temp, index, this.columnCount - 1 - index);
                        item.cellBackground = temp;
                    }
                    if (item.cellForeground != null) {
                        Color[] cellForeground = item.cellForeground;
                        temp = new Color[this.columnCount - 1];
                        System.arraycopy(cellForeground, 0, temp, 0, index);
                        System.arraycopy(cellForeground, index + 1, temp, index, this.columnCount - 1 - index);
                        item.cellForeground = temp;
                    }
                    if (item.cellFont != null) {
                        Font[] cellFont = item.cellFont;
                        temp = new Font[this.columnCount - 1];
                        System.arraycopy(cellFont, 0, temp, 0, index);
                        System.arraycopy(cellFont, index + 1, temp, index, this.columnCount - 1 - index);
                        item.cellFont = temp;
                    }
                }
            }
            ++i;
        }
        if (this.columnCount == 1) {
            int str;
            this.column_id = column.id;
            this.idCount = 0;
            DataBrowserListViewHeaderDesc desc = new DataBrowserListViewHeaderDesc();
            desc.version = 0;
            short[] width = new short[1];
            OS.GetDataBrowserTableViewNamedColumnWidth(this.handle, this.column_id, width);
            desc.minimumWidth = desc.maximumWidth = width[0];
            desc.titleString = str = OS.CFStringCreateWithCharacters(0, null, 0);
            OS.SetDataBrowserListViewHeaderDesc(this.handle, this.column_id, desc);
            OS.CFRelease(str);
        } else {
            int[] disclosure = new int[1];
            boolean[] expandableRows = new boolean[1];
            OS.GetDataBrowserListViewDisclosureColumn(this.handle, disclosure, expandableRows);
            if (disclosure[0] == column.id) {
                TreeColumn firstColumn = this.columns[1];
                firstColumn.style &= 0xFEFDBFFF;
                firstColumn.style |= 0x4000;
                firstColumn.updateHeader();
                OS.SetDataBrowserListViewDisclosureColumn(this.handle, firstColumn.id, expandableRows[0]);
            }
            if (OS.RemoveDataBrowserTableViewColumn(this.handle, column.id) != 0) {
                this.error(15);
            }
        }
        System.arraycopy(this.columns, index + 1, this.columns, index, --this.columnCount - index);
        this.columns[this.columnCount] = null;
        i = index;
        while (i < this.columnCount) {
            this.columns[i].sendEvent(10);
            ++i;
        }
    }

    void destroyItem(TreeItem item) {
        TreeItem parentItem = item.parentItem;
        if (parentItem == null || parentItem.getExpanded()) {
            int parentID = parentItem == null ? 0 : parentItem.id;
            this.ignoreExpand = true;
            if (OS.RemoveDataBrowserItems(this.handle, parentID, 1, new int[]{item.id}, 0) != 0) {
                this.error(15);
            }
            --this.visibleCount;
            this.ignoreExpand = false;
        }
        if (parentItem != null && !parentItem.getExpanded() && parentItem.itemCount > 0) {
            parentItem.redraw(0);
        }
        this.releaseItem(item, false);
        this.setScrollWidth(true);
        this.fixScrollBar();
    }

    int drawItemProc(int browser, int id, int property, int itemState, int theRect, int gdDepth, int colorDevice) {
        boolean wasSelected;
        if (id < 0) {
            return 0;
        }
        int columnIndex = 0;
        if (this.columnCount > 0) {
            columnIndex = 0;
            while (columnIndex < this.columnCount) {
                if (this.columns[columnIndex].id == property) break;
                ++columnIndex;
            }
            if (columnIndex == this.columnCount) {
                return 0;
            }
        }
        short offsetX = 0;
        short offsetY = 0;
        Rect rect = new Rect();
        OS.GetControlBounds(this.handle, rect);
        if (!OS.HIVIEW) {
            offsetX = rect.left;
            offsetY = rect.top;
        }
        TreeItem item = this._getItem(id, true);
        if ((this.style & 0x10000000) != 0 && !item.cached) {
            if (!this.checkData(item, false)) {
                return 0;
            }
            if (this.setScrollWidth(item)) {
                if (OS.GetDataBrowserItemPartBounds(this.handle, id, property, 0, rect) == 0) {
                    int x = rect.left - offsetX;
                    int y = rect.top - offsetY;
                    int width = rect.right - rect.left;
                    int height = rect.bottom - rect.top;
                    this.redrawWidget(this.handle, x, y, width, height, false);
                }
                return 0;
            }
        }
        OS.memcpy(rect, theRect, 8);
        int x = rect.left - offsetX;
        int y = rect.top - offsetY;
        int width = rect.right - rect.left;
        int height = rect.bottom - rect.top;
        GC gc = this.paintGC;
        if (gc == null) {
            GCData data = new GCData();
            int[] port = new int[1];
            OS.GetPort(port);
            data.port = port[0];
            gc = GC.carbon_new(this, data);
        }
        OS.GetDataBrowserItemPartBounds(this.handle, id, property, 0, rect);
        if (!OS.HIVIEW) {
            OS.OffsetRect(rect, -offsetX, -offsetX);
        }
        short gridWidth = this.getLinesVisible() ? (short)1 : 0;
        int itemX = rect.left + gridWidth;
        short itemY = rect.top;
        int itemWidth = rect.right - rect.left - gridWidth;
        int itemHeight = rect.bottom - rect.top + 1;
        if (this.drawBackground) {
            this.drawBackground = false;
            Region region = new Region(this.display);
            Rectangle clientArea = this.getClientArea();
            int headerHeight = this.getHeaderHeight();
            clientArea.y += headerHeight;
            clientArea.height -= headerHeight;
            region.add(clientArea);
            if ((this.style & 0x20) != 0 || gridWidth != 0) {
                int rgn = OS.NewRgn();
                if ((this.style & 0x20) != 0 && OS.GetDataBrowserItemPartBounds(this.handle, id, 1024, 0, rect) == 0) {
                    OS.SetRectRgn(rgn, rect.left, (short)clientArea.y, (short)(rect.right + gridWidth), (short)(clientArea.y + clientArea.height));
                    OS.DiffRgn(region.handle, rgn, region.handle);
                }
                if (gridWidth != 0) {
                    if (this.columnCount == 0) {
                        if (OS.GetDataBrowserItemPartBounds(this.handle, id, 1025, 0, rect) == 0) {
                            OS.SetRectRgn(rgn, rect.right, (short)clientArea.y, (short)(rect.right + gridWidth), (short)(clientArea.y + clientArea.height));
                            OS.DiffRgn(region.handle, rgn, region.handle);
                        }
                    } else {
                        int i = 0;
                        while (i < this.columnCount) {
                            if (OS.GetDataBrowserItemPartBounds(this.handle, id, this.columns[i].id, 0, rect) == 0) {
                                OS.SetRectRgn(rgn, rect.right, (short)clientArea.y, (short)(rect.right + gridWidth), (short)(clientArea.y + clientArea.height));
                                OS.DiffRgn(region.handle, rgn, region.handle);
                            }
                            ++i;
                        }
                    }
                }
                OS.DisposeRgn(rgn);
            }
            if (region != null) {
                gc.setClipping(region);
            }
            this.fillBackground(this.handle, gc.handle, null);
            if (region != null) {
                gc.setClipping((Rectangle)null);
                region.dispose();
            }
        }
        OS.CGContextSaveGState(gc.handle);
        int itemRgn = OS.NewRgn();
        OS.SetRectRgn(itemRgn, (short)itemX, itemY, (short)(itemX + itemWidth), (short)(itemY + itemHeight));
        int clip = OS.NewRgn();
        OS.GetClip(clip);
        if (!OS.HIVIEW) {
            OS.OffsetRgn(clip, -offsetX, -offsetY);
        }
        OS.SectRgn(clip, itemRgn, itemRgn);
        OS.DisposeRgn(clip);
        Region region = Region.carbon_new(this.display, itemRgn);
        Font font = item.getFont(columnIndex);
        Color background = item.getBackground(columnIndex);
        Color foreground = item.getForeground(columnIndex);
        Image image = item.getImage(columnIndex);
        String text = item.getText(columnIndex);
        gc.setClipping(region);
        gc.setFont(font);
        org.eclipse.swt.graphics.Point extent = gc.stringExtent(text);
        int contentWidth = extent.x;
        Rectangle imageBounds = null;
        int gap = 0;
        if (image != null) {
            gap = this.getGap();
            imageBounds = image.getBounds();
            contentWidth += this.imageBounds.width + gap;
        }
        int paintWidth = contentWidth;
        if (this.hooks(41)) {
            Event event = new Event();
            event.item = item;
            event.index = columnIndex;
            event.gc = gc;
            event.width = contentWidth;
            event.height = itemHeight;
            this.sendEvent(41, event);
            if (this.itemHeight < event.height) {
                this.itemHeight = event.height;
                OS.SetDataBrowserTableViewRowHeight(this.handle, (short)event.height);
            }
            if (this.setScrollWidth(item)) {
                this.redrawWidget(this.handle, false);
            }
            contentWidth = event.width;
            itemHeight = event.height;
            gc.setClipping(region);
            gc.setFont(font);
        }
        int drawState = 16;
        if (item.background != null || item.cellBackground != null && item.cellBackground[columnIndex] != null) {
            drawState |= 8;
        }
        if ((itemState & 5) != 0) {
            drawState |= 2;
        }
        boolean bl = wasSelected = (drawState & 2) != 0;
        if ((drawState & 2) != 0 && ((this.style & 0x10000) != 0 || columnIndex == 0)) {
            gc.setBackground(this.display.getSystemColor(26));
            gc.setForeground(this.display.getSystemColor(27));
        } else {
            gc.setBackground(background);
            gc.setForeground(foreground);
        }
        if (this.hooks(40)) {
            Event event = new Event();
            event.item = item;
            event.index = columnIndex;
            event.gc = gc;
            event.x = itemX;
            event.y = itemY;
            event.width = itemWidth;
            event.height = itemHeight;
            event.detail = drawState;
            this.sendEvent(40, event);
            drawState = event.doit ? event.detail : 0;
            gc.setClipping(region);
            gc.setFont(font);
            if ((drawState & 2) != 0 && ((this.style & 0x10000) != 0 || columnIndex == 0)) {
                gc.setBackground(this.display.getSystemColor(26));
                gc.setForeground(this.display.getSystemColor(27));
            } else {
                gc.setBackground(background);
                if (!wasSelected) {
                    gc.setForeground(foreground);
                }
            }
        }
        if (this.columnCount != 0) {
            TreeColumn column = this.columns[columnIndex];
            if ((column.style & 0x1000000) != 0) {
                x += (width - contentWidth) / 2;
            }
            if ((column.style & 0x20000) != 0) {
                x += width - contentWidth;
            }
        }
        int stringX = x;
        if (image != null) {
            stringX += this.imageBounds.width + gap;
        }
        if ((drawState & 2) != 0 && ((this.style & 0x10000) != 0 || columnIndex == 0)) {
            if ((this.style & 0x8000) == 0 || this.hasFocus()) {
                if ((this.style & 0x10000) != 0) {
                    gc.fillRectangle(itemX, itemY, itemWidth, itemHeight - 1);
                    drawState &= 0xFFFFFFF7;
                } else if (columnIndex == 0) {
                    gc.fillRectangle(stringX - 1, y, extent.x + 2, itemHeight - 1);
                    drawState &= 0xFFFFFFF7;
                }
            } else if ((drawState & 8) != 0) {
                gc.setBackground(background);
            }
        }
        if ((drawState & 8) != 0) {
            gc.fillRectangle(itemX, itemY, itemWidth, itemHeight);
        }
        if ((drawState & 0x10) != 0) {
            if (image != null) {
                int imageX = x;
                int imageY = y + (height - this.imageBounds.height) / 2;
                gc.drawImage(image, 0, 0, imageBounds.width, imageBounds.height, imageX, imageY, this.imageBounds.width, this.imageBounds.height);
            }
            gc.drawString(text, stringX, y + (height - extent.y) / 2, true);
        }
        if (this.hooks(42)) {
            Event event = new Event();
            event.item = item;
            event.index = columnIndex;
            event.gc = gc;
            event.x = x;
            event.y = y;
            event.width = paintWidth;
            event.height = itemHeight;
            event.detail = drawState;
            this.sendEvent(42, event);
        }
        OS.CGContextRestoreGState(gc.handle);
        OS.DisposeRgn(itemRgn);
        if (gc != this.paintGC) {
            gc.dispose();
        }
        return 0;
    }

    void fixScrollBar() {
        int[] top = new int[1];
        int[] left = new int[1];
        OS.GetDataBrowserScrollPosition(this.handle, top, left);
        int maximum = Math.max(0, this.getItemHeight() * this.visibleCount - this.getClientArea().height);
        if (top[0] > maximum) {
            OS.SetDataBrowserScrollPosition(this.handle, maximum, left[0]);
        }
    }

    int getBorder() {
        int border = 0;
        byte[] hasBorder = new byte[1];
        OS.GetControlData(this.handle, (short)0, 1651663986, 1, hasBorder, null);
        if (hasBorder[0] != 0) {
            int[] outMetric = new int[1];
            OS.GetThemeMetric(7, outMetric);
            border += outMetric[0] - 1;
        }
        return border;
    }

    int getCheckColumnWidth() {
        int inset = 0;
        if (OS.VERSION >= 4160) {
            float[] metric = new float[1];
            OS.DataBrowserGetMetric(this.handle, 1, null, metric);
            inset = (int)metric[0];
        } else {
            inset = 12;
        }
        int[] checkWidth = new int[1];
        OS.GetThemeMetric(50, checkWidth);
        return checkWidth[0] + inset * 2;
    }

    public Rectangle getClientArea() {
        this.checkWidget();
        int border = this.getBorder();
        Rect rect = new Rect();
        Rect inset = new Rect();
        OS.GetControlBounds(this.handle, rect);
        OS.GetDataBrowserScrollBarInset(this.handle, inset);
        int width = Math.max(0, rect.right - rect.left - inset.right - border - border);
        int height = Math.max(0, rect.bottom - rect.top - inset.bottom - border - border);
        return new Rectangle(inset.left + border, inset.top + border, width, height);
    }

    public TreeColumn getColumn(int index) {
        this.checkWidget();
        if (index < 0 || index >= this.columnCount) {
            this.error(6);
        }
        return this.columns[index];
    }

    public int getColumnCount() {
        this.checkWidget();
        return this.columnCount;
    }

    public int[] getColumnOrder() {
        this.checkWidget();
        int[] order = new int[this.columnCount];
        int[] position = new int[1];
        int i = 0;
        while (i < this.columnCount) {
            TreeColumn column = this.columns[i];
            OS.GetDataBrowserTableViewColumnPosition(this.handle, column.id, position);
            if ((this.style & 0x20) != 0) {
                position[0] = position[0] - 1;
            }
            order[position[0]] = i++;
        }
        return order;
    }

    public TreeColumn[] getColumns() {
        this.checkWidget();
        TreeColumn[] result = new TreeColumn[this.columnCount];
        System.arraycopy(this.columns, 0, result, 0, this.columnCount);
        return result;
    }

    int getGap() {
        if (OS.VERSION >= 4160) {
            float[] metric = new float[1];
            OS.DataBrowserGetMetric(this.handle, 2, null, metric);
            return (int)metric[0];
        }
        return 4;
    }

    public int getGridLineWidth() {
        this.checkWidget();
        return 0;
    }

    public int getHeaderHeight() {
        this.checkWidget();
        short[] height = new short[1];
        OS.GetDataBrowserListViewHeaderBtnHeight(this.handle, height);
        return height[0];
    }

    public boolean getHeaderVisible() {
        this.checkWidget();
        short[] height = new short[1];
        OS.GetDataBrowserListViewHeaderBtnHeight(this.handle, height);
        return height[0] != 0;
    }

    int getLeftDisclosureInset(int column_id) {
        int[] disclosure = new int[1];
        OS.GetDataBrowserListViewDisclosureColumn(this.handle, disclosure, new boolean[1]);
        if (disclosure[0] == column_id) {
            int width = 0;
            int[] metric1 = new int[1];
            OS.GetThemeMetric(26, metric1);
            width += metric1[0];
            if (OS.VERSION >= 4160) {
                float[] metric = new float[1];
                OS.DataBrowserGetMetric(this.handle, 3, null, metric);
                width += (int)metric[0];
                OS.DataBrowserGetMetric(this.handle, 4, null, metric);
                width += (int)metric[0];
            } else {
                width += 16;
            }
            return width;
        }
        return 0;
    }

    int getInsetWidth(int column_id, boolean leftInset) {
        int inset = 0;
        if (OS.VERSION >= 4160) {
            float[] metric = new float[1];
            OS.DataBrowserGetMetric(this.handle, 1, null, metric);
            inset = (int)metric[0];
        } else {
            inset = 12;
        }
        int width = 0;
        int[] disclosure = new int[1];
        OS.GetDataBrowserListViewDisclosureColumn(this.handle, disclosure, new boolean[1]);
        if (disclosure[0] != column_id) {
            width += inset * 2;
        } else {
            width += inset;
            if (leftInset) {
                width += this.getLeftDisclosureInset(column_id);
            }
        }
        return width;
    }

    public TreeItem getItem(int index) {
        this.checkWidget();
        int count = this.getItemCount(null);
        if (index < 0 || index >= count) {
            this.error(6);
        }
        return this._getItem(null, index);
    }

    public TreeItem getItem(org.eclipse.swt.graphics.Point point) {
        TreeItem item;
        int columnId;
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        Rect rect = new Rect();
        if (!OS.HIVIEW) {
            OS.GetControlBounds(this.handle, rect);
        }
        Point pt = new Point();
        OS.SetPt(pt, (short)(point.x + rect.left), (short)(point.y + rect.top));
        int n = columnId = this.columnCount == 0 ? this.column_id : this.columns[0].id;
        if (this.lastHittest > 0 && this.lastHittest <= this.items.length && (item = this._getItem(this.lastHittest, false)) != null && OS.GetDataBrowserItemPartBounds(this.handle, item.id, columnId, 0, rect) == 0 && rect.top <= pt.v && pt.v <= rect.bottom) {
            if ((this.style & 0x10000) != 0) {
                return item;
            }
            return OS.PtInRect(pt, rect) ? item : null;
        }
        int i = 0;
        while (i < this.items.length) {
            TreeItem item2 = this.items[i];
            if (item2 != null && OS.GetDataBrowserItemPartBounds(this.handle, item2.id, columnId, 0, rect) == 0 && rect.top <= pt.v && pt.v <= rect.bottom) {
                if ((this.style & 0x10000) != 0) {
                    return item2;
                }
                return OS.PtInRect(pt, rect) ? item2 : null;
            }
            ++i;
        }
        return null;
    }

    public int getItemCount() {
        this.checkWidget();
        return this.getItemCount(null);
    }

    int getItemCount(TreeItem parentItem) {
        if (parentItem == null) {
            int[] count = new int[1];
            if (OS.GetDataBrowserItemCount(this.handle, 0, false, -1, count) == 0) {
                return count[0];
            }
            return 0;
        }
        return parentItem.itemCount;
    }

    public int getItemHeight() {
        this.checkWidget();
        short[] height = new short[1];
        if (OS.GetDataBrowserTableViewRowHeight(this.handle, height) != 0) {
            this.error(11);
        }
        return height[0];
    }

    public TreeItem[] getItems() {
        this.checkWidget();
        return this.getItems(null);
    }

    TreeItem[] getItems(TreeItem parentItem) {
        if (this.items == null) {
            return new TreeItem[0];
        }
        int count = this.getItemCount(parentItem);
        TreeItem[] result = new TreeItem[count];
        int i = 0;
        while (i < count) {
            result[i] = this._getItem(parentItem, i);
            ++i;
        }
        return result;
    }

    public boolean getLinesVisible() {
        this.checkWidget();
        if (OS.VERSION >= 4160) {
            int[] attrib = new int[1];
            OS.DataBrowserGetAttributes(this.handle, attrib);
            return (attrib[0] & 6) != 0;
        }
        return false;
    }

    public TreeItem getParentItem() {
        this.checkWidget();
        return null;
    }

    public TreeItem[] getSelection() {
        this.checkWidget();
        int ptr = OS.NewHandle(0);
        if (OS.GetDataBrowserItems(this.handle, 0, true, 1, ptr) != 0) {
            this.error(9);
        }
        int count = OS.GetHandleSize(ptr) / 4;
        TreeItem[] result = new TreeItem[count];
        if (count > 0) {
            OS.HLock(ptr);
            int[] start = new int[1];
            OS.memcpy(start, ptr, 4);
            int[] id = new int[1];
            int i = 0;
            while (i < count) {
                OS.memcpy(id, start[0] + i * 4, 4);
                result[i] = this._getItem(id[0], true);
                ++i;
            }
            OS.HUnlock(ptr);
        }
        OS.DisposeHandle(ptr);
        return result;
    }

    public int getSelectionCount() {
        this.checkWidget();
        int[] count = new int[1];
        if (OS.GetDataBrowserItemCount(this.handle, 0, true, 1, count) != 0) {
            this.error(36);
        }
        return count[0];
    }

    public TreeColumn getSortColumn() {
        this.checkWidget();
        return this.sortColumn;
    }

    public int getSortDirection() {
        this.checkWidget();
        return this.sortDirection;
    }

    public TreeItem getTopItem() {
        this.checkWidget();
        Rect rect = new Rect();
        if (!OS.HIVIEW) {
            OS.GetControlBounds(this.handle, rect);
        }
        int y = rect.top + this.getBorder() + this.getHeaderHeight();
        int i = 0;
        while (i < this.items.length) {
            TreeItem item = this.items[i];
            if (item != null) {
                int columnId;
                int n = columnId = this.columnCount == 0 ? this.column_id : this.columns[0].id;
                if (OS.GetDataBrowserItemPartBounds(this.handle, item.id, columnId, 0, rect) == 0 && rect.top <= y && y <= rect.bottom) {
                    return item;
                }
            }
            ++i;
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    int helpProc(int inControl, int inGlobalMouse, int inRequest, int outContentProvided, int ioHelpContent) {
        switch (inRequest) {
            case 0: {
                if (this.toolTipText != null && this.toolTipText.length() != 0) break;
                rect = new Rect();
                window = OS.GetControlOwner(this.handle);
                OS.GetWindowBounds(window, (short)33, rect);
                windowLeft = rect.left;
                windowTop = rect.top;
                pt = new Point();
                pt.h = (short)((inGlobalMouse & 65535) - windowLeft);
                pt.v = (short)((inGlobalMouse >> 16) - windowTop);
                if (!this.contains(pt.h, pt.v)) break;
                toolTipText = null;
                tagSide = 23;
                if (OS.HIVIEW) {
                    inPt = new CGPoint();
                    contentView = new int[1];
                    OS.HIViewFindByID(OS.HIViewGetRoot(OS.GetControlOwner(this.handle)), OS.kHIViewWindowContentID(), contentView);
                    OS.HIViewConvertPoint(inPt, this.handle, contentView[0]);
                    pt.h = (short)(pt.h - (int)inPt.x);
                    pt.v = (short)(pt.v - (int)inPt.y);
                    windowLeft = (short)(windowLeft + (int)inPt.x);
                    windowTop = (short)(windowTop + (int)inPt.y);
                    x = pt.h;
                    y = pt.v;
                } else {
                    OS.GetControlBounds(this.handle, rect);
                    x = pt.h - rect.left;
                    y = pt.v - rect.top;
                }
                headerHeight = this.getHeaderHeight();
                if (headerHeight == 0 || y < 0 || y >= headerHeight) ** GOTO lbl50
                startX = 0;
                i = 0;
                while (i < this.columnCount) {
                    column = this.columns[i];
                    width = column.lastWidth + this.getLeftDisclosureInset(column.id);
                    if (startX > x || x >= startX + width) ** GOTO lbl46
                    toolTipText = column.toolTipText;
                    rect.left = (short)startX;
                    rect.right = (short)(rect.left + width);
                    rect.bottom = (short)(rect.top + headerHeight);
                    tagSide = 10;
                    ** GOTO lbl94
lbl46:
                    // 1 sources

                    startX += width;
                    ++i;
                }
                ** GOTO lbl94
lbl50:
                // 1 sources

                columnIndex = 0;
                item = null;
                column = null;
                i = 0;
                while (i < this.items.length && item == null) {
                    nextItem = this.items[i];
                    if (nextItem != null) {
                        if (this.columnCount == 0) {
                            if (OS.GetDataBrowserItemPartBounds(this.handle, nextItem.id, this.column_id, 0x2D2D2D2D, rect) == 0 && OS.PtInRect(pt, rect)) {
                                item = nextItem;
                                break;
                            }
                        } else {
                            j = 0;
                            while (j < this.columnCount) {
                                column = this.columns[j];
                                if (OS.GetDataBrowserItemPartBounds(this.handle, nextItem.id, column.id, 0x2D2D2D2D, rect) == 0 && OS.PtInRect(pt, rect)) {
                                    item = nextItem;
                                    columnIndex = j;
                                    break;
                                }
                                ++j;
                            }
                        }
                    }
                    ++i;
                }
                if (item != null) {
                    columnId = column == null ? this.column_id : column.id;
                    gc = new GC(this);
                    inset = this.getInsetWidth(columnId, false);
                    width = item.calculateWidth(columnIndex, gc) + inset;
                    gc.dispose();
                    w = new short[1];
                    OS.GetDataBrowserTableViewNamedColumnWidth(this.handle, columnId, w);
                    if (width > w[0]) {
                        toolTipText = item.getText(columnIndex);
                        image = item.getImage(columnIndex);
                        imageWidth = image != null ? image.getBounds().width + this.getGap() : 0;
                        v0 = style = column == null ? 16384 : column.style;
                        if ((style & 16384) != 0) {
                            rect.left = (short)(rect.left + imageWidth);
                            rect.right = (short)(rect.left + width - imageWidth - inset);
                        }
                        if ((style & 131072) != 0) {
                            rect.left = (short)(rect.right - width + imageWidth + inset);
                        }
                        if ((style & 0x1000000) != 0) {
                            rect.left = (short)(rect.left + imageWidth);
                        }
                    }
                }
lbl94:
                // 9 sources

                if (toolTipText == null || toolTipText.length() == 0) break;
                buffer = new char[toolTipText.length()];
                toolTipText.getChars(0, buffer.length, buffer, 0);
                length = this.fixMnemonic(buffer);
                if (this.display.helpString != 0) {
                    OS.CFRelease(this.display.helpString);
                }
                this.display.helpString = OS.CFStringCreateWithCharacters(0, buffer, length);
                helpContent = new HMHelpContentRec();
                OS.memcpy(helpContent, ioHelpContent, 534);
                this.display.helpWidget = this;
                helpContent.version = 3;
                helpContent.tagSide = (short)tagSide;
                helpContent.absHotRect_left = (short)(rect.left + windowLeft);
                helpContent.absHotRect_top = (short)(rect.top + windowTop);
                helpContent.absHotRect_right = (short)(rect.right + windowLeft);
                helpContent.absHotRect_bottom = (short)(rect.bottom + windowTop);
                helpContent.content0_contentType = 1667658612;
                helpContent.content0_tagCFString = this.display.helpString;
                helpContent.content1_contentType = 1667658612;
                helpContent.content1_tagCFString = this.display.helpString;
                OS.memcpy(ioHelpContent, helpContent, 534);
                OS.memcpy(outContentProvided, new int[1], 4);
                return 0;
            }
        }
        return super.helpProc(inControl, inGlobalMouse, inRequest, outContentProvided, ioHelpContent);
    }

    int hitTestProc(int browser, int id, int property, int theRect, int mouseRect) {
        this.lastHittest = id;
        return 1;
    }

    void hookEvents() {
        super.hookEvents();
        DataBrowserCallbacks callbacks = new DataBrowserCallbacks();
        callbacks.version = 0;
        OS.InitDataBrowserCallbacks(callbacks);
        callbacks.v1_itemDataCallback = this.display.itemDataProc;
        callbacks.v1_itemNotificationCallback = this.display.itemNotificationProc;
        callbacks.v1_itemCompareCallback = this.display.itemCompareProc;
        OS.SetDataBrowserCallbacks(this.handle, callbacks);
        DataBrowserCustomCallbacks custom = new DataBrowserCustomCallbacks();
        custom.version = 0;
        OS.InitDataBrowserCustomCallbacks(custom);
        custom.v1_drawItemCallback = this.display.drawItemProc;
        custom.v1_hitTestCallback = this.display.hitTestProc;
        custom.v1_trackingCallback = this.display.trackingProc;
        OS.SetDataBrowserCustomCallbacks(this.handle, custom);
    }

    public int indexOf(TreeColumn column) {
        this.checkWidget();
        if (column == null) {
            this.error(4);
        }
        if (column.isDisposed()) {
            this.error(5);
        }
        int i = 0;
        while (i < this.columnCount) {
            if (this.columns[i] == column) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int indexOf(TreeItem item) {
        this.checkWidget();
        if (item == null) {
            this.error(4);
        }
        if (item.isDisposed()) {
            this.error(5);
        }
        if (item.parentItem != null) {
            return -1;
        }
        return this._indexOf(null, item);
    }

    int _indexOf(TreeItem parentItem, TreeItem item) {
        int[] ids;
        int[] nArray = ids = parentItem == null ? this.childIds : parentItem.childIds;
        if (ids != null) {
            int i = 0;
            while (i < ids.length) {
                if (ids[i] == item.id) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    int itemCompareProc(int browser, int itemOne, int itemTwo, int sortProperty) {
        TreeItem item1 = this._getItem(itemOne, false);
        TreeItem item2 = this._getItem(itemTwo, false);
        if (item1 == null || item2 == null) {
            return 0;
        }
        int index1 = this._indexOf(item1.parentItem, item1);
        int index2 = this._indexOf(item2.parentItem, item2);
        if (this.sortDirection == 1024 && this.sortColumn != null) {
            return index1 > index2 ? 1 : 0;
        }
        return index1 < index2 ? 1 : 0;
    }

    int itemDataProc(int browser, int id, int property, int itemData, int setValue) {
        switch (property) {
            case 1024: {
                TreeItem item = this._getItem(id, true);
                if (setValue != 0) {
                    boolean bl = item.checked = !item.checked;
                    if (item.checked && item.grayed) {
                        OS.SetDataBrowserItemDataButtonValue(itemData, (short)2);
                    } else {
                        boolean theData = item.checked;
                        OS.SetDataBrowserItemDataButtonValue(itemData, (short)(theData ? 1 : 0));
                    }
                    Event event = new Event();
                    event.item = item;
                    event.detail = 32;
                    this.postEvent(13, event);
                    if (item.checked) break;
                    item.redraw(1024);
                    break;
                }
                int theData = 0;
                if (item.checked) {
                    theData = item.grayed ? 2 : 1;
                }
                OS.SetDataBrowserItemDataButtonValue(itemData, (short)theData);
                break;
            }
            case 4: {
                TreeItem item = this._getItem(id, true);
                if (item.itemCount <= 0) break;
                OS.SetDataBrowserItemDataBooleanValue(itemData, true);
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    int itemNotificationProc(int browser, int id, int message) {
        TreeItem item;
        block42: {
            int i;
            int index;
            int[] newIds;
            block43: {
                if (message == 13) {
                    block41: {
                        int i2;
                        int[] property;
                        boolean resized = false;
                        short[] width = new short[1];
                        TreeColumn[] newColumns = this.getColumns();
                        int i3 = 0;
                        while (true) {
                            if (i3 >= this.columnCount) {
                                property = new int[1];
                                OS.GetDataBrowserSortProperty(this.handle, property);
                                if (property[0] == 0) return 0;
                                if (!resized) {
                                    i2 = 0;
                                    break;
                                }
                                break block41;
                            }
                            TreeColumn column = newColumns[i3];
                            if (!column.isDisposed()) {
                                OS.GetDataBrowserTableViewNamedColumnWidth(this.handle, column.id, width);
                                if (width[0] != column.lastWidth) {
                                    column.resized(width[0]);
                                    resized = true;
                                }
                            }
                            if (!column.isDisposed()) {
                                int[] position = new int[1];
                                OS.GetDataBrowserTableViewColumnPosition(this.handle, column.id, position);
                                if (position[0] != column.lastPosition) {
                                    int order;
                                    column.lastPosition = position[0];
                                    int n = order = (this.style & 0x20) != 0 ? position[0] - 1 : position[0];
                                    if (order == 0) {
                                        int[] disclosure = new int[1];
                                        boolean[] expandableRows = new boolean[1];
                                        OS.GetDataBrowserListViewDisclosureColumn(this.handle, disclosure, expandableRows);
                                        if (disclosure[0] != column.id) {
                                            OS.SetDataBrowserListViewDisclosureColumn(this.handle, column.id, expandableRows[0]);
                                        }
                                    }
                                    column.sendEvent(10);
                                    resized = true;
                                }
                            }
                            ++i3;
                        }
                        while (i2 < this.columnCount) {
                            TreeColumn column = this.columns[i2];
                            if (property[0] == column.id) {
                                column.postEvent(this.display.clickCount == 2 ? 14 : 13);
                                break;
                            }
                            ++i2;
                        }
                    }
                    OS.SetDataBrowserSortProperty(this.handle, 0);
                    if (this.sortColumn == null) return 0;
                    if (this.sortColumn.isDisposed()) return 0;
                    if (this.sortDirection == 0) return 0;
                    OS.SetDataBrowserSortProperty(this.handle, this.sortColumn.id);
                    int order = this.sortDirection == 1024 ? 2 : 1;
                    OS.SetDataBrowserSortOrder(this.handle, (short)order);
                    return 0;
                }
                switch (message) {
                    case 5: 
                    case 6: {
                        int modifiers;
                        this.wasSelected = true;
                        if (this.ignoreSelect) {
                            return 0;
                        }
                        int[] first = new int[1];
                        int[] last = new int[1];
                        OS.GetDataBrowserSelectionAnchor(this.handle, first, last);
                        boolean selected = false;
                        selected = (this.style & 2) != 0 ? (((modifiers = OS.GetCurrentEventKeyModifiers()) & 0x200) != 0 ? (message == 5 ? first[0] == id || last[0] == id : id == this.anchorFirst || id == this.anchorLast) : ((modifiers & 0x100) != 0 ? true : first[0] == last[0])) : message == 5;
                        if (!selected) return 0;
                        this.anchorFirst = first[0];
                        this.anchorLast = last[0];
                        Event event = new Event();
                        event.item = this._getItem(id, true);
                        this.postEvent(13, event);
                        return 0;
                    }
                    case 7: {
                        this.wasSelected = true;
                        if (this.display.clickCount != 2) return 0;
                        Event event = new Event();
                        event.item = this._getItem(id, true);
                        this.postEvent(14, event);
                        return 0;
                    }
                    case 9: {
                        int count;
                        int ptr = OS.NewHandle(0);
                        if (OS.GetDataBrowserItems(this.handle, id, false, -1, ptr) == 0) {
                            count = OS.GetHandleSize(ptr) / 4;
                            this.visibleCount -= count;
                        }
                        OS.DisposeHandle(ptr);
                        ptr = OS.NewHandle(0);
                        if (OS.GetDataBrowserItems(this.handle, id, true, 1, ptr) == 0 && (count = OS.GetHandleSize(ptr) / 4) > 0) {
                            int[] ids = new int[count];
                            OS.HLock(ptr);
                            int[] start = new int[1];
                            OS.memcpy(start, ptr, 4);
                            OS.memcpy(ids, start[0], count * 4);
                            OS.HUnlock(ptr);
                            boolean oldIgnore = this.ignoreSelect;
                            this.ignoreSelect = true;
                            int[] selectionFlags = null;
                            if ((this.style & 4) != 0) {
                                selectionFlags = new int[1];
                                OS.GetDataBrowserSelectionFlags(this.handle, selectionFlags);
                                OS.SetDataBrowserSelectionFlags(this.handle, selectionFlags[0] & 0xFFFFFFBF);
                            }
                            OS.SetDataBrowserSelectedItems(this.handle, ids.length, ids, 3);
                            if ((this.style & 4) != 0) {
                                OS.SetDataBrowserSelectionFlags(this.handle, selectionFlags[0]);
                            }
                            this.ignoreSelect = oldIgnore;
                            if (!this.ignoreSelect) {
                                Event event = new Event();
                                event.item = this._getItem(id, true);
                                this.sendEvent(13, event);
                            }
                        }
                        OS.DisposeHandle(ptr);
                        return 0;
                    }
                    case 10: {
                        TreeItem parentItem = this._getItem(id, true);
                        if (parentItem == null) {
                            return 0;
                        }
                        int[] ids = parentItem.childIds;
                        if (ids != null) {
                            int i4 = 0;
                            while (i4 < parentItem.itemCount) {
                                TreeItem item2 = this._getItem(ids[i4], false);
                                if (item2 == null) {
                                    ids[i4] = 0;
                                }
                                ++i4;
                            }
                        }
                        this.wasExpanded = true;
                        if (this.ignoreExpand) return 0;
                        Event event2 = new Event();
                        event2.item = parentItem;
                        this.sendEvent(18, event2);
                        if (this.isDisposed()) {
                            return 0;
                        }
                        this.setScrollWidth(true);
                        this.fixScrollBar();
                        return 0;
                    }
                    case 8: {
                        item = this._getItem(id, true);
                        this.wasExpanded = true;
                        if (!this.ignoreExpand) {
                            Event event = new Event();
                            event.item = item;
                            try {
                                item.state |= 0x100;
                                this.sendEvent(17, event);
                                if (this.isDisposed()) {
                                    Object event2 = null;
                                    item.state &= 0xFFFFFEFF;
                                    return 0;
                                }
                                break;
                            }
                            catch (Throwable item2) {
                                Object event2 = null;
                                item.state &= 0xFFFFFEFF;
                                throw item2;
                            }
                        }
                        break block43;
                    }
                    default: {
                        return 0;
                    }
                }
                {
                    Object event2 = null;
                    item.state &= 0xFFFFFEFF;
                }
            }
            int newIdCount = 0;
            int i5 = 0;
            while (true) {
                if (i5 >= item.itemCount) {
                    if (newIdCount > 0) {
                        newIds = this._getIds(newIdCount);
                        index = 0;
                        i = 0;
                        break;
                    }
                    break block42;
                }
                if (item.childIds[i5] == 0) {
                    ++newIdCount;
                }
                ++i5;
            }
            while (i < item.itemCount) {
                if (item.childIds[i] == 0) {
                    item.childIds[i] = newIds[index++];
                }
                ++i;
            }
        }
        OS.AddDataBrowserItems(this.handle, id, item.itemCount, item.childIds, 0);
        this.visibleCount += item.itemCount;
        this.setScrollWidth(false);
        return 0;
    }

    int kEventControlGetClickActivation(int nextHandler, int theEvent, int userData) {
        OS.SetEventParameter(theEvent, 1668047203, 1668047203, 4, new int[]{3});
        return 0;
    }

    int kEventControlSetCursor(int nextHandler, int theEvent, int userData) {
        if (!this.isEnabledCursor()) {
            return 0;
        }
        if (this.isEnabledModal()) {
            Point pt = new Point();
            int sizeof = 4;
            OS.GetEventParameter(theEvent, 1835822947, 1363439732, null, sizeof, null, pt);
            if (!this.contains(pt.h, pt.v)) {
                return -9874;
            }
        }
        return super.kEventControlSetCursor(nextHandler, theEvent, userData);
    }

    int kEventUnicodeKeyPressed(int nextHandler, int theEvent, int userData) {
        int result = super.kEventUnicodeKeyPressed(nextHandler, theEvent, userData);
        if (result == 0) {
            return result;
        }
        int[] keyboardEvent = new int[1];
        OS.GetEventParameter(theEvent, 1953721189, 1702261350, null, keyboardEvent.length * 4, null, keyboardEvent);
        int[] keyCode = new int[1];
        OS.GetEventParameter(keyboardEvent[0], 1801678692, 1835100014, null, keyCode.length * 4, null, keyCode);
        switch (keyCode[0]) {
            case 36: 
            case 76: {
                this.postEvent(14);
                break;
            }
            case 125: 
            case 126: {
                this.redrawBackgroundImage();
            }
        }
        return result;
    }

    int kEventMouseDown(int nextHandler, int theEvent, int userData) {
        int result = super.kEventMouseDown(nextHandler, theEvent, userData);
        if (result == 0) {
            return result;
        }
        Display display = this.display;
        Control oldFocus = display.getFocusControl();
        display.ignoreFocus = true;
        this.wasExpanded = false;
        this.wasSelected = false;
        result = OS.CallNextEventHandler(nextHandler, theEvent);
        display.ignoreFocus = false;
        if (oldFocus != this) {
            if (oldFocus != null && !oldFocus.isDisposed()) {
                oldFocus.sendFocusEvent(16, false);
            }
            if (!this.isDisposed() && this.isEnabled()) {
                this.sendFocusEvent(15, false);
            }
        }
        if (this.isDisposed()) {
            return 0;
        }
        if (!this.wasSelected && !this.wasExpanded && OS.IsDataBrowserItemSelected(this.handle, this.lastHittest) && this.lastHittest > 0 && this.lastHittest <= this.items.length) {
            Event event = new Event();
            event.item = this._getItem(this.lastHittest, true);
            this.postEvent(13, event);
        }
        if (this.wasExpanded) {
            int y;
            int x;
            Point outPt = new Point();
            OS.GetGlobalMouse(outPt);
            Rect rect = new Rect();
            int window = OS.GetControlOwner(this.handle);
            if (OS.HIVIEW) {
                CGPoint pt = new CGPoint();
                pt.x = outPt.h;
                pt.y = outPt.v;
                OS.HIViewConvertPoint(pt, 0, this.handle);
                x = (int)pt.x;
                y = (int)pt.y;
                OS.GetWindowBounds(window, (short)32, rect);
            } else {
                OS.GetControlBounds(this.handle, rect);
                x = outPt.h - rect.left;
                y = outPt.v - rect.top;
                OS.GetWindowBounds(window, (short)33, rect);
            }
            x -= rect.left;
            y -= rect.top;
            short[] button = new short[1];
            OS.GetEventParameter(theEvent, 1835168878, 1835168878, null, 2, null, button);
            int chord = OS.GetCurrentEventButtonState();
            int modifiers = OS.GetCurrentEventKeyModifiers();
            this.sendMouseEvent(4, button[0], true, chord, (short)x, (short)y, modifiers);
        }
        this.wasExpanded = false;
        this.wasSelected = false;
        return result;
    }

    void releaseItem(TreeItem item, boolean release) {
        int id = item.id;
        if (release) {
            item.release(false);
        }
        this.items[id - 1] = null;
        TreeItem parentItem = item.parentItem;
        int[] ids = parentItem == null ? this.childIds : parentItem.childIds;
        int index = -1;
        int i = 0;
        while (i < ids.length) {
            if (ids[i] == id) {
                index = i;
                break;
            }
            ++i;
        }
        if (index != -1) {
            System.arraycopy(ids, 0, ids, 0, index);
            System.arraycopy(ids, index + 1, ids, index, ids.length - index - 1);
            ids[ids.length - 1] = 0;
        }
        if (parentItem != null) {
            --parentItem.itemCount;
            if (parentItem.itemCount == 0) {
                parentItem.childIds = null;
            }
        }
    }

    void releaseItems(int[] ids) {
        if (ids == null) {
            return;
        }
        int i = ids.length - 1;
        while (i >= 0) {
            TreeItem item = this._getItem(ids[i], false);
            if (item != null) {
                this.releaseItems(item.childIds);
                if (!this.isDisposed()) {
                    this.releaseItem(item, true);
                }
            }
            --i;
        }
    }

    void releaseChildren(boolean destroy) {
        int i = 0;
        while (i < this.items.length) {
            TreeItem item = this.items[i];
            if (item != null && !item.isDisposed()) {
                item.release(false);
            }
            ++i;
        }
        this.items = null;
        this.childIds = null;
        if (this.columns != null) {
            i = 0;
            while (i < this.columnCount) {
                TreeColumn column = this.columns[i];
                if (column != null && !column.isDisposed()) {
                    column.release(false);
                }
                ++i;
            }
            this.columns = null;
        }
        super.releaseChildren(destroy);
    }

    void releaseWidget() {
        super.releaseWidget();
        this.sortColumn = null;
        this.paintGC = null;
        this.imageBounds = null;
        this.showItem = null;
        DataBrowserCallbacks callbacks = new DataBrowserCallbacks();
        OS.GetDataBrowserCallbacks(this.handle, callbacks);
        callbacks.v1_itemNotificationCallback = 0;
        callbacks.v1_itemCompareCallback = 0;
        OS.SetDataBrowserCallbacks(this.handle, callbacks);
    }

    public void removeAll() {
        this.checkWidget();
        int i = 0;
        while (i < this.items.length) {
            TreeItem item = this.items[i];
            if (item != null && !item.isDisposed()) {
                item.release(false);
            }
            ++i;
        }
        this.items = new TreeItem[4];
        this.childIds = null;
        DataBrowserCallbacks callbacks = new DataBrowserCallbacks();
        OS.GetDataBrowserCallbacks(this.handle, callbacks);
        callbacks.v1_itemNotificationCallback = 0;
        callbacks.v1_itemCompareCallback = 0;
        OS.SetDataBrowserCallbacks(this.handle, callbacks);
        this.ignoreSelect = true;
        this.ignoreExpand = true;
        int result = OS.RemoveDataBrowserItems(this.handle, 0, 0, null, 0);
        this.ignoreSelect = false;
        this.ignoreExpand = false;
        callbacks.v1_itemNotificationCallback = this.display.itemNotificationProc;
        callbacks.v1_itemCompareCallback = this.display.itemCompareProc;
        OS.SetDataBrowserCallbacks(this.handle, callbacks);
        if (result != 0) {
            this.error(15);
        }
        OS.SetDataBrowserScrollPosition(this.handle, 0, 0);
        this.anchorLast = 0;
        this.anchorFirst = 0;
        this.visibleCount = 0;
        this.itemHeight = -1;
        this.setScrollWidth(true);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        this.eventTable.unhook(13, listener);
        this.eventTable.unhook(14, listener);
    }

    public void removeTreeListener(TreeListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(17, listener);
        this.eventTable.unhook(18, listener);
    }

    void resetVisibleRegion(int control) {
        super.resetVisibleRegion(control);
        if (this.showItem != null && !this.showItem.isDisposed()) {
            this.showItem(this.showItem, true);
        }
    }

    public void setInsertMark(TreeItem item, boolean before) {
        this.checkWidget();
        if (item != null && item.isDisposed()) {
            this.error(5);
        }
    }

    public void selectAll() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return;
        }
        this.ignoreSelect = true;
        OS.SetDataBrowserSelectedItems(this.handle, 0, null, 1);
        this.ignoreSelect = false;
    }

    void setBackground(float[] color) {
    }

    int setBounds(int x, int y, int width, int height, boolean move, boolean resize, boolean events) {
        int result = super.setBounds(x, y, width, height, move, resize, events);
        if (this.showItem != null && !this.showItem.isDisposed()) {
            this.showItem(this.showItem, true);
        }
        return result;
    }

    public void setColumnOrder(int[] order) {
        this.checkWidget();
        if (order == null) {
            this.error(4);
        }
        if (this.columnCount == 0) {
            if (order.length != 0) {
                this.error(5);
            }
            return;
        }
        if (order.length != this.columnCount) {
            this.error(5);
        }
        int[] oldOrder = this.getColumnOrder();
        boolean reorder = false;
        boolean[] seen = new boolean[this.columnCount];
        int i = 0;
        while (i < order.length) {
            int index = order[i];
            if (index < 0 || index >= this.columnCount) {
                this.error(5);
            }
            if (seen[index]) {
                this.error(5);
            }
            seen[index] = true;
            if (order[i] != oldOrder[i]) {
                reorder = true;
            }
            ++i;
        }
        if (reorder) {
            TreeColumn column;
            int[] disclosure = new int[1];
            boolean[] expandableRows = new boolean[1];
            OS.GetDataBrowserListViewDisclosureColumn(this.handle, disclosure, expandableRows);
            TreeColumn firstColumn = this.columns[order[0]];
            if (disclosure[0] != firstColumn.id) {
                OS.SetDataBrowserListViewDisclosureColumn(this.handle, firstColumn.id, expandableRows[0]);
            }
            int x = 0;
            short[] width = new short[1];
            int[] oldX = new int[oldOrder.length];
            int i2 = 0;
            while (i2 < oldOrder.length) {
                int index = oldOrder[i2];
                TreeColumn column2 = this.columns[index];
                oldX[index] = x;
                OS.GetDataBrowserTableViewNamedColumnWidth(this.handle, column2.id, width);
                x += width[0];
                ++i2;
            }
            x = 0;
            int[] newX = new int[order.length];
            int i3 = 0;
            while (i3 < order.length) {
                int index = order[i3];
                column = this.columns[index];
                int position = (this.style & 0x20) != 0 ? i3 + 1 : i3;
                OS.SetDataBrowserTableViewColumnPosition(this.handle, column.id, position);
                column.lastPosition = position;
                newX[index] = x;
                OS.GetDataBrowserTableViewNamedColumnWidth(this.handle, column.id, width);
                x += width[0];
                ++i3;
            }
            TreeColumn[] newColumns = new TreeColumn[this.columnCount];
            System.arraycopy(this.columns, 0, newColumns, 0, this.columnCount);
            int i4 = 0;
            while (i4 < this.columnCount) {
                column = newColumns[i4];
                if (!column.isDisposed() && newX[i4] != oldX[i4]) {
                    column.sendEvent(10);
                }
                ++i4;
            }
        }
    }

    void setFontStyle(Font font) {
        super.setFontStyle(font);
        if (this.items == null) {
            return;
        }
        int i = 0;
        while (i < this.items.length) {
            TreeItem item = this.items[i];
            if (item != null) {
                item.width = -1;
            }
            ++i;
        }
        this.setScrollWidth(true);
    }

    public void setHeaderVisible(boolean show) {
        this.checkWidget();
        short[] height = new short[1];
        OS.GetDataBrowserListViewHeaderBtnHeight(this.handle, height);
        if (height[0] != 0 != show) {
            OS.SetDataBrowserListViewHeaderBtnHeight(this.handle, (short)(show ? this.headerHeight : 0));
            this.invalidateVisibleRegion(this.handle);
        }
    }

    public void setItemCount(int count) {
        this.checkWidget();
        count = Math.max(0, count);
        this.setItemCount(null, count);
    }

    void setItemCount(TreeItem parentItem, int count) {
        int[] ids;
        int itemCount = this.getItemCount(parentItem);
        if (count == itemCount) {
            return;
        }
        this.setRedraw(false);
        int[] top = new int[1];
        int[] left = new int[1];
        OS.GetDataBrowserScrollPosition(this.handle, top, left);
        DataBrowserCallbacks callbacks = new DataBrowserCallbacks();
        OS.GetDataBrowserCallbacks(this.handle, callbacks);
        callbacks.v1_itemNotificationCallback = 0;
        callbacks.v1_itemCompareCallback = 0;
        OS.SetDataBrowserCallbacks(this.handle, callbacks);
        int[] nArray = ids = parentItem == null ? this.childIds : parentItem.childIds;
        if (count < itemCount) {
            int index = ids.length - 1;
            while (index >= count) {
                int id = ids[index];
                if (id != 0) {
                    TreeItem item = this._getItem(id, false);
                    if (item != null && !item.isDisposed()) {
                        item.dispose();
                    } else if (parentItem == null || parentItem.getExpanded()) {
                        if (OS.RemoveDataBrowserItems(this.handle, 0, 1, new int[]{id}, 0) != 0) {
                            this.error(15);
                            break;
                        }
                        --this.visibleCount;
                    }
                }
                --index;
            }
            int lastIndex = this.items.length;
            int i = this.items.length;
            while (i > 0) {
                if (this.items[i - 1] != null) {
                    lastIndex = i;
                    break;
                }
                --i;
            }
            if (lastIndex < this.items.length - 4) {
                int length = Math.max(4, (lastIndex + 3) / 4 * 4);
                TreeItem[] newItems = new TreeItem[length];
                System.arraycopy(this.items, 0, newItems, 0, Math.min(this.items.length, lastIndex));
            }
        }
        if (parentItem != null) {
            parentItem.itemCount = count;
        }
        int length = Math.max(4, (count + 3) / 4 * 4);
        int[] newIds = new int[length];
        if (ids != null) {
            System.arraycopy(ids, 0, newIds, 0, Math.min(count, itemCount));
        }
        ids = newIds;
        if (parentItem == null) {
            this.childIds = newIds;
        } else {
            parentItem.childIds = newIds;
        }
        if (count > itemCount) {
            if ((this.getStyle() & 0x10000000) == 0) {
                int delta = Math.max(4, (count - itemCount + 3) / 4 * 4);
                TreeItem[] newItems = new TreeItem[this.items.length + delta];
                System.arraycopy(this.items, 0, newItems, 0, this.items.length);
                this.items = newItems;
                int i = itemCount;
                while (i < count) {
                    this.items[i] = new TreeItem(this, parentItem, 0, i, true);
                    ++i;
                }
            } else if (parentItem == null || parentItem.getExpanded()) {
                int[] addIds;
                int parentID = parentItem == null ? 0 : parentItem.id;
                if (OS.AddDataBrowserItems(this.handle, parentID, (addIds = this._getIds(count - itemCount)).length, addIds, 0) != 0) {
                    this.error(14);
                }
                this.visibleCount += count - itemCount;
                System.arraycopy(addIds, 0, ids, itemCount, addIds.length);
            }
        }
        callbacks.v1_itemNotificationCallback = this.display.itemNotificationProc;
        callbacks.v1_itemCompareCallback = this.display.itemCompareProc;
        OS.SetDataBrowserCallbacks(this.handle, callbacks);
        this.setRedraw(true);
        if (itemCount == 0 && parentItem != null) {
            parentItem.redraw(0);
        }
    }

    void setItemHeight(int itemHeight) {
        this.checkWidget();
        if (itemHeight < -1) {
            this.error(5);
        }
        if (itemHeight != -1) {
            OS.SetDataBrowserTableViewRowHeight(this.handle, (short)itemHeight);
        }
    }

    void setItemHeight(Image image) {
        Rectangle bounds;
        Rectangle rectangle = bounds = image != null ? image.getBounds() : this.imageBounds;
        if (bounds == null) {
            return;
        }
        this.imageBounds = bounds;
        short[] height = new short[1];
        if (OS.GetDataBrowserTableViewRowHeight(this.handle, height) == 0 && height[0] < bounds.height) {
            OS.SetDataBrowserTableViewRowHeight(this.handle, (short)bounds.height);
        }
    }

    public void setLinesVisible(boolean show) {
        this.checkWidget();
        if (OS.VERSION >= 4160) {
            int attrib = 6;
            OS.DataBrowserChangeAttributes(this.handle, show ? attrib : 0, !show ? attrib : 0);
            this.redraw();
        }
    }

    public void setRedraw(boolean redraw) {
        this.checkWidget();
        super.setRedraw(redraw);
        if (redraw && this.drawCount == 0) {
            this.setScrollWidth(true);
        }
    }

    boolean setScrollWidth(TreeItem item) {
        if (this.ignoreRedraw || this.drawCount != 0) {
            return false;
        }
        if (this.columnCount != 0) {
            return false;
        }
        TreeItem parentItem = item.parentItem;
        if (parentItem != null && !parentItem._getExpanded()) {
            return false;
        }
        GC gc = new GC(this);
        int newWidth = item.calculateWidth(0, gc);
        gc.dispose();
        short[] width = new short[1];
        OS.GetDataBrowserTableViewNamedColumnWidth(this.handle, this.column_id, width);
        if (width[0] < (newWidth += this.getInsetWidth(this.column_id, false))) {
            OS.SetDataBrowserTableViewNamedColumnWidth(this.handle, this.column_id, (short)newWidth);
            return true;
        }
        return false;
    }

    boolean setScrollWidth(boolean set) {
        if (this.ignoreRedraw || this.drawCount != 0) {
            return false;
        }
        if (this.columnCount != 0 || this.childIds == null) {
            return false;
        }
        GC gc = new GC(this);
        int newWidth = this.calculateWidth(this.childIds, gc);
        gc.dispose();
        newWidth += this.getInsetWidth(this.column_id, false);
        if (!set) {
            short[] width = new short[1];
            OS.GetDataBrowserTableViewNamedColumnWidth(this.handle, this.column_id, width);
            if (width[0] >= newWidth) {
                return false;
            }
        }
        OS.SetDataBrowserTableViewNamedColumnWidth(this.handle, this.column_id, (short)newWidth);
        return true;
    }

    public void setSelection(TreeItem item) {
        this.checkWidget();
        if (item == null) {
            this.error(4);
        }
        this.setSelection(new TreeItem[]{item});
    }

    public void setSelection(TreeItem[] items) {
        this.checkWidget();
        if (items == null) {
            this.error(4);
        }
        this.deselectAll();
        int length = items.length;
        if (length == 0 || (this.style & 4) != 0 && length > 1) {
            return;
        }
        int count = 0;
        int[] ids = new int[length];
        int i = 0;
        while (i < length) {
            if (items[i] != null) {
                if (items[i].isDisposed()) {
                    this.error(5);
                }
                ids[count++] = items[i].id;
                this.showItem(items[i], false);
            }
            ++i;
        }
        this.ignoreSelect = true;
        int[] selectionFlags = null;
        if ((this.style & 4) != 0) {
            selectionFlags = new int[1];
            OS.GetDataBrowserSelectionFlags(this.handle, selectionFlags);
            OS.SetDataBrowserSelectionFlags(this.handle, selectionFlags[0] & 0xFFFFFFBF);
        }
        OS.SetDataBrowserSelectedItems(this.handle, count, ids, 1);
        if ((this.style & 4) != 0) {
            OS.SetDataBrowserSelectionFlags(this.handle, selectionFlags[0]);
        }
        this.ignoreSelect = false;
        if (length > 0) {
            int index = -1;
            int i2 = 0;
            while (i2 < items.length) {
                if (items[i2] != null) {
                    index = i2;
                    break;
                }
                ++i2;
            }
            if (index != -1) {
                this.showItem(items[index], true);
            }
        }
    }

    public void setSortColumn(TreeColumn column) {
        this.checkWidget();
        if (column != null && column.isDisposed()) {
            this.error(5);
        }
        if (column == this.sortColumn) {
            return;
        }
        if (column == null && this.sortColumn != null && !this.sortColumn.isDisposed() && this.sortDirection != 0) {
            OS.SetDataBrowserSortOrder(this.handle, (short)1);
            this.sortColumn = null;
            OS.SetDataBrowserSortProperty(this.handle, 0);
        }
        this.sortColumn = column;
        if (this.sortColumn != null && !this.sortColumn.isDisposed() && this.sortDirection != 0) {
            OS.SetDataBrowserSortProperty(this.handle, this.sortColumn.id);
            int order = this.sortDirection == 1024 ? 2 : 1;
            OS.SetDataBrowserSortOrder(this.handle, (short)order);
        }
    }

    public void setSortDirection(int direction) {
        this.checkWidget();
        if (direction != 128 && direction != 1024 && direction != 0) {
            return;
        }
        if (direction == this.sortDirection) {
            return;
        }
        this.sortDirection = direction;
        if (this.sortColumn != null && !this.sortColumn.isDisposed()) {
            if (this.sortDirection == 0) {
                OS.SetDataBrowserSortOrder(this.handle, (short)1);
                TreeColumn column = this.sortColumn;
                this.sortColumn = null;
                OS.SetDataBrowserSortProperty(this.handle, 0);
                this.sortColumn = column;
            } else {
                OS.SetDataBrowserSortProperty(this.handle, 0);
                OS.SetDataBrowserSortProperty(this.handle, this.sortColumn.id);
                int order = this.sortDirection == 1024 ? 2 : 1;
                OS.SetDataBrowserSortOrder(this.handle, (short)order);
            }
        }
    }

    public void setTopItem(TreeItem item) {
        this.checkWidget();
        if (item == null) {
            this.error(4);
        }
        if (item.isDisposed()) {
            this.error(5);
        }
        this.showItem(item, false);
        int columnId = this.columnCount == 0 ? this.column_id : this.columns[0].id;
        OS.RevealDataBrowserItem(this.handle, item.id, columnId, (byte)2);
        Rect rect = new Rect();
        if (OS.GetDataBrowserItemPartBounds(this.handle, item.id, this.column_id, 0, rect) == 0) {
            int border = this.getBorder();
            int[] top = new int[1];
            int[] left = new int[1];
            OS.GetDataBrowserScrollPosition(this.handle, top, left);
            OS.SetDataBrowserScrollPosition(this.handle, top[0] + rect.top - border, left[0]);
        }
    }

    public void showColumn(TreeColumn column) {
        this.checkWidget();
        if (column == null) {
            this.error(4);
        }
        if (column.isDisposed()) {
            this.error(5);
        }
        if (column.parent != this) {
            return;
        }
        int index = this.indexOf(column);
        if (this.columnCount <= 1 || index < 0 || index >= this.columnCount) {
            return;
        }
        short[] w = new short[1];
        OS.GetDataBrowserTableViewNamedColumnWidth(this.handle, column.id, w);
        int width = w[0];
        int x = 0;
        int i = 0;
        while (i < index) {
            w = new short[1];
            OS.GetDataBrowserTableViewNamedColumnWidth(this.handle, this.columns[i].id, w);
            x += w[0];
            ++i;
        }
        int[] top = new int[1];
        int[] left = new int[1];
        OS.GetDataBrowserScrollPosition(this.handle, top, left);
        if (x < left[0]) {
            OS.SetDataBrowserScrollPosition(this.handle, top[0], x);
        } else {
            Rectangle rect = this.getClientArea();
            int maxWidth = rect.width;
            if (x + (width = Math.min(width, maxWidth)) > left[0] + maxWidth) {
                left[0] = x + width - maxWidth;
                OS.SetDataBrowserScrollPosition(this.handle, top[0], left[0]);
            }
        }
    }

    public void showItem(TreeItem item) {
        this.checkWidget();
        if (item == null) {
            this.error(4);
        }
        if (item.isDisposed()) {
            this.error(5);
        }
        this.showItem(item, true);
    }

    void showItem(TreeItem item, boolean scroll) {
        int count = 0;
        TreeItem parentItem = item.parentItem;
        while (parentItem != null && !parentItem._getExpanded()) {
            ++count;
            parentItem = parentItem.parentItem;
        }
        int index = 0;
        parentItem = item.parentItem;
        TreeItem[] path = new TreeItem[count];
        while (parentItem != null && !parentItem._getExpanded()) {
            path[index++] = parentItem;
            parentItem = parentItem.parentItem;
        }
        int i = path.length - 1;
        while (i >= 0) {
            path[i].setExpanded(true);
            --i;
        }
        if (scroll) {
            Rectangle rect = this.getClientArea();
            if (rect.height < this.getItemHeight() || !OS.IsControlVisible(this.handle)) {
                this.showItem = item;
                return;
            }
            this.showItem = null;
            Rectangle itemRect = item.getBounds();
            if (!itemRect.isEmpty() && rect.contains(itemRect.x, itemRect.y) && rect.contains(itemRect.x, itemRect.y + itemRect.height)) {
                return;
            }
            int[] top = new int[1];
            int[] left = new int[1];
            OS.GetDataBrowserScrollPosition(this.handle, top, left);
            int columnId = this.columnCount == 0 ? this.column_id : this.columns[0].id;
            OS.RevealDataBrowserItem(this.handle, item.id, columnId, (byte)2);
            int[] newTop = new int[1];
            int[] newLeft = new int[1];
            OS.GetDataBrowserScrollPosition(this.handle, newTop, newLeft);
            if (this.horizontalBar != null && newLeft[0] != left[0]) {
                this.horizontalBar.redraw();
            }
            if (this.verticalBar != null && newTop[0] != top[0]) {
                this.verticalBar.redraw();
            }
        }
    }

    public void showSelection() {
        this.checkWidget();
        TreeItem[] selection = this.getSelection();
        if (selection.length > 0) {
            this.showItem(selection[0], true);
        }
    }

    int trackingProc(int browser, int id, int property, int theRect, int startPt, int modifiers) {
        return 1;
    }
}

