/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.systray;

import java.util.List;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Tray;
import org.eclipse.swt.widgets.TrayItem;
import org.eclipse.swt.widgets.Widget;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.impl.TransferSpeedValidator;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.DisplayFormatters;
import org.gudy.azureus2.ui.swt.ImageRepository;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.PasswordWindow;
import org.gudy.azureus2.ui.swt.mainwindow.MainWindow;
import org.gudy.azureus2.ui.swt.views.utils.ManagerUtils;

public class SystemTraySWT {
    MainWindow mainWindow;
    Display display;
    Tray tray;
    TrayItem trayItem;
    Menu menu;

    public SystemTraySWT(MainWindow _mainWindow) {
        this.mainWindow = _mainWindow;
        this.display = this.mainWindow.getDisplay();
        this.tray = this.display.getSystemTray();
        this.trayItem = new TrayItem(this.tray, 0);
        if (!Constants.isOSX) {
            this.trayItem.setImage(ImageRepository.getImage("azureus"));
        }
        this.trayItem.setVisible(true);
        this.menu = new Menu((Decorations)this.mainWindow.getShell(), 8);
        MenuItem itemShow = new MenuItem(this.menu, 0);
        Messages.setLanguageText((Widget)itemShow, "SystemTray.menu.show");
        new MenuItem(this.menu, 2);
        MenuItem itemCloseAll = new MenuItem(this.menu, 0);
        Messages.setLanguageText((Widget)itemCloseAll, "SystemTray.menu.closealldownloadbars");
        new MenuItem(this.menu, 2);
        this.createUploadLimitMenu(this.menu);
        this.createDownloadLimitMenu(this.menu);
        new MenuItem(this.menu, 2);
        MenuItem itemStartAll = new MenuItem(this.menu, 0);
        Messages.setLanguageText((Widget)itemStartAll, "SystemTray.menu.startalltransfers");
        MenuItem itemStopAll = new MenuItem(this.menu, 0);
        Messages.setLanguageText((Widget)itemStopAll, "SystemTray.menu.stopalltransfers");
        final MenuItem itemPause = new MenuItem(this.menu, 0);
        Messages.setLanguageText((Widget)itemPause, "SystemTray.menu.pausetransfers");
        final MenuItem itemResume = new MenuItem(this.menu, 0);
        Messages.setLanguageText((Widget)itemResume, "SystemTray.menu.resumetransfers");
        new MenuItem(this.menu, 2);
        MenuItem itemExit = new MenuItem(this.menu, 0);
        Messages.setLanguageText((Widget)itemExit, "SystemTray.menu.exit");
        itemShow.addListener(13, new Listener(){

            public void handleEvent(Event arg0) {
                SystemTraySWT.this.show();
            }
        });
        itemStartAll.addListener(13, new Listener(){

            public void handleEvent(Event arg0) {
                SystemTraySWT.this.mainWindow.getGlobalManager().startAllDownloads();
            }
        });
        itemStopAll.addListener(13, new Listener(){

            public void handleEvent(Event arg0) {
                ManagerUtils.asyncStopAll();
            }
        });
        itemPause.addListener(13, new Listener(){

            public void handleEvent(Event arg0) {
                ManagerUtils.asyncPause();
            }
        });
        itemResume.addListener(13, new Listener(){

            public void handleEvent(Event arg0) {
                SystemTraySWT.this.mainWindow.getGlobalManager().resumeDownloads();
            }
        });
        this.menu.addMenuListener(new MenuListener(){

            public void menuShown(MenuEvent _menu) {
                itemPause.setEnabled(SystemTraySWT.this.mainWindow.getGlobalManager().canPauseDownloads());
                itemResume.setEnabled(SystemTraySWT.this.mainWindow.getGlobalManager().canResumeDownloads());
            }

            public void menuHidden(MenuEvent _menu) {
            }
        });
        itemCloseAll.addListener(13, new Listener(){

            public void handleEvent(Event arg0) {
                SystemTraySWT.this.mainWindow.closeDownloadBars();
            }
        });
        itemExit.addListener(13, new Listener(){

            public void handleEvent(Event arg0) {
                SystemTraySWT.this.mainWindow.dispose(false, false);
            }
        });
        this.trayItem.addListener(14, new Listener(){

            public void handleEvent(Event arg0) {
                SystemTraySWT.this.show();
            }
        });
        this.trayItem.addListener(35, new Listener(){

            public void handleEvent(Event arg0) {
                SystemTraySWT.this.menu.setVisible(true);
            }
        });
    }

    private final void createUploadLimitMenu(Menu parent) {
        MenuItem uploadSpeedItem = new MenuItem(parent, 64);
        uploadSpeedItem.setText(MessageText.getString("GeneralView.label.maxuploadspeed"));
        final Menu uploadSpeedMenu = new Menu((Decorations)this.mainWindow.getShell(), 4);
        uploadSpeedMenu.addListener(22, new Listener(){

            public void handleEvent(Event event) {
                SystemTraySWT.this.createLimitMenuItems(TransferSpeedValidator.getActiveUploadParameter(SystemTraySWT.this.mainWindow.getGlobalManager()), uploadSpeedMenu);
            }
        });
        uploadSpeedItem.setMenu(uploadSpeedMenu);
    }

    private final void createDownloadLimitMenu(Menu parent) {
        MenuItem downloadSpeedItem = new MenuItem(parent, 64);
        downloadSpeedItem.setText(MessageText.getString("GeneralView.label.maxdownloadspeed"));
        final Menu downloadSpeedMenu = new Menu((Decorations)this.mainWindow.getShell(), 4);
        downloadSpeedMenu.addListener(22, new Listener(){

            public void handleEvent(Event event) {
                SystemTraySWT.this.createLimitMenuItems("Max Download Speed KBs", downloadSpeedMenu);
            }
        });
        downloadSpeedItem.setMenu(downloadSpeedMenu);
    }

    private final void createLimitMenuItems(String configKey, Menu parent) {
        boolean unlim;
        MenuItem[] oldItems = parent.getItems();
        for (int i = 0; i < oldItems.length; ++i) {
            oldItems[i].dispose();
        }
        int speedPartitions = 12;
        int maxBandwidth = COConfigurationManager.getIntParameter(configKey);
        boolean bl = unlim = maxBandwidth == 0;
        if (maxBandwidth == 0 && configKey == "Max Download Speed KBs") {
            maxBandwidth = 275;
        }
        MenuItem item = new MenuItem(parent, 16);
        item.setText(MessageText.getString("MyTorrentsView.menu.setSpeed.unlimited"));
        item.setData("maxkb", (Object)new Integer(0));
        item.setSelection(unlim);
        item.addListener(13, this.getLimitMenuItemListener(parent, configKey));
        int delta = 0;
        for (int i = 0; i < 12; ++i) {
            int[] valuePair = delta == 0 ? new int[]{maxBandwidth} : new int[]{maxBandwidth - delta, maxBandwidth + delta};
            for (int j = 0; j < valuePair.length; ++j) {
                if (valuePair[j] < 5) continue;
                item = new MenuItem(parent, 16, j == 0 ? 1 : parent.getItemCount());
                item.setText(DisplayFormatters.formatByteCountToKiBEtcPerSec(valuePair[j] * 1024, true));
                item.setData("maxkb", (Object)new Integer(valuePair[j]));
                item.addListener(13, this.getLimitMenuItemListener(parent, configKey));
                item.setSelection(!unlim && valuePair[j] == maxBandwidth);
            }
            delta += delta >= 50 ? 50 : (delta >= 10 ? 10 : (delta >= 5 ? 5 : (delta >= 2 ? 3 : 1)));
        }
    }

    private final Listener getLimitMenuItemListener(final Menu parent, final String configKey) {
        return new Listener(){

            public void handleEvent(Event event) {
                MenuItem[] items = parent.getItems();
                for (int i = 0; i < items.length; ++i) {
                    if (items[i] == event.widget) {
                        items[i].setSelection(true);
                        int cValue = (Integer)new TransferSpeedValidator(configKey, items[i].getData("maxkb")).getValue();
                        COConfigurationManager.setParameter(configKey, cValue);
                        COConfigurationManager.save();
                        continue;
                    }
                    items[i].setSelection(false);
                }
            }
        };
    }

    public void dispose() {
        if (this.trayItem != null && !this.trayItem.isDisposed()) {
            this.trayItem.dispose();
        }
    }

    public void update() {
        if (this.trayItem.isDisposed()) {
            return;
        }
        List managers = this.mainWindow.getGlobalManager().getDownloadManagers();
        StringBuffer toolTip = new StringBuffer();
        int seeding = 0;
        int downloading = 0;
        for (int i = 0; i < managers.size(); ++i) {
            DownloadManager manager = (DownloadManager)managers.get(i);
            int state = manager.getState();
            if (state == 50) {
                ++downloading;
            }
            if (state != 60) continue;
            ++seeding;
        }
        String seeding_text = MessageText.getString("SystemTray.tooltip.seeding");
        String downloading_text = MessageText.getString("SystemTray.tooltip.downloading");
        if (!seeding_text.startsWith(" ")) {
            seeding_text = " " + seeding_text;
        }
        if (!downloading_text.startsWith(" ")) {
            downloading_text = " " + downloading_text;
        }
        toolTip.append(seeding);
        toolTip.append(seeding_text);
        toolTip.append(downloading);
        toolTip.append(downloading_text).append(MessageText.getString("ConfigView.download.abbreviated")).append(" ");
        toolTip.append(DisplayFormatters.formatByteCountToKiBEtcPerSec(this.mainWindow.getGlobalManager().getStats().getDataReceiveRate() + this.mainWindow.getGlobalManager().getStats().getProtocolReceiveRate()));
        toolTip.append(", ").append(MessageText.getString("ConfigView.upload.abbreviated")).append(" ");
        toolTip.append(DisplayFormatters.formatByteCountToKiBEtcPerSec(this.mainWindow.getGlobalManager().getStats().getDataSendRate() + this.mainWindow.getGlobalManager().getStats().getProtocolSendRate()));
        this.trayItem.setToolTipText(toolTip.toString());
        this.trayItem.setVisible(true);
    }

    private void show() {
        if (!COConfigurationManager.getBooleanParameter("Password enabled", false)) {
            this.mainWindow.setVisible(true);
        } else {
            PasswordWindow.showPasswordWindow(MainWindow.getWindow().getDisplay());
        }
    }

    public Menu getMenu() {
        return this.menu;
    }
}

