/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.table.impl;

import java.text.Collator;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Locale;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.ui.Graphic;
import org.gudy.azureus2.plugins.ui.SWT.GraphicSWT;
import org.gudy.azureus2.plugins.ui.UIRuntimeException;
import org.gudy.azureus2.plugins.ui.tables.TableCellDisposeListener;
import org.gudy.azureus2.plugins.ui.tables.TableCellMouseEvent;
import org.gudy.azureus2.plugins.ui.tables.TableCellMouseListener;
import org.gudy.azureus2.plugins.ui.tables.TableCellRefreshListener;
import org.gudy.azureus2.plugins.ui.tables.TableCellToolTipListener;
import org.gudy.azureus2.plugins.ui.tables.TableColumn;
import org.gudy.azureus2.plugins.ui.tables.TableRow;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.components.BufferedGraphicTableItem;
import org.gudy.azureus2.ui.swt.components.BufferedGraphicTableItem1;
import org.gudy.azureus2.ui.swt.components.BufferedGraphicTableItem2;
import org.gudy.azureus2.ui.swt.components.BufferedTableItem;
import org.gudy.azureus2.ui.swt.components.BufferedTableRow;
import org.gudy.azureus2.ui.swt.plugins.UISWTGraphic;
import org.gudy.azureus2.ui.swt.pluginsimpl.UISWTGraphicImpl;
import org.gudy.azureus2.ui.swt.views.table.TableCellCore;
import org.gudy.azureus2.ui.swt.views.table.TableColumnCore;
import org.gudy.azureus2.ui.swt.views.table.TableRowCore;

public class TableCellImpl
implements TableCellCore {
    private static final LogIDs LOGID = LogIDs.GUI;
    private TableRowCore tableRow;
    private Comparable sortValue;
    private boolean bSortValueIsText = true;
    private BufferedTableItem bufferedTableItem;
    private ArrayList refreshListeners;
    private ArrayList disposeListeners;
    private ArrayList tooltipListeners;
    private ArrayList cellMouseListeners;
    private TableColumnCore tableColumn;
    private boolean valid;
    private int refreshErrLoopCount;
    private int tooltipErrLoopCount;
    private int loopFactor;
    private Object oToolTip;
    private boolean bIsUpToDate = true;
    private boolean bDisposed = false;
    private boolean bMustRefresh = false;
    public boolean bDebug = false;
    private AEMonitor this_mon = new AEMonitor("TableCell");
    private static final String CFG_PAINT = "GUI_SWT_bAlternateTablePainting";
    private static boolean bAlternateTablePainting;
    private boolean bInRefresh = false;
    public static final Comparator TEXT_COMPARATOR;

    public TableCellImpl(TableRowCore _tableRow, TableColumnCore _tableColumn, int position) {
        this.tableColumn = _tableColumn;
        this.tableRow = _tableRow;
        this.valid = false;
        this.refreshErrLoopCount = 0;
        this.tooltipErrLoopCount = 0;
        this.loopFactor = 0;
        BufferedTableRow bufRow = (BufferedTableRow)((Object)this.tableRow);
        if (this.tableColumn.getType() == 2) {
            this.bufferedTableItem = bAlternateTablePainting ? new BufferedGraphicTableItem2(bufRow, position){

                public void refresh() {
                    TableCellImpl.this.refresh();
                }

                public void invalidate() {
                    TableCellImpl.this.valid = false;
                }
            } : new BufferedGraphicTableItem1(bufRow, position){

                public void refresh() {
                    TableCellImpl.this.refresh();
                }

                public void invalidate() {
                    TableCellImpl.this.valid = false;
                }
            };
            this.setOrientationViaColumn();
        } else {
            this.bufferedTableItem = new BufferedTableItem(bufRow, position){

                public void refresh() {
                    TableCellImpl.this.refresh();
                }

                public void invalidate() {
                    TableCellImpl.this.valid = false;
                }
            };
        }
        this.tableColumn.invokeCellAddedListeners(this);
    }

    private void pluginError(Throwable e) {
        String sPosition = this.bufferedTableItem == null ? "null" : "" + this.bufferedTableItem.getPosition() + " (" + this.bufferedTableItem.getColumnName() + ")";
        Logger.log(new LogEvent(LOGID, "Table Cell Plugin for Column #" + sPosition + " generated an exception ", e));
    }

    private void checkCellForSetting() {
        if (this.isDisposed()) {
            throw new UIRuntimeException("Table Cell is disposed.");
        }
    }

    public Object getDataSource() {
        return this.tableRow.getDataSource(this.tableColumn.getUseCoreDataSource());
    }

    public TableColumn getTableColumn() {
        return this.tableColumn;
    }

    public TableRow getTableRow() {
        return this.tableRow;
    }

    public String getTableID() {
        return this.tableRow.getTableID();
    }

    public boolean isValid() {
        return this.valid;
    }

    public boolean setForeground(Color color) {
        this.checkCellForSetting();
        if (!this.tableRow.isVisible()) {
            return false;
        }
        return this.bufferedTableItem.setItemForeground(color);
    }

    public boolean setForeground(int red, int green, int blue) {
        this.checkCellForSetting();
        if (!this.tableRow.isVisible()) {
            return false;
        }
        return this.bufferedTableItem.setItemForeground(red, green, blue);
    }

    public boolean setText(String text) {
        this.checkCellForSetting();
        if (text == null) {
            text = "";
        }
        boolean bChanged = false;
        if (this.bSortValueIsText && !text.equals(this.sortValue)) {
            bChanged = true;
            this.sortValue = text;
            if (this.bDebug) {
                this.debug("Setting SortValue to text;");
            }
        }
        if (!this.tableRow.isVisible()) {
            return false;
        }
        if (this.bufferedTableItem.setText(text) && !this.bSortValueIsText) {
            bChanged = true;
        }
        return bChanged;
    }

    public String getText() {
        if (this.bSortValueIsText && this.sortValue instanceof String) {
            return (String)((Object)this.sortValue);
        }
        return this.bufferedTableItem.getText();
    }

    public boolean isShown() {
        return this.bufferedTableItem.isShown();
    }

    public boolean setSortValue(Comparable valueToSort) {
        this.checkCellForSetting();
        if (this.sortValue == valueToSort) {
            return false;
        }
        if (this.bSortValueIsText) {
            this.bSortValueIsText = false;
            if (this.sortValue instanceof String) {
                this.setText((String)((Object)this.sortValue));
            }
        }
        if (this.bDebug) {
            this.debug("Setting SortValue to " + (valueToSort == null ? "null" : valueToSort.getClass().getName()));
        }
        this.sortValue = valueToSort;
        return true;
    }

    public boolean setSortValue(long valueToSort) {
        this.checkCellForSetting();
        if (this.sortValue instanceof Long && (Long)this.sortValue == valueToSort) {
            return false;
        }
        return this.setSortValue(new Long(valueToSort));
    }

    public boolean setSortValue(float valueToSort) {
        this.checkCellForSetting();
        if (this.sortValue instanceof Float && ((Float)this.sortValue).floatValue() == valueToSort) {
            return false;
        }
        return this.setSortValue(new Float(valueToSort));
    }

    public Comparable getSortValue() {
        if (this.bDebug) {
            this.debug("GetSortValue;" + (this.sortValue == null ? "null" : this.sortValue.getClass().getName() + ";" + this.sortValue.toString()));
        }
        if (this.sortValue == null) {
            if (this.bufferedTableItem != null) {
                return this.bufferedTableItem.getText();
            }
            return "";
        }
        return this.sortValue;
    }

    public void setToolTip(Object tooltip) {
        this.oToolTip = tooltip;
    }

    public Object getToolTip() {
        return this.oToolTip;
    }

    public boolean isDisposed() {
        return this.bDisposed;
    }

    public Point getSize() {
        if (!(this.bufferedTableItem instanceof BufferedGraphicTableItem)) {
            return null;
        }
        return ((BufferedGraphicTableItem)this.bufferedTableItem).getSize();
    }

    public int getWidth() {
        if (!(this.bufferedTableItem instanceof BufferedGraphicTableItem)) {
            return -1;
        }
        Point pt = ((BufferedGraphicTableItem)this.bufferedTableItem).getSize();
        if (pt == null) {
            return -1;
        }
        return pt.x;
    }

    public int getHeight() {
        if (!(this.bufferedTableItem instanceof BufferedGraphicTableItem)) {
            return -1;
        }
        Point pt = ((BufferedGraphicTableItem)this.bufferedTableItem).getSize();
        if (pt == null) {
            return -1;
        }
        return pt.y;
    }

    public boolean setGraphic(Image img) {
        this.checkCellForSetting();
        if (!(this.bufferedTableItem instanceof BufferedGraphicTableItem)) {
            return false;
        }
        return ((BufferedGraphicTableItem)this.bufferedTableItem).setGraphic(img);
    }

    public boolean setGraphic(Graphic img) {
        this.checkCellForSetting();
        if (!(this.bufferedTableItem instanceof BufferedGraphicTableItem)) {
            return false;
        }
        if (img == null) {
            return ((BufferedGraphicTableItem)this.bufferedTableItem).setGraphic(null);
        }
        if (img instanceof GraphicSWT) {
            Image imgSWT = ((GraphicSWT)img).getImage();
            return ((BufferedGraphicTableItem)this.bufferedTableItem).setGraphic(imgSWT);
        }
        if (img instanceof UISWTGraphic) {
            Image imgSWT = ((UISWTGraphic)img).getImage();
            return ((BufferedGraphicTableItem)this.bufferedTableItem).setGraphic(imgSWT);
        }
        return false;
    }

    public Graphic getGraphic() {
        if (!(this.bufferedTableItem instanceof BufferedGraphicTableItem)) {
            return null;
        }
        Image img = ((BufferedGraphicTableItem)this.bufferedTableItem).getGraphic();
        return new UISWTGraphicImpl(img);
    }

    public Image getGraphicSWT() {
        if (!(this.bufferedTableItem instanceof BufferedGraphicTableItem)) {
            return null;
        }
        return ((BufferedGraphicTableItem)this.bufferedTableItem).getGraphic();
    }

    public void setFillCell(boolean bFillCell) {
        this.checkCellForSetting();
        if (!(this.bufferedTableItem instanceof BufferedGraphicTableItem)) {
            return;
        }
        if (bFillCell) {
            ((BufferedGraphicTableItem)this.bufferedTableItem).orientation = 4;
        } else {
            this.setOrientationViaColumn();
        }
    }

    public void setMarginHeight(int height) {
        this.checkCellForSetting();
        if (!(this.bufferedTableItem instanceof BufferedGraphicTableItem)) {
            return;
        }
        ((BufferedGraphicTableItem)this.bufferedTableItem).marginHeight = height;
    }

    public void setMarginWidth(int width) {
        this.checkCellForSetting();
        if (!(this.bufferedTableItem instanceof BufferedGraphicTableItem)) {
            return;
        }
        ((BufferedGraphicTableItem)this.bufferedTableItem).marginWidth = width;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRefreshListener(TableCellRefreshListener listener) {
        try {
            this.this_mon.enter();
            if (this.refreshListeners == null) {
                this.refreshListeners = new ArrayList();
            }
            this.refreshListeners.add(listener);
        }
        finally {
            this.this_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRefreshListener(TableCellRefreshListener listener) {
        try {
            this.this_mon.enter();
            if (this.refreshListeners == null) {
                return;
            }
            this.refreshListeners.remove(listener);
        }
        finally {
            this.this_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDisposeListener(TableCellDisposeListener listener) {
        try {
            this.this_mon.enter();
            if (this.disposeListeners == null) {
                this.disposeListeners = new ArrayList();
            }
            this.disposeListeners.add(listener);
        }
        finally {
            this.this_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDisposeListener(TableCellDisposeListener listener) {
        try {
            this.this_mon.enter();
            if (this.disposeListeners == null) {
                return;
            }
            this.disposeListeners.remove(listener);
        }
        finally {
            this.this_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addToolTipListener(TableCellToolTipListener listener) {
        try {
            this.this_mon.enter();
            if (this.tooltipListeners == null) {
                this.tooltipListeners = new ArrayList();
            }
            this.tooltipListeners.add(listener);
        }
        finally {
            this.this_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeToolTipListener(TableCellToolTipListener listener) {
        try {
            this.this_mon.enter();
            if (this.tooltipListeners == null) {
                return;
            }
            this.tooltipListeners.remove(listener);
        }
        finally {
            this.this_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMouseListener(TableCellMouseListener listener) {
        try {
            this.this_mon.enter();
            if (this.cellMouseListeners == null) {
                this.cellMouseListeners = new ArrayList();
            }
            this.cellMouseListeners.add(listener);
        }
        finally {
            this.this_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMouseListener(TableCellMouseListener listener) {
        try {
            this.this_mon.enter();
            if (this.cellMouseListeners == null) {
                return;
            }
            this.cellMouseListeners.remove(listener);
        }
        finally {
            this.this_mon.exit();
        }
    }

    public void addListeners(Object listenerObject) {
        if (listenerObject instanceof TableCellDisposeListener) {
            this.addDisposeListener((TableCellDisposeListener)listenerObject);
        }
        if (listenerObject instanceof TableCellRefreshListener) {
            this.addRefreshListener((TableCellRefreshListener)listenerObject);
        }
        if (listenerObject instanceof TableCellToolTipListener) {
            this.addToolTipListener((TableCellToolTipListener)listenerObject);
        }
        if (listenerObject instanceof TableCellMouseListener) {
            this.addMouseListener((TableCellMouseListener)listenerObject);
        }
    }

    public void invalidate() {
        this.checkCellForSetting();
        this.invalidate(true);
    }

    public void invalidate(boolean bMustRefresh) {
        this.valid = false;
        if (this.bDebug) {
            this.debug("Invalidate Cell;" + bMustRefresh + "; Visible?" + this.tableRow.isVisible());
        }
        if (bMustRefresh) {
            this.bMustRefresh = true;
        }
    }

    public void refresh() {
        this.refresh(true);
    }

    public void refresh(boolean bDoGraphics) {
        this.refresh(bDoGraphics, this.tableRow.isVisible());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh(boolean bDoGraphics, boolean bRowVisible) {
        if (this.refreshErrLoopCount > 2) {
            return;
        }
        int iErrCount = this.tableColumn.getConsecutiveErrCount();
        if (iErrCount > 10) {
            return;
        }
        if (this.bInRefresh) {
            if (this.bDebug) {
                this.debug("Calling Refresh from Refresh :) Skipping.");
            }
            return;
        }
        this.bInRefresh = true;
        if (bRowVisible && !this.bIsUpToDate) {
            if (this.bDebug) {
                this.debug("Setting Invalid because visible & not up to date");
            }
            this.valid = false;
            this.bIsUpToDate = true;
        } else if (!bRowVisible && this.bIsUpToDate) {
            this.bIsUpToDate = false;
        }
        try {
            int iInterval;
            if (this.bDebug) {
                this.debug("Cell Valid?" + this.valid + "; Visible?" + this.tableRow.isVisible());
            }
            if ((iInterval = this.tableColumn.getRefreshInterval()) == -3 && !this.valid && !this.bMustRefresh && this.bSortValueIsText && this.sortValue != null && this.tableColumn.getType() == 3) {
                this.setText((String)((Object)this.sortValue));
                this.valid = true;
            } else if ((iInterval == -2 || iInterval == -1 && bDoGraphics || iInterval > 0 && this.loopFactor % iInterval == 0 || !this.valid || this.bMustRefresh) && this.bufferedTableItem.isShown()) {
                boolean bWasValid = this.isValid();
                this.tableColumn.invokeCellRefreshListeners(this);
                if (this.refreshListeners != null) {
                    for (int i = 0; i < this.refreshListeners.size(); ++i) {
                        ((TableCellRefreshListener)this.refreshListeners.get(i)).refresh(this);
                    }
                }
                if (!bWasValid) {
                    this.valid = true;
                }
                if (this.bMustRefresh) {
                    this.bMustRefresh = false;
                }
            }
            ++this.loopFactor;
            this.refreshErrLoopCount = 0;
            if (iErrCount > 0) {
                this.tableColumn.setConsecutiveErrCount(0);
            }
        }
        catch (Throwable e) {
            ++this.refreshErrLoopCount;
            this.tableColumn.setConsecutiveErrCount(++iErrCount);
            this.pluginError(e);
            if (this.refreshErrLoopCount > 2) {
                Logger.log(new LogEvent(LOGID, 3, "TableCell will not be refreshed anymore this session."));
            }
        }
        finally {
            this.bInRefresh = false;
        }
    }

    public void dispose() {
        this.bDisposed = true;
        if (this.disposeListeners != null) {
            try {
                this.tableColumn.invokeCellDisposeListeners(this);
                Iterator iter = this.disposeListeners.iterator();
                while (iter.hasNext()) {
                    TableCellDisposeListener listener = (TableCellDisposeListener)iter.next();
                    listener.dispose(this);
                }
                this.disposeListeners = null;
            }
            catch (Throwable e) {
                this.pluginError(e);
            }
        }
        if (this.bufferedTableItem != null) {
            this.bufferedTableItem.dispose();
        }
        this.refreshListeners = null;
        this.bufferedTableItem = null;
        this.tableColumn = null;
        this.tableRow = null;
        this.sortValue = null;
    }

    public void setImage(Image img) {
        if (!this.tableRow.isVisible()) {
            return;
        }
        this.bufferedTableItem.setImage(img);
    }

    public boolean needsPainting() {
        return this.bufferedTableItem.needsPainting();
    }

    public void doPaint(GC gc) {
        this.bufferedTableItem.doPaint(gc);
    }

    public void locationChanged() {
        this.bufferedTableItem.locationChanged();
    }

    public TableRowCore getTableRowCore() {
        return this.tableRow;
    }

    public String toString() {
        return this.getText();
    }

    public int compareTo(Object o) {
        try {
            Comparable ourSortValue = this.getSortValue();
            Comparable otherSortValue = ((TableCellImpl)o).getSortValue();
            if (ourSortValue instanceof String && otherSortValue instanceof String) {
                Collator collator = Collator.getInstance(Locale.getDefault());
                return collator.compare(ourSortValue, otherSortValue);
            }
            try {
                return ourSortValue.compareTo(otherSortValue);
            }
            catch (ClassCastException e) {
            }
        }
        catch (Exception e) {
            System.out.println("Could not compare cells");
            Debug.printStackTrace(e);
        }
        return 0;
    }

    public void invokeToolTipListeners(int type) {
        block9: {
            if (this.tableColumn == null) {
                return;
            }
            this.tableColumn.invokeCellToolTipListeners(this, type);
            if (this.tooltipListeners == null || this.tooltipErrLoopCount > 2) {
                return;
            }
            int iErrCount = this.tableColumn.getConsecutiveErrCount();
            if (iErrCount > 10) {
                return;
            }
            try {
                if (type == 0) {
                    for (int i = 0; i < this.tooltipListeners.size(); ++i) {
                        ((TableCellToolTipListener)this.tooltipListeners.get(i)).cellHover(this);
                    }
                } else {
                    for (int i = 0; i < this.tooltipListeners.size(); ++i) {
                        ((TableCellToolTipListener)this.tooltipListeners.get(i)).cellHoverComplete(this);
                    }
                }
                this.tooltipErrLoopCount = 0;
            }
            catch (Throwable e) {
                ++this.tooltipErrLoopCount;
                this.tableColumn.setConsecutiveErrCount(++iErrCount);
                this.pluginError(e);
                if (this.tooltipErrLoopCount <= 2) break block9;
                Logger.log(new LogEvent(LOGID, 3, "TableCell's tooltip will not be refreshed anymore this session."));
            }
        }
    }

    public void invokeMouseListeners(TableCellMouseEvent event) {
        if (this.cellMouseListeners == null) {
            return;
        }
        for (int i = 0; i < this.cellMouseListeners.size(); ++i) {
            try {
                TableCellMouseListener l = (TableCellMouseListener)this.cellMouseListeners.get(i);
                l.cellMouseTrigger(event);
                continue;
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
    }

    public void setUpToDate(boolean upToDate) {
        this.bIsUpToDate = upToDate;
    }

    private void debug(final String s) {
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                System.out.println("r" + TableCellImpl.this.tableRow.getIndex() + "; " + s);
            }
        }, true);
    }

    public Rectangle getBounds() {
        if (!(this.bufferedTableItem instanceof BufferedGraphicTableItem)) {
            return new Rectangle(0, 0, 0, 0);
        }
        return ((BufferedGraphicTableItem)this.bufferedTableItem).getBounds();
    }

    private void setOrientationViaColumn() {
        if (!(this.bufferedTableItem instanceof BufferedGraphicTableItem)) {
            return;
        }
        BufferedGraphicTableItem ti = (BufferedGraphicTableItem)this.bufferedTableItem;
        int align = this.tableColumn.getAlignment();
        if (align == 3) {
            ti.orientation = 0x1000000;
        } else if (align == 1) {
            ti.orientation = 16384;
        } else if (align == 2) {
            ti.orientation = 131072;
        }
    }

    static {
        COConfigurationManager.addAndFireParameterListener(CFG_PAINT, new ParameterListener(){

            public void parameterChanged(String parameterName) {
                bAlternateTablePainting = COConfigurationManager.getBooleanParameter(TableCellImpl.CFG_PAINT);
            }
        });
        TEXT_COMPARATOR = new TextComparator();
    }

    private static class TextComparator
    implements Comparator {
        private TextComparator() {
        }

        public int compare(Object arg0, Object arg1) {
            return arg0.toString().compareToIgnoreCase(arg1.toString());
        }
    }
}

