/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.stats;

import com.aelitis.azureus.core.dht.control.DHTControlContact;
import com.aelitis.azureus.core.dht.transport.DHTTransportContact;
import com.aelitis.azureus.core.dht.vivaldi.maths.VivaldiPosition;
import com.aelitis.azureus.core.dht.vivaldi.maths.impl.HeightCoordinatesImpl;
import java.util.Iterator;
import java.util.List;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;

public class VivaldiPanel {
    Display display;
    Composite parent;
    Canvas canvas;
    Scale scale;
    private boolean mouseLeftDown = false;
    private boolean mouseRightDown = false;
    private int xDown;
    private int yDown;
    private boolean antiAliasingAvailable = true;

    public VivaldiPanel(Composite parent) {
        this.parent = parent;
        this.display = parent.getDisplay();
        this.canvas = new Canvas(parent, 0);
        this.scale = new Scale();
        this.canvas.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent event) {
                if (event.button == 1) {
                    VivaldiPanel.this.mouseLeftDown = true;
                }
                if (event.button == 3) {
                    VivaldiPanel.this.mouseRightDown = true;
                }
                VivaldiPanel.this.xDown = event.x;
                VivaldiPanel.this.yDown = event.y;
                VivaldiPanel.this.scale.saveMinX = VivaldiPanel.this.scale.minX;
                VivaldiPanel.this.scale.saveMaxX = VivaldiPanel.this.scale.maxX;
                VivaldiPanel.this.scale.saveMinY = VivaldiPanel.this.scale.minY;
                VivaldiPanel.this.scale.saveMaxY = VivaldiPanel.this.scale.maxY;
            }

            public void mouseUp(MouseEvent event) {
                if (event.button == 1) {
                    VivaldiPanel.this.mouseLeftDown = false;
                }
                if (event.button == 3) {
                    VivaldiPanel.this.mouseRightDown = false;
                }
            }
        });
        this.canvas.addMouseMoveListener(new MouseMoveListener(){

            public void mouseMove(MouseEvent event) {
                if (VivaldiPanel.this.mouseLeftDown) {
                    int deltaX = event.x - VivaldiPanel.this.xDown;
                    int deltaY = event.y - VivaldiPanel.this.yDown;
                    int width = VivaldiPanel.this.scale.width;
                    int height = VivaldiPanel.this.scale.height;
                    float ratioX = (VivaldiPanel.this.scale.saveMaxX - VivaldiPanel.this.scale.saveMinX) / (float)width;
                    float ratioY = (VivaldiPanel.this.scale.saveMaxY - VivaldiPanel.this.scale.saveMinY) / (float)height;
                    float realDeltaX = (float)deltaX * ratioX;
                    float realDeltaY = (float)deltaY * ratioY;
                    VivaldiPanel.this.scale.minX = VivaldiPanel.this.scale.saveMinX - realDeltaX;
                    VivaldiPanel.this.scale.maxX = VivaldiPanel.this.scale.saveMaxX - realDeltaX;
                    VivaldiPanel.this.scale.minY = VivaldiPanel.this.scale.saveMinY - realDeltaY;
                    VivaldiPanel.this.scale.maxY = VivaldiPanel.this.scale.saveMaxY - realDeltaY;
                }
                if (VivaldiPanel.this.mouseRightDown) {
                    int deltaY = event.y - VivaldiPanel.this.yDown;
                    float scaleFactor = 1.0f - (float)deltaY / 300.0f;
                    if (scaleFactor <= 0.0f) {
                        scaleFactor = 0.01f;
                    }
                    float moveFactor = 1.0f - 1.0f / scaleFactor;
                    float centerX = (VivaldiPanel.this.scale.saveMinX + VivaldiPanel.this.scale.saveMaxX) / 2.0f;
                    VivaldiPanel.this.scale.minX = VivaldiPanel.this.scale.saveMinX + moveFactor * (centerX - VivaldiPanel.this.scale.saveMinX);
                    VivaldiPanel.this.scale.maxX = VivaldiPanel.this.scale.saveMaxX - moveFactor * (VivaldiPanel.this.scale.saveMaxX - centerX);
                    float centerY = (VivaldiPanel.this.scale.saveMinY + VivaldiPanel.this.scale.saveMaxY) / 2.0f;
                    VivaldiPanel.this.scale.minY = VivaldiPanel.this.scale.saveMinY + moveFactor * (centerY - VivaldiPanel.this.scale.saveMinY);
                    VivaldiPanel.this.scale.maxY = VivaldiPanel.this.scale.saveMaxY - moveFactor * (VivaldiPanel.this.scale.saveMaxY - centerY);
                }
            }
        });
    }

    public void setLayoutData(Object data) {
        this.canvas.setLayoutData(data);
    }

    public void refreshContacts(List contacts, DHTTransportContact self) {
        if (this.canvas.isDisposed()) {
            return;
        }
        Rectangle size = this.canvas.getBounds();
        this.scale.width = size.width;
        this.scale.height = size.height;
        Color white = new Color((Device)this.display, 255, 255, 255);
        Color blue = new Color((Device)this.display, 66, 87, 104);
        Image img = new Image((Device)this.display, size);
        GC gc = new GC((Drawable)img);
        gc.setForeground(white);
        gc.setBackground(white);
        gc.fillRectangle(size);
        if (SWT.getVersion() < 3138 || this.antiAliasingAvailable) {
            // empty if block
        }
        gc.setForeground(blue);
        gc.setBackground(white);
        VivaldiPosition ownPosition = self.getVivaldiPosition();
        float ownErrorEstimate = ownPosition.getErrorEstimate();
        HeightCoordinatesImpl ownCoords = (HeightCoordinatesImpl)ownPosition.getCoordinates();
        gc.drawText("Our error: " + ownErrorEstimate, 10, 10);
        Color black = new Color((Device)this.display, 0, 0, 0);
        gc.setBackground(black);
        Iterator iter = contacts.iterator();
        while (iter.hasNext()) {
            DHTControlContact contact = (DHTControlContact)iter.next();
            VivaldiPosition position = contact.getTransportContact().getVivaldiPosition();
            HeightCoordinatesImpl coord = (HeightCoordinatesImpl)position.getCoordinates();
            if (!coord.isValid()) continue;
            this.draw(gc, coord.getX(), coord.getY(), coord.getH(), contact, (int)ownCoords.distance(coord), position.getErrorEstimate());
        }
        Color red = new Color((Device)this.display, 255, 0, 0);
        gc.setForeground(red);
        red.dispose();
        this.drawSelf(gc, ownCoords.getX(), ownCoords.getY(), ownCoords.getH(), ownErrorEstimate);
        gc.dispose();
        gc = new GC((Drawable)this.canvas);
        gc.drawImage(img, 0, 0);
        gc.dispose();
        img.dispose();
        white.dispose();
        blue.dispose();
        black.dispose();
    }

    public void refresh(List vivaldiPositions) {
        if (this.canvas.isDisposed()) {
            return;
        }
        Rectangle size = this.canvas.getBounds();
        this.scale.width = size.width;
        this.scale.height = size.height;
        Image img = new Image((Device)this.display, size);
        GC gc = new GC((Drawable)img);
        Color white = new Color((Device)this.display, 255, 255, 255);
        gc.setForeground(white);
        gc.setBackground(white);
        gc.fillRectangle(size);
        Color blue = new Color((Device)this.display, 66, 87, 104);
        gc.setForeground(blue);
        gc.setBackground(blue);
        Iterator iter = vivaldiPositions.iterator();
        while (iter.hasNext()) {
            VivaldiPosition position = (VivaldiPosition)iter.next();
            HeightCoordinatesImpl coord = (HeightCoordinatesImpl)position.getCoordinates();
            float error = position.getErrorEstimate() - 0.1f;
            if (error < 0.0f) {
                error = 0.0f;
            }
            if (error > 1.0f) {
                error = 1.0f;
            }
            int blueComponent = (int)(255.0f - error * 255.0f);
            int redComponent = (int)(255.0f * error);
            Color drawColor = new Color((Device)this.display, redComponent, 50, blueComponent);
            gc.setForeground(drawColor);
            this.draw(gc, coord.getX(), coord.getY(), coord.getH());
            drawColor.dispose();
        }
        gc.dispose();
        gc = new GC((Drawable)this.canvas);
        gc.drawImage(img, 0, 0);
        gc.dispose();
        img.dispose();
        white.dispose();
        blue.dispose();
    }

    private void draw(GC gc, float x, float y, float h) {
        int x0 = this.scale.getX(x, y);
        int y0 = this.scale.getY(x, y);
        gc.fillRectangle(x0 - 1, y0 - 1, 3, 3);
        gc.drawLine(x0, y0, x0, (int)((float)y0 - 200.0f * h / (this.scale.maxY - this.scale.minY)));
    }

    private void draw(GC gc, float x, float y, float h, DHTControlContact contact, int distance, float error) {
        if (x == 0.0f && y == 0.0f) {
            return;
        }
        if (error > 1.0f) {
            error = 1.0f;
        }
        int errDisplay = (int)(100.0f * error);
        int x0 = this.scale.getX(x, y);
        int y0 = this.scale.getY(x, y);
        gc.fillRectangle(x0 - 1, y0 - 1, 3, 3);
        String text = distance + " ms \nerr:" + errDisplay + "%";
        int lineReturn = text.indexOf("\n");
        int xOffset = gc.getFontMetrics().getAverageCharWidth() * (lineReturn != -1 ? lineReturn : text.length()) / 2;
        gc.drawText(text, x0 - xOffset, y0, true);
    }

    private void drawSelf(GC gc, float x, float y, float h, float errorEstimate) {
        int x0 = this.scale.getX(x, y);
        int y0 = this.scale.getY(x, y);
        gc.drawLine(x0 - 15, y0, x0 + 15, y0);
        gc.drawLine(x0, y0 - 15, x0, y0 + 15);
    }

    private void drawBorder(GC gc) {
    }

    private class Scale {
        int width;
        int height;
        float minX = -1000.0f;
        float maxX = 1000.0f;
        float minY = -1000.0f;
        float maxY = 1000.0f;
        float saveMinX;
        float saveMaxX;
        float saveMinY;
        float saveMaxY;

        private Scale() {
        }

        public int getX(float x, float y) {
            return (int)((x - this.minX) / (this.maxX - this.minX) * (float)this.width);
        }

        public int getY(float x, float y) {
            return (int)((y - this.minY) / (this.maxY - this.minY) * (float)this.height);
        }
    }
}

