/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views;

import com.aelitis.azureus.core.AzureusCore;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;
import org.gudy.azureus2.core3.category.Category;
import org.gudy.azureus2.core3.category.CategoryManager;
import org.gudy.azureus2.core3.global.GlobalManager;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.download.DownloadManager;
import org.gudy.azureus2.plugins.sharing.ShareException;
import org.gudy.azureus2.plugins.sharing.ShareItem;
import org.gudy.azureus2.plugins.sharing.ShareManager;
import org.gudy.azureus2.plugins.sharing.ShareManagerListener;
import org.gudy.azureus2.plugins.sharing.ShareResource;
import org.gudy.azureus2.plugins.sharing.ShareResourceDir;
import org.gudy.azureus2.plugins.sharing.ShareResourceDirContents;
import org.gudy.azureus2.plugins.sharing.ShareResourceFile;
import org.gudy.azureus2.plugins.torrent.Torrent;
import org.gudy.azureus2.plugins.torrent.TorrentAttribute;
import org.gudy.azureus2.plugins.tracker.Tracker;
import org.gudy.azureus2.plugins.tracker.TrackerTorrent;
import org.gudy.azureus2.pluginsimpl.local.torrent.TorrentManagerImpl;
import org.gudy.azureus2.ui.swt.Alerts;
import org.gudy.azureus2.ui.swt.CategoryAdderWindow;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.mainwindow.MainWindow;
import org.gudy.azureus2.ui.swt.views.TableView;
import org.gudy.azureus2.ui.swt.views.table.TableColumnCore;
import org.gudy.azureus2.ui.swt.views.table.TableRowCore;
import org.gudy.azureus2.ui.swt.views.tableitems.myshares.CategoryItem;
import org.gudy.azureus2.ui.swt.views.tableitems.myshares.NameItem;
import org.gudy.azureus2.ui.swt.views.tableitems.myshares.TypeItem;

public class MySharesView
extends TableView
implements ShareManagerListener {
    private static final TableColumnCore[] basicItems = new TableColumnCore[]{new NameItem(), new TypeItem(), new CategoryItem()};
    protected static final TorrentAttribute category_attribute = TorrentManagerImpl.getSingleton().getAttribute("Category");
    private AzureusCore azureus_core;
    private GlobalManager global_manager;
    private Menu menuCategory;
    private boolean start;
    private boolean stop;
    private boolean remove;

    public MySharesView(AzureusCore _azureus_core) {
        super("MyShares", "MySharesView", basicItems, "name", 268503042);
        this.azureus_core = _azureus_core;
        this.global_manager = this.azureus_core.getGlobalManager();
    }

    public void initialize(Composite composite) {
        super.initialize(composite);
        this.getTable().addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent mEvent) {
                TableItem[] tis = MySharesView.this.getTable().getSelection();
                if (tis.length == 0) {
                    return;
                }
                ShareResource share = (ShareResource)MySharesView.this.getFirstSelectedDataSource();
                if (share != null) {
                    List dms = MySharesView.this.global_manager.getDownloadManagers();
                    for (int i = 0; i < dms.size(); ++i) {
                        org.gudy.azureus2.core3.download.DownloadManager dm = (org.gudy.azureus2.core3.download.DownloadManager)dms.get(i);
                        try {
                            byte[] share_hash = null;
                            if (share.getType() == 2) {
                                share_hash = ((ShareResourceDir)share).getItem().getTorrent().getHash();
                            } else if (share.getType() == 1) {
                                share_hash = ((ShareResourceFile)share).getItem().getTorrent().getHash();
                            }
                            if (!Arrays.equals(share_hash, dm.getTorrent().getHash())) continue;
                            MainWindow.getWindow().openManagerView(dm);
                            break;
                        }
                        catch (Throwable e) {
                            Debug.printStackTrace(e);
                        }
                    }
                }
            }
        });
        this.createRows();
    }

    private void createRows() {
        try {
            ShareManager sm = this.azureus_core.getPluginManager().getDefaultPluginInterface().getShareManager();
            ShareResource[] shares = sm.getShares();
            for (int i = 0; i < shares.length; ++i) {
                this.resourceAdded(shares[i]);
            }
            sm.addListener(this);
        }
        catch (ShareException e) {
            Debug.printStackTrace(e);
        }
    }

    public void tableStructureChanged() {
        super.tableStructureChanged();
        this.createRows();
    }

    public void fillMenu(Menu menu) {
        this.menuCategory = new Menu((Decorations)this.getComposite().getShell(), 4);
        MenuItem itemCategory = new MenuItem(menu, 64);
        Messages.setLanguageText((Widget)itemCategory, "MyTorrentsView.menu.setCategory");
        itemCategory.setMenu(this.menuCategory);
        this.addCategorySubMenu();
        new MenuItem(menu, 2);
        MenuItem itemRemove = new MenuItem(menu, 8);
        Messages.setLanguageText((Widget)itemRemove, "MySharesView.menu.remove");
        Utils.setMenuItemImage(itemRemove, "delete");
        Object[] shares = this.getSelectedDataSources();
        itemRemove.setEnabled(shares.length > 0);
        itemRemove.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                MySharesView.this.removeSelectedShares();
            }
        });
        new MenuItem(menu, 2);
        super.fillMenu(menu);
    }

    public void resourceAdded(ShareResource resource) {
        this.addDataSource(resource);
    }

    public void resourceModified(ShareResource resource) {
    }

    public void resourceDeleted(ShareResource resource) {
        this.removeDataSource(resource);
    }

    public void reportProgress(int percent_complete) {
    }

    public void reportCurrentTask(String task_description) {
    }

    public void refresh(boolean bForceSort) {
        if (this.getComposite() == null || this.getComposite().isDisposed()) {
            return;
        }
        this.computePossibleActions();
        MainWindow.getWindow().refreshIconBar();
        super.refresh(bForceSort);
    }

    private void addCategorySubMenu() {
        int i;
        MenuItem[] items = this.menuCategory.getItems();
        for (i = 0; i < items.length; ++i) {
            items[i].dispose();
        }
        Object[] categories = CategoryManager.getCategories();
        Arrays.sort(categories);
        if (categories.length > 0) {
            MenuItem itemCategory;
            Category catUncat = CategoryManager.getCategory(2);
            if (catUncat != null) {
                itemCategory = new MenuItem(this.menuCategory, 8);
                Messages.setLanguageText((Widget)itemCategory, catUncat.getName());
                itemCategory.setData("Category", (Object)catUncat);
                itemCategory.addListener(13, new Listener(){

                    public void handleEvent(Event event) {
                        MenuItem item = (MenuItem)event.widget;
                        MySharesView.this.assignSelectedToCategory((Category)item.getData("Category"));
                    }
                });
                new MenuItem(this.menuCategory, 2);
            }
            for (i = 0; i < categories.length; ++i) {
                if (categories[i].getType() != 0) continue;
                itemCategory = new MenuItem(this.menuCategory, 8);
                itemCategory.setText(categories[i].getName());
                itemCategory.setData("Category", categories[i]);
                itemCategory.addListener(13, new Listener(){

                    public void handleEvent(Event event) {
                        MenuItem item = (MenuItem)event.widget;
                        MySharesView.this.assignSelectedToCategory((Category)item.getData("Category"));
                    }
                });
            }
            new MenuItem(this.menuCategory, 2);
        }
        MenuItem itemAddCategory = new MenuItem(this.menuCategory, 8);
        Messages.setLanguageText((Widget)itemAddCategory, "MyTorrentsView.menu.setCategory.add");
        itemAddCategory.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                MySharesView.this.addCategory();
            }
        });
    }

    private void addCategory() {
        CategoryAdderWindow adderWindow = new CategoryAdderWindow(MainWindow.getWindow().getDisplay());
        Category newCategory = adderWindow.getNewCategory();
        if (newCategory != null) {
            this.assignSelectedToCategory(newCategory);
        }
    }

    private void assignSelectedToCategory(final Category category) {
        this.runForSelectedRows(new TableView.GroupTableRowRunner(){

            public void run(TableRowCore row) {
                String value = category == null ? null : (category == CategoryManager.getCategory(2) ? null : category.getName());
                ((ShareResource)row.getDataSource(true)).setAttribute(category_attribute, value);
            }
        });
    }

    public void delete() {
        super.delete();
        try {
            this.azureus_core.getPluginManager().getDefaultPluginInterface().getShareManager().removeListener(this);
        }
        catch (ShareException e) {
            Debug.printStackTrace(e);
        }
        MainWindow.getWindow().setMyShares(null);
    }

    private void computePossibleActions() {
        this.remove = false;
        this.stop = false;
        this.start = false;
        List items = this.getSelectedItems();
        if (items.size() > 0) {
            PluginInterface pi = this.azureus_core.getPluginManager().getDefaultPluginInterface();
            DownloadManager dm = pi.getDownloadManager();
            this.remove = true;
            for (int i = 0; i < items.size(); ++i) {
                ShareItem item = (ShareItem)items.get(i);
                try {
                    int dl_state;
                    Torrent t = item.getTorrent();
                    Download download = dm.getDownload(t);
                    if (download == null || (dl_state = download.getState()) == 8) continue;
                    if (dl_state != 7) {
                        this.stop = true;
                        continue;
                    }
                    this.start = true;
                    continue;
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
            }
        }
    }

    public boolean isEnabled(String itemKey) {
        if (itemKey.equals("start")) {
            return this.start;
        }
        if (itemKey.equals("stop")) {
            return this.stop;
        }
        if (itemKey.equals("remove")) {
            return this.remove;
        }
        return false;
    }

    public void itemActivated(String itemKey) {
        if (itemKey.equals("remove")) {
            this.removeSelectedShares();
            return;
        }
        if (itemKey.equals("stop")) {
            this.stopSelectedShares();
        } else if (itemKey.equals("start")) {
            this.startSelectedShares();
        }
    }

    private List getSelectedItems() {
        Object[] shares = this.getSelectedDataSources();
        ArrayList<ShareItem> items = new ArrayList<ShareItem>();
        if (shares.length > 0) {
            for (int i = 0; i < shares.length; ++i) {
                ShareResource sr;
                ShareResource share = (ShareResource)shares[i];
                int type = share.getType();
                if (type == 2) {
                    sr = (ShareResourceDir)share;
                    items.add(sr.getItem());
                    continue;
                }
                if (type == 1) {
                    sr = (ShareResourceFile)share;
                    items.add(sr.getItem());
                    continue;
                }
                ShareResourceDirContents cont = (ShareResourceDirContents)share;
                ArrayList entries = new ArrayList();
                this.getEntries(entries, cont);
                for (int j = 0; j < entries.size(); ++j) {
                    ShareResource sr2;
                    share = (ShareResource)entries.get(j);
                    type = share.getType();
                    if (type == 2) {
                        sr2 = (ShareResourceDir)share;
                        items.add(sr2.getItem());
                        continue;
                    }
                    if (type != 1) continue;
                    sr2 = (ShareResourceFile)share;
                    items.add(sr2.getItem());
                }
            }
        }
        return items;
    }

    private void getEntries(List entries, ShareResourceDirContents cont) {
        ShareResource[] kids = cont.getChildren();
        for (int i = 0; i < kids.length; ++i) {
            ShareResource share = kids[i];
            int type = share.getType();
            if (type == 3) {
                this.getEntries(entries, (ShareResourceDirContents)share);
                continue;
            }
            entries.add(share);
        }
    }

    private void startStopSelectedShares(boolean do_stop) {
        List items = this.getSelectedItems();
        PluginInterface pi = this.azureus_core.getPluginManager().getDefaultPluginInterface();
        DownloadManager dm = pi.getDownloadManager();
        Tracker tracker = pi.getTracker();
        for (int i = 0; i < items.size(); ++i) {
            ShareItem item = (ShareItem)items.get(i);
            try {
                int dl_state;
                Torrent t = item.getTorrent();
                TrackerTorrent tracker_torrent = tracker.getTorrent(t);
                Download download = dm.getDownload(t);
                if (tracker_torrent == null || download == null || (dl_state = download.getState()) == 8) continue;
                if (dl_state != 7) {
                    if (!do_stop) continue;
                    try {
                        download.stop();
                    }
                    catch (Throwable e) {
                        // empty catch block
                    }
                    try {
                        tracker_torrent.stop();
                    }
                    catch (Throwable e) {}
                    continue;
                }
                if (do_stop) continue;
                try {
                    download.restart();
                }
                catch (Throwable e) {
                    // empty catch block
                }
                try {
                    tracker_torrent.start();
                }
                catch (Throwable e) {}
                continue;
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
    }

    private void startSelectedShares() {
        this.startStopSelectedShares(false);
    }

    private void stopSelectedShares() {
        this.startStopSelectedShares(true);
    }

    private void removeSelectedShares() {
        this.stopSelectedShares();
        Object[] shares = this.getSelectedDataSources();
        for (int i = 0; i < shares.length; ++i) {
            try {
                ((ShareResource)shares[i]).delete();
                continue;
            }
            catch (Throwable e) {
                Alerts.showErrorMessageBoxUsingResourceString("globalmanager.download.remove.veto", e);
            }
        }
    }
}

