/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.update;

import com.aelitis.azureus.core.AzureusCore;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AEThread;
import org.gudy.azureus2.core3.util.DelayedEvent;
import org.gudy.azureus2.core3.util.SimpleTimer;
import org.gudy.azureus2.core3.util.SystemProperties;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.update.Update;
import org.gudy.azureus2.plugins.update.UpdateCheckInstance;
import org.gudy.azureus2.plugins.update.UpdateCheckInstanceListener;
import org.gudy.azureus2.plugins.update.UpdateManager;
import org.gudy.azureus2.plugins.update.UpdateManagerListener;
import org.gudy.azureus2.ui.swt.mainwindow.MainWindow;
import org.gudy.azureus2.ui.swt.mainwindow.SWTThread;
import org.gudy.azureus2.ui.swt.update.UpdateWindow;
import org.gudy.azureus2.update.CoreUpdateChecker;

public class UpdateMonitor
implements UpdateCheckInstanceListener {
    private static final LogIDs LOGID = LogIDs.GUI;
    public static final long AUTO_UPDATE_CHECK_PERIOD = 82800000L;
    protected static UpdateMonitor singleton;
    protected static AEMonitor class_mon;
    protected AzureusCore azureus_core;
    protected UpdateWindow current_update_window;
    protected UpdateCheckInstance current_update_instance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static UpdateMonitor getSingleton(AzureusCore core) {
        try {
            class_mon.enter();
            if (singleton == null) {
                singleton = new UpdateMonitor(core);
            }
            UpdateMonitor updateMonitor = singleton;
            return updateMonitor;
        }
        finally {
            class_mon.exit();
        }
    }

    protected UpdateMonitor(AzureusCore _azureus_core) {
        this.azureus_core = _azureus_core;
        UpdateManager um = this.azureus_core.getPluginManager().getDefaultPluginInterface().getUpdateManager();
        um.addListener(new UpdateManagerListener(){

            public void checkInstanceCreated(UpdateCheckInstance instance) {
                instance.addListener(UpdateMonitor.this);
            }
        });
        SimpleTimer.addPeriodicEvent(82800000L, new TimerEventPerformer(){

            public void perform(TimerEvent ev) {
                UpdateMonitor.this.performAutoCheck(false);
            }
        });
        new DelayedEvent(2500L, new AERunnable(){

            public void runSupport() {
                UpdateMonitor.this.performAutoCheck(true);
            }
        });
    }

    protected void performAutoCheck(final boolean start_of_day) {
        boolean check_at_start = false;
        boolean check_periodic = false;
        if (!SystemProperties.isJavaWebStartInstance()) {
            check_at_start = COConfigurationManager.getBooleanParameter("update.start", true);
            check_periodic = COConfigurationManager.getBooleanParameter("update.periodic", true);
        }
        boolean bl = check_at_start = check_at_start || check_periodic;
        if (check_at_start && start_of_day || check_periodic && !start_of_day) {
            this.performCheck();
        } else {
            new DelayedEvent(5000L, new AERunnable(){

                public void runSupport() {
                    if (start_of_day) {
                        MainWindow.getWindow().setStatusText("");
                    }
                    CoreUpdateChecker.doUsageStats();
                }
            });
        }
    }

    public void performCheck() {
        if (SystemProperties.isJavaWebStartInstance()) {
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent(LOGID, "skipping update check as java web start"));
            }
            return;
        }
        if (this.current_update_window != null && !this.current_update_window.isDisposed()) {
            SWTThread.getInstance().getDisplay().syncExec((Runnable)new AERunnable(){

                public void runSupport() {
                    UpdateMonitor.this.current_update_window.dispose();
                }
            });
        }
        if (this.current_update_instance != null) {
            this.current_update_instance.cancel();
        }
        MainWindow mainWindow = MainWindow.getWindow();
        mainWindow.setStatusText("MainWindow.status.checking ...");
        AEThread t = new AEThread("UpdateMonitor:kickoff"){

            public void runSupport() {
                UpdateManager um = UpdateMonitor.this.azureus_core.getPluginManager().getDefaultPluginInterface().getUpdateManager();
                UpdateMonitor.this.current_update_instance = um.createUpdateCheckInstance(2, "update.instance.update");
                UpdateMonitor.this.current_update_instance.start();
            }
        };
        t.setDaemon(true);
        t.start();
    }

    public void complete(UpdateCheckInstance instance) {
        boolean update_action;
        boolean bl = update_action = instance.getType() == 2;
        if (update_action) {
            PluginInterface core_plugin = this.azureus_core.getPluginManager().getPluginInterfaceByClass(CoreUpdateChecker.class);
            String latest_version = core_plugin.getPluginProperties().getProperty("latest_version");
            MainWindow mainWindow = MainWindow.getWindow();
            mainWindow.setStatusText("");
        }
        Update[] us = instance.getUpdates();
        boolean show_window = false;
        for (int i = 0; i < us.length; ++i) {
            if (us[i].getDownloaders().length <= 0) continue;
            show_window = true;
            break;
        }
        if (show_window) {
            UpdateWindow this_window = null;
            if (update_action) {
                if (this.current_update_window == null || this.current_update_window.isDisposed()) {
                    this_window = this.current_update_window = new UpdateWindow(this.azureus_core, instance);
                }
            } else {
                this_window = new UpdateWindow(this.azureus_core, instance);
            }
            if (this_window != null) {
                for (int i = 0; i < us.length; ++i) {
                    if (us[i].getDownloaders().length <= 0) continue;
                    this_window.addUpdate(us[i]);
                }
                this_window.updateAdditionComplete();
            } else if (Logger.isEnabled()) {
                Logger.log(new LogEvent(LOGID, 1, "UpdateMonitor: user dialog already in progress, updates skipped"));
            }
        } else if (Logger.isEnabled()) {
            Logger.log(new LogEvent(LOGID, "UpdateMonitor: check instance resulted in no user-actionable updates"));
        }
    }

    public void cancelled(UpdateCheckInstance instance) {
        MainWindow mainWindow = MainWindow.getWindow();
        mainWindow.setStatusText("");
    }

    static {
        class_mon = new AEMonitor("UpdateMonitor:class");
    }
}

