/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt;

import java.util.Vector;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.DisplayFormatters;
import org.gudy.azureus2.ui.swt.ImageRepository;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.Tab;
import org.gudy.azureus2.ui.swt.components.shell.ShellFactory;
import org.gudy.azureus2.ui.swt.components.shell.ShellManager;
import org.gudy.azureus2.ui.swt.mainwindow.Colors;
import org.gudy.azureus2.ui.swt.mainwindow.MainWindow;
import org.gudy.azureus2.ui.swt.views.MyTorrentsSuperView;

public class MinimizedWindow {
    Shell splash;
    Label lDrag;
    MinimizedWindow stucked;
    private Rectangle screen;
    private static final Vector downloadBars = new Vector();
    private static final ShellManager shellManager = new ShellManager();
    private int xPressed;
    private int yPressed;
    private boolean moving;
    private int hSize;
    private Label splashFile;
    private Label splashDown;
    private Label splashUp;
    private Label splashTime;
    public ProgressBar pb1;
    public GC gc;
    private DownloadManager manager;

    public MinimizedWindow(DownloadManager _manager, Shell main) {
        this.manager = _manager;
        this.stucked = null;
        this.splash = ShellFactory.createShell(16384);
        shellManager.addWindow(this.splash);
        main.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                MinimizedWindow.this.close();
            }
        });
        this.screen = main.getDisplay().getClientArea();
        this.lDrag = new Label((Composite)this.splash, 0);
        if (!Constants.isOSX) {
            this.lDrag.setImage(ImageRepository.getImage("dragger"));
        }
        this.lDrag.pack();
        int hSizeImage = this.lDrag.getSize().y;
        int xSize = this.lDrag.getSize().x + 3;
        this.lDrag.setLocation(0, 0);
        MouseAdapter mListener = new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                MinimizedWindow.this.xPressed = e.x;
                MinimizedWindow.this.yPressed = e.y;
                MinimizedWindow.this.moving = true;
            }

            public void mouseUp(MouseEvent e) {
                MinimizedWindow.this.moving = false;
            }
        };
        MouseMoveListener mMoveListener = new MouseMoveListener(){

            public void mouseMove(MouseEvent e) {
                if (MinimizedWindow.this.moving) {
                    int dX = MinimizedWindow.this.xPressed - e.x;
                    int dY = MinimizedWindow.this.yPressed - e.y;
                    Point currentLoc = MinimizedWindow.this.splash.getLocation();
                    currentLoc.x -= dX;
                    currentLoc.y -= dY;
                    MinimizedWindow.this.setSnapLocation(currentLoc);
                }
            }
        };
        this.splash.setBackground(Colors.blues[0]);
        this.splash.setForeground(Colors.blues[9]);
        this.splash.addMouseListener((MouseListener)mListener);
        this.splash.addMouseMoveListener(mMoveListener);
        this.lDrag.addMouseListener((MouseListener)mListener);
        this.lDrag.addMouseMoveListener(mMoveListener);
        Label l1 = new Label((Composite)this.splash, 0);
        l1.setBackground(Colors.blues[0]);
        l1.setForeground(Colors.blues[9]);
        Messages.setLanguageText((Widget)l1, "MinimizedWindow.name");
        l1.addMouseListener((MouseListener)mListener);
        l1.addMouseMoveListener(mMoveListener);
        l1.pack();
        l1.setLocation(xSize, 0);
        xSize += l1.getSize().x + 3;
        int hSizeText = l1.getSize().y;
        this.hSize = hSizeText > hSizeImage ? hSizeText : hSizeImage;
        this.splashFile = new Label((Composite)this.splash, 0);
        this.splashFile.setBackground(Colors.blues[0]);
        this.splashFile.setText("");
        this.splashFile.addMouseListener((MouseListener)mListener);
        this.splashFile.addMouseMoveListener(mMoveListener);
        this.splashFile.setSize(200, this.hSize);
        this.splashFile.setLocation(xSize, 0);
        xSize += 203;
        this.pb1 = new ProgressBar((Composite)this.splash, 65536);
        this.pb1.setBackground(Colors.blues[0]);
        this.pb1.setForeground(Colors.blues[2]);
        this.pb1.setMinimum(0);
        this.pb1.setMaximum(1000);
        this.pb1.addMouseListener((MouseListener)mListener);
        this.pb1.addMouseMoveListener(mMoveListener);
        this.pb1.setSize(100, this.hSize);
        this.pb1.setLocation(xSize, 0);
        xSize += 105;
        Listener pb_listener = new Listener(){

            public void handleEvent(Event event) {
                int perc = MinimizedWindow.this.manager.getStats().getCompleted();
                Color old = event.gc.getForeground();
                event.gc.setForeground(Colors.black);
                int char_width = event.gc.getFontMetrics().getAverageCharWidth();
                String percent = DisplayFormatters.formatPercentFromThousands(perc);
                event.gc.drawText(percent, (MinimizedWindow.this.pb1.getSize().x - percent.length() * char_width) / 2, -1, true);
                event.gc.setForeground(old);
            }
        };
        this.pb1.addListener(9, pb_listener);
        Label l3 = new Label((Composite)this.splash, 0);
        l3.setBackground(Colors.blues[0]);
        l3.setForeground(Colors.blues[9]);
        l3.setText(MessageText.getString("ConfigView.download.abbreviated"));
        l3.addMouseListener((MouseListener)mListener);
        l3.addMouseMoveListener(mMoveListener);
        l3.pack();
        l3.setLocation(xSize, 0);
        xSize += l3.getSize().x + 3;
        this.splashDown = new Label((Composite)this.splash, 0);
        this.splashDown.setBackground(Colors.blues[0]);
        this.splashDown.setText("");
        this.splashDown.addMouseListener((MouseListener)mListener);
        this.splashDown.addMouseMoveListener(mMoveListener);
        this.splashDown.setSize(65, this.hSize);
        this.splashDown.setLocation(xSize, 0);
        xSize += 68;
        Label l4 = new Label((Composite)this.splash, 0);
        l4.setBackground(Colors.blues[0]);
        l4.setForeground(Colors.blues[9]);
        l4.setText(MessageText.getString("ConfigView.upload.abbreviated"));
        l4.addMouseListener((MouseListener)mListener);
        l4.addMouseMoveListener(mMoveListener);
        l4.pack();
        l4.setLocation(xSize, 0);
        xSize += l4.getSize().x + 3;
        this.splashUp = new Label((Composite)this.splash, 0);
        this.splashUp.setBackground(Colors.blues[0]);
        this.splashUp.setText("");
        this.splashUp.addMouseListener((MouseListener)mListener);
        this.splashUp.addMouseMoveListener(mMoveListener);
        this.splashUp.setSize(65, this.hSize);
        this.splashUp.setLocation(xSize, 0);
        xSize += 68;
        Label l5 = new Label((Composite)this.splash, 0);
        l5.setBackground(Colors.blues[0]);
        l5.setForeground(Colors.blues[9]);
        l5.setText(MessageText.getString("MyTorrentsView.eta") + ":");
        l5.addMouseListener((MouseListener)mListener);
        l5.addMouseMoveListener(mMoveListener);
        l5.pack();
        l5.setLocation(xSize, 0);
        xSize += l5.getSize().x + 3;
        this.splashTime = new Label((Composite)this.splash, 0);
        this.splashTime.setBackground(Colors.blues[0]);
        this.splashTime.setText("");
        this.splashTime.addMouseListener((MouseListener)mListener);
        this.splashTime.addMouseMoveListener(mMoveListener);
        this.splashTime.setSize(65, this.hSize);
        this.splashTime.setLocation(xSize, 0);
        this.splash.addListener(20, new Listener(){

            public void handleEvent(Event e) {
                MinimizedWindow.this.splash.setVisible(true);
                MinimizedWindow.this.splash.setActive();
            }
        });
        this.splash.setSize((xSize += 68) + 3, this.hSize + 2);
        Menu menu = new Menu((Decorations)this.splash, 8);
        MenuItem itemClose = new MenuItem(menu, 0);
        itemClose.setText(MessageText.getString("wizard.close"));
        itemClose.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                MinimizedWindow.this.close();
                MyTorrentsSuperView viewMyTorrents = (MyTorrentsSuperView)Tab.getView(MainWindow.getWindow().getMytorrents().getTabItem());
                if (viewMyTorrents != null) {
                    viewMyTorrents.removeDownloadBar(MinimizedWindow.this.manager);
                }
            }
        });
        this.splash.setMenu(menu);
        this.lDrag.setMenu(menu);
        l1.setMenu(menu);
        l3.setMenu(menu);
        l4.setMenu(menu);
        l5.setMenu(menu);
        this.pb1.setMenu(menu);
        this.splashDown.setMenu(menu);
        this.splashFile.setMenu(menu);
        this.splashUp.setMenu(menu);
        this.splashTime.setMenu(menu);
        downloadBars.add(this);
        this.splash.setVisible(true);
    }

    public static ShellManager getShellManager() {
        return shellManager;
    }

    private void setSnapLocation(Point currentLoc) {
        if (currentLoc.x < 10) {
            currentLoc.x = 0;
        } else if (currentLoc.x > this.screen.width - this.splash.getBounds().width - 10) {
            currentLoc.x = this.screen.width - this.splash.getBounds().width;
        }
        if (currentLoc.y < 10) {
            currentLoc.y = 0;
        }
        MinimizedWindow mw = this;
        int height = 0;
        while (mw != null) {
            Shell s = mw.getShell();
            if (s.isDisposed()) {
                mw = null;
                continue;
            }
            height += s.getBounds().height - 1;
            if ((mw = mw.getStucked()) != this) continue;
            mw = null;
        }
        if (currentLoc.y > this.screen.height - height - 10) {
            currentLoc.y = this.screen.height - height;
        }
        if (downloadBars.size() > 1) {
            for (int i = 0; i < downloadBars.size(); ++i) {
                MinimizedWindow downloadBar = (MinimizedWindow)downloadBars.get(i);
                Point location = downloadBar.getShell().getLocation();
                location.y += downloadBar.getShell().getBounds().height;
                if ((downloadBar != this && downloadBar.getStucked() == null || downloadBar.getStucked() == this) && Math.abs(location.x - currentLoc.x) < 10 && location.y - currentLoc.y < 10 && location.y - currentLoc.y > 0) {
                    downloadBar.setStucked(this);
                    currentLoc.x = location.x;
                    currentLoc.y = location.y - 1;
                }
                if (downloadBar == this || downloadBar.getStucked() != this || Math.abs(location.x - currentLoc.x) <= 10 && Math.abs(location.y - currentLoc.y) <= 10) continue;
                downloadBar.setStucked(null);
            }
        }
        this.splash.setLocation(currentLoc);
        MinimizedWindow mwCurrent = this;
        while (mwCurrent != null) {
            currentLoc.y += mwCurrent.getShell().getBounds().height - 1;
            MinimizedWindow mwChild = mwCurrent.getStucked();
            if (mwChild != null && mwChild != this) {
                Shell s = mwChild.getShell();
                if (s.isDisposed()) {
                    mwCurrent.setStucked(null);
                    mwCurrent = null;
                    continue;
                }
                mwCurrent = mwChild;
                mwCurrent.getShell().setLocation(currentLoc);
                continue;
            }
            mwCurrent = null;
        }
    }

    public void close() {
        Display display;
        if (!this.splash.isDisposed() && (display = this.splash.getDisplay()) != null && !display.isDisposed()) {
            display.asyncExec((Runnable)new AERunnable(){

                public void runSupport() {
                    if (!MinimizedWindow.this.splash.isDisposed()) {
                        MinimizedWindow.this.splash.dispose();
                    }
                }
            });
        }
        downloadBars.remove(this);
    }

    public void refresh() {
        if (this.splash.isDisposed()) {
            return;
        }
        this.splashFile.setText(this.manager.getDisplayName());
        int percent = this.manager.getStats().getCompleted();
        this.splashDown.setText(DisplayFormatters.formatByteCountToKiBEtcPerSec(this.manager.getStats().getDataReceiveRate()));
        this.splashUp.setText(DisplayFormatters.formatByteCountToKiBEtcPerSec(this.manager.getStats().getDataSendRate()));
        this.splashTime.setText(DisplayFormatters.formatETA(this.manager.getStats().getETA()));
        if (this.pb1.getSelection() != percent) {
            this.pb1.setSelection(percent);
            this.pb1.redraw();
        }
    }

    public void setVisible(boolean visible) {
        this.splash.setVisible(visible);
    }

    public Shell getShell() {
        return this.splash;
    }

    public MinimizedWindow getStucked() {
        return this.stucked;
    }

    public void setStucked(MinimizedWindow mw) {
        this.stucked = mw;
    }
}

