/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.console.commands;

import java.util.List;
import java.util.Vector;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.ui.console.ConsoleInput;
import org.gudy.azureus2.ui.console.commands.TorrentCommand;

public class TorrentStart
extends TorrentCommand {
    private boolean startNow;

    public TorrentStart() {
        super(new String[]{"start", "s"}, "Starting");
    }

    public void execute(String commandName, ConsoleInput console, List args) {
        this.startNow = false;
        Vector newargs = new Vector(args);
        if (!newargs.isEmpty() && newargs.contains("now")) {
            newargs.removeElement("now");
            this.startNow = true;
        }
        super.execute(commandName, console, args);
    }

    protected boolean performCommand(ConsoleInput ci, DownloadManager dm, List args) {
        try {
            dm.setStateWaiting();
            if (this.startNow) {
                dm.startDownloadInitialized(true);
            }
        }
        catch (Exception e) {
            e.printStackTrace(ci.out);
            return false;
        }
        return true;
    }

    public String getCommandDescriptions() {
        return "start (<torrentoptions>) [now]\ts\tStart torrent(s).";
    }

    public String getHelpExtra() {
        return "<torrentoptions> can be one of:\n<#>\t\tNumber of a torrent. You have to use 'show torrents' first. as the number is taken from there.\nall\t\tCommand is applied to all torrents\nhash <hash>\tApplied to torrent with the hash <hash> as given in the xml output or extended torrent info ('show <#>').";
    }
}

