/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.test;

import java.io.File;
import java.util.Arrays;
import java.util.Properties;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.AEThread;
import org.gudy.azureus2.core3.util.ByteFormatter;
import org.gudy.azureus2.plugins.Plugin;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.PluginListener;
import org.gudy.azureus2.plugins.PluginManager;
import org.gudy.azureus2.plugins.ddb.DistributedDatabase;
import org.gudy.azureus2.plugins.ddb.DistributedDatabaseEvent;
import org.gudy.azureus2.plugins.ddb.DistributedDatabaseKey;
import org.gudy.azureus2.plugins.ddb.DistributedDatabaseListener;
import org.gudy.azureus2.plugins.ddb.DistributedDatabaseValue;
import org.gudy.azureus2.plugins.disk.DiskManagerFileInfo;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.download.DownloadManagerListener;
import org.gudy.azureus2.plugins.torrent.TorrentAttribute;
import org.gudy.azureus2.plugins.torrent.TorrentAttributeEvent;
import org.gudy.azureus2.plugins.torrent.TorrentAttributeListener;

public class Test
implements Plugin {
    private static AESemaphore init_sem = new AESemaphore("PluginTester");
    private static AEMonitor class_mon = new AEMonitor("PluginTester");
    private static Test singleton;
    protected PluginInterface plugin_interface;
    static /* synthetic */ Class class$org$gudy$azureus2$pluginsimpl$local$test$Test;
    static /* synthetic */ Class array$B;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Test getSingleton() {
        try {
            class_mon.enter();
            if (singleton == null) {
                new AEThread("plugin initialiser"){

                    public void runSupport() {
                        PluginManager.registerPlugin(class$org$gudy$azureus2$pluginsimpl$local$test$Test == null ? (class$org$gudy$azureus2$pluginsimpl$local$test$Test = Test.class$("org.gudy.azureus2.pluginsimpl.local.test.Test")) : class$org$gudy$azureus2$pluginsimpl$local$test$Test);
                        Properties props = new Properties();
                        props.put("MULTI_INSTANCE", "true");
                        PluginManager.startAzureus(1, props);
                    }
                }.start();
                init_sem.reserve();
            }
            Test test = singleton;
            return test;
        }
        finally {
            class_mon.exit();
        }
    }

    public void initialize(PluginInterface _pi) {
        this.plugin_interface = _pi;
        singleton = this;
        init_sem.release();
        this.plugin_interface.addListener(new PluginListener(){

            public void initializationComplete() {
                AEThread t = new AEThread(this, "test"){
                    private final /* synthetic */ 2 this$1;
                    {
                        this.this$1 = this$1;
                        super(x0);
                    }

                    public void runSupport() {
                        2.access$000(this.this$1).testLinks();
                    }
                };
                t.setDaemon(true);
                t.start();
            }

            public void closedownInitiated() {
            }

            public void closedownComplete() {
            }

            static /* synthetic */ Test access$000(2 x0) {
                return x0.Test.this;
            }
        });
    }

    protected void testLinks() {
        this.plugin_interface.getDownloadManager().addListener(new DownloadManagerListener(){

            public void downloadAdded(Download download) {
                DiskManagerFileInfo[] info = download.getDiskManagerFileInfo();
                for (int i = 0; i < info.length; ++i) {
                    info[i].setLink(new File("C:\\temp"));
                }
            }

            public void downloadRemoved(Download download) {
            }
        });
    }

    protected void testDDB() {
        try {
            DistributedDatabase db = this.plugin_interface.getDistributedDatabase();
            DistributedDatabaseKey key = db.createKey(new byte[]{4, 7, 1, 2, 5, 8});
            boolean do_write = false;
            if (do_write) {
                DistributedDatabaseValue[] values = new DistributedDatabaseValue[500];
                for (int i = 0; i < values.length; ++i) {
                    byte[] val = new byte[20];
                    Arrays.fill(val, (byte)i);
                    values[i] = db.createValue(val);
                }
                db.write(new DistributedDatabaseListener(){

                    public void event(DistributedDatabaseEvent event) {
                        System.out.println("Event:" + event.getType());
                        if (event.getType() == 1) {
                            try {
                                System.out.println("    write - key = " + ByteFormatter.encodeString((byte[])event.getKey().getKey()) + ", val = " + ByteFormatter.encodeString((byte[])event.getValue().getValue(array$B == null ? (array$B = Test.class$("[B")) : array$B)));
                            }
                            catch (Throwable e) {
                                e.printStackTrace();
                            }
                        }
                    }
                }, key, values);
            } else {
                db.read(new DistributedDatabaseListener(){

                    public void event(DistributedDatabaseEvent event) {
                        System.out.println("Event:" + event.getType());
                        if (event.getType() == 2) {
                            try {
                                System.out.println("    read - key = " + ByteFormatter.encodeString((byte[])event.getKey().getKey()) + ", val = " + ByteFormatter.encodeString((byte[])event.getValue().getValue(array$B == null ? (array$B = Test.class$("[B")) : array$B)));
                            }
                            catch (Throwable e) {
                                e.printStackTrace();
                            }
                        }
                    }
                }, key, 60000L);
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    protected void taTest() {
        try {
            final TorrentAttribute ta = this.plugin_interface.getTorrentManager().getAttribute("Category");
            ta.addTorrentAttributeListener(new TorrentAttributeListener(){

                public void event(TorrentAttributeEvent ev) {
                    System.out.println("ev: " + ev.getType() + ", " + ev.getData());
                    if (ev.getType() == 1 && "plop".equals(ev.getData())) {
                        ta.removeDefinedValue("plop");
                    }
                }
            });
            ta.addDefinedValue("wibble");
            this.plugin_interface.getDownloadManager().addListener(new DownloadManagerListener(){

                public void downloadAdded(Download download) {
                    try {
                        download.setAttribute(ta, "wibble");
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                    }
                }

                public void downloadRemoved(Download download) {
                }
            });
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        Test.getSingleton();
    }
}

