/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.config.COConfigurationListener;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.plugins.PluginConfig;
import org.gudy.azureus2.plugins.PluginConfigListener;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.config.ConfigParameter;
import org.gudy.azureus2.pluginsimpl.local.config.ConfigParameterImpl;

public class PluginConfigImpl
implements PluginConfig {
    protected static Map external_to_internal_key_map = new HashMap();
    private PluginInterface plugin_interface;
    private String key;

    public PluginConfigImpl(PluginInterface _plugin_interface, String _key) {
        this.plugin_interface = _plugin_interface;
        this.key = _key + ".";
    }

    public String getPluginConfigKeyPrefix() {
        return this.key;
    }

    public String getStringParameter(String name) {
        return COConfigurationManager.getStringParameter(this.mapKeyName(name));
    }

    public String getStringParameter(String name, String _default) {
        return COConfigurationManager.getStringParameter(this.mapKeyName(name), _default);
    }

    public float getFloatParameter(String name) {
        return COConfigurationManager.getFloatParameter(this.mapKeyName(name));
    }

    public int getIntParameter(String name) {
        return COConfigurationManager.getIntParameter(this.mapKeyName(name));
    }

    public int getIntParameter(String name, int default_value) {
        return COConfigurationManager.getIntParameter(this.mapKeyName(name), default_value);
    }

    public void setIntParameter(String key, int value) {
        String target_key = (String)external_to_internal_key_map.get(key);
        if (target_key == null) {
            throw new RuntimeException("Invalid code int parameter (" + key + ")");
        }
        COConfigurationManager.setParameter(target_key, value);
    }

    public boolean getBooleanParameter(String name) {
        return COConfigurationManager.getBooleanParameter(this.mapKeyName(name));
    }

    public boolean getBooleanParameter(String name, boolean _default) {
        return COConfigurationManager.getBooleanParameter(this.mapKeyName(name), _default);
    }

    public void setBooleanParameter(String key, boolean value) {
        String target_key = (String)external_to_internal_key_map.get(key);
        if (target_key == null) {
            throw new RuntimeException("Invalid code int parameter (" + key + ")");
        }
        COConfigurationManager.setParameter(target_key, value);
    }

    public byte[] getByteParameter(String name, byte[] _default) {
        return COConfigurationManager.getByteParameter(this.mapKeyName(name), _default);
    }

    public int getPluginIntParameter(String key) {
        return this.getIntParameter(this.key + key);
    }

    public int getPluginIntParameter(String key, int defaultValue) {
        COConfigurationManager.setIntDefault(this.key + key, defaultValue);
        return COConfigurationManager.getIntParameter(this.key + key, defaultValue);
    }

    public String getPluginStringParameter(String key) {
        return this.getStringParameter(this.key + key);
    }

    public String getPluginStringParameter(String key, String defaultValue) {
        COConfigurationManager.setStringDefault(this.key + key, defaultValue);
        return COConfigurationManager.getStringParameter(this.key + key, defaultValue);
    }

    public boolean getPluginBooleanParameter(String key) {
        return this.getBooleanParameter(this.key + key);
    }

    public boolean getPluginBooleanParameter(String key, boolean defaultValue) {
        COConfigurationManager.setBooleanDefault(this.key + key, defaultValue);
        return COConfigurationManager.getBooleanParameter(this.key + key, defaultValue);
    }

    public byte[] getPluginByteParameter(String key, byte[] defaultValue) {
        COConfigurationManager.setByteDefault(this.key + key, defaultValue);
        return COConfigurationManager.getByteParameter(this.key + key, defaultValue);
    }

    public List getPluginListParameter(String key, List default_value) {
        return COConfigurationManager.getListParameter(this.key + key, default_value);
    }

    public void setPluginListParameter(String key, List value) {
        COConfigurationManager.setParameter(this.key + key, value);
    }

    public Map getPluginMapParameter(String key, Map default_value) {
        return COConfigurationManager.getMapParameter(this.key + key, default_value);
    }

    public void setPluginMapParameter(String key, Map value) {
        COConfigurationManager.setParameter(this.key + key, value);
    }

    public void setPluginParameter(String key, int value) {
        COConfigurationManager.setParameter(this.key + key, value);
    }

    public void setPluginParameter(String key, String value) {
        COConfigurationManager.setParameter(this.key + key, value);
    }

    public void setPluginParameter(String key, boolean value) {
        COConfigurationManager.setParameter(this.key + key, value);
    }

    public void setPluginParameter(String key, byte[] value) {
        COConfigurationManager.setParameter(this.key + key, value);
    }

    public ConfigParameter getParameter(String key) {
        return new ConfigParameterImpl(this.mapKeyName(key));
    }

    public ConfigParameter getPluginParameter(String key) {
        return new ConfigParameterImpl(this.key + key);
    }

    public void save() {
        COConfigurationManager.save();
    }

    protected String mapKeyName(String key) {
        String k = (String)external_to_internal_key_map.get(key);
        if (k != null) {
            return k;
        }
        return key;
    }

    public File getPluginUserFile(String name) {
        String dir = this.plugin_interface.getUtilities().getAzureusUserDir();
        File file = new File(dir, "plugins");
        String p_dir = this.plugin_interface.getPluginDirectoryName();
        if (p_dir.length() != 0) {
            int lp = p_dir.lastIndexOf(File.separatorChar);
            if (lp != -1) {
                p_dir = p_dir.substring(lp + 1);
            }
            file = new File(file, p_dir);
        } else {
            String id = this.plugin_interface.getPluginID();
            if (id.length() > 0 && !id.equals("<internal>")) {
                file = new File(file, id);
            } else {
                throw new RuntimeException("Plugin was not loaded from a directory");
            }
        }
        file.mkdirs();
        return new File(file, name);
    }

    public void addListener(final PluginConfigListener l) {
        COConfigurationManager.addListener(new COConfigurationListener(){

            public void configurationSaved() {
                l.configSaved();
            }
        });
    }

    static {
        external_to_internal_key_map.put("Max Upload Speed KBs", "Max Upload Speed KBs");
        external_to_internal_key_map.put("Max Upload Speed When Only Seeding KBs", "Max Upload Speed Seeding KBs");
        external_to_internal_key_map.put("Max Download Speed KBs", "Max Download Speed KBs");
        external_to_internal_key_map.put("Max Connections Global", "Max.Peer.Connections.Total");
        external_to_internal_key_map.put("Max Connections Per Torrent", "Max.Peer.Connections.Per.Torrent");
        external_to_internal_key_map.put("Max Downloads", "max downloads");
        external_to_internal_key_map.put("Max Active Torrents", "max active torrents");
        external_to_internal_key_map.put("Max Active Torrents When Only Seeding", "StartStopManager_iMaxActiveTorrentsWhenSeeding");
        external_to_internal_key_map.put("Max Upload Speed When Only Seeding Enabled", "enable.seedingonly.upload.rate");
        external_to_internal_key_map.put("Max Active Torrents When Only Seeding Enabled", "StartStopManager_bMaxActiveTorrentsWhenSeedingEnabled");
        external_to_internal_key_map.put("SOCKS Proxy No Inward Connection", "Proxy.Data.SOCKS.inform");
        external_to_internal_key_map.put("Newly Seeding Torrents Get First Priority", "Newly Seeding Torrents Get First Priority");
        external_to_internal_key_map.put("CORE_PARAM_STRING_LOCAL_BIND_IP", "Bind IP");
        external_to_internal_key_map.put("CORE_PARAM_BOOLEAN_FRIENDLY_HASH_CHECKING", "diskmanager.friendly.hashchecking");
    }
}

