/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.xml.util;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;

public class XMLElement {
    protected Object single_content = null;
    protected Map attributes = null;
    protected Collection contents = null;
    protected String tag_name;
    protected boolean auto_order;
    private static Comparator ATTRIBUTE_COMPARATOR = String.CASE_INSENSITIVE_ORDER;
    private static Comparator CONTENT_COMPARATOR = new ContentComparator();

    public XMLElement(String tag_name) {
        this(tag_name, false);
    }

    public XMLElement(String tag_name, boolean auto_order) {
        this.tag_name = tag_name;
        this.auto_order = auto_order;
    }

    public String getTag() {
        return this.tag_name;
    }

    public String getAttribute(String key) {
        if (this.attributes == null) {
            return null;
        }
        return (String)this.attributes.get(key);
    }

    public void addAttribute(String key, String value) {
        if (this.attributes == null) {
            this.attributes = new TreeMap(ATTRIBUTE_COMPARATOR);
        }
        this.attributes.put(key, value);
    }

    public void addAttribute(String key, int value) {
        this.addAttribute(key, String.valueOf(value));
    }

    public void addAttribute(String key, boolean value) {
        this.addAttribute(key, value ? "yes" : "no");
    }

    public void addContent(String s) {
        this.addContent((Object)s);
    }

    public void addContent(XMLElement e) {
        this.addContent((Object)e);
    }

    protected void addContent(Object o) {
        if (o == null) {
            throw new NullPointerException();
        }
        if (this.contents == null && this.single_content != null) {
            this.contents = !this.auto_order ? new ArrayList() : new TreeSet(CONTENT_COMPARATOR);
            this.contents.add(this.single_content);
            this.single_content = null;
        }
        if (this.contents == null) {
            this.single_content = o;
        } else {
            this.contents.add(o);
        }
    }

    public void printTo(PrintWriter pw) {
        this.printTo(pw, 0);
    }

    public void printTo(PrintWriter pw, int indent) {
        boolean needs_close_tag;
        if (this.attributes == null && this.contents == null && this.single_content == null) {
            pw.print("<");
            pw.print(this.tag_name);
            pw.print(" />");
            return;
        }
        for (int i = 0; i < indent; ++i) {
            pw.print(" ");
        }
        pw.print("<");
        pw.print(this.tag_name);
        Iterator<Object> itr = null;
        if (this.attributes != null) {
            itr = this.attributes.entrySet().iterator();
            while (itr.hasNext()) {
                Map.Entry entry2 = itr.next();
                pw.print(" ");
                pw.print(entry2.getKey());
                pw.print("=\"");
                pw.print(this.quote((String)entry2.getValue()));
                pw.print("\"");
            }
        }
        boolean needs_indented_close = this.contents != null || this.single_content instanceof XMLElement;
        boolean bl = needs_close_tag = needs_indented_close || this.single_content != null;
        if (needs_indented_close) {
            pw.println(">");
        } else if (needs_close_tag) {
            pw.print(">");
        } else {
            pw.print(" />");
        }
        itr = null;
        if (this.contents != null) {
            itr = this.contents.iterator();
        } else if (this.single_content != null) {
            itr = Collections.singletonList(this.single_content).iterator();
        }
        Object content_element = null;
        if (itr != null) {
            while (itr.hasNext()) {
                content_element = itr.next();
                if (content_element instanceof XMLElement) {
                    ((XMLElement)content_element).printTo(pw, indent + 2);
                    continue;
                }
                pw.print(this.quote((String)content_element));
            }
        }
        if (needs_indented_close) {
            for (int i = 0; i < indent; ++i) {
                pw.print(" ");
            }
        }
        if (needs_close_tag) {
            pw.print("</");
            pw.print(this.tag_name);
            pw.println(">");
        }
    }

    private String quote(String text) {
        text = text.replaceAll("&", "&amp;");
        text = text.replaceAll(">", "&gt;");
        text = text.replaceAll("<", "&lt;");
        text = text.replaceAll("\"", "&quot;");
        text = text.replaceAll("--", "&#45;&#45;");
        return text;
    }

    public XMLElement makeContent(String tag_name) {
        return this.makeContent(tag_name, false);
    }

    public XMLElement makeContent(String tag_name, boolean auto_order) {
        XMLElement content = new XMLElement(tag_name, auto_order);
        this.addContent(content);
        return content;
    }

    public void clear() {
        this.single_content = null;
        this.attributes = null;
        this.contents = null;
    }

    public void setAutoOrdering(boolean mode) {
        if (mode == this.auto_order) {
            return;
        }
        this.auto_order = mode;
        if (this.contents == null) {
            return;
        }
        Collection previous_contents = this.contents;
        if (this.auto_order) {
            this.contents = new TreeSet(CONTENT_COMPARATOR);
            this.contents.addAll(previous_contents);
        } else {
            this.contents = new ArrayList(previous_contents);
        }
    }

    public String toString() {
        return "XMLElement[" + this.tag_name + "]@" + Integer.toHexString(System.identityHashCode(this));
    }

    private static class ContentComparator
    implements Comparator {
        private ContentComparator() {
        }

        public int compare(Object o1, Object o2) {
            if (o1 instanceof XMLElement) {
                if (o2 instanceof XMLElement) {
                    int result = String.CASE_INSENSITIVE_ORDER.compare(((XMLElement)o1).getTag(), ((XMLElement)o2).getTag());
                    if (result == 0) {
                        throw new RuntimeException("Shouldn't be using sorting for contents if you have tags with same name! (e.g. " + o1 + ")");
                    }
                    return result;
                }
                return -1;
            }
            if (o2 instanceof XMLElement) {
                return 1;
            }
            int result = String.CASE_INSENSITIVE_ORDER.compare((String)o1, (String)o2);
            if (result == 0) {
                return -1;
            }
            return result;
        }
    }
}

