/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.util;

import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.core.instancemanager.AZInstanceManager;
import com.aelitis.azureus.core.proxy.AEProxyFactory;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URL;
import org.gudy.azureus2.core3.util.Debug;

public class AddressUtils {
    private static AZInstanceManager instance_manager;

    public static URL adjustURL(URL url) {
        url = AEProxyFactory.getAddressMapper().internalise(url);
        return url;
    }

    public static InetSocketAddress adjustDHTAddress(InetSocketAddress address, boolean ext_to_lan) {
        if (instance_manager == null) {
            try {
                instance_manager = AzureusCoreFactory.getSingleton().getInstanceManager();
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
        if (instance_manager == null || !instance_manager.isInitialized()) {
            return address;
        }
        InetSocketAddress adjusted_address = ext_to_lan ? instance_manager.getLANAddress(address, false) : instance_manager.getExternalAddress(address, false);
        if (adjusted_address == null) {
            adjusted_address = address;
        }
        return adjusted_address;
    }

    public static boolean isLANLocalAddress(InetAddress address) {
        if (instance_manager == null) {
            try {
                instance_manager = AzureusCoreFactory.getSingleton().getInstanceManager();
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
        if (instance_manager == null || !instance_manager.isInitialized()) {
            return false;
        }
        return instance_manager.isLANAddress(address);
    }

    public static boolean isLANLocalAddress(String address) {
        boolean is_lan_local = false;
        try {
            is_lan_local = AddressUtils.isLANLocalAddress(InetAddress.getByName(address));
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return is_lan_local;
    }
}

