/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.tracker.server.impl;

import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.tracker.server.TRTrackerServerException;
import org.gudy.azureus2.core3.tracker.server.TRTrackerServerPeer;
import org.gudy.azureus2.core3.tracker.server.impl.TRTrackerServerImpl;
import org.gudy.azureus2.core3.tracker.server.impl.TRTrackerServerPeerImpl;
import org.gudy.azureus2.core3.tracker.server.impl.TRTrackerServerTorrentImpl;
import org.gudy.azureus2.core3.tracker.util.TRTrackerUtils;
import org.gudy.azureus2.core3.util.AENetworkClassifier;
import org.gudy.azureus2.core3.util.ByteEncodedKeyHashMap;
import org.gudy.azureus2.core3.util.HashWrapper;
import org.gudy.azureus2.core3.util.ThreadPoolTask;

public abstract class TRTrackerServerProcessor
extends ThreadPoolTask {
    protected TRTrackerServerImpl server;

    protected TRTrackerServerTorrentImpl processTrackerRequest(TRTrackerServerImpl _server, String request2, Map[] root_out, TRTrackerServerPeerImpl[] peer_out, int request_type, byte[][] hashes, HashWrapper peer_id, boolean no_peer_id, boolean compact, String key, String event, int port, String client_ip_address, long downloaded, long uploaded, long left, int num_want) throws TRTrackerServerException {
        this.server = _server;
        client_ip_address = TRTrackerUtils.adjustHostFromHosting(client_ip_address);
        if (!TRTrackerServerImpl.getAllNetworksSupported()) {
            String network = AENetworkClassifier.categoriseAddress(client_ip_address);
            String[] permitted_networks = TRTrackerServerImpl.getPermittedNetworks();
            boolean ok = false;
            for (int i = 0; i < permitted_networks.length; ++i) {
                if (network != permitted_networks[i]) continue;
                ok = true;
                break;
            }
            if (!ok) {
                throw new TRTrackerServerException("Network '" + network + "' not supported");
            }
        }
        boolean loopback = client_ip_address.equals(TRTrackerUtils.getTrackerIP());
        TRTrackerServerTorrentImpl torrent = null;
        if (request_type != 3) {
            if (hashes == null || hashes.length == 0) {
                throw new TRTrackerServerException("Hash missing from request ");
            }
            if (request_type == 1) {
                if (hashes.length != 1) {
                    throw new TRTrackerServerException("Too many hashes for announce");
                }
                byte[] hash = hashes[0];
                torrent = this.server.getTorrent(hash);
                if (torrent == null) {
                    if (!COConfigurationManager.getBooleanParameter("Tracker Public Enable", false)) {
                        throw new TRTrackerServerException("Torrent unauthorised");
                    }
                    try {
                        torrent = (TRTrackerServerTorrentImpl)this.server.permit(hash, false);
                    }
                    catch (Throwable e) {
                        throw new TRTrackerServerException("Torrent unauthorised", e);
                    }
                }
                if (peer_id == null) {
                    throw new TRTrackerServerException("peer_id missing from request");
                }
                long interval = this.server.getAnnounceRetryInterval(torrent);
                TRTrackerServerPeerImpl peer = torrent.peerContact(event, peer_id, port, client_ip_address, loopback, key, uploaded, downloaded, left, interval);
                HashMap pre_map = new HashMap();
                this.server.preProcess(peer, torrent, request_type, request2, pre_map);
                boolean stopped = event != null && event.equalsIgnoreCase("stopped");
                root_out[0] = torrent.exportAnnounceToMap(pre_map, peer, left > 0L, stopped ? 0 : num_want, interval, this.server.getMinAnnounceRetryInterval(), no_peer_id, compact);
                peer_out[0] = peer;
            } else {
                HashMap<String, ByteEncodedKeyHashMap> root;
                boolean local_scrape = client_ip_address.equals("127.0.0.1");
                long max_interval = this.server.getMinScrapeRetryInterval();
                root_out[0] = root = new HashMap<String, ByteEncodedKeyHashMap>();
                ByteEncodedKeyHashMap files = new ByteEncodedKeyHashMap();
                root.put("files", files);
                for (int i = 0; i < hashes.length; ++i) {
                    long interval;
                    String str_hash;
                    byte[] hash = hashes[i];
                    try {
                        str_hash = new String(hash, "ISO-8859-1");
                        if (i > 0 && files.get(str_hash) != null) {
                        }
                    }
                    catch (UnsupportedEncodingException e) {}
                    continue;
                    torrent = this.server.getTorrent(hash);
                    if (torrent == null) {
                        if (!COConfigurationManager.getBooleanParameter("Tracker Public Enable", false)) continue;
                        try {
                            torrent = (TRTrackerServerTorrentImpl)this.server.permit(hash, false);
                        }
                        catch (Throwable e) {
                            continue;
                        }
                    }
                    if ((interval = this.server.getScrapeRetryInterval(torrent)) > max_interval) {
                        max_interval = interval;
                    }
                    this.server.preProcess(new lightweightPeer(client_ip_address), torrent, request_type, request2, null);
                    Map hash_entry = torrent.exportScrapeToMap(!local_scrape);
                    files.put(str_hash, hash_entry);
                }
                if (hashes.length > 1) {
                    torrent = null;
                }
                this.addScrapeInterval(max_interval, root);
            }
        } else {
            HashMap<String, ByteEncodedKeyHashMap> root;
            ByteEncodedKeyHashMap files = new ByteEncodedKeyHashMap();
            TRTrackerServerTorrentImpl[] torrents = this.server.getTorrents();
            for (int i = 0; i < torrents.length; ++i) {
                TRTrackerServerTorrentImpl this_torrent = torrents[i];
                this.server.preProcess(new lightweightPeer(client_ip_address), this_torrent, request_type, request2, null);
                byte[] torrent_hash = this_torrent.getHash().getHash();
                try {
                    String str_hash = new String(torrent_hash, "ISO-8859-1");
                    Map hash_entry = this_torrent.exportScrapeToMap(true);
                    files.put(str_hash, hash_entry);
                    continue;
                }
                catch (UnsupportedEncodingException e) {
                    throw new TRTrackerServerException("Encoding error", e);
                }
            }
            root_out[0] = root = new HashMap<String, ByteEncodedKeyHashMap>();
            this.addScrapeInterval(null, root);
            root.put("files", files);
        }
        return torrent;
    }

    protected void addScrapeInterval(TRTrackerServerTorrentImpl torrent, Map root) {
        long interval = this.server.getScrapeRetryInterval(torrent);
        this.addScrapeInterval(interval, root);
    }

    protected void addScrapeInterval(long interval, Map root) {
        if (interval > 0L) {
            HashMap<String, Long> flags = new HashMap<String, Long>();
            flags.put("min_request_interval", new Long(interval));
            root.put("flags", flags);
        }
    }

    protected static class lightweightPeer
    implements TRTrackerServerPeer {
        private String ip;

        protected lightweightPeer(String _ip) {
            this.ip = _ip;
        }

        public long getUploaded() {
            return -1L;
        }

        public long getDownloaded() {
            return -1L;
        }

        public long getAmountLeft() {
            return -1L;
        }

        public String getIP() {
            return this.ip;
        }

        public String getIPRaw() {
            return this.ip;
        }

        public byte getNATStatus() {
            return 0;
        }
    }
}

