/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.tracker.client.impl;

import java.net.URL;
import java.util.Map;
import org.gudy.azureus2.core3.tracker.client.TRTrackerAnnouncerResponse;
import org.gudy.azureus2.core3.tracker.client.TRTrackerAnnouncerResponsePeer;

public class TRTrackerAnnouncerResponseImpl
implements TRTrackerAnnouncerResponse {
    private URL url;
    private byte[] hash;
    private int status;
    private long time_to_wait;
    private String failure_reason;
    protected TRTrackerAnnouncerResponsePeer[] peers;
    protected Map extensions;

    public TRTrackerAnnouncerResponseImpl(URL _url, byte[] _hash, int _status, long _time_to_wait) {
        this.url = _url;
        this.hash = _hash;
        this.status = _status;
        this.time_to_wait = _time_to_wait;
    }

    public TRTrackerAnnouncerResponseImpl(URL _url, byte[] _hash, int _status, long _time_to_wait, String _failure_reason) {
        this.url = _url;
        this.hash = _hash;
        this.status = _status;
        this.time_to_wait = _time_to_wait;
        this.failure_reason = _failure_reason;
    }

    public TRTrackerAnnouncerResponseImpl(URL _url, byte[] _hash, int _status, long _time_to_wait, TRTrackerAnnouncerResponsePeer[] _peers) {
        this.url = _url;
        this.hash = _hash;
        this.status = _status;
        this.time_to_wait = _time_to_wait;
        this.peers = _peers;
    }

    public byte[] getHash() {
        return this.hash;
    }

    public int getStatus() {
        return this.status;
    }

    public String getStatusString() {
        String str = "";
        str = this.status == 0 ? "Offline" : (this.status == 2 ? "OK" : "Failed");
        if (this.failure_reason != null && this.failure_reason.length() > 0) {
            str = str + " - " + this.failure_reason;
        }
        return str;
    }

    public long getTimeToWait() {
        return this.time_to_wait;
    }

    public String getFailureReason() {
        return this.failure_reason;
    }

    public void setPeers(TRTrackerAnnouncerResponsePeer[] _peers) {
        this.peers = _peers;
    }

    public TRTrackerAnnouncerResponsePeer[] getPeers() {
        return this.peers;
    }

    public void setExtensions(Map _extensions) {
        this.extensions = _extensions;
    }

    public Map getExtensions() {
        return this.extensions;
    }

    public URL getURL() {
        return this.url;
    }

    public void print() {
        System.out.println("TRTrackerResponse::print");
        System.out.println("\tstatus = " + this.getStatus());
        System.out.println("\tfail msg = " + this.getFailureReason());
        System.out.println("\tpeers:");
        if (this.peers != null) {
            for (int i = 0; i < this.peers.length; ++i) {
                TRTrackerAnnouncerResponsePeer peer = this.peers[i];
                System.out.println("\t\t" + peer.getAddress() + ":" + peer.getPort());
            }
        }
    }
}

