/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.net.magneturi.impl;

import com.aelitis.net.magneturi.MagnetURIHandler;
import com.aelitis.net.magneturi.MagnetURIHandlerListener;
import com.aelitis.net.magneturi.MagnetURIHandlerProgressListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AEThread;
import org.gudy.azureus2.core3.util.Base32;
import org.gudy.azureus2.core3.util.Debug;

public class MagnetURIHandlerImpl
extends MagnetURIHandler {
    private static final LogIDs LOGID = LogIDs.NET;
    private static MagnetURIHandlerImpl singleton;
    private static AEMonitor class_mon;
    private static final int DOWNLOAD_TIMEOUT = 120000;
    protected static final String NL = "\r\n";
    private int port;
    private List listeners = new ArrayList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MagnetURIHandler getSingleton() {
        try {
            class_mon.enter();
            if (singleton == null) {
                singleton = new MagnetURIHandlerImpl();
            }
            MagnetURIHandlerImpl magnetURIHandlerImpl = singleton;
            return magnetURIHandlerImpl;
        }
        finally {
            class_mon.exit();
        }
    }

    protected MagnetURIHandlerImpl() {
        ServerSocket socket = null;
        for (int i = 45100; i <= 45199; ++i) {
            try {
                socket = new ServerSocket(i, 50, InetAddress.getByName("127.0.0.1"));
                this.port = i;
                break;
            }
            catch (Throwable e) {
                continue;
            }
        }
        if (socket == null) {
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent(LOGID, 3, "MagnetURI: no free sockets, giving up"));
            }
        } else {
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent(LOGID, "MagnetURI: bound on " + socket.getLocalPort()));
            }
            final ServerSocket f_socket = socket;
            AEThread t = new AEThread("MagnetURIHandler"){

                public void runSupport() {
                    int errors = 0;
                    int ok = 0;
                    while (true) {
                        try {
                            while (true) {
                                Socket sck = f_socket.accept();
                                ++ok;
                                errors = 0;
                                AEThread t = new AEThread(this, "MagnetURIHandler:processor", sck){
                                    private final /* synthetic */ Socket val$sck;
                                    private final /* synthetic */ 1 this$1;
                                    {
                                        this.this$1 = this$1;
                                        this.val$sck = val$sck;
                                        super(x0);
                                    }

                                    /*
                                     * WARNING - Removed try catching itself - possible behaviour change.
                                     */
                                    public void runSupport() {
                                        boolean close_socket = true;
                                        try {
                                            String address = this.val$sck.getInetAddress().getHostAddress();
                                            if (address.equals("localhost") || address.equals("127.0.0.1")) {
                                                BufferedReader br = new BufferedReader(new InputStreamReader(this.val$sck.getInputStream(), "UTF8"));
                                                String line = br.readLine();
                                                if (line != null) {
                                                    if (line.toUpperCase().startsWith("GET ")) {
                                                        if (Logger.isEnabled()) {
                                                            Logger.log(new LogEvent(MagnetURIHandlerImpl.access$000(), "MagentURIHandler: processing '" + line + "'"));
                                                        }
                                                        line = line.substring(4);
                                                        int pos = line.lastIndexOf(32);
                                                        line = line.substring(0, pos);
                                                        close_socket = 1.access$100(this.this$1).process(line, this.val$sck.getOutputStream());
                                                    } else {
                                                        Logger.log(new LogEvent(MagnetURIHandlerImpl.access$000(), 1, "MagentURIHandler: invalid command - '" + line + "'"));
                                                    }
                                                } else if (Logger.isEnabled()) {
                                                    Logger.log(new LogEvent(MagnetURIHandlerImpl.access$000(), 1, "MagentURIHandler: connect from invalid address '" + address + "'"));
                                                }
                                            }
                                        }
                                        catch (Throwable e) {
                                            if (!(e instanceof IOException) && !(e instanceof SocketException)) {
                                                Debug.printStackTrace(e);
                                            }
                                        }
                                        finally {
                                            try {
                                                if (close_socket) {
                                                    this.val$sck.close();
                                                }
                                            }
                                            catch (Throwable e) {}
                                        }
                                    }
                                };
                                t.setDaemon(true);
                                t.start();
                            }
                        }
                        catch (Throwable e) {
                            Debug.printStackTrace(e);
                            if (++errors <= 100 || !Logger.isEnabled()) continue;
                            Logger.log(new LogEvent(LOGID, "MagentURIHandler: bailing out, too many socket errors"));
                            continue;
                        }
                        break;
                    }
                }

                static /* synthetic */ MagnetURIHandlerImpl access$100(1 x0) {
                    return x0.MagnetURIHandlerImpl.this;
                }
            };
            t.setDaemon(true);
            t.start();
        }
    }

    protected boolean process(String get, OutputStream os) throws IOException {
        String urn;
        HashMap<String, String> params = new HashMap<String, String>();
        int pos = get.indexOf(63);
        if (pos != -1) {
            StringTokenizer tok = new StringTokenizer(get.substring(pos + 1), "&");
            while (tok.hasMoreTokens()) {
                String arg = tok.nextToken();
                pos = arg.indexOf(61);
                if (pos == -1) {
                    params.put(arg.trim(), "");
                    continue;
                }
                try {
                    params.put(arg.substring(0, pos).trim(), URLDecoder.decode(arg.substring(pos + 1).trim(), "UTF8"));
                }
                catch (UnsupportedEncodingException e) {
                    Debug.printStackTrace(e);
                }
            }
        }
        if (get.equals("/magnet10/badge.img")) {
            for (int i = 0; i < this.listeners.size(); ++i) {
                byte[] data = ((MagnetURIHandlerListener)this.listeners.get(i)).badge();
                if (data == null) continue;
                this.writeReply(os, "image/gif", data);
                return true;
            }
            this.writeNotFound(os);
            return true;
        }
        if (get.startsWith("/magnet10/canHandle.img?")) {
            urn = (String)params.get("xt");
            if (urn != null && urn.startsWith("urn:btih:")) {
                for (int i = 0; i < this.listeners.size(); ++i) {
                    byte[] data = ((MagnetURIHandlerListener)this.listeners.get(i)).badge();
                    if (data == null) continue;
                    this.writeReply(os, "image/gif", data);
                    return true;
                }
            }
            this.writeNotFound(os);
            return true;
        }
        if (get.startsWith("/magnet10/options.js?") || get.startsWith("/magnet10/default.js?")) {
            String resp = "";
            resp = resp + this.getJS("magnetOptionsPreamble");
            resp = resp + this.getJSS("<a href=\\\"http://127.0.0.1:\"+(45100+magnetCurrentSlot)+\"/select/?\"+magnetQueryString+\"\\\" target=\\\"_blank\\\">");
            resp = resp + this.getJSS("<img src=\\\"http://127.0.0.1:\"+(45100+magnetCurrentSlot)+\"/magnet10/badge.img\\\">");
            resp = resp + this.getJSS("Download with Azureus");
            resp = resp + this.getJSS("</a>");
            resp = resp + this.getJS("magnetOptionsPostamble");
            resp = resp + "magnetOptionsPollSuccesses++";
            this.writeReply(os, "application/x-javascript", resp);
            return true;
        }
        if (get.startsWith("/magnet10/pause")) {
            try {
                Thread.sleep(250L);
            }
            catch (Throwable e) {
                // empty catch block
            }
            this.writeNotFound(os);
            return true;
        }
        if (get.startsWith("/select/")) {
            int query = get.indexOf(63);
            boolean ok = false;
            String fail_reason = "";
            try {
                URL magnet = new URL("magnet:" + get.substring(query));
                for (int i = 0; i < this.listeners.size(); ++i) {
                    if (!((MagnetURIHandlerListener)this.listeners.get(i)).download(magnet)) continue;
                    ok = true;
                    break;
                }
                if (!ok) {
                    fail_reason = "No listeners accepted the operation";
                }
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
                fail_reason = Debug.getNestedExceptionMessage(e);
            }
            if (ok) {
                this.writeReply(os, "text/plain", "Download initiated");
            } else {
                this.writeReply(os, "text/plain", "Download initiation failed: " + fail_reason);
            }
        } else if (get.startsWith("/download/")) {
            urn = (String)params.get("xt");
            if (urn == null || !urn.startsWith("urn:sha1:") && !urn.startsWith("urn:btih:")) {
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent(LOGID, 1, "MagentURIHandler: invalid command - '" + get + "'"));
                }
                return true;
            }
            final PrintWriter pw = new PrintWriter(new OutputStreamWriter(os));
            try {
                pw.print("HTTP/1.0 200 OK\r\n");
                pw.flush();
                String base_32 = urn.substring(9);
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent(LOGID, "MagentURIHandler: download of '" + base_32 + "' starts"));
                }
                byte[] sha1 = Base32.decode(base_32);
                byte[] data = null;
                for (int i = 0; i < this.listeners.size() && (data = ((MagnetURIHandlerListener)this.listeners.get(i)).download(new MagnetURIHandlerProgressListener(){

                    public void reportSize(long size) {
                        pw.print("X-Report: torrent size: " + size + MagnetURIHandlerImpl.NL);
                        pw.flush();
                    }

                    public void reportActivity(String str) {
                        pw.print("X-Report: " + str + MagnetURIHandlerImpl.NL);
                        pw.flush();
                    }

                    public void reportCompleteness(int percent) {
                        pw.print("X-Report: completed: " + percent + "%" + MagnetURIHandlerImpl.NL);
                        pw.flush();
                    }
                }, sha1, 120000L)) == null; ++i) {
                }
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent(LOGID, "MagentURIHandler: download of '" + base_32 + "' completes, data " + (data == null ? "not found" : "found, length = " + data.length)));
                }
                if (data == null) {
                    pw.print("X-Report: no sources found for torrent\r\n");
                    pw.flush();
                    return !params.containsKey("pause_on_error");
                }
                pw.print("Content-Length: " + data.length + NL + NL);
                pw.flush();
                os.write(data);
                os.flush();
            }
            catch (Throwable e) {
                pw.print("X-Report: Error " + Debug.getNestedExceptionMessage(e) + NL);
                pw.flush();
                Debug.printStackTrace(e);
                return !params.containsKey("pause_on_error");
            }
        }
        return true;
    }

    protected String getJS(String s) {
        return "document.write(" + s + ");" + NL;
    }

    protected String getJSS(String s) {
        return "document.write(\"" + s + "\");" + NL;
    }

    protected void writeReply(OutputStream os, String content_type, String content) throws IOException {
        this.writeReply(os, content_type, content.getBytes());
    }

    protected void writeReply(OutputStream os, String content_type, byte[] content) throws IOException {
        PrintWriter pw = new PrintWriter(new OutputStreamWriter(os));
        pw.print("HTTP/1.0 200 OK\r\n");
        pw.print("Content-type: " + content_type + NL);
        pw.print("Content-length: " + content.length + NL);
        pw.print(NL);
        pw.flush();
        os.write(content);
    }

    protected void writeNotFound(OutputStream os) throws IOException {
        PrintWriter pw = new PrintWriter(new OutputStreamWriter(os));
        pw.print("HTTP/1.0 404 Not Found\r\n\r\n");
        pw.flush();
    }

    public int getPort() {
        return this.port;
    }

    public void addListener(MagnetURIHandlerListener l) {
        this.listeners.add(l);
    }

    public void removeListener(MagnetURIHandlerListener l) {
        this.listeners.remove(l);
    }

    public static void main(String[] args) {
        new MagnetURIHandlerImpl();
        try {
            Thread.sleep(1000000L);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    static {
        class_mon = new AEMonitor("MagnetURLHandler:class");
    }
}

