/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.plugins.jpc.validation.impl;

import com.aelitis.azureus.plugins.jpc.JPCException;
import com.aelitis.azureus.plugins.jpc.JPCPlugin;
import com.aelitis.azureus.plugins.jpc.license.JPCLicense;
import com.aelitis.azureus.plugins.jpc.license.JPCLicenseEntry;
import com.aelitis.azureus.plugins.jpc.validation.JPCValidator;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class JPCValidatorImpl
implements JPCValidator {
    private JPCPlugin plugin;

    public JPCValidatorImpl(JPCPlugin _plugin) {
        this.plugin = _plugin;
    }

    public void validate(InetSocketAddress cache_address, InetAddress public_ip_address, JPCLicense license) throws JPCException {
        Date check_date;
        JPCLicenseEntry[] entries = license.getEntries();
        boolean bt_enabled = false;
        boolean cache_ip_ok = false;
        boolean client_ip_ok = false;
        Date expire_date = null;
        Date bt_expire_date = null;
        long public_address_long = JPCValidatorImpl.addressToLong(public_ip_address);
        this.plugin.log("Validating license:", 2);
        for (int i = 0; i < entries.length; ++i) {
            String name = entries[i].getName().toLowerCase();
            String value = entries[i].getValue();
            this.plugin.log("   " + name + "=" + value, 2);
            try {
                if (name.equals("cacheip")) {
                    if (cache_ip_ok) continue;
                    cache_ip_ok = cache_address.getAddress().getHostAddress().equals(value);
                    continue;
                }
                if (name.equals("clientiprange")) {
                    if (client_ip_ok) continue;
                    int pos = value.indexOf("-");
                    if (pos == -1) {
                        client_ip_ok = public_address_long == this.addressToLong(value);
                        continue;
                    }
                    String range_start = value.substring(0, pos).trim();
                    String range_end = value.substring(pos + 1).trim();
                    client_ip_ok = public_address_long >= this.addressToLong(range_start) && public_address_long <= this.addressToLong(range_end);
                    continue;
                }
                if (name.equals("expiredate")) {
                    expire_date = new SimpleDateFormat("yyyyMMdd").parse(value);
                    continue;
                }
                if (name.equals("btexpiredate")) {
                    bt_expire_date = new SimpleDateFormat("yyyyMMdd").parse(value);
                    continue;
                }
                if (!name.equals("enablebt")) continue;
                bt_enabled = value.equals("1");
                continue;
            }
            catch (Throwable e) {
                // empty catch block
            }
        }
        this.plugin.log("Validator:bt_enabled = " + bt_enabled + ", bt_exp = " + bt_expire_date + ", exp = " + expire_date + ", cache_ip_ok = " + cache_ip_ok, 2);
        if (!bt_enabled) {
            throw new JPCException("BT is not enabled for the cache");
        }
        if (!cache_ip_ok) {
            throw new JPCException("Actual cache IP and that in license file differ");
        }
        Date date = check_date = bt_expire_date != null ? bt_expire_date : expire_date;
        if (check_date == null) {
            throw new JPCException("Expiry date not found in license file");
        }
        if (new Date(System.currentTimeMillis() + 86400000L).compareTo(check_date) > 0) {
            throw new JPCException("Cache license has expired");
        }
        if (!client_ip_ok) {
            throw new JPCException("Cache does not support this IP (" + public_ip_address + ")");
        }
    }

    private long addressToLong(String address) throws UnknownHostException {
        return JPCValidatorImpl.addressToLong(InetAddress.getByName(address));
    }

    private static long addressToLong(InetAddress i_address) {
        byte[] bytes = i_address.getAddress();
        long resp = bytes[0] << 24 & 0xFF000000 | bytes[1] << 16 & 0xFF0000 | bytes[2] << 8 & 0xFF00 | bytes[3] & 0xFF;
        if (resp < 0L) {
            resp += 0x100000000L;
        }
        return resp;
    }
}

