/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.plugins.jpc.peer.impl.messaging;

import com.aelitis.azureus.plugins.jpc.peer.impl.messaging.JPCPeerMessage;
import java.nio.ByteBuffer;
import org.gudy.azureus2.plugins.messaging.Message;
import org.gudy.azureus2.plugins.messaging.MessageException;

public class JPCCacheHello
implements JPCPeerMessage {
    private final String description;
    private final ByteBuffer buffer;
    private final String address;
    private final int port;
    private final int session_id;

    public JPCCacheHello(String address, int port, int session_id) {
        this.address = address;
        this.port = port;
        this.session_id = session_id;
        this.description = this.getID() + " for server at " + address + ":" + port + " using session id# " + session_id;
        byte[] raw_address = address.getBytes();
        this.buffer = ByteBuffer.allocate(12 + raw_address.length);
        this.buffer.putInt(raw_address.length);
        this.buffer.put(raw_address);
        this.buffer.putInt(port);
        this.buffer.putInt(session_id);
        this.buffer.flip();
    }

    public String getAddress() {
        return this.address;
    }

    public int getPort() {
        return this.port;
    }

    public int getSessionID() {
        return this.session_id;
    }

    public String getID() {
        return "JPC_CACHE_HELLO";
    }

    public byte getVersion() {
        return 1;
    }

    public int getType() {
        return 0;
    }

    public String getDescription() {
        return this.description;
    }

    public ByteBuffer[] getPayload() {
        return new ByteBuffer[]{this.buffer};
    }

    public void destroy() {
    }

    public Message create(ByteBuffer data) throws MessageException {
        if (data == null) {
            throw new MessageException("[" + this.getID() + ":" + this.getVersion() + "] decode error: data == null");
        }
        if (data.remaining() < 13) {
            throw new MessageException("[" + this.getID() + ":" + this.getVersion() + "] decode error: payload.remaining[" + data.remaining() + "] < 13");
        }
        int size = data.getInt();
        byte[] raw_address = new byte[size];
        data.get(raw_address);
        int prt = data.getInt();
        int id = data.getInt();
        return new JPCCacheHello(new String(raw_address), prt, id);
    }
}

