/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.plugins.jpc.discovery.impl;

import com.aelitis.azureus.plugins.jpc.JPCException;
import com.aelitis.azureus.plugins.jpc.JPCPlugin;
import com.aelitis.azureus.plugins.jpc.discovery.JPCDiscovery;
import com.aelitis.azureus.plugins.jpc.discovery.JPCDiscoveryAdapter;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.StringTokenizer;
import org.gudy.azureus2.plugins.PluginConfig;
import org.gudy.azureus2.plugins.utils.UTTimer;
import org.gudy.azureus2.plugins.utils.UTTimerEvent;
import org.gudy.azureus2.plugins.utils.UTTimerEventPerformer;

public class JPCDiscoveryImpl
implements JPCDiscovery {
    private JPCDiscoveryAdapter adapter;
    private InetAddress public_address;
    private InetSocketAddress cache_address;
    private InetSocketAddress informed_cache_address;
    private JPCPlugin jpcPlugin;
    private UTTimer timer;
    private static final String TEST_ADDRESS = "dev2.skype.net";
    private static final int CACHE_PORT = 1215;
    private static final int DISCOVERY_REFRESH_TIME = 172800;

    public JPCDiscoveryImpl(JPCPlugin _jpcPlugin, JPCDiscoveryAdapter _adapter) throws JPCException {
        this.adapter = _adapter;
        this.jpcPlugin = _jpcPlugin;
        this.public_address = this.jpcPlugin.getPluginInterface().getUtilities().getPublicAddress();
        this.jpcPlugin.log("Public Address : " + this.public_address, 2);
        if (this.public_address == null) {
            throw new JPCException("Can't determine the public address of the computer");
        }
        this.discoverCache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void discoverCache() {
        InetAddress discovery_address = null;
        boolean newly_discovered = true;
        try {
            PluginConfig config = this.jpcPlugin.getPluginInterface().getPluginconfig();
            int lastDiscoveryTime = config.getPluginIntParameter("lastJPCDiscoveryTime", 0);
            String lastDiscoveryAddress = config.getPluginStringParameter("lastJPCDiscoveryAddress", "");
            int currentTime = (int)(System.currentTimeMillis() / 1000L);
            this.jpcPlugin.log("Loaded from config : last update : " + lastDiscoveryTime + " , lastAddress : " + lastDiscoveryAddress + " (current time : " + currentTime + " )", 2);
            if (lastDiscoveryAddress != null && !lastDiscoveryAddress.equals("") && currentTime - lastDiscoveryTime < 172800) {
                try {
                    this.jpcPlugin.log("Using saved address for the cache", 2);
                    discovery_address = InetAddress.getByName(lastDiscoveryAddress);
                    newly_discovered = false;
                }
                catch (UnknownHostException e) {
                    this.jpcPlugin.log("Unknown Host :" + discovery_address, 2);
                }
            }
            if (discovery_address == null) {
                try {
                    discovery_address = InetAddress.getByName("btcache.p2p");
                }
                catch (UnknownHostException e) {
                    this.jpcPlugin.log("Unknown Host : btcache.p2p", 2);
                }
            }
            if (discovery_address == null) {
                String public_name = this.jpcPlugin.getPluginInterface().getUtilities().reverseDNSLookup(this.public_address);
                if (public_name == null) {
                    this.jpcPlugin.log("Can't perform reverse-dns lookup of '" + this.public_address + "'", 1);
                } else {
                    this.jpcPlugin.log("Public Name : " + public_name, 2);
                    StringTokenizer st = new StringTokenizer(public_name, ".");
                    int nbSubDomains = st.countTokens();
                    String[] subDomains = new String[nbSubDomains];
                    int i = 0;
                    while (st.hasMoreElements()) {
                        subDomains[i++] = st.nextToken();
                    }
                    for (i = 0; i < nbSubDomains - 1 && discovery_address == null; ++i) {
                        String host = this.constructDiscoveryAddress(i, subDomains);
                        try {
                            this.jpcPlugin.log("Looking for : " + this.constructDiscoveryAddress(i, subDomains), 2);
                            discovery_address = InetAddress.getByName(host);
                            continue;
                        }
                        catch (UnknownHostException e) {
                            this.jpcPlugin.log("Unknown Host : " + host, 2);
                        }
                    }
                }
            }
            if (discovery_address == null) {
                // empty if block
            }
            this.setCacheAddress(discovery_address, newly_discovered);
        }
        catch (Throwable throwable) {
            this.setCacheAddress(discovery_address, newly_discovered);
            throw throwable;
        }
    }

    private String constructDiscoveryAddress(int start, String[] subDomains) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("btcache.p2p");
        for (int i = start; i < subDomains.length; ++i) {
            buffer.append(".");
            buffer.append(subDomains[i]);
        }
        return buffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setCacheAddress(InetAddress address, boolean persist) {
        try {
            if (address != null) {
                this.jpcPlugin.log("Cache Found at address : " + address.getHostName(), 1);
                this.cache_address = new InetSocketAddress(address, 1215);
                if (persist) {
                    this.jpcPlugin.log("Persisting cache information.", 2);
                    int currentTime = (int)(System.currentTimeMillis() / 1000L);
                    PluginConfig config = this.jpcPlugin.getPluginInterface().getPluginconfig();
                    config.setPluginParameter("lastJPCDiscoveryTime", currentTime);
                    config.setPluginParameter("lastJPCDiscoveryAddress", address.getHostName());
                    try {
                        config.save();
                    }
                    catch (Exception e) {
                        this.jpcPlugin.log("Error while saving cache information : " + e.getMessage(), 2);
                    }
                }
            } else {
                this.jpcPlugin.log("Cache Not Found", 1);
                this.cache_address = null;
            }
            if (this.timer == null) {
                int currentTime;
                this.timer = this.jpcPlugin.getPluginInterface().getUtilities().createTimer("JPC Discovery Refresh");
                PluginConfig config = this.jpcPlugin.getPluginInterface().getPluginconfig();
                int lastCheck = config.getPluginIntParameter("lastJPCDiscoveryTime", currentTime = (int)(System.currentTimeMillis() / 1000L));
                long waitTime = (lastCheck - currentTime + 172800) * 1000;
                if (waitTime < 0L) {
                    waitTime = 172800000L;
                }
                this.jpcPlugin.log("Adding a refresh timer on " + this.jpcPlugin.getPluginInterface().getUtilities().getFormatters().formatDate(waitTime + (long)currentTime * 1000L) + " (" + waitTime / 1000L + "s).", 2);
                this.timer.addPeriodicEvent(waitTime, new UTTimerEventPerformer(){

                    public void perform(UTTimerEvent event) {
                        JPCDiscoveryImpl.this.timer.destroy();
                        JPCDiscoveryImpl.this.timer = null;
                        JPCDiscoveryImpl.this.discoverCache();
                    }
                });
            }
            Object var9_10 = null;
            if (this.informed_cache_address == null || this.cache_address != null && !this.informed_cache_address.equals(this.cache_address)) {
                this.jpcPlugin.log("Informing adapter of cache address", 2);
                this.informed_cache_address = this.cache_address;
                this.adapter.cacheDiscovered(this, false);
            } else {
                this.adapter.cacheDiscovered(this, true);
                this.jpcPlugin.log("Informing adapter that cache address hasn't changed", 2);
            }
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            if (this.informed_cache_address == null || this.cache_address != null && !this.informed_cache_address.equals(this.cache_address)) {
                this.jpcPlugin.log("Informing adapter of cache address", 2);
                this.informed_cache_address = this.cache_address;
                this.adapter.cacheDiscovered(this, false);
            } else {
                this.adapter.cacheDiscovered(this, true);
                this.jpcPlugin.log("Informing adapter that cache address hasn't changed", 2);
            }
            throw throwable;
        }
    }

    public InetAddress getPublicAddress() {
        return this.public_address;
    }

    public InetSocketAddress getCacheAddress() {
        return this.cache_address;
    }
}

