/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.plugins.jpc.cache.impl.messaging;

import com.aelitis.azureus.plugins.jpc.cache.impl.messaging.JPCCacheMessage;
import java.nio.ByteBuffer;
import org.gudy.azureus2.plugins.messaging.Message;
import org.gudy.azureus2.plugins.messaging.MessageException;

public class JPCHelloDown
implements JPCCacheMessage {
    private final String description;
    private final ByteBuffer buffer;

    public JPCHelloDown(String client_id) {
        this.description = this.getID() + " from " + client_id;
        this.buffer = ByteBuffer.wrap(client_id.getBytes());
    }

    public String getID() {
        return "JPC_HELLO_DOWN";
    }

    public byte getVersion() {
        return 1;
    }

    public int getType() {
        return 0;
    }

    public String getDescription() {
        return this.description;
    }

    public ByteBuffer[] getPayload() {
        return new ByteBuffer[]{this.buffer};
    }

    public void destroy() {
    }

    public Message create(ByteBuffer data) throws MessageException {
        if (data == null) {
            throw new MessageException("[" + this.getID() + ":" + this.getVersion() + "] decode error: data == null");
        }
        if (data.remaining() < 1) {
            throw new MessageException("[" + this.getID() + ":" + this.getVersion() + "] decode error: payload.remaining[" + data.remaining() + "] < 1");
        }
        byte[] client = new byte[data.remaining()];
        data.get(client);
        return new JPCHelloDown(new String(client));
    }
}

