/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.networkmanager.impl;

import com.aelitis.azureus.core.networkmanager.impl.TCPProtocolDecoder;
import com.aelitis.azureus.core.networkmanager.impl.TCPProtocolDecoderAdapter;
import com.aelitis.azureus.core.networkmanager.impl.TCPProtocolDecoderInitial;
import com.aelitis.azureus.core.networkmanager.impl.TCPTransportHelperFilter;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;

public class TransportCryptoManager {
    private static final TransportCryptoManager instance = new TransportCryptoManager();

    public static TransportCryptoManager getSingleton() {
        return instance;
    }

    public void manageCrypto(SocketChannel channel, byte[] shared_secret, boolean is_incoming, final HandshakeListener listener) {
        try {
            new TCPProtocolDecoderInitial(channel, shared_secret, !is_incoming, new TCPProtocolDecoderAdapter(){

                public int getMaximumPlainHeaderLength() {
                    return listener.getMaximumPlainHeaderLength();
                }

                public int matchPlainHeader(ByteBuffer buffer) {
                    return listener.matchPlainHeader(buffer);
                }

                public void decodeComplete(TCPProtocolDecoder decoder) {
                    listener.handshakeSuccess(decoder.getFilter());
                }

                public void decodeFailed(TCPProtocolDecoder decoder, Throwable cause) {
                    listener.handshakeFailure(cause);
                }
            });
        }
        catch (Throwable e) {
            listener.handshakeFailure(e);
        }
    }

    public static interface HandshakeListener {
        public static final int MATCH_NONE = 1;
        public static final int MATCH_CRYPTO_NO_AUTO_FALLBACK = 2;
        public static final int MATCH_CRYPTO_AUTO_FALLBACK = 3;

        public void handshakeSuccess(TCPTransportHelperFilter var1);

        public void handshakeFailure(Throwable var1);

        public int getMaximumPlainHeaderLength();

        public int matchPlainHeader(ByteBuffer var1);
    }
}

