/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.networkmanager.impl;

import com.aelitis.azureus.core.networkmanager.IncomingMessageQueue;
import com.aelitis.azureus.core.networkmanager.LimitedRateGroup;
import com.aelitis.azureus.core.networkmanager.NetworkConnection;
import com.aelitis.azureus.core.networkmanager.NetworkManager;
import com.aelitis.azureus.core.networkmanager.OutgoingMessageQueue;
import com.aelitis.azureus.core.networkmanager.TCPTransport;
import com.aelitis.azureus.core.networkmanager.TransportFactory;
import com.aelitis.azureus.core.networkmanager.impl.TCPTransportHelperFilter;
import com.aelitis.azureus.core.peermanager.messaging.MessageStreamDecoder;
import com.aelitis.azureus.core.peermanager.messaging.MessageStreamEncoder;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import org.gudy.azureus2.core3.util.AddressUtils;
import org.gudy.azureus2.core3.util.Debug;

public class NetworkConnectionImpl
implements NetworkConnection {
    private final InetSocketAddress remote_address;
    private final TCPTransport tcp_transport;
    private NetworkConnection.ConnectionListener connection_listener;
    private boolean is_connected;
    private final OutgoingMessageQueue outgoing_message_queue;
    private final IncomingMessageQueue incoming_message_queue;

    public NetworkConnectionImpl(InetSocketAddress _remote_address, MessageStreamEncoder encoder, MessageStreamDecoder decoder, boolean connect_with_crypto, boolean allow_fallback, byte[] shared_secret) {
        this.remote_address = _remote_address;
        this.tcp_transport = TransportFactory.createTCPTransport(connect_with_crypto, allow_fallback, shared_secret);
        this.is_connected = false;
        this.outgoing_message_queue = new OutgoingMessageQueue(encoder, this.tcp_transport);
        this.incoming_message_queue = new IncomingMessageQueue(decoder, this);
    }

    public NetworkConnectionImpl(TCPTransportHelperFilter filter, ByteBuffer data_already_read, MessageStreamEncoder encoder, MessageStreamDecoder decoder) {
        this.remote_address = new InetSocketAddress(filter.getSocketChannel().socket().getInetAddress(), filter.getSocketChannel().socket().getPort());
        this.tcp_transport = TransportFactory.createTCPTransport(filter, data_already_read);
        this.is_connected = true;
        this.outgoing_message_queue = new OutgoingMessageQueue(encoder, this.tcp_transport);
        this.incoming_message_queue = new IncomingMessageQueue(decoder, this);
    }

    public void connect(NetworkConnection.ConnectionListener listener) {
        this.connection_listener = listener;
        if (this.is_connected) {
            this.connection_listener.connectStarted();
            this.connection_listener.connectSuccess();
            return;
        }
        this.tcp_transport.establishOutboundConnection(this.remote_address, new TCPTransport.ConnectListener(){

            public void connectAttemptStarted() {
                NetworkConnectionImpl.this.connection_listener.connectStarted();
            }

            public void connectSuccess() {
                NetworkConnectionImpl.this.is_connected = true;
                NetworkConnectionImpl.this.connection_listener.connectSuccess();
            }

            public void connectFailure(Throwable failure_msg) {
                NetworkConnectionImpl.this.is_connected = false;
                NetworkConnectionImpl.this.connection_listener.connectFailure(failure_msg);
            }
        });
    }

    public void close() {
        NetworkManager.getSingleton().stopTransferProcessing(this);
        this.tcp_transport.close();
        this.incoming_message_queue.destroy();
        this.outgoing_message_queue.destroy();
        this.is_connected = false;
    }

    public void notifyOfException(Throwable error) {
        if (this.connection_listener != null) {
            this.connection_listener.exceptionThrown(error);
        } else {
            Debug.out("notifyOfException():: connection_listener == null for exception: " + error.getMessage());
        }
    }

    public OutgoingMessageQueue getOutgoingMessageQueue() {
        return this.outgoing_message_queue;
    }

    public IncomingMessageQueue getIncomingMessageQueue() {
        return this.incoming_message_queue;
    }

    public void startMessageProcessing(LimitedRateGroup upload_group, LimitedRateGroup download_group) {
        NetworkManager.getSingleton().startTransferProcessing(this, upload_group, download_group);
    }

    public void enableEnhancedMessageProcessing(boolean enable) {
        if (enable) {
            NetworkManager.getSingleton().upgradeTransferProcessing(this);
        } else {
            NetworkManager.getSingleton().downgradeTransferProcessing(this);
        }
    }

    public TCPTransport getTCPTransport() {
        return this.tcp_transport;
    }

    public InetSocketAddress getAddress() {
        return this.remote_address;
    }

    public String toString() {
        return this.tcp_transport.getDescription();
    }

    public boolean isConnected() {
        return this.is_connected;
    }

    public boolean isLANLocal() {
        return AddressUtils.isLANLocalAddress(this.remote_address.getAddress());
    }
}

