/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.networkmanager.impl;

import com.aelitis.azureus.core.networkmanager.NetworkManager;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SystemTime;

public class ByteBucket {
    private int rate;
    private int burst_rate;
    private long avail_bytes;
    private long prev_update_time;

    public ByteBucket(int rate_bytes_per_sec) {
        this(rate_bytes_per_sec, rate_bytes_per_sec + rate_bytes_per_sec / 5);
    }

    public ByteBucket(int rate_bytes_per_sec, int burst_rate) {
        this.rate = rate_bytes_per_sec;
        this.burst_rate = burst_rate;
        this.avail_bytes = 0L;
        this.prev_update_time = SystemTime.getCurrentTime();
        this.ensureByteBucketMinBurstRate();
    }

    public int getAvailableByteCount() {
        this.update_avail_byte_count();
        return (int)this.avail_bytes;
    }

    public void setBytesUsed(int bytes_used) {
        this.avail_bytes -= (long)bytes_used;
        if (this.avail_bytes < 0L) {
            Debug.out("avail_bytes < 0: " + this.avail_bytes);
        }
    }

    public int getRate() {
        return this.rate;
    }

    public int getBurstRate() {
        return this.burst_rate;
    }

    public void setRate(int rate_bytes_per_sec) {
        this.setRate(rate_bytes_per_sec, rate_bytes_per_sec + rate_bytes_per_sec / 5);
    }

    public void setRate(int rate_bytes_per_sec, int burst_rate) {
        if (rate_bytes_per_sec < 0) {
            Debug.out("rate_bytes_per_sec [" + rate_bytes_per_sec + "] < 0");
            rate_bytes_per_sec = 0;
        }
        if (burst_rate < rate_bytes_per_sec) {
            Debug.out("burst_rate [" + burst_rate + "] < rate_bytes_per_sec [" + rate_bytes_per_sec + "]");
            burst_rate = rate_bytes_per_sec;
        }
        this.rate = rate_bytes_per_sec;
        this.burst_rate = burst_rate;
        this.ensureByteBucketMinBurstRate();
    }

    private void update_avail_byte_count() {
        long current_time = SystemTime.getCurrentTime();
        long time_diff = current_time - this.prev_update_time;
        if (time_diff > 0L) {
            long num_new_bytes = time_diff * (long)this.rate / 1000L;
            this.prev_update_time = current_time;
            this.avail_bytes += num_new_bytes;
            if (this.avail_bytes < 0L) {
                Debug.out("ERROR: avail_bytes < 0: " + this.avail_bytes);
            }
            if (this.avail_bytes > (long)this.burst_rate) {
                this.avail_bytes = this.burst_rate;
            }
        } else if (time_diff < 0L) {
            this.prev_update_time = current_time;
            this.avail_bytes = this.burst_rate;
        }
    }

    private void ensureByteBucketMinBurstRate() {
        int mss = NetworkManager.getTcpMssSize();
        if (this.burst_rate < mss) {
            this.burst_rate = mss;
        }
    }
}

