/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.dht.transport.udp.impl;

import com.aelitis.azureus.core.dht.transport.DHTTransportContact;
import com.aelitis.azureus.core.dht.transport.DHTTransportException;
import com.aelitis.azureus.core.dht.transport.DHTTransportFullStats;
import com.aelitis.azureus.core.dht.transport.DHTTransportValue;
import com.aelitis.azureus.core.dht.transport.udp.impl.DHTTransportUDPContactImpl;
import com.aelitis.azureus.core.dht.transport.udp.impl.DHTTransportUDPImpl;
import com.aelitis.azureus.core.dht.transport.udp.impl.DHTUDPPacket;
import com.aelitis.azureus.core.dht.transport.udp.impl.DHTUDPPacketReply;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SHA1Simple;

public class DHTUDPUtils {
    protected static final int CT_UDP = 1;
    private static ThreadLocal tls = new ThreadLocal(){

        public Object initialValue() {
            return new SHA1Simple();
        }
    };
    public static final int INETSOCKETADDRESS_IPV4_SIZE = 7;
    public static final int INETSOCKETADDRESS_IPV6_SIZE = 19;
    public static final int DHTTRANSPORTCONTACT_SIZE = 9;
    public static final int DHTTRANSPORTVALUE_SIZE_WITHOUT_VALUE = 24;

    protected static byte[] getNodeID(InetSocketAddress address) throws DHTTransportException {
        InetAddress ia = address.getAddress();
        if (ia == null) {
            throw new DHTTransportException("Address '" + address + "' is unresolved");
        }
        SHA1Simple hasher = (SHA1Simple)tls.get();
        byte[] res = hasher.calculateHash((ia.getHostAddress() + ":" + address.getPort()).getBytes());
        return res;
    }

    protected static void serialiseLength(DataOutputStream os, int len, int max_length) throws IOException {
        if (len > max_length) {
            throw new IOException("Invalid data length");
        }
        if (max_length < 256) {
            os.writeByte(len);
        } else if (max_length < 65536) {
            os.writeShort(len);
        } else {
            os.writeInt(len);
        }
    }

    protected static int deserialiseLength(DataInputStream is, int max_length) throws IOException {
        int len = max_length < 256 ? is.readByte() & 0xFF : (max_length < 65536 ? is.readShort() & 0xFFFF : is.readInt());
        if (len > max_length) {
            throw new IOException("Invalid data length");
        }
        return len;
    }

    protected static byte[] deserialiseByteArray(DataInputStream is, int max_length) throws IOException {
        int len = DHTUDPUtils.deserialiseLength(is, max_length);
        byte[] data = new byte[len];
        is.read(data);
        return data;
    }

    protected static void serialiseByteArray(DataOutputStream os, byte[] data, int max_length) throws IOException {
        DHTUDPUtils.serialiseByteArray(os, data, 0, data.length, max_length);
    }

    protected static void serialiseByteArray(DataOutputStream os, byte[] data, int start, int length, int max_length) throws IOException {
        DHTUDPUtils.serialiseLength(os, length, max_length);
        os.write(data, start, length);
    }

    protected static void serialiseByteArrayArray(DataOutputStream os, byte[][] data, int max_length) throws IOException {
        DHTUDPUtils.serialiseLength(os, data.length, max_length);
        for (int i = 0; i < data.length; ++i) {
            DHTUDPUtils.serialiseByteArray(os, data[i], max_length);
        }
    }

    protected static byte[][] deserialiseByteArrayArray(DataInputStream is, int max_length) throws IOException {
        int len = DHTUDPUtils.deserialiseLength(is, max_length);
        byte[][] data = new byte[len][];
        for (int i = 0; i < data.length; ++i) {
            data[i] = DHTUDPUtils.deserialiseByteArray(is, max_length);
        }
        return data;
    }

    protected static void serialiseAddress(DataOutputStream os, InetSocketAddress address) throws IOException, DHTTransportException {
        InetAddress ia = address.getAddress();
        if (ia == null) {
            Debug.out("Address '" + address + "' is unresolved");
            throw new DHTTransportException("Address '" + address + "' is unresolved");
        }
        DHTUDPUtils.serialiseByteArray(os, ia.getAddress(), 16);
        os.writeShort(address.getPort());
    }

    protected static InetSocketAddress deserialiseAddress(DataInputStream is) throws IOException {
        byte[] bytes = DHTUDPUtils.deserialiseByteArray(is, 16);
        int port = is.readShort() & 0xFFFF;
        return new InetSocketAddress(InetAddress.getByAddress(bytes), port);
    }

    protected static DHTTransportValue[][] deserialiseTransportValuesArray(DHTUDPPacket packet, DataInputStream is, long skew, int max_length) throws IOException {
        int len = DHTUDPUtils.deserialiseLength(is, max_length);
        DHTTransportValue[][] data = new DHTTransportValue[len][];
        for (int i = 0; i < data.length; ++i) {
            data[i] = DHTUDPUtils.deserialiseTransportValues(packet, is, skew);
        }
        return data;
    }

    protected static void serialiseTransportValuesArray(DHTUDPPacket packet, DataOutputStream os, DHTTransportValue[][] values, long skew, int max_length) throws IOException, DHTTransportException {
        DHTUDPUtils.serialiseLength(os, values.length, max_length);
        for (int i = 0; i < values.length; ++i) {
            DHTUDPUtils.serialiseTransportValues(packet, os, values[i], skew);
        }
    }

    protected static void serialiseContact(DataOutputStream os, DHTTransportContact contact) throws IOException, DHTTransportException {
        if (!(contact instanceof DHTTransportUDPContactImpl)) {
            throw new IOException("Unsupported contact type:" + contact.getClass().getName());
        }
        os.writeByte(1);
        os.writeByte(contact.getProtocolVersion());
        DHTTransportUDPContactImpl c = (DHTTransportUDPContactImpl)contact;
        DHTUDPUtils.serialiseAddress(os, c.getExternalAddress());
    }

    protected static DHTTransportUDPContactImpl deserialiseContact(DHTTransportUDPImpl transport, DataInputStream is) throws IOException, DHTTransportException {
        byte ct = is.readByte();
        if (ct != 1) {
            throw new IOException("Unsupported contact type:" + ct);
        }
        byte version = is.readByte();
        InetSocketAddress external_address = DHTUDPUtils.deserialiseAddress(is);
        return new DHTTransportUDPContactImpl(transport, external_address, external_address, version, 0, 0L);
    }

    protected static DHTTransportValue[] deserialiseTransportValues(DHTUDPPacket packet, DataInputStream is, long skew) throws IOException {
        int len = DHTUDPUtils.deserialiseLength(is, 65535);
        ArrayList<DHTTransportValue> l = new ArrayList<DHTTransportValue>(len);
        for (int i = 0; i < len; ++i) {
            try {
                l.add(DHTUDPUtils.deserialiseTransportValue(packet, is, skew));
                continue;
            }
            catch (DHTTransportException e) {
                Debug.printStackTrace(e);
            }
        }
        DHTTransportValue[] res = new DHTTransportValue[l.size()];
        l.toArray(res);
        return res;
    }

    protected static void serialiseTransportValues(DHTUDPPacket packet, DataOutputStream os, DHTTransportValue[] values, long skew) throws IOException, DHTTransportException {
        DHTUDPUtils.serialiseLength(os, values.length, 65535);
        for (int i = 0; i < values.length; ++i) {
            DHTUDPUtils.serialiseTransportValue(packet, os, values[i], skew);
        }
    }

    protected static DHTTransportValue deserialiseTransportValue(DHTUDPPacket packet, DataInputStream is, long skew) throws IOException, DHTTransportException {
        int version;
        if (packet.getProtocolVersion() >= 11) {
            version = is.readInt();
        } else {
            version = -1;
            int distance = is.readInt();
        }
        final long created = is.readLong() + skew;
        final byte[] value_bytes = DHTUDPUtils.deserialiseByteArray(is, 256);
        final DHTTransportUDPContactImpl originator = DHTUDPUtils.deserialiseContact(packet.getTransport(), is);
        final int flags = is.readByte() & 0xFF;
        DHTTransportValue value = new DHTTransportValue(){

            public boolean isLocal() {
                return false;
            }

            public long getCreationTime() {
                return created;
            }

            public byte[] getValue() {
                return value_bytes;
            }

            public int getVersion() {
                return version;
            }

            public DHTTransportContact getOriginator() {
                return originator;
            }

            public int getFlags() {
                return flags;
            }

            public String getString() {
                return new String(this.getValue());
            }
        };
        return value;
    }

    protected static void serialiseTransportValue(DHTUDPPacket packet, DataOutputStream os, DHTTransportValue value, long skew) throws IOException, DHTTransportException {
        if (packet.getProtocolVersion() >= 11) {
            int version = value.getVersion();
            os.writeInt(version);
        } else {
            os.writeInt(0);
        }
        os.writeLong(value.getCreationTime() + skew);
        DHTUDPUtils.serialiseByteArray(os, value.getValue(), 256);
        DHTUDPUtils.serialiseContact(os, value.getOriginator());
        os.writeByte(value.getFlags());
    }

    protected static void serialiseContacts(DataOutputStream os, DHTTransportContact[] contacts) throws IOException {
        DHTUDPUtils.serialiseLength(os, contacts.length, 65535);
        for (int i = 0; i < contacts.length; ++i) {
            try {
                DHTUDPUtils.serialiseContact(os, contacts[i]);
                continue;
            }
            catch (DHTTransportException e) {
                Debug.printStackTrace(e);
                throw new IOException(e.getMessage());
            }
        }
    }

    protected static DHTTransportContact[] deserialiseContacts(DHTTransportUDPImpl transport, DataInputStream is) throws IOException {
        int len = DHTUDPUtils.deserialiseLength(is, 65535);
        ArrayList<DHTTransportUDPContactImpl> l = new ArrayList<DHTTransportUDPContactImpl>(len);
        for (int i = 0; i < len; ++i) {
            try {
                l.add(DHTUDPUtils.deserialiseContact(transport, is));
                continue;
            }
            catch (DHTTransportException e) {
                Debug.printStackTrace(e);
            }
        }
        DHTTransportContact[] res = new DHTTransportContact[l.size()];
        l.toArray(res);
        return res;
    }

    protected static void serialiseVivaldi(DataOutputStream os, DHTUDPPacketReply reply) throws IOException {
        float[] data = reply.getVivaldiData();
        if (data.length != 4) {
            Debug.out("Vivaldi serialisation length changed!!!!");
            throw new IOException("argh!!");
        }
        for (int i = 0; i < data.length; ++i) {
            os.writeFloat(data[i]);
        }
    }

    protected static void deserialiseVivaldi(DataInputStream is, DHTUDPPacketReply reply) throws IOException {
        float[] data = new float[4];
        if (data.length != 4) {
            Debug.out("Vivaldi serialisation length changed!!!!");
            throw new IOException("argh!!");
        }
        for (int i = 0; i < data.length; ++i) {
            data[i] = is.readFloat();
        }
        reply.setVivaldiData(data);
    }

    protected static void serialiseStats(int version, DataOutputStream os, DHTTransportFullStats stats) throws IOException {
        os.writeLong(stats.getDBValuesStored());
        os.writeLong(stats.getRouterNodes());
        os.writeLong(stats.getRouterLeaves());
        os.writeLong(stats.getRouterContacts());
        os.writeLong(stats.getTotalBytesReceived());
        os.writeLong(stats.getTotalBytesSent());
        os.writeLong(stats.getTotalPacketsReceived());
        os.writeLong(stats.getTotalPacketsSent());
        os.writeLong(stats.getTotalPingsReceived());
        os.writeLong(stats.getTotalFindNodesReceived());
        os.writeLong(stats.getTotalFindValuesReceived());
        os.writeLong(stats.getTotalStoresReceived());
        os.writeLong(stats.getAverageBytesReceived());
        os.writeLong(stats.getAverageBytesSent());
        os.writeLong(stats.getAveragePacketsReceived());
        os.writeLong(stats.getAveragePacketsSent());
        os.writeLong(stats.getIncomingRequests());
        String azversion = stats.getVersion() + "[" + version + "]";
        DHTUDPUtils.serialiseByteArray(os, azversion.getBytes(), 64);
        if (version >= 5) {
            os.writeLong(stats.getRouterUptime());
            os.writeInt(stats.getRouterCount());
        }
    }

    protected static DHTTransportFullStats deserialiseStats(int version, DataInputStream is) throws IOException {
        int router_count;
        long router_uptime;
        final long db_values_stored = is.readLong();
        final long router_nodes = is.readLong();
        final long router_leaves = is.readLong();
        final long router_contacts = is.readLong();
        final long total_bytes_received = is.readLong();
        final long total_bytes_sent = is.readLong();
        final long total_packets_received = is.readLong();
        final long total_packets_sent = is.readLong();
        final long total_pings_received = is.readLong();
        final long total_find_nodes_received = is.readLong();
        final long total_find_values_received = is.readLong();
        final long total_stores_received = is.readLong();
        final long average_bytes_received = is.readLong();
        final long average_bytes_sent = is.readLong();
        final long average_packets_received = is.readLong();
        final long average_packets_sent = is.readLong();
        final long incoming_requests = is.readLong();
        final String az_version = new String(DHTUDPUtils.deserialiseByteArray(is, 64));
        if (version >= 5) {
            router_uptime = is.readLong();
            router_count = is.readInt();
        } else {
            router_uptime = 0L;
            router_count = 0;
        }
        DHTTransportFullStats res = new DHTTransportFullStats(){

            public long getDBValuesStored() {
                return db_values_stored;
            }

            public long getRouterNodes() {
                return router_nodes;
            }

            public long getRouterLeaves() {
                return router_leaves;
            }

            public long getRouterContacts() {
                return router_contacts;
            }

            public long getRouterUptime() {
                return router_uptime;
            }

            public int getRouterCount() {
                return router_count;
            }

            public long getTotalBytesReceived() {
                return total_bytes_received;
            }

            public long getTotalBytesSent() {
                return total_bytes_sent;
            }

            public long getTotalPacketsReceived() {
                return total_packets_received;
            }

            public long getTotalPacketsSent() {
                return total_packets_sent;
            }

            public long getTotalPingsReceived() {
                return total_pings_received;
            }

            public long getTotalFindNodesReceived() {
                return total_find_nodes_received;
            }

            public long getTotalFindValuesReceived() {
                return total_find_values_received;
            }

            public long getTotalStoresReceived() {
                return total_stores_received;
            }

            public long getAverageBytesReceived() {
                return average_bytes_received;
            }

            public long getAverageBytesSent() {
                return average_bytes_sent;
            }

            public long getAveragePacketsReceived() {
                return average_packets_received;
            }

            public long getAveragePacketsSent() {
                return average_packets_sent;
            }

            public long getIncomingRequests() {
                return incoming_requests;
            }

            public String getVersion() {
                return az_version;
            }

            public String getString() {
                return "transport:" + this.getTotalBytesReceived() + "," + this.getTotalBytesSent() + "," + this.getTotalPacketsReceived() + "," + this.getTotalPacketsSent() + "," + this.getTotalPingsReceived() + "," + this.getTotalFindNodesReceived() + "," + this.getTotalFindValuesReceived() + "," + this.getTotalStoresReceived() + "," + this.getAverageBytesReceived() + "," + this.getAverageBytesSent() + "," + this.getAveragePacketsReceived() + "," + this.getAveragePacketsSent() + "," + this.getIncomingRequests() + ",router:" + this.getRouterNodes() + "," + this.getRouterLeaves() + "," + this.getRouterContacts() + ",database:" + this.getDBValuesStored() + ",version:" + this.getVersion() + "," + this.getRouterUptime() + "," + this.getRouterCount();
            }
        };
        return res;
    }
}

