/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.dht.transport.udp.impl;

import com.aelitis.azureus.core.dht.transport.DHTTransportContact;
import com.aelitis.azureus.core.dht.transport.DHTTransportException;
import com.aelitis.azureus.core.dht.transport.udp.impl.DHTTransportUDPImpl;
import com.aelitis.azureus.core.dht.transport.udp.impl.DHTUDPPacketReply;
import com.aelitis.azureus.core.dht.transport.udp.impl.DHTUDPUtils;
import com.aelitis.azureus.core.dht.transport.udp.impl.packethandler.DHTUDPPacketNetworkHandler;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import org.gudy.azureus2.core3.util.Debug;

public class DHTUDPPacketReplyError
extends DHTUDPPacketReply {
    public static final int ET_UNKNOWN = 0;
    public static final int ET_ORIGINATOR_ADDRESS_WRONG = 1;
    private int error_type = 0;
    private InetSocketAddress originator_address;

    public DHTUDPPacketReplyError(DHTTransportUDPImpl transport, int trans_id, long conn_id, DHTTransportContact local_contact, DHTTransportContact remote_contact) {
        super(transport, 1032, trans_id, conn_id, local_contact, remote_contact);
    }

    protected DHTUDPPacketReplyError(DHTUDPPacketNetworkHandler network_handler, DataInputStream is, int trans_id) throws IOException {
        super(network_handler, is, 1032, trans_id);
        this.error_type = is.readInt();
        if (this.error_type == 1) {
            this.originator_address = DHTUDPUtils.deserialiseAddress(is);
        }
    }

    protected void setErrorType(int error) {
        this.error_type = error;
    }

    protected int getErrorType() {
        return this.error_type;
    }

    protected void setOriginatingAddress(InetSocketAddress a) {
        this.originator_address = a;
    }

    protected InetSocketAddress getOriginatingAddress() {
        return this.originator_address;
    }

    public void serialise(DataOutputStream os) throws IOException {
        super.serialise(os);
        os.writeInt(this.error_type);
        if (this.error_type == 1) {
            try {
                DHTUDPUtils.serialiseAddress(os, this.originator_address);
            }
            catch (DHTTransportException e) {
                Debug.printStackTrace(e);
                throw new IOException(e.getMessage());
            }
        }
    }
}

