/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.webplugin.remoteui.xml.server;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.Map;
import org.gudy.azureus2.core3.util.ByteFormatter;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.xml.simpleparser.SimpleXMLParserDocumentFactory;
import org.gudy.azureus2.core3.xml.util.XUXmlWriter;
import org.gudy.azureus2.plugins.utils.xml.simpleparser.SimpleXMLParserDocument;
import org.gudy.azureus2.plugins.utils.xml.simpleparser.SimpleXMLParserDocumentAttribute;
import org.gudy.azureus2.plugins.utils.xml.simpleparser.SimpleXMLParserDocumentException;
import org.gudy.azureus2.plugins.utils.xml.simpleparser.SimpleXMLParserDocumentNode;
import org.gudy.azureus2.pluginsimpl.remote.RPException;
import org.gudy.azureus2.pluginsimpl.remote.RPObject;
import org.gudy.azureus2.pluginsimpl.remote.RPReply;
import org.gudy.azureus2.pluginsimpl.remote.RPRequest;
import org.gudy.azureus2.pluginsimpl.remote.RPRequestAccessController;
import org.gudy.azureus2.pluginsimpl.remote.RPRequestHandler;

public class XMLRequestProcessor
extends XUXmlWriter {
    protected RPRequestHandler request_handler;
    protected SimpleXMLParserDocument request;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected XMLRequestProcessor(RPRequestHandler _request_handler, RPRequestAccessController _access_controller, String _client_ip, InputStream _request, OutputStream _reply) {
        super(_reply);
        this.request_handler = _request_handler;
        this.writeLineRaw("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        try {
            this.writeLineRaw("<RESPONSE>");
            this.indent();
            this.request = SimpleXMLParserDocumentFactory.create(_request);
            this.process(_client_ip, _access_controller);
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
            if (e instanceof SimpleXMLParserDocumentException) {
                this.writeTag("ERROR", "Invalid XML Plugin request received - " + this.exceptionToString(e));
            } else {
                this.writeTag("ERROR", e);
            }
        }
        finally {
            this.exdent();
            this.writeLineRaw("</RESPONSE>");
            this.flushOutputStream();
        }
    }

    protected void process(String client_ip, RPRequestAccessController access_controller) {
        RPRequest req_obj = (RPRequest)this.deserialiseObject(this.request, RPRequest.class, "");
        req_obj.setClientIP(client_ip);
        RPReply reply = this.request_handler.processRequest(req_obj, access_controller);
        if (reply != null) {
            Map props = reply.getProperties();
            for (String name : props.keySet()) {
                String value = (String)props.get(name);
                this.writeTag(name, value);
            }
            try {
                Object response = reply.getResponse();
                if (response != null) {
                    this.serialiseObject(response, "", -1);
                }
            }
            catch (RPException e) {
                Debug.printStackTrace(e);
                this.writeTag("ERROR", e);
            }
        }
    }

    protected void writeTag(String tag, Throwable e) {
        this.writeLineRaw("<ERROR>");
        this.writeLineEscaped(this.exceptionToString(e));
        if (e instanceof RPException && e.getCause() != null) {
            e = e.getCause();
        }
        this.serialiseObject(e, "    ", -3);
        this.writeLineRaw("</ERROR>");
    }

    protected String exceptionToString(Throwable e) {
        Throwable cause = e.getCause();
        if (cause != null) {
            String m = cause.getMessage();
            if (m != null) {
                return m;
            }
            return cause.toString();
        }
        String m = e.getMessage();
        if (m != null) {
            return m;
        }
        return e.toString();
    }

    protected Object deserialiseObject(SimpleXMLParserDocumentNode node, Class cla, String indent) {
        String request_method = null;
        if (cla == RPRequest.class) {
            request_method = node.getChild("METHOD").getValue().trim();
        }
        try {
            Object obj = cla.newInstance();
            Field[] fields = cla.getDeclaredFields();
            for (int i = 0; i < fields.length; ++i) {
                Field field = fields[i];
                int modifiers = field.getModifiers();
                if ((modifiers & 0x88) != 0) continue;
                String name = field.getName();
                Class<?> type = field.getType();
                SimpleXMLParserDocumentNode child = node.getChild(name);
                if (child == null) continue;
                if (type.isArray()) {
                    Class<?> sub_type = type.getComponentType();
                    SimpleXMLParserDocumentNode[] entries = child.getChildren();
                    Object array = Array.newInstance(sub_type, entries.length);
                    if (request_method != null) {
                        int j;
                        String[] bits = new String[entries.length];
                        int method_pos = request_method.indexOf(91) + 1;
                        for (j = 0; j < entries.length; ++j) {
                            int p1 = request_method.indexOf(44, method_pos);
                            if (p1 == -1) {
                                bits[j] = request_method.substring(method_pos, request_method.length() - 1).toLowerCase();
                                break;
                            }
                            bits[j] = request_method.substring(method_pos, p1).toLowerCase();
                            method_pos = p1 + 1;
                        }
                        for (j = 0; j < entries.length; ++j) {
                            SimpleXMLParserDocumentNode array_child = entries[j];
                            SimpleXMLParserDocumentAttribute index_attr = array_child.getAttribute("index");
                            String index_str = index_attr == null ? null : index_attr.getValue().trim();
                            int array_index = index_str == null ? j : Integer.parseInt(index_str);
                            String bit = bits[array_index];
                            String sub_value = array_child.getValue().trim();
                            if (bit.equals("string")) {
                                Array.set(array, array_index, sub_value);
                                continue;
                            }
                            if (bit.equals("int")) {
                                Array.set(array, array_index, Integer.valueOf(sub_value));
                                continue;
                            }
                            if (bit.equals("boolean")) {
                                Array.set(array, array_index, Boolean.valueOf(sub_value));
                                continue;
                            }
                            if (bit.equals("url")) {
                                Array.set(array, array_index, new URL(sub_value));
                                continue;
                            }
                            if (bit.equals("byte[]")) {
                                Array.set(array, array_index, ByteFormatter.decodeString(sub_value));
                                continue;
                            }
                            SimpleXMLParserDocumentNode obj_node = array_child.getChild("OBJECT");
                            if (obj_node != null) {
                                String oid_str = obj_node.getChild("_object_id").getValue().trim();
                                long oid = Long.parseLong(oid_str);
                                RPObject local_obj = RPObject._lookupLocal(oid);
                                Array.set(array, array_index, local_obj);
                                continue;
                            }
                            throw new RuntimeException("not implemented");
                        }
                    } else {
                        for (int j = 0; j < entries.length; ++j) {
                            SimpleXMLParserDocumentNode array_child = entries[j];
                            if (sub_type != String.class) {
                                throw new RuntimeException("not implemented");
                            }
                            Array.set(array, j, child.getValue().trim());
                        }
                    }
                    field.set(obj, array);
                    continue;
                }
                String value = child.getValue().trim();
                if (type == String.class) {
                    field.set(obj, value);
                    continue;
                }
                if (type == Long.TYPE) {
                    field.setLong(obj, Long.parseLong(value));
                    continue;
                }
                if (type == Boolean.TYPE) {
                    throw new RuntimeException("not implemented");
                }
                if (type == Byte.TYPE) {
                    throw new RuntimeException("not implemented");
                }
                if (type == Character.TYPE) {
                    field.setChar(obj, value.charAt(0));
                    continue;
                }
                if (type == Double.TYPE) {
                    field.setDouble(obj, Double.parseDouble(value));
                    continue;
                }
                if (type == Float.TYPE) {
                    field.setFloat(obj, Float.parseFloat(value));
                    continue;
                }
                if (type == Integer.TYPE) {
                    field.setInt(obj, Integer.parseInt(value));
                    continue;
                }
                if (type == Short.TYPE) {
                    field.setShort(obj, Short.parseShort(value));
                    continue;
                }
                if (type == Long.class || type == Long.TYPE) {
                    field.set(obj, new Long(Long.parseLong(value)));
                    continue;
                }
                field.set(obj, this.deserialiseObject(child, type, indent + "    "));
            }
            return obj;
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
            throw new RuntimeException(e.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void serialiseObject(Object obj, String indent, int original_modifier_filter) {
        int modifier_filter = original_modifier_filter & 0xFFFFFF77;
        Class<?> cla = obj.getClass();
        if (cla.isArray()) {
            int len = Array.getLength(obj);
            if (cla.getComponentType() == Byte.TYPE) {
                byte[] data = (byte[])obj;
                this.writeLineEscaped(ByteFormatter.nicePrint(data, true));
            } else {
                for (int i = 0; i < len; ++i) {
                    Object entry = Array.get(obj, i);
                    try {
                        this.writeLineRaw("<ENTRY index=\"" + i + "\">");
                        this.indent();
                        this.serialiseObject(entry, indent + "  ", original_modifier_filter);
                        continue;
                    }
                    finally {
                        this.exdent();
                        this.writeLineRaw("</ENTRY>");
                    }
                }
            }
            return;
        }
        if (cla == String.class) {
            this.writeLineEscaped("" + (String)obj);
        } else if (cla == Integer.class) {
            this.writeLineEscaped("" + (Integer)obj);
        } else if (cla == Boolean.class) {
            this.writeLineEscaped("" + (Boolean)obj);
        } else {
            while (cla != null) {
                try {
                    Field[] fields = cla.getDeclaredFields();
                    for (int i = 0; i < fields.length; ++i) {
                        Field field = fields[i];
                        int modifiers = field.getModifiers();
                        if ((modifiers | modifier_filter) != modifier_filter) continue;
                        String name = field.getName();
                        Class<?> type = field.getType();
                        try {
                            this.writeLineRaw("<" + name + ">");
                            this.indent();
                            if (type == String.class) {
                                this.writeLineEscaped((String)field.get(obj));
                                continue;
                            }
                            if (type == File.class) {
                                this.writeLineEscaped("" + ((File)field.get(obj)).toString());
                                continue;
                            }
                            if (type == Integer.class) {
                                this.writeLineEscaped("" + (Integer)field.get(obj));
                                continue;
                            }
                            if (type == Boolean.class) {
                                this.writeLineEscaped("" + (Boolean)field.get(obj));
                                continue;
                            }
                            if (type == Long.TYPE) {
                                this.writeLineEscaped("" + field.getLong(obj));
                                continue;
                            }
                            if (type == Boolean.TYPE) {
                                this.writeLineEscaped("" + field.getBoolean(obj));
                                continue;
                            }
                            if (type == Byte.TYPE) {
                                this.writeLineEscaped("" + field.getByte(obj));
                                continue;
                            }
                            if (type == Character.TYPE) {
                                this.writeLineEscaped("" + field.getChar(obj));
                                continue;
                            }
                            if (type == Double.TYPE) {
                                this.writeLineEscaped("" + field.getDouble(obj));
                                continue;
                            }
                            if (type == Float.TYPE) {
                                this.writeLineEscaped("" + field.getFloat(obj));
                                continue;
                            }
                            if (type == Integer.TYPE) {
                                this.writeLineEscaped("" + field.getInt(obj));
                                continue;
                            }
                            if (type == Short.TYPE) {
                                this.writeLineEscaped("" + field.getShort(obj));
                                continue;
                            }
                            if (type == Long.class) {
                                this.writeLineEscaped("" + field.get(obj));
                                continue;
                            }
                            this.serialiseObject(field.get(obj), indent + "    ", original_modifier_filter);
                            continue;
                        }
                        finally {
                            this.exdent();
                            this.writeLineRaw("</" + name + ">");
                        }
                    }
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                    throw new RuntimeException(e.toString());
                }
                cla = cla.getSuperclass();
            }
        }
    }
}

