/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.tableitems.mytorrents;

import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.peer.PEPeerManager;
import org.gudy.azureus2.core3.util.TimeFormatter;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.plugins.ui.tables.TableCellRefreshListener;
import org.gudy.azureus2.ui.swt.views.table.utils.CoreTableColumn;

public class TimeSinceUploadItem
extends CoreTableColumn
implements TableCellRefreshListener {
    public TimeSinceUploadItem(String sTableID) {
        super("timesinceupload", 2, -1, 70, sTableID);
        this.setRefreshInterval(-2);
    }

    public void refresh(TableCell cell) {
        DownloadManager dm = (DownloadManager)cell.getDataSource();
        PEPeerManager pm = dm == null ? null : dm.getPeerManager();
        int value = pm == null ? -2 : pm.getStats().getTimeSinceLastDataSentInSeconds();
        if (!cell.setSortValue(value == -1 ? Integer.MAX_VALUE : (long)value) && cell.isValid()) {
            return;
        }
        cell.setText(value == -2 ? "" : (value == -1 ? "\u221e" : TimeFormatter.format(value)));
    }
}

