/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.components.graphics;

import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.util.DisplayFormatters;
import org.gudy.azureus2.ui.swt.components.graphics.Scale;
import org.gudy.azureus2.ui.swt.components.graphics.ScaledGraphic;
import org.gudy.azureus2.ui.swt.components.graphics.ValueFormater;
import org.gudy.azureus2.ui.swt.mainwindow.Colors;

public class SpeedGraphic
extends ScaledGraphic
implements ParameterListener {
    private static final int ENTRIES = 2000;
    public static final int COLOR_AVERAGE = 0;
    public static final int COLOR_VALUE0 = 1;
    public static final int COLOR_VALUE1 = 2;
    public static final int COLOR_VALUE2PLUS = 3;
    public static final int COLOR_TRIMMED = 4;
    public static Color[] colors = new Color[]{Colors.red, Colors.blues[7], Colors.blue, Colors.grey, Colors.light_grey};
    private int internalLoop;
    private int graphicsUpdate;
    private Point oldSize;
    protected Image bufferImage;
    private int nbValues = 0;
    private int[][] all_values = new int[1][2000];
    private int currentPosition = 0;

    private SpeedGraphic(Scale scale, ValueFormater formater) {
        super(scale, formater);
        COConfigurationManager.addParameterListener("Graphics Update", this);
        this.parameterChanged("Graphics Update");
    }

    public static SpeedGraphic getInstance() {
        return new SpeedGraphic(new Scale(), new ValueFormater(){

            public String format(int value) {
                return DisplayFormatters.formatByteCountToBase10KBEtcPerSec(value);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addIntsValue(int[] new_values) {
        try {
            this.this_mon.enter();
            if (this.all_values.length < new_values.length) {
                int i;
                int[][] new_all_values = new int[new_values.length][];
                for (i = 0; i < this.all_values.length; ++i) {
                    new_all_values[i] = this.all_values[i];
                }
                for (i = this.all_values.length; i < new_all_values.length; ++i) {
                    new_all_values[i] = new int[2000];
                }
                this.all_values = new_all_values;
            }
            for (int i = 0; i < new_values.length; ++i) {
                this.all_values[i][this.currentPosition] = new_values[i];
            }
            ++this.currentPosition;
            if (this.nbValues < 2000) {
                ++this.nbValues;
            }
            if (this.currentPosition >= 2000) {
                this.currentPosition = 0;
            }
        }
        finally {
            this.this_mon.exit();
        }
    }

    public void addIntValue(int value) {
        this.addIntsValue(new int[]{value});
    }

    public void refresh() {
        if (this.drawCanvas == null || this.drawCanvas.isDisposed()) {
            return;
        }
        Rectangle bounds = this.drawCanvas.getClientArea();
        if (bounds.height < 30 || bounds.width < 100 || bounds.width > 2000 || bounds.height > 2000) {
            return;
        }
        boolean sizeChanged = this.oldSize == null || this.oldSize.x != bounds.width || this.oldSize.y != bounds.height;
        this.oldSize = new Point(bounds.width, bounds.height);
        ++this.internalLoop;
        if (this.internalLoop > this.graphicsUpdate) {
            this.internalLoop = 0;
        }
        if (this.internalLoop == 0 || sizeChanged) {
            this.drawChart(sizeChanged);
        }
        GC gc = new GC((Drawable)this.drawCanvas);
        gc.drawImage(this.bufferImage, bounds.x, bounds.y);
        gc.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void drawChart(boolean sizeChanged) {
        try {
            int max;
            this.this_mon.enter();
            this.drawScale(sizeChanged);
            Rectangle bounds = this.drawCanvas.getClientArea();
            if (this.bufferImage != null && !this.bufferImage.isDisposed()) {
                this.bufferImage.dispose();
            }
            this.bufferImage = new Image((Device)this.drawCanvas.getDisplay(), bounds);
            GC gcImage = new GC((Drawable)this.bufferImage);
            gcImage.drawImage(this.bufferScale, 0, 0);
            int oldAverage = 0;
            int[] oldTargetValues = new int[this.all_values.length];
            Color background = Colors.blues[9];
            Color foreground = Colors.blues[2];
            int[] maxs = new int[this.all_values.length];
            for (int x = 0; x < bounds.width - 71; ++x) {
                int position = this.currentPosition - x - 1;
                if (position < 0) {
                    position += 2000;
                }
                for (int z = 0; z < this.all_values.length; ++z) {
                    int value = this.all_values[z][position];
                    if (value <= maxs[z]) continue;
                    maxs[z] = value;
                }
            }
            int max_primary = max = maxs[0];
            for (int i = 1; i < maxs.length; ++i) {
                int m = maxs[i];
                if (i == 1) {
                    if (max >= m) continue;
                    max_primary = max = m;
                    continue;
                }
                if (max >= m) continue;
                if (m <= 2 * max_primary) {
                    max = m;
                    continue;
                }
                max = 2 * max_primary;
                break;
            }
            this.scale.setMax(max);
            int maxHeight = this.scale.getScaledValue(max);
            for (int x = 0; x < bounds.width - 71; ++x) {
                int position = this.currentPosition - x - 1;
                if (position < 0) {
                    position += 2000;
                }
                int value = this.all_values[0][position];
                int xDraw = bounds.width - 71 - x;
                int height = this.scale.getScaledValue(value);
                if (height < 0) {
                    int a;
                    int b = a = 2;
                }
                gcImage.setForeground(background);
                gcImage.setBackground(foreground);
                gcImage.setClipping(xDraw, bounds.height - 1 - height, 1, height);
                gcImage.fillGradientRectangle(xDraw, bounds.height - 1 - maxHeight, 1, maxHeight, true);
                gcImage.setClipping(0, 0, bounds.width, bounds.height);
                for (int z = 1; z < this.all_values.length; ++z) {
                    int targetValue = this.all_values[z][position];
                    int oldTargetValue = oldTargetValues[z];
                    if (x > 1 && (z == 1 && targetValue > 0 && oldTargetValue > 0 || z > 1 && (targetValue > 0 || oldTargetValue > 0))) {
                        int trimmed = 0;
                        if (targetValue > max) {
                            targetValue = max;
                            ++trimmed;
                        }
                        if (oldTargetValue > max) {
                            oldTargetValue = max;
                            ++trimmed;
                        }
                        if (trimmed < 2 || trimmed == 2 && position % 3 == 0) {
                            int h1 = bounds.height - this.scale.getScaledValue(targetValue) - 2;
                            int h2 = bounds.height - this.scale.getScaledValue(oldTargetValue) - 2;
                            gcImage.setForeground(z == 1 ? colors[2] : (trimmed > 0 ? colors[4] : colors[3]));
                            gcImage.drawLine(xDraw, h1, xDraw + 1, h2);
                        }
                    }
                    oldTargetValues[z] = this.all_values[z][position];
                }
                int average = this.computeAverage(position);
                if (x > 6) {
                    int h1 = bounds.height - this.scale.getScaledValue(average) - 2;
                    int h2 = bounds.height - this.scale.getScaledValue(oldAverage) - 2;
                    gcImage.setForeground(colors[0]);
                    gcImage.drawLine(xDraw, h1, xDraw + 1, h2);
                }
                oldAverage = average;
            }
            if (this.nbValues > 0) {
                int height = bounds.height - this.scale.getScaledValue(this.computeAverage(this.currentPosition - 6)) - 2;
                gcImage.setForeground(colors[0]);
                gcImage.drawText(this.formater.format(this.computeAverage(this.currentPosition - 6)), bounds.width - 65, height - 12, true);
            }
            gcImage.dispose();
        }
        finally {
            this.this_mon.exit();
        }
    }

    protected int computeAverage(int position) {
        long sum = 0L;
        for (int i = -5; i < 6; ++i) {
            int pos = position + i;
            if (pos < 0) {
                pos += 2000;
            }
            if (pos >= 2000) {
                pos -= 2000;
            }
            sum += (long)this.all_values[0][pos];
        }
        return (int)(sum / 11L);
    }

    public void parameterChanged(String parameter) {
        this.graphicsUpdate = COConfigurationManager.getIntParameter("Graphics Update");
    }

    public void dispose() {
        super.dispose();
        if (this.bufferImage != null && !this.bufferImage.isDisposed()) {
            this.bufferImage.dispose();
        }
        COConfigurationManager.removeParameterListener("Graphics Update", this);
    }
}

