/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.download;

import com.aelitis.azureus.core.util.CopyOnWriteList;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.category.Category;
import org.gudy.azureus2.core3.category.CategoryManager;
import org.gudy.azureus2.core3.disk.DiskManagerFileInfo;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.download.DownloadManagerActivationListener;
import org.gudy.azureus2.core3.download.DownloadManagerException;
import org.gudy.azureus2.core3.download.DownloadManagerListener;
import org.gudy.azureus2.core3.download.DownloadManagerPeerListener;
import org.gudy.azureus2.core3.download.DownloadManagerState;
import org.gudy.azureus2.core3.download.DownloadManagerStateEvent;
import org.gudy.azureus2.core3.download.DownloadManagerStateListener;
import org.gudy.azureus2.core3.download.DownloadManagerTrackerListener;
import org.gudy.azureus2.core3.global.GlobalManager;
import org.gudy.azureus2.core3.global.GlobalManagerDownloadRemovalVetoException;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.logging.LogRelation;
import org.gudy.azureus2.core3.peer.PEPeer;
import org.gudy.azureus2.core3.peer.PEPeerManager;
import org.gudy.azureus2.core3.peer.PEPiece;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.tracker.client.TRTrackerAnnouncer;
import org.gudy.azureus2.core3.tracker.client.TRTrackerAnnouncerResponse;
import org.gudy.azureus2.core3.tracker.client.TRTrackerScraperResponse;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.disk.DiskManager;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.download.DownloadActivationEvent;
import org.gudy.azureus2.plugins.download.DownloadActivationListener;
import org.gudy.azureus2.plugins.download.DownloadAnnounceResult;
import org.gudy.azureus2.plugins.download.DownloadException;
import org.gudy.azureus2.plugins.download.DownloadListener;
import org.gudy.azureus2.plugins.download.DownloadPeerListener;
import org.gudy.azureus2.plugins.download.DownloadPropertyEvent;
import org.gudy.azureus2.plugins.download.DownloadPropertyListener;
import org.gudy.azureus2.plugins.download.DownloadRemovalVetoException;
import org.gudy.azureus2.plugins.download.DownloadScrapeResult;
import org.gudy.azureus2.plugins.download.DownloadStats;
import org.gudy.azureus2.plugins.download.DownloadTrackerListener;
import org.gudy.azureus2.plugins.download.DownloadWillBeRemovedListener;
import org.gudy.azureus2.plugins.download.session.SessionAuthenticator;
import org.gudy.azureus2.plugins.peers.PeerManager;
import org.gudy.azureus2.plugins.torrent.Torrent;
import org.gudy.azureus2.plugins.torrent.TorrentAttribute;
import org.gudy.azureus2.pluginsimpl.local.disk.DiskManagerFileInfoImpl;
import org.gudy.azureus2.pluginsimpl.local.download.DownloadAnnounceResultImpl;
import org.gudy.azureus2.pluginsimpl.local.download.DownloadScrapeResultImpl;
import org.gudy.azureus2.pluginsimpl.local.download.DownloadStatsImpl;
import org.gudy.azureus2.pluginsimpl.local.peers.PeerManagerImpl;
import org.gudy.azureus2.pluginsimpl.local.torrent.TorrentImpl;
import org.gudy.azureus2.pluginsimpl.local.torrent.TorrentManagerImpl;

public class DownloadImpl
extends LogRelation
implements Download,
DownloadManagerListener,
DownloadManagerTrackerListener,
DownloadManagerPeerListener,
DownloadManagerStateListener,
DownloadManagerActivationListener {
    private DownloadManager download_manager;
    private DownloadStatsImpl download_stats;
    private int latest_state = 7;
    private boolean latest_forcedStart;
    private DownloadAnnounceResultImpl last_announce_result = new DownloadAnnounceResultImpl(this, null);
    private DownloadScrapeResultImpl last_scrape_result = new DownloadScrapeResultImpl(this, null);
    private TorrentImpl torrent = null;
    private List listeners = new ArrayList();
    private AEMonitor listeners_mon = new AEMonitor("Download:L");
    private List property_listeners = new ArrayList();
    private List tracker_listeners = new ArrayList();
    private AEMonitor tracker_listeners_mon = new AEMonitor("Download:TL");
    private List removal_listeners = new ArrayList();
    private AEMonitor removal_listeners_mon = new AEMonitor("Download:RL");
    private List peer_listeners = new ArrayList();
    private AEMonitor peer_listeners_mon = new AEMonitor("Download:PL");
    private CopyOnWriteList activation_listeners = new CopyOnWriteList();
    private DownloadActivationEvent activation_state;

    protected DownloadImpl(DownloadManager _dm) {
        this.download_manager = _dm;
        this.download_stats = new DownloadStatsImpl(this.download_manager);
        this.activation_state = new DownloadActivationEvent(){

            public Download getDownload() {
                return DownloadImpl.this;
            }

            public int getActivationCount() {
                return DownloadImpl.this.download_manager.getActivationCount();
            }
        };
        this.download_manager.addListener(this);
        this.latest_forcedStart = this.download_manager.isForceStart();
    }

    public DownloadManager getDownload() {
        return this.download_manager;
    }

    public int getState() {
        return this.convertState(this.download_manager.getState());
    }

    public int getSubState() {
        int state = this.getState();
        if (state == 6) {
            int substate = this.download_manager.getSubState();
            if (substate == 75) {
                return 9;
            }
            if (substate == 70) {
                return 7;
            }
            if (substate == 100) {
                return 8;
            }
        }
        return state;
    }

    protected int convertState(int dm_state) {
        int our_state;
        switch (dm_state) {
            case 0: {
                our_state = 1;
                break;
            }
            case 5: 
            case 10: 
            case 20: 
            case 30: {
                our_state = 2;
                break;
            }
            case 40: {
                our_state = 3;
                break;
            }
            case 50: 
            case 55: {
                our_state = 4;
                break;
            }
            case 60: {
                our_state = 5;
                break;
            }
            case 65: {
                our_state = 6;
                break;
            }
            case 70: {
                our_state = 7;
                break;
            }
            case 75: {
                our_state = 9;
                break;
            }
            case 100: {
                our_state = 8;
                break;
            }
            default: {
                our_state = 8;
            }
        }
        return our_state;
    }

    public String getErrorStateDetails() {
        return this.download_manager.getErrorDetails();
    }

    public boolean getFlag(long flag) {
        return this.download_manager.getDownloadState().getFlag(flag);
    }

    public int getIndex() {
        GlobalManager globalManager = this.download_manager.getGlobalManager();
        return globalManager.getIndexOf(this.download_manager);
    }

    public Torrent getTorrent() {
        if (this.torrent != null) {
            return this.torrent;
        }
        TOTorrent torrent = this.download_manager.getTorrent();
        if (torrent == null) {
            return null;
        }
        this.torrent = new TorrentImpl(torrent);
        return this.torrent;
    }

    public void initialize() throws DownloadException {
        int state = this.download_manager.getState();
        if (state != 0) {
            throw new DownloadException("Download::initialize: download not waiting (state=" + state + ")");
        }
        this.download_manager.initialize();
    }

    public void start() throws DownloadException {
        int state = this.download_manager.getState();
        if (state != 40) {
            throw new DownloadException("Download::start: download not ready (state=" + state + ")");
        }
        this.download_manager.startDownload();
    }

    public void restart() throws DownloadException {
        int state = this.download_manager.getState();
        if (state != 70 && state != 75) {
            throw new DownloadException("Download::restart: download already running (state=" + state + ")");
        }
        this.download_manager.setStateWaiting();
    }

    public void stop() throws DownloadException {
        if (this.download_manager.getState() == 70) {
            throw new DownloadException("Download::stop: download already stopped");
        }
        this.download_manager.stopIt(70, false, false);
    }

    public void stopAndQueue() throws DownloadException {
        if (this.download_manager.getState() == 75) {
            throw new DownloadException("Download::stopAndQueue: download already queued");
        }
        this.download_manager.stopIt(75, false, false);
    }

    public void recheckData() throws DownloadException {
        if (!this.download_manager.canForceRecheck()) {
            throw new DownloadException("Download::recheckData: download must be stopped, quued or in error state");
        }
        this.download_manager.forceRecheck();
    }

    public boolean isStartStopLocked() {
        return this.download_manager.getState() == 70;
    }

    public boolean isForceStart() {
        return this.download_manager.isForceStart();
    }

    public void setForceStart(boolean forceStart) {
        this.download_manager.setForceStart(forceStart);
    }

    public boolean isPaused() {
        return this.download_manager.isPaused();
    }

    public int getPosition() {
        return this.download_manager.getPosition();
    }

    public long getCreationTime() {
        return this.download_manager.getCreationTime();
    }

    public void setPosition(int newPosition) {
        this.download_manager.setPosition(newPosition);
    }

    public void moveUp() {
        this.download_manager.getGlobalManager().moveUp(this.download_manager);
    }

    public void moveDown() {
        this.download_manager.getGlobalManager().moveDown(this.download_manager);
    }

    public void moveTo(int pos) {
        this.download_manager.getGlobalManager().moveTo(this.download_manager, pos);
    }

    public String getName() {
        return this.download_manager.getDisplayName();
    }

    public String getTorrentFileName() {
        return this.download_manager.getTorrentFileName();
    }

    public String getCategoryName() {
        Category category = this.download_manager.getDownloadState().getCategory();
        if (category == null) {
            category = CategoryManager.getCategory(2);
        }
        if (category == null) {
            return null;
        }
        return category.getName();
    }

    public String getAttribute(TorrentAttribute attribute) {
        String name = this.convertAttribute(attribute);
        if (name != null) {
            return this.download_manager.getDownloadState().getAttribute(name);
        }
        return null;
    }

    public String[] getListAttribute(TorrentAttribute attribute) {
        String name = this.convertAttribute(attribute);
        if (name != null) {
            return this.download_manager.getDownloadState().getListAttribute(name);
        }
        return null;
    }

    public void setMapAttribute(TorrentAttribute attribute, Map value) {
        String name = this.convertAttribute(attribute);
        if (name != null) {
            this.download_manager.getDownloadState().setMapAttribute(name, value);
        }
    }

    public Map getMapAttribute(TorrentAttribute attribute) {
        String name = this.convertAttribute(attribute);
        if (name != null) {
            return this.download_manager.getDownloadState().getMapAttribute(name);
        }
        return null;
    }

    public void setAttribute(TorrentAttribute attribute, String value) {
        String name = this.convertAttribute(attribute);
        if (name != null) {
            this.download_manager.getDownloadState().setAttribute(name, value);
        }
    }

    protected String convertAttribute(TorrentAttribute attribute) {
        if (attribute.getName() == "Category") {
            return "category";
        }
        if (attribute.getName() == "Networks") {
            return "networks";
        }
        if (attribute.getName() == "TrackerClientExtensions") {
            return "trackerclientextensions";
        }
        if (attribute.getName() == "PeerSources") {
            return "peersources";
        }
        if (attribute.getName() == "DisplayName") {
            return "displayname";
        }
        if (attribute.getName() == "ContentMap") {
            return "contentmap";
        }
        if (attribute.getName() == "ShareProperties") {
            return null;
        }
        if (attribute.getName().startsWith("Plugin.")) {
            return attribute.getName();
        }
        Debug.out("Can't convert attribute '" + attribute.getName() + "'");
        return null;
    }

    protected TorrentAttribute convertAttribute(String name) {
        if (name.equals("category")) {
            return TorrentManagerImpl.getSingleton().getAttribute("Category");
        }
        if (name.equals("networks")) {
            return TorrentManagerImpl.getSingleton().getAttribute("Networks");
        }
        if (name.equals("peersources")) {
            return TorrentManagerImpl.getSingleton().getAttribute("PeerSources");
        }
        if (name.equals("trackerclientextensions")) {
            return TorrentManagerImpl.getSingleton().getAttribute("TrackerClientExtensions");
        }
        if (name.equals("displayname")) {
            return TorrentManagerImpl.getSingleton().getAttribute("DisplayName");
        }
        if (name.equals("contentmap")) {
            return TorrentManagerImpl.getSingleton().getAttribute("ContentMap");
        }
        if (name.startsWith("Plugin.")) {
            return TorrentManagerImpl.getSingleton().getAttribute(name);
        }
        return null;
    }

    public void setCategory(String sName) {
        Category category = CategoryManager.getCategory(sName);
        if (category == null) {
            category = CategoryManager.createCategory(sName);
        }
        this.download_manager.getDownloadState().setCategory(category);
    }

    public boolean isPersistent() {
        return this.download_manager.isPersistent();
    }

    public void remove() throws DownloadException, DownloadRemovalVetoException {
        this.remove(false, false);
    }

    public void remove(boolean delete_torrent, boolean delete_data) throws DownloadException, DownloadRemovalVetoException {
        int dl_state = this.download_manager.getState();
        if (dl_state == 70 || dl_state == 100 || dl_state == 75) {
            GlobalManager globalManager = this.download_manager.getGlobalManager();
            try {
                globalManager.canDownloadManagerBeRemoved(this.download_manager);
                if (delete_torrent || delete_data) {
                    this.download_manager.stopIt(dl_state, delete_torrent, delete_data);
                }
                globalManager.removeDownloadManager(this.download_manager);
            }
            catch (GlobalManagerDownloadRemovalVetoException e) {
                throw new DownloadRemovalVetoException(e.getMessage());
            }
        } else {
            throw new DownloadRemovalVetoException(MessageText.getString("plugin.download.remove.veto.notstopped"));
        }
    }

    public boolean canBeRemoved() throws DownloadRemovalVetoException {
        int dl_state = this.download_manager.getState();
        if (dl_state == 70 || dl_state == 100 || dl_state == 75) {
            GlobalManager globalManager = this.download_manager.getGlobalManager();
            try {
                globalManager.canDownloadManagerBeRemoved(this.download_manager);
            }
            catch (GlobalManagerDownloadRemovalVetoException e) {
                throw new DownloadRemovalVetoException(e.getMessage(), e.isSilent());
            }
        } else {
            throw new DownloadRemovalVetoException(MessageText.getString("plugin.download.remove.veto.notstopped"));
        }
        return true;
    }

    public DownloadStats getStats() {
        return this.download_stats;
    }

    public boolean isComplete() {
        int state = this.getState();
        return state == 5 || this.download_manager.isDownloadComplete(false);
    }

    public boolean isComplete(boolean bIncludeDND) {
        return this.download_manager.isDownloadComplete(bIncludeDND);
    }

    public boolean isChecking() {
        org.gudy.azureus2.core3.disk.DiskManager dm = this.download_manager.getDiskManager();
        if (dm != null) {
            return dm.getCompleteRecheckStatus() != -1;
        }
        return false;
    }

    protected void isRemovable() throws DownloadRemovalVetoException {
        for (int i = 0; i < this.removal_listeners.size(); ++i) {
            try {
                ((DownloadWillBeRemovedListener)this.removal_listeners.get(i)).downloadWillBeRemoved(this);
                continue;
            }
            catch (DownloadRemovalVetoException e) {
                throw e;
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
    }

    protected void destroy() {
        this.download_manager.removeListener(this);
    }

    public void stateChanged(DownloadManager manager, int state) {
        int prev_state = this.latest_state;
        this.latest_state = this.convertState(state);
        boolean curr_forcedStart = this.isForceStart();
        if (prev_state != this.latest_state || this.latest_forcedStart != curr_forcedStart) {
            this.latest_forcedStart = curr_forcedStart;
            for (int i = 0; i < this.listeners.size(); ++i) {
                try {
                    ((DownloadListener)this.listeners.get(i)).stateChanged(this, prev_state, this.latest_state);
                    continue;
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
            }
        }
    }

    public void downloadComplete(DownloadManager manager) {
    }

    public void completionChanged(DownloadManager manager, boolean bCompleted) {
    }

    public void filePriorityChanged(DownloadManager download, DiskManagerFileInfo file) {
    }

    public void positionChanged(DownloadManager download, int oldPosition, int newPosition) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            try {
                ((DownloadListener)this.listeners.get(i)).positionChanged(this, oldPosition, newPosition);
                continue;
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(DownloadListener l) {
        try {
            this.listeners_mon.enter();
            ArrayList<DownloadListener> new_listeners = new ArrayList<DownloadListener>(this.listeners);
            new_listeners.add(l);
            this.listeners = new_listeners;
        }
        finally {
            this.listeners_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(DownloadListener l) {
        try {
            this.listeners_mon.enter();
            ArrayList new_listeners = new ArrayList(this.listeners);
            new_listeners.remove(l);
            this.listeners = new_listeners;
        }
        finally {
            this.listeners_mon.exit();
        }
    }

    public DownloadAnnounceResult getLastAnnounceResult() {
        TRTrackerAnnouncer tc = this.download_manager.getTrackerClient();
        if (tc != null) {
            this.last_announce_result.setContent(tc.getLastResponse());
        }
        return this.last_announce_result;
    }

    public DownloadScrapeResult getLastScrapeResult() {
        TRTrackerScraperResponse response = this.download_manager.getTrackerScrapeResponse();
        this.last_scrape_result.setContent(response);
        return this.last_scrape_result;
    }

    public void scrapeResult(TRTrackerScraperResponse response) {
        this.last_scrape_result.setContent(response);
        for (int i = 0; i < this.tracker_listeners.size(); ++i) {
            try {
                ((DownloadTrackerListener)this.tracker_listeners.get(i)).scrapeResult(this.last_scrape_result);
                continue;
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
    }

    public void announceResult(TRTrackerAnnouncerResponse response) {
        this.last_announce_result.setContent(response);
        List tracker_listeners_ref = this.tracker_listeners;
        for (int i = 0; i < tracker_listeners_ref.size(); ++i) {
            try {
                ((DownloadTrackerListener)tracker_listeners_ref.get(i)).announceResult(this.last_announce_result);
                continue;
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
    }

    public void setAnnounceResult(DownloadAnnounceResult result) {
        this.download_manager.setAnnounceResult(result);
    }

    public void setScrapeResult(DownloadScrapeResult result) {
        this.download_manager.setScrapeResult(result);
    }

    public void stateChanged(DownloadManagerState state, DownloadManagerStateEvent event2) {
        final int type = event2.getType();
        if (type == 1 || type == 2) {
            String name = (String)event2.getData();
            List property_listeners_ref = this.property_listeners;
            final TorrentAttribute attr = this.convertAttribute(name);
            if (attr != null) {
                for (int i = 0; i < property_listeners_ref.size(); ++i) {
                    try {
                        ((DownloadPropertyListener)property_listeners_ref.get(i)).propertyChanged(this, new DownloadPropertyEvent(){

                            public int getType() {
                                return type == 1 ? 1 : 2;
                            }

                            public Object getData() {
                                return attr;
                            }
                        });
                        continue;
                    }
                    catch (Throwable e) {
                        Debug.printStackTrace(e);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPropertyListener(DownloadPropertyListener l) {
        try {
            this.tracker_listeners_mon.enter();
            ArrayList<DownloadPropertyListener> new_property_listeners = new ArrayList<DownloadPropertyListener>(this.property_listeners);
            new_property_listeners.add(l);
            this.property_listeners = new_property_listeners;
            if (this.property_listeners.size() == 1) {
                this.download_manager.getDownloadState().addListener(this);
            }
        }
        finally {
            this.tracker_listeners_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePropertyListener(DownloadPropertyListener l) {
        try {
            this.tracker_listeners_mon.enter();
            ArrayList new_property_listeners = new ArrayList(this.property_listeners);
            new_property_listeners.remove(l);
            this.property_listeners = new_property_listeners;
            if (this.property_listeners.size() == 0) {
                this.download_manager.getDownloadState().removeListener(this);
            }
        }
        finally {
            this.tracker_listeners_mon.exit();
        }
    }

    public void torrentChanged() {
        TRTrackerAnnouncer client = this.download_manager.getTrackerClient();
        if (client != null) {
            client.resetTrackerUrl(true);
        }
    }

    public void addTrackerListener(DownloadTrackerListener l) {
        this.addTrackerListener(l, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTrackerListener(DownloadTrackerListener l, boolean immediateTrigger) {
        try {
            this.tracker_listeners_mon.enter();
            ArrayList<DownloadTrackerListener> new_tracker_listeners = new ArrayList<DownloadTrackerListener>(this.tracker_listeners);
            new_tracker_listeners.add(l);
            this.tracker_listeners = new_tracker_listeners;
            if (this.tracker_listeners.size() == 1) {
                this.download_manager.addTrackerListener(this);
            }
        }
        finally {
            this.tracker_listeners_mon.exit();
        }
        if (immediateTrigger) {
            l.announceResult(this.last_announce_result);
            l.scrapeResult(this.last_scrape_result);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTrackerListener(DownloadTrackerListener l) {
        try {
            this.tracker_listeners_mon.enter();
            ArrayList new_tracker_listeners = new ArrayList(this.tracker_listeners);
            new_tracker_listeners.remove(l);
            this.tracker_listeners = new_tracker_listeners;
            if (this.tracker_listeners.size() == 0) {
                this.download_manager.removeTrackerListener(this);
            }
        }
        finally {
            this.tracker_listeners_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDownloadWillBeRemovedListener(DownloadWillBeRemovedListener l) {
        try {
            this.removal_listeners_mon.enter();
            ArrayList<DownloadWillBeRemovedListener> new_removal_listeners = new ArrayList<DownloadWillBeRemovedListener>(this.removal_listeners);
            new_removal_listeners.add(l);
            this.removal_listeners = new_removal_listeners;
        }
        finally {
            this.removal_listeners_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDownloadWillBeRemovedListener(DownloadWillBeRemovedListener l) {
        try {
            this.removal_listeners_mon.enter();
            ArrayList new_removal_listeners = new ArrayList(this.removal_listeners);
            new_removal_listeners.remove(l);
            this.removal_listeners = new_removal_listeners;
        }
        finally {
            this.removal_listeners_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPeerListener(DownloadPeerListener l) {
        try {
            this.peer_listeners_mon.enter();
            ArrayList<DownloadPeerListener> new_peer_listeners = new ArrayList<DownloadPeerListener>(this.peer_listeners);
            new_peer_listeners.add(l);
            this.peer_listeners = new_peer_listeners;
            if (this.peer_listeners.size() == 1) {
                this.download_manager.addPeerListener(this);
            }
        }
        finally {
            this.peer_listeners_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePeerListener(DownloadPeerListener l) {
        try {
            this.peer_listeners_mon.enter();
            ArrayList new_peer_listeners = new ArrayList(this.peer_listeners);
            new_peer_listeners.remove(l);
            this.peer_listeners = new_peer_listeners;
            if (this.peer_listeners.size() == 0) {
                this.download_manager.removePeerListener(this);
            }
        }
        finally {
            this.peer_listeners_mon.exit();
        }
    }

    public boolean activateRequest(final int count) {
        DownloadActivationEvent event2 = new DownloadActivationEvent(){

            public Download getDownload() {
                return DownloadImpl.this;
            }

            public int getActivationCount() {
                return count;
            }
        };
        Iterator it = this.activation_listeners.iterator();
        while (it.hasNext()) {
            try {
                DownloadActivationListener listener = (DownloadActivationListener)it.next();
                if (!listener.activationRequested(event2)) continue;
                return true;
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
        return false;
    }

    public DownloadActivationEvent getActivationState() {
        return this.activation_state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addActivationListener(DownloadActivationListener l) {
        try {
            this.peer_listeners_mon.enter();
            this.activation_listeners.add(l);
            if (this.activation_listeners.size() == 1) {
                this.download_manager.addActivationListener(this);
            }
        }
        finally {
            this.peer_listeners_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeActivationListener(DownloadActivationListener l) {
        try {
            this.peer_listeners_mon.enter();
            this.activation_listeners.remove(l);
            if (this.activation_listeners.size() == 0) {
                this.download_manager.removeActivationListener(this);
            }
        }
        finally {
            this.peer_listeners_mon.exit();
        }
    }

    public void peerManagerAdded(PEPeerManager manager) {
        if (this.peer_listeners.size() > 0) {
            PeerManagerImpl pm = PeerManagerImpl.getPeerManager(manager);
            for (int i = 0; i < this.peer_listeners.size(); ++i) {
                ((DownloadPeerListener)this.peer_listeners.get(i)).peerManagerAdded(this, pm);
            }
        }
    }

    public void peerManagerRemoved(PEPeerManager manager) {
        if (this.peer_listeners.size() > 0) {
            PeerManagerImpl pm = PeerManagerImpl.getPeerManager(manager);
            for (int i = 0; i < this.peer_listeners.size(); ++i) {
                ((DownloadPeerListener)this.peer_listeners.get(i)).peerManagerRemoved(this, pm);
            }
        }
    }

    public PeerManager getPeerManager() {
        PEPeerManager pm = this.download_manager.getPeerManager();
        if (pm == null) {
            return null;
        }
        return PeerManagerImpl.getPeerManager(pm);
    }

    public DiskManager getDiskManager() {
        PeerManager pm = this.getPeerManager();
        if (pm != null) {
            return pm.getDiskManager();
        }
        return null;
    }

    public org.gudy.azureus2.plugins.disk.DiskManagerFileInfo[] getDiskManagerFileInfo() {
        DiskManagerFileInfo[] info = this.download_manager.getDiskManagerFileInfo();
        if (info == null) {
            return new org.gudy.azureus2.plugins.disk.DiskManagerFileInfo[0];
        }
        org.gudy.azureus2.plugins.disk.DiskManagerFileInfo[] res = new org.gudy.azureus2.plugins.disk.DiskManagerFileInfo[info.length];
        for (int i = 0; i < res.length; ++i) {
            res[i] = new DiskManagerFileInfoImpl(this, info[i]);
        }
        return res;
    }

    public void peerAdded(PEPeer peer) {
    }

    public void peerRemoved(PEPeer peer) {
    }

    public void pieceAdded(PEPiece piece) {
    }

    public void pieceRemoved(PEPiece piece) {
    }

    public void setMaximumDownloadKBPerSecond(int kb) {
        this.download_manager.getStats().setDownloadRateLimitBytesPerSecond(kb < 0 ? 0 : kb * 1024);
    }

    public int getMaximumDownloadKBPerSecond() {
        return this.download_manager.getStats().getDownloadRateLimitBytesPerSecond() / 1024;
    }

    public int getUploadRateLimitBytesPerSecond() {
        return this.download_manager.getStats().getUploadRateLimitBytesPerSecond();
    }

    public void setUploadRateLimitBytesPerSecond(int max_rate_bps) {
        this.download_manager.getStats().setUploadRateLimitBytesPerSecond(max_rate_bps);
    }

    public int getSeedingRank() {
        return this.download_manager.getSeedingRank();
    }

    public void setSeedingRank(int rank) {
        this.download_manager.setSeedingRank(rank);
    }

    public String getSavePath() {
        return this.download_manager.getSaveLocation().toString();
    }

    public void moveDataFiles(File new_parent_dir) throws DownloadException {
        try {
            this.download_manager.moveDataFiles(new_parent_dir);
        }
        catch (DownloadManagerException e) {
            throw new DownloadException("move operation failed", e);
        }
    }

    public void renameDownload(String new_name) throws DownloadException {
        try {
            this.download_manager.renameDownload(new_name);
        }
        catch (DownloadManagerException e) {
            throw new DownloadException("rename operation failed", e);
        }
    }

    public void moveTorrentFile(File new_parent_dir) throws DownloadException {
        try {
            this.download_manager.moveTorrentFile(new_parent_dir);
        }
        catch (DownloadManagerException e) {
            throw new DownloadException("move operation failed", e);
        }
    }

    public void requestTrackerAnnounce() {
        this.download_manager.requestTrackerAnnounce(false);
    }

    public void requestTrackerAnnounce(boolean immediate) {
        this.download_manager.requestTrackerAnnounce(immediate);
    }

    public void requestTrackerScrape(boolean immediate) {
        this.download_manager.requestTrackerScrape(immediate);
    }

    public byte[] getDownloadPeerId() {
        TRTrackerAnnouncer announcer = this.download_manager.getTrackerClient();
        if (announcer == null) {
            return null;
        }
        return announcer.getPeerId();
    }

    public boolean isMessagingEnabled() {
        return this.download_manager.isAZMessagingEnabled();
    }

    public void setMessagingEnabled(boolean enabled) {
        this.download_manager.setAZMessagingEnabled(enabled);
    }

    public void setSessionAuthenticator(SessionAuthenticator auth) {
    }

    public int getPriority() {
        return 0;
    }

    public boolean isPriorityLocked() {
        return false;
    }

    public void setPriority(int priority) {
    }

    public String getRelationText() {
        return this.propogatedRelationText(this.download_manager);
    }

    public Object[] getQueryableInterfaces() {
        return new Object[]{this.download_manager};
    }
}

