/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.AEThread;
import org.gudy.azureus2.core3.util.NonDaemonTask;

public class NonDaemonTaskRunner {
    public static final int LINGER_PERIOD = 2500;
    protected static NonDaemonTaskRunner singleton;
    protected static AEMonitor class_mon;
    protected Stack tasks = new Stack();
    protected AEMonitor tasks_mon = new AEMonitor("NonDaemonTaskRunner:tasks");
    protected AESemaphore task_sem = new AESemaphore("NonDaemonTaskRunner");
    protected List wait_until_idle_list = new ArrayList();
    protected Thread current_thread;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static NonDaemonTaskRunner getSingleton() {
        try {
            class_mon.enter();
            if (singleton == null) {
                singleton = new NonDaemonTaskRunner();
            }
            NonDaemonTaskRunner nonDaemonTaskRunner = singleton;
            return nonDaemonTaskRunner;
        }
        finally {
            class_mon.exit();
        }
    }

    public static Object run(NonDaemonTask target) throws Throwable {
        return NonDaemonTaskRunner.getSingleton().runSupport(target, false);
    }

    public static Object runAsync(NonDaemonTask target) throws Throwable {
        return NonDaemonTaskRunner.getSingleton().runSupport(target, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object runSupport(NonDaemonTask target, boolean async) throws Throwable {
        if (this.current_thread == Thread.currentThread()) {
            return target.run();
        }
        taskWrapper wrapper2 = new taskWrapper(target);
        try {
            this.tasks_mon.enter();
            this.tasks.push(wrapper2);
            this.task_sem.release();
            if (this.current_thread == null) {
                final AESemaphore wait_sem = new AESemaphore("NonDaemonTaskRunnerTask");
                this.current_thread = new AEThread("NonDaemonTaskRunner"){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void runSupport() {
                        wait_sem.release();
                        while (true) {
                            NonDaemonTaskRunner.this.task_sem.reserve(2500L);
                            taskWrapper t = null;
                            try {
                                NonDaemonTaskRunner.this.tasks_mon.enter();
                                if (NonDaemonTaskRunner.this.tasks.isEmpty()) {
                                    NonDaemonTaskRunner.this.current_thread = null;
                                    for (int i = 0; i < NonDaemonTaskRunner.this.wait_until_idle_list.size(); ++i) {
                                        ((AESemaphore)NonDaemonTaskRunner.this.wait_until_idle_list.get(i)).release();
                                    }
                                    NonDaemonTaskRunner.this.wait_until_idle_list.clear();
                                    break;
                                }
                                t = (taskWrapper)NonDaemonTaskRunner.this.tasks.pop();
                            }
                            finally {
                                NonDaemonTaskRunner.this.tasks_mon.exit();
                            }
                            t.run();
                        }
                    }
                };
                this.current_thread.setDaemon(false);
                this.current_thread.start();
                wait_sem.reserve();
            }
        }
        finally {
            this.tasks_mon.exit();
        }
        if (async) {
            return null;
        }
        return wrapper2.waitForResult();
    }

    public static void waitUntilIdle() {
        NonDaemonTaskRunner.getSingleton().waitUntilIdleSupport();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void waitUntilIdleSupport() {
        AESemaphore sem;
        try {
            this.tasks_mon.enter();
            if (this.current_thread == null) {
                return;
            }
            sem = new AESemaphore("NDTR::idleWaiter");
            this.wait_until_idle_list.add(sem);
        }
        finally {
            this.tasks_mon.exit();
        }
        sem.reserve();
    }

    static {
        class_mon = new AEMonitor("NonDaemonTaskRunner:class");
    }

    protected class taskWrapper {
        protected NonDaemonTask task;
        protected AESemaphore sem;
        protected Object result;
        protected Throwable exception;

        protected taskWrapper(NonDaemonTask _task) {
            this.task = _task;
            this.sem = new AESemaphore("NonDaemonTaskRunner::taskWrapper");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void run() {
            try {
                this.result = this.task.run();
            }
            catch (Throwable e) {
                this.exception = e;
            }
            finally {
                this.sem.release();
            }
        }

        protected Object waitForResult() throws Throwable {
            this.sem.reserve();
            if (this.exception != null) {
                throw this.exception;
            }
            return this.result;
        }
    }
}

