/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.peer;

import com.aelitis.azureus.core.peermanager.unchoker.HistoricalDataPoint;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.LinkedList;
import java.util.Locale;
import org.gudy.azureus2.core3.peer.PEPeer;
import org.gudy.azureus2.core3.peer.impl.transport.PEPeerTransportProtocol;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TyrantStats {
    public static String TYRANT_HOMEPAGE_URL = "http://bittyrant.cs.washington.edu";
    public static String TYRANT_GUI_TEXT_STRING = "BitTyrant";
    PEPeer mPeer = null;
    double last_observed_download = 0.0;
    double last_upload_cost = 0.0;
    long last_offered_update_time = 0L;
    long last_download_update_time = 0L;
    long last_choked_time = 0L;
    String ipPort = null;
    ArrayList<String> logEntries = new ArrayList();
    LinkedList<HistoricalDataPoint> history = new LinkedList();
    public static String DEFAULT_ALLOCATION = "No peer history.  The peer got a default upload allocation.";
    long lastUploadAllocation = 0L;
    private String lastTyrantAction = "";

    public TyrantStats(PEPeer inPeer) {
        this.mPeer = inPeer;
        this.ipPort = ((PEPeerTransportProtocol)inPeer).getIp() + ":" + ((PEPeerTransportProtocol)inPeer).getPort();
    }

    public void fileLog(long timeStamp) {
        StringBuilder sb = new StringBuilder();
        Formatter fmt = new Formatter(sb, Locale.US);
        fmt.format("%s %d %d %d %d %d %c %c %c %c %f %f %d", this.ipPort, timeStamp, this.mPeer.getStats().getTotalDataBytesSent() / 1024L, this.mPeer.getStats().getTotalDataBytesReceived() / 1024L, this.mPeer.getStats().getDataSendRate() / 1024L, this.mPeer.getStats().getDataReceiveRate() / 1024L, Character.valueOf(this.mPeer.isChokedByMe() ? (char)'y' : 'n'), Character.valueOf(this.mPeer.isChokingMe() ? (char)'y' : 'n'), Character.valueOf(this.mPeer.isInterested() ? (char)'y' : 'n'), Character.valueOf(this.mPeer.isInteresting() ? (char)'y' : 'n'), this.downloadRate(), this.getUploadCost(), this.lastChoked());
        this.logEntries.add(sb.toString());
    }

    public ArrayList<String> getLog() {
        return this.logEntries;
    }

    public double active_size() {
        long inRate = this.mPeer.getStats().getEstimatedUploadRateOfPeer();
        if (inRate < 11L) {
            return 2.0;
        }
        if (inRate < 35L) {
            return 3.0;
        }
        if (inRate < 80L) {
            return 4.0;
        }
        if (inRate < 200L) {
            return 5.0;
        }
        if (inRate < 350L) {
            return 6.0;
        }
        if (inRate < 600L) {
            return 7.0;
        }
        if (inRate < 900L) {
            return 8.0;
        }
        return 9.0;
    }

    public double downloadRate() {
        return this.last_observed_download;
    }

    public double getUploadCost() {
        return this.last_upload_cost;
    }

    public void updateOfferedRate(double inRate) {
        this.last_upload_cost = inRate;
        this.last_offered_update_time = System.currentTimeMillis();
    }

    public void updateDownloadRate() {
        this.last_observed_download = (double)this.mPeer.getStats().getSmoothDataReceiveRate() / 1024.0;
        this.last_download_update_time = System.currentTimeMillis();
    }

    public long getLastDownloadUpdate() {
        return this.last_download_update_time;
    }

    public void updateLastChokedTime() {
        this.last_choked_time = System.currentTimeMillis();
    }

    public long lastChoked() {
        return this.last_choked_time;
    }

    public double ratio(double market_rate) {
        double d1 = this.downloadRate() == 0.0 ? (double)this.mPeer.getStats().getSmoothDataReceiveRate() / 1024.0 / this.active_size() : this.downloadRate();
        double u1 = this.getUploadCost() == 0.0 ? market_rate : this.getUploadCost();
        return d1 / u1;
    }

    public boolean hasObservedInfo() {
        return this.last_observed_download != 0.0 && this.last_upload_cost != 0.0;
    }

    public long getLastUploadAllocation() {
        return this.lastUploadAllocation;
    }

    public void setLastUploadAllocation(long allocation) {
        this.lastUploadAllocation = allocation;
    }

    public void updateHistory(HistoricalDataPoint now) {
        long time = System.currentTimeMillis();
        while (this.history.size() > 0 && this.history.peek().getTimestamp() + 60000L < time) {
            this.history.removeFirst();
        }
        this.history.addLast(now);
    }

    public long getDataBytesReceivedInTheLast(long sec) {
        if (this.history.size() == 0) {
            return 0L;
        }
        long start = System.currentTimeMillis() - sec * 1000L;
        for (HistoricalDataPoint point : this.history) {
            if (point.getTimestamp() <= start) continue;
            return this.history.getLast().getDataReceivedFromPeer() - point.getDataReceivedFromPeer();
        }
        return 0L;
    }

    public long getDataBytesSentInTheLast(long sec) {
        if (this.history.size() == 0) {
            return 0L;
        }
        long start = System.currentTimeMillis() - sec * 1000L;
        for (HistoricalDataPoint point : this.history) {
            if (point.getTimestamp() <= start) continue;
            return this.history.getLast().getDataSentToPeer() - point.getDataSentToPeer();
        }
        return 0L;
    }

    public double getBytesReceivedOverBytesSentRatioInTheLast(long sec) {
        long sent = this.getDataBytesSentInTheLast(sec * 1000L);
        long received = this.getDataBytesReceivedInTheLast(sec * 1000L);
        if (sent == 0L) {
            if (received > 0L) {
                return Double.MAX_VALUE;
            }
            return 1.0;
        }
        return (double)received / (double)sent;
    }

    public String getLastTyrantAction() {
        if (this.mPeer != null && this.mPeer.isSeed()) {
            return "Peer is a seed";
        }
        return this.lastTyrantAction;
    }

    public void setLastTyrantAction(String lastTyrantAction) {
        this.lastTyrantAction = lastTyrantAction;
    }
}

