/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.disk.impl;

import com.aelitis.azureus.core.diskmanager.access.DiskAccessController;
import com.aelitis.azureus.core.diskmanager.access.DiskAccessControllerFactory;
import com.aelitis.azureus.core.diskmanager.cache.CacheFile;
import com.aelitis.azureus.core.diskmanager.cache.CacheFileManagerException;
import com.aelitis.azureus.core.diskmanager.cache.CacheFileManagerFactory;
import com.aelitis.azureus.core.diskmanager.cache.CacheFileOwner;
import com.aelitis.azureus.core.diskmanager.file.FMFileManagerFactory;
import com.aelitis.azureus.core.util.CaseSensitiveFileMap;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.disk.DiskManager;
import org.gudy.azureus2.core3.disk.DiskManagerCheckRequest;
import org.gudy.azureus2.core3.disk.DiskManagerCheckRequestListener;
import org.gudy.azureus2.core3.disk.DiskManagerFileInfo;
import org.gudy.azureus2.core3.disk.DiskManagerFileInfoListener;
import org.gudy.azureus2.core3.disk.DiskManagerListener;
import org.gudy.azureus2.core3.disk.DiskManagerPiece;
import org.gudy.azureus2.core3.disk.DiskManagerReadRequest;
import org.gudy.azureus2.core3.disk.DiskManagerReadRequestListener;
import org.gudy.azureus2.core3.disk.DiskManagerWriteRequest;
import org.gudy.azureus2.core3.disk.DiskManagerWriteRequestListener;
import org.gudy.azureus2.core3.disk.impl.DiskManagerAllocationScheduler;
import org.gudy.azureus2.core3.disk.impl.DiskManagerFileInfoHelper;
import org.gudy.azureus2.core3.disk.impl.DiskManagerFileInfoImpl;
import org.gudy.azureus2.core3.disk.impl.DiskManagerHelper;
import org.gudy.azureus2.core3.disk.impl.DiskManagerPieceImpl;
import org.gudy.azureus2.core3.disk.impl.DiskManagerRecheckScheduler;
import org.gudy.azureus2.core3.disk.impl.access.DMAccessFactory;
import org.gudy.azureus2.core3.disk.impl.access.DMChecker;
import org.gudy.azureus2.core3.disk.impl.access.DMReader;
import org.gudy.azureus2.core3.disk.impl.access.DMWriter;
import org.gudy.azureus2.core3.disk.impl.piecemapper.DMPieceList;
import org.gudy.azureus2.core3.disk.impl.piecemapper.DMPieceMapEntry;
import org.gudy.azureus2.core3.disk.impl.piecemapper.DMPieceMapper;
import org.gudy.azureus2.core3.disk.impl.piecemapper.DMPieceMapperFactory;
import org.gudy.azureus2.core3.disk.impl.piecemapper.DMPieceMapperFile;
import org.gudy.azureus2.core3.disk.impl.resume.RDResumeHandler;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.download.DownloadManagerState;
import org.gudy.azureus2.core3.internat.LocaleTorrentUtil;
import org.gudy.azureus2.core3.internat.LocaleUtilDecoder;
import org.gudy.azureus2.core3.internat.LocaleUtilEncodingException;
import org.gudy.azureus2.core3.logging.LogAlert;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.LogRelation;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.TOTorrentException;
import org.gudy.azureus2.core3.torrent.TOTorrentFile;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.AEThread;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DirectByteBuffer;
import org.gudy.azureus2.core3.util.DirectByteBufferPool;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.core3.util.ListenerManager;
import org.gudy.azureus2.core3.util.ListenerManagerDispatcher;
import org.gudy.azureus2.core3.util.ThreadPool;
import org.gudy.azureus2.core3.util.TorrentUtils;
import org.gudy.azureus2.platform.PlatformManager;
import org.gudy.azureus2.platform.PlatformManagerCapabilities;
import org.gudy.azureus2.platform.PlatformManagerFactory;
import org.gudy.azureus2.plugins.platform.PlatformManagerException;

public class DiskManagerImpl
extends LogRelation
implements DiskManagerHelper {
    private static final LogIDs LOGID = LogIDs.DISK;
    private static DiskAccessController disk_access_controller;
    private static DiskManagerRecheckScheduler recheck_scheduler;
    private static DiskManagerAllocationScheduler allocation_scheduler;
    private static ThreadPool start_pool;
    private static AEMonitor cache_read_mon;
    private boolean used = false;
    private boolean started = false;
    private AESemaphore started_sem = new AESemaphore("DiskManager::started");
    private boolean starting;
    private boolean stopping;
    private int state_set_via_method;
    protected String errorMessage = "";
    private int pieceLength;
    private int lastPieceLength;
    private int nbPieces;
    private long totalLength;
    private int percentDone;
    private long allocated;
    private long remaining;
    private TOTorrent torrent;
    private DMReader reader;
    private DMChecker checker;
    private DMWriter writer;
    private RDResumeHandler resume_handler;
    private DMPieceMapper piece_mapper;
    private DiskManagerPieceImpl[] pieces;
    private DMPieceList[] pieceMap;
    private DiskManagerFileInfoImpl[] files;
    protected DownloadManager download_manager;
    private boolean alreadyMoved = false;
    private boolean skipped_file_set_changed = true;
    private long skipped_file_set_size;
    private long skipped_but_downloaded;
    private static final int LDT_STATECHANGED = 1;
    private static final int LDT_PRIOCHANGED = 2;
    private static final int LDT_PIECE_DONE_CHANGED = 3;
    private static final int LDT_ACCESS_MODE_CHANGED = 4;
    protected static ListenerManager listeners_aggregator;
    private ListenerManager listeners = ListenerManager.createManager("DiskM:ListenDispatcher", new ListenerManagerDispatcher(){

        public void dispatch(Object listener, int type, Object value) {
            listeners_aggregator.dispatch(listener, type, value);
        }
    });
    private AEMonitor start_stop_mon = new AEMonitor("DiskManager:startStop");
    private AEMonitor file_piece_mon = new AEMonitor("DiskManager:filePiece");
    protected static int max_read_block_size;

    public DiskManagerImpl(TOTorrent _torrent, DownloadManager _dmanager) {
        this.torrent = _torrent;
        this.download_manager = _dmanager;
        this.pieces = new DiskManagerPieceImpl[0];
        this.setState(1);
        this.percentDone = 0;
        if (this.torrent == null) {
            this.errorMessage = "Torrent not available";
            this.setState(10);
            return;
        }
        LocaleUtilDecoder locale_decoder = null;
        try {
            locale_decoder = LocaleTorrentUtil.getTorrentEncoding(this.torrent);
        }
        catch (TOTorrentException e) {
            Debug.printStackTrace(e);
            this.errorMessage = TorrentUtils.exceptionToText(e);
            this.setState(10);
            return;
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
            this.errorMessage = "Initialisation failed - " + Debug.getNestedExceptionMessage(e);
            this.setState(10);
            return;
        }
        this.piece_mapper = DMPieceMapperFactory.create(this.torrent);
        try {
            this.piece_mapper.construct(locale_decoder, this.download_manager.getAbsoluteSaveLocation().getName());
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
            this.errorMessage = "Failed to build piece map - " + Debug.getNestedExceptionMessage(e);
            this.setState(10);
            return;
        }
        this.remaining = this.totalLength = this.piece_mapper.getTotalLength();
        this.nbPieces = this.torrent.getNumberOfPieces();
        this.pieceLength = (int)this.torrent.getPieceLength();
        this.lastPieceLength = this.piece_mapper.getLastPieceLength();
        this.pieces = new DiskManagerPieceImpl[this.nbPieces];
        for (int i = 0; i < this.nbPieces; ++i) {
            this.pieces[i] = new DiskManagerPieceImpl(this, i);
        }
        this.reader = DMAccessFactory.createReader(this);
        this.checker = DMAccessFactory.createChecker(this);
        this.writer = DMAccessFactory.createWriter(this);
        this.resume_handler = new RDResumeHandler(this, this.checker);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        try {
            this.start_stop_mon.enter();
            if (this.used) {
                Debug.out("DiskManager reuse not supported!!!!");
            }
            this.used = true;
            if (this.getState() == 10) {
                Debug.out("starting a faulty disk manager");
                return;
            }
            this.started = true;
            this.starting = true;
            start_pool.run(new AERunnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void runSupport() {
                    boolean stop_required;
                    try {
                        try {
                            DiskManagerImpl.this.start_stop_mon.enter();
                            if (DiskManagerImpl.this.stopping) {
                                throw new Exception("Stopped during startup");
                            }
                        }
                        finally {
                            DiskManagerImpl.this.start_stop_mon.exit();
                        }
                        DiskManagerImpl.this.startSupport();
                    }
                    catch (Throwable e) {
                        DiskManagerImpl.this.errorMessage = Debug.getNestedExceptionMessage(e) + " (start)";
                        DiskManagerImpl.this.setState(10);
                    }
                    finally {
                        DiskManagerImpl.this.started_sem.release();
                    }
                    try {
                        DiskManagerImpl.this.start_stop_mon.enter();
                        stop_required = DiskManagerImpl.this.getState() == 10 || DiskManagerImpl.this.stopping;
                        DiskManagerImpl.this.starting = false;
                    }
                    finally {
                        DiskManagerImpl.this.start_stop_mon.exit();
                    }
                    if (stop_required) {
                        DiskManagerImpl.this.stop(false);
                    }
                }
            });
        }
        finally {
            this.start_stop_mon.exit();
        }
    }

    private void startSupport() {
        boolean moveWhenDone = COConfigurationManager.getBooleanParameter("Move Completed When Done", false);
        String moveToDir = COConfigurationManager.getStringParameter("Completed Files Directory", "");
        if (moveWhenDone && moveToDir.length() > 0 && this.download_manager.isPersistent() && this.filesExist(moveToDir)) {
            this.alreadyMoved = true;
            this.download_manager.setTorrentSaveDir(moveToDir);
        }
        this.reader.start();
        this.checker.start();
        this.writer.start();
        int newFiles = this.allocateFiles();
        if (this.getState() == 10) {
            return;
        }
        this.pieceMap = this.piece_mapper.getPieceMap();
        this.constructFilesPieces();
        if (this.getState() == 10) {
            return;
        }
        this.setState(3);
        this.resume_handler.start();
        if (newFiles == 0) {
            this.resume_handler.checkAllPieces(false);
        } else if (newFiles != this.files.length) {
            this.resume_handler.checkAllPieces(true);
        }
        if (this.getState() == 10) {
            return;
        }
        this.setState(4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(boolean closing) {
        try {
            this.start_stop_mon.enter();
            if (!this.started) {
                return;
            }
            if (this.starting) {
                this.stopping = true;
                this.checker.stop();
                this.writer.stop();
                this.reader.stop();
                this.resume_handler.stop(closing);
                this.saveState(false);
                return;
            }
            this.started = false;
            this.stopping = false;
        }
        finally {
            this.start_stop_mon.exit();
        }
        this.started_sem.reserve();
        this.checker.stop();
        this.writer.stop();
        this.reader.stop();
        this.resume_handler.stop(closing);
        if (this.files != null) {
            for (int i = 0; i < this.files.length; ++i) {
                try {
                    if (this.files[i] == null) continue;
                    this.files[i].getCacheFile().close();
                    continue;
                }
                catch (Throwable e) {
                    this.setFailed("File close fails: " + Debug.getNestedExceptionMessage(e));
                }
            }
        }
        if (this.getState() == 4) {
            try {
                this.saveResumeData(false);
            }
            catch (Exception e) {
                this.setFailed("Resume data save fails: " + Debug.getNestedExceptionMessage(e));
            }
        }
        this.saveState();
        this.listeners.clear();
    }

    public boolean filesExist() {
        return this.filesExist(this.download_manager.getAbsoluteSaveLocation().getParent());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    protected boolean filesExist(String root_dir) {
        if (!this.torrent.isSimpleTorrent()) {
            root_dir = root_dir + File.separator + this.download_manager.getAbsoluteSaveLocation().getName();
        }
        if (!root_dir.endsWith(File.separator)) {
            root_dir = root_dir + File.separator;
        }
        DMPieceMapperFile[] pm_files = this.piece_mapper.getFiles();
        String[] storage_types = this.getStorageTypes();
        for (int i = 0; i < pm_files.length; ++i) {
            DMPieceMapperFile pm_info = pm_files[i];
            File relative_file = pm_info.getDataFile();
            long target_length = pm_info.getLength();
            DiskManagerFileInfoImpl file_info = pm_info.getFileInfo();
            boolean close_it = false;
            try {
                if (file_info == null) {
                    boolean linear = storage_types[i].equals("L");
                    file_info = new DiskManagerFileInfoImpl(this, new File(root_dir + relative_file.toString()), i, pm_info.getTorrentFile(), linear);
                    close_it = true;
                }
                try {
                    CacheFile cache_file = file_info.getCacheFile();
                    File data_file = file_info.getFile(true);
                    if (!cache_file.exists()) {
                        File parent;
                        File current = data_file;
                        while (!current.exists() && (parent = current.getParentFile()) != null) {
                            if (parent.exists()) {
                                this.errorMessage = parent.isDirectory() ? current.toString() + " not found." : parent.toString() + " is not a directory.";
                                boolean bl = false;
                                return bl;
                            }
                            current = parent;
                        }
                        this.errorMessage = data_file.toString() + " not found.";
                        boolean bl = false;
                        return bl;
                    }
                    long existing_length = file_info.getCacheFile().getLength();
                    if (existing_length <= target_length) continue;
                    if (COConfigurationManager.getBooleanParameter("File.truncate.if.too.large")) {
                        file_info.setAccessMode(2);
                        file_info.getCacheFile().setLength(target_length);
                        Debug.out("Existing data file length too large [" + existing_length + ">" + target_length + "]: " + data_file.getAbsolutePath() + ", truncating");
                        continue;
                    }
                    this.errorMessage = "Existing data file length too large [" + existing_length + ">" + target_length + "]: " + data_file.getAbsolutePath();
                    boolean bl = false;
                    return bl;
                }
                finally {
                    if (close_it) {
                        file_info.getCacheFile().close();
                    }
                }
            }
            catch (Throwable e) {
                this.errorMessage = Debug.getNestedExceptionMessage(e) + " (filesExist:" + relative_file.toString() + ")";
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int allocateFiles() {
        HashSet<String> file_set = new HashSet<String>();
        DMPieceMapperFile[] pm_files = this.piece_mapper.getFiles();
        DiskManagerFileInfoImpl[] allocated_files = new DiskManagerFileInfoImpl[pm_files.length];
        try {
            allocation_scheduler.register(this);
            this.setState(2);
            this.allocated = 0L;
            int numNewFiles = 0;
            String root_dir = this.download_manager.getAbsoluteSaveLocation().getParent();
            if (!this.torrent.isSimpleTorrent()) {
                root_dir = root_dir + File.separator + this.download_manager.getAbsoluteSaveLocation().getName();
            }
            root_dir = root_dir + File.separator;
            String[] storage_types = this.getStorageTypes();
            for (int i = 0; i < pm_files.length; ++i) {
                DiskManagerFileInfoImpl fileInfo2;
                DMPieceMapperFile pm_info = pm_files[i];
                long target_length = pm_info.getLength();
                File relative_data_file = pm_info.getDataFile();
                try {
                    boolean linear = storage_types[i].equals("L");
                    allocated_files[i] = fileInfo2 = new DiskManagerFileInfoImpl(this, new File(root_dir + relative_data_file.toString()), i, pm_info.getTorrentFile(), linear);
                    pm_info.setFileInfo(fileInfo2);
                }
                catch (CacheFileManagerException e) {
                    this.errorMessage = Debug.getNestedExceptionMessage(e) + " (allocateFiles:" + relative_data_file.toString() + ")";
                    this.setState(10);
                    int n = -1;
                    allocation_scheduler.unregister(this);
                    if (this.files == null) {
                        for (int i2 = 0; i2 < allocated_files.length; ++i2) {
                            if (allocated_files[i2] == null) continue;
                            try {
                                allocated_files[i2].getCacheFile().close();
                                continue;
                            }
                            catch (Throwable e2) {
                                // empty catch block
                            }
                        }
                    }
                    return n;
                }
                CacheFile cache_file = fileInfo2.getCacheFile();
                File data_file = fileInfo2.getFile(true);
                String data_file_name = data_file.getName();
                String file_key = data_file.getAbsolutePath();
                if (Constants.isWindows) {
                    file_key = file_key.toLowerCase();
                }
                if (file_set.contains(file_key)) {
                    this.errorMessage = "File occurs more than once in download: " + data_file.toString();
                    this.setState(10);
                    int n = -1;
                    return n;
                }
                file_set.add(file_key);
                int separator = data_file_name.lastIndexOf(".");
                if (separator == -1) {
                    separator = 0;
                }
                fileInfo2.setExtension(data_file_name.substring(separator));
                String extensions = COConfigurationManager.getStringParameter("priorityExtensions", "");
                if (!extensions.equals("")) {
                    boolean bIgnoreCase = COConfigurationManager.getBooleanParameter("priorityExtensionsIgnoreCase");
                    StringTokenizer st = new StringTokenizer(extensions, ";");
                    while (st.hasMoreTokens()) {
                        boolean bHighPriority;
                        String extension = st.nextToken();
                        if (!(extension = extension.trim()).startsWith(".")) {
                            extension = "." + extension;
                        }
                        if (!(bHighPriority = bIgnoreCase ? fileInfo2.getExtension().equalsIgnoreCase(extension) : fileInfo2.getExtension().equals(extension))) continue;
                        fileInfo2.setPriority(true);
                    }
                }
                fileInfo2.setLength(target_length);
                fileInfo2.setDownloaded(0L);
                if (cache_file.exists()) {
                    block64: {
                        try {
                            long existing_length = fileInfo2.getCacheFile().getLength();
                            if (existing_length <= target_length) break block64;
                            if (COConfigurationManager.getBooleanParameter("File.truncate.if.too.large")) {
                                fileInfo2.setAccessMode(2);
                                cache_file.setLength(target_length);
                                Debug.out("Existing data file length too large [" + existing_length + ">" + target_length + "]: " + data_file.getAbsolutePath() + ", truncating");
                                break block64;
                            }
                            this.errorMessage = "Existing data file length too large [" + existing_length + ">" + target_length + "]: " + data_file.getAbsolutePath();
                            this.setState(10);
                            int extension = -1;
                            return extension;
                        }
                        catch (CacheFileManagerException e) {
                            this.errorMessage = Debug.getNestedExceptionMessage(e) + " (allocateFiles existing:" + data_file.getAbsolutePath() + ")";
                            this.setState(10);
                            int st = -1;
                            allocation_scheduler.unregister(this);
                            if (this.files == null) {
                                for (int i3 = 0; i3 < allocated_files.length; ++i3) {
                                    if (allocated_files[i3] == null) continue;
                                    try {
                                        allocated_files[i3].getCacheFile().close();
                                        continue;
                                    }
                                    catch (Throwable e3) {
                                        // empty catch block
                                    }
                                }
                            }
                            return st;
                        }
                    }
                    fileInfo2.setAccessMode(1);
                    this.allocated += target_length;
                    continue;
                }
                if (this.download_manager.isDataAlreadyAllocated()) {
                    this.errorMessage = "Data file missing: " + data_file.getAbsolutePath();
                    this.setState(10);
                    int e = -1;
                    return e;
                }
                while (this.started && !allocation_scheduler.getPermission(this)) {
                }
                if (!this.started) {
                    int e = -1;
                    return e;
                }
                fileInfo2.setAccessMode(2);
                if (COConfigurationManager.getBooleanParameter("Enable incremental file creation")) {
                    fileInfo2.getCacheFile().setLength(0L);
                } else if (COConfigurationManager.getBooleanParameter("Zero New")) {
                    if (!this.writer.zeroFile(fileInfo2, target_length)) {
                        try {
                            fileInfo2.getCacheFile().close();
                            fileInfo2.getCacheFile().delete();
                        }
                        catch (Throwable e) {
                            // empty catch block
                        }
                        this.setState(10);
                        int e = -1;
                        return e;
                    }
                } else {
                    try {
                        fileInfo2.getCacheFile().setLength(target_length);
                        this.allocated += target_length;
                    }
                    catch (Exception e) {
                        this.errorMessage = Debug.getNestedExceptionMessage(e) + " (allocateFiles new:" + data_file.toString() + ")";
                        this.setState(10);
                        int n = -1;
                        return n;
                    }
                }
                ++numNewFiles;
            }
            this.files = allocated_files;
            this.loadFilePriorities();
            this.download_manager.setDataAlreadyAllocated(true);
            int n = numNewFiles;
            return n;
        }
        finally {
            allocation_scheduler.unregister(this);
            if (this.files == null) {
                for (int i = 0; i < allocated_files.length; ++i) {
                    if (allocated_files[i] == null) continue;
                    try {
                        allocated_files[i].getCacheFile().close();
                        continue;
                    }
                    catch (Throwable e) {}
                }
            }
        }
    }

    public DiskAccessController getDiskAccessController() {
        return disk_access_controller;
    }

    public void enqueueReadRequest(DiskManagerReadRequest request2, DiskManagerReadRequestListener listener) {
        this.reader.readBlock(request2, listener);
    }

    public int getNbPieces() {
        return this.nbPieces;
    }

    public int getPercentDone() {
        return this.percentDone;
    }

    public void setPercentDone(int num) {
        this.percentDone = num;
    }

    public long getRemaining() {
        return this.remaining;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getRemainingExcludingDND() {
        long rem;
        DiskManagerFileInfoImpl[] current_files;
        if (this.skipped_file_set_changed && (current_files = this.files) != null) {
            this.skipped_file_set_changed = false;
            try {
                this.file_piece_mon.enter();
                this.skipped_file_set_size = 0L;
                this.skipped_but_downloaded = 0L;
                for (int i = 0; i < current_files.length; ++i) {
                    DiskManagerFileInfoImpl file = current_files[i];
                    if (!file.isSkipped()) continue;
                    this.skipped_file_set_size += file.getLength();
                    this.skipped_but_downloaded += file.getDownloaded();
                }
            }
            finally {
                this.file_piece_mon.exit();
            }
        }
        if ((rem = this.remaining - (this.skipped_file_set_size - this.skipped_but_downloaded)) < 0L) {
            rem = 0L;
        }
        return rem;
    }

    public long getAllocated() {
        return this.allocated;
    }

    public void setAllocated(long num) {
        this.allocated = num;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setPieceDone(DiskManagerPieceImpl dmPiece, boolean done) {
        int piece_number = dmPiece.getPieceNumber();
        int piece_length = dmPiece.getLength();
        DMPieceList piece_list = this.pieceMap[piece_number];
        try {
            this.file_piece_mon.enter();
            if (dmPiece.isDone() != done) {
                dmPiece.setDoneSupport(done);
                this.remaining = done ? (this.remaining -= (long)piece_length) : (this.remaining += (long)piece_length);
                for (int i = 0; i < piece_list.size(); ++i) {
                    long file_done;
                    DMPieceMapEntry piece_map_entry = piece_list.get(i);
                    DiskManagerFileInfoImpl this_file = piece_map_entry.getFile();
                    long file_length = this_file.getLength();
                    long file_done_before = file_done = this_file.getDownloaded();
                    file_done = done ? (file_done += (long)piece_map_entry.getLength()) : (file_done -= (long)piece_map_entry.getLength());
                    if (file_done < 0L) {
                        Debug.out("piece map entry length negative");
                        file_done = 0L;
                    } else if (file_done > file_length) {
                        Debug.out("piece map entry length too large");
                        file_done = file_length;
                    }
                    if (this_file.isSkipped()) {
                        this.skipped_but_downloaded += file_done - file_done_before;
                    }
                    this_file.setDownloaded(file_done);
                    if (file_done != file_length || this_file.getAccessMode() != 2) continue;
                    try {
                        this_file.setAccessMode(1);
                        continue;
                    }
                    catch (Exception e) {
                        this.setFailed("Disk access error - " + Debug.getNestedExceptionMessage(e));
                        Debug.printStackTrace(e);
                    }
                }
                this.listeners.dispatch(3, dmPiece);
            }
        }
        finally {
            this.file_piece_mon.exit();
        }
    }

    public void accessModeChanged(DiskManagerFileInfoImpl file, int old_mode, int new_mode) {
        this.listeners.dispatch(4, new Object[]{file, new Integer(old_mode), new Integer(new_mode)});
    }

    public DiskManagerPiece[] getPieces() {
        return this.pieces;
    }

    public DiskManagerPiece getPiece(int PieceNumber) {
        return this.pieces[PieceNumber];
    }

    public int getPieceLength() {
        return this.pieceLength;
    }

    public long getTotalLength() {
        return this.totalLength;
    }

    public int getLastPieceLength() {
        return this.lastPieceLength;
    }

    public int getState() {
        return this.state_set_via_method;
    }

    protected void setState(int _state) {
        if (this.state_set_via_method == 10) {
            if (_state != 10) {
                Debug.out("DiskManager: attempt to move from faulty state to " + _state);
            }
            return;
        }
        if (this.state_set_via_method != _state) {
            int[] params = new int[]{this.state_set_via_method, _state};
            this.state_set_via_method = _state;
            this.listeners.dispatch(1, params);
        }
    }

    public DiskManagerFileInfo[] getFiles() {
        return this.files;
    }

    private void constructFilesPieces() {
        for (int i = 0; i < this.pieceMap.length; ++i) {
            DMPieceList pieceList = this.pieceMap[i];
            for (int j = 0; j < pieceList.size(); ++j) {
                DiskManagerFileInfoImpl fileInfo2 = pieceList.get(j).getFile();
                if (fileInfo2.getFirstPieceNumber() == -1) {
                    fileInfo2.setFirstPieceNumber(i);
                }
                fileInfo2.setNbPieces(fileInfo2.getNbPieces() + 1);
            }
        }
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setFailed(final String reason) {
        new AEThread("DiskManager:setFailed"){

            public void runSupport() {
                DiskManagerImpl.this.errorMessage = reason;
                Logger.log(new LogAlert(false, 3, DiskManagerImpl.this.errorMessage));
                DiskManagerImpl.this.setState(10);
                DiskManagerImpl.this.stop(false);
            }
        }.start();
    }

    public void setFailed(final DiskManagerFileInfo file, final String reason) {
        new AEThread("DiskManager:setFailed"){

            public void runSupport() {
                DiskManagerImpl.this.errorMessage = reason;
                Logger.log(new LogAlert(false, 3, DiskManagerImpl.this.errorMessage));
                DiskManagerImpl.this.setState(10);
                DiskManagerImpl.this.stop(false);
                RDResumeHandler.recheckFile(DiskManagerImpl.this.download_manager, file);
            }
        }.start();
    }

    public DMPieceList getPieceList(int piece_number) {
        return this.pieceMap[piece_number];
    }

    public byte[] getPieceHash(int piece_number) throws TOTorrentException {
        return this.torrent.getPieces()[piece_number];
    }

    public DiskManagerReadRequest createReadRequest(int pieceNumber, int offset, int length) {
        return this.reader.createRequest(pieceNumber, offset, length);
    }

    public DiskManagerCheckRequest createCheckRequest(int pieceNumber, Object user_data) {
        return this.checker.createRequest(pieceNumber, user_data);
    }

    public void enqueueCompleteRecheckRequest(DiskManagerCheckRequest request2, DiskManagerCheckRequestListener listener) {
        this.checker.enqueueCompleteRecheckRequest(request2, listener);
    }

    public void enqueueCheckRequest(DiskManagerCheckRequest request2, DiskManagerCheckRequestListener listener) {
        this.checker.enqueueCheckRequest(request2, listener);
    }

    public int getCompleteRecheckStatus() {
        return this.checker.getCompleteRecheckStatus();
    }

    public DirectByteBuffer readBlock(int pieceNumber, int offset, int length) {
        return this.reader.readBlock(pieceNumber, offset, length);
    }

    public DiskManagerWriteRequest createWriteRequest(int pieceNumber, int offset, DirectByteBuffer data, Object user_data) {
        return this.writer.createWriteRequest(pieceNumber, offset, data, user_data);
    }

    public void enqueueWriteRequest(DiskManagerWriteRequest request2, DiskManagerWriteRequestListener listener) {
        this.writer.writeBlock(request2, listener);
    }

    public boolean hasOutstandingWriteRequestForPiece(int piece_number) {
        return this.writer.hasOutstandingWriteRequestForPiece(piece_number);
    }

    public boolean checkBlockConsistency(int pieceNumber, int offset, DirectByteBuffer data) {
        if (pieceNumber < 0) {
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent((Object)this, LOGID, 3, "CHECKBLOCK1: pieceNumber=" + pieceNumber + " < 0"));
            }
            return false;
        }
        if (pieceNumber >= this.nbPieces) {
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent((Object)this, LOGID, 3, "CHECKBLOCK1: pieceNumber=" + pieceNumber + " >= this.nbPieces=" + this.nbPieces));
            }
            return false;
        }
        int length = this.pieceLength;
        if (pieceNumber == this.nbPieces - 1) {
            length = this.lastPieceLength;
        }
        if (offset < 0) {
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent((Object)this, LOGID, 3, "CHECKBLOCK1: offset=" + offset + " < 0"));
            }
            return false;
        }
        if (offset > length) {
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent((Object)this, LOGID, 3, "CHECKBLOCK1: offset=" + offset + " > length=" + length));
            }
            return false;
        }
        int size = data.remaining((byte)8);
        if (size <= 0) {
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent((Object)this, LOGID, 3, "CHECKBLOCK1: size=" + size + " <= 0"));
            }
            return false;
        }
        if (offset + size > length) {
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent((Object)this, LOGID, 3, "CHECKBLOCK1: offset=" + offset + " + size=" + size + " > length=" + length));
            }
            return false;
        }
        return true;
    }

    public boolean checkBlockConsistency(int pieceNumber, int offset, int length) {
        if (length > max_read_block_size) {
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent((Object)this, LOGID, 3, "CHECKBLOCK2: length=" + length + " > " + max_read_block_size));
            }
            return false;
        }
        if (length <= 0) {
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent((Object)this, LOGID, 3, "CHECKBLOCK2: length=" + length + " <= 0"));
            }
            return false;
        }
        if (pieceNumber < 0) {
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent((Object)this, LOGID, 3, "CHECKBLOCK2: pieceNumber=" + pieceNumber + " < 0"));
            }
            return false;
        }
        if (pieceNumber >= this.nbPieces) {
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent((Object)this, LOGID, 3, "CHECKBLOCK2: pieceNumber=" + pieceNumber + " >= this.nbPieces=" + this.nbPieces));
            }
            return false;
        }
        int pLength = this.pieceLength;
        if (pieceNumber == this.nbPieces - 1) {
            pLength = this.lastPieceLength;
        }
        if (offset < 0) {
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent((Object)this, LOGID, 3, "CHECKBLOCK2: offset=" + offset + " < 0"));
            }
            return false;
        }
        if (offset > pLength) {
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent((Object)this, LOGID, 3, "CHECKBLOCK2: offset=" + offset + " > pLength=" + pLength));
            }
            return false;
        }
        if (offset + length > pLength) {
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent((Object)this, LOGID, 3, "CHECKBLOCK2: offset=" + offset + " + length=" + length + " > pLength=" + pLength));
            }
            return false;
        }
        if (!this.pieces[pieceNumber].isDone()) {
            Logger.log(new LogEvent((Object)this, LOGID, 3, "CHECKBLOCK2: piece #" + pieceNumber + " not done"));
            return false;
        }
        return true;
    }

    public void saveResumeData(boolean interim_save) throws Exception {
        this.resume_handler.saveResumeData(interim_save);
    }

    public static MoveDownloadInfo getMoveDownloadInfoOnCompletion(DownloadManager dm, LogRelation log_object) {
        return DiskManagerImpl.getMoveDownloadInfo(false, dm, log_object);
    }

    public static MoveDownloadInfo getMoveDownloadInfoOnRemoval(DownloadManager dm, LogRelation log_object) {
        return DiskManagerImpl.getMoveDownloadInfo(true, dm, log_object);
    }

    private static MoveDownloadInfo getMoveDownloadInfo(boolean removing, DownloadManager dm, LogRelation log_object) {
        String move_when_done_param;
        boolean move_when_done;
        boolean ending;
        if (!dm.isPersistent()) {
            return null;
        }
        boolean bl = ending = !removing;
        if (removing && !dm.isDownloadComplete(true)) {
            if (!dm.isDownloadComplete(false)) {
                return null;
            }
            if (!COConfigurationManager.getBooleanParameter("File.move.download.removed.move_partial", false)) {
                return null;
            }
        }
        if (!(move_when_done = COConfigurationManager.getBooleanParameter(move_when_done_param = ending ? "Move Completed When Done" : "File.move.download.removed.enabled", false))) {
            return null;
        }
        String move_path_param = ending ? "Completed Files Directory" : "File.move.download.removed.path";
        String move_path = COConfigurationManager.getStringParameter(move_path_param, "");
        if (move_path.length() == 0) {
            return null;
        }
        String move_only_in_default_param = ending ? "Move Only When In Default Save Dir" : "File.move.download.removed.only_in_default";
        boolean move_only_in_default = COConfigurationManager.getBooleanParameter(move_only_in_default_param, true);
        String save_dir = dm.getSaveLocation().getParent();
        if (move_only_in_default) {
            String[] stringArray;
            boolean use_completed_dir = removing;
            if (use_completed_dir) {
                String[] stringArray2 = new String[2];
                stringArray2[0] = "Completed Files Directory";
                stringArray = stringArray2;
                stringArray2[1] = "Default save path";
            } else {
                String[] stringArray3 = new String[1];
                stringArray = stringArray3;
                stringArray3[0] = "Default save path";
            }
            String[] params_to_check = stringArray;
            String dir_to_check = null;
            boolean dir_matches = false;
            for (int i = 0; i < params_to_check.length; ++i) {
                dir_to_check = COConfigurationManager.getStringParameter(params_to_check[i]);
                try {
                    dir_to_check = new File(dir_to_check).getCanonicalPath();
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
                if (!save_dir.equals(dir_to_check)) continue;
                dir_matches = true;
                break;
            }
            if (!dir_matches) {
                if (Logger.isEnabled()) {
                    String log_message = "Not moving-on-" + (removing ? "remove" : "complete") + " since data is" + " not within " + use_completed_dir;
                    Logger.log(new LogEvent((Object)log_object, LOGID, 1, log_message));
                }
                return null;
            }
        }
        String move_torrent_param = ending ? "Move Torrent When Done" : "File.move.download.removed.move_torrent";
        boolean move_torrent = COConfigurationManager.getBooleanParameter(move_torrent_param, true);
        MoveDownloadInfo result = new MoveDownloadInfo();
        result.location = move_path;
        result.move_torrent = move_torrent;
        return result;
    }

    public void downloadEnded() {
        this.moveDownloadFilesWhenEndedOrRemoved(false, true);
    }

    public void downloadRemoved() {
        this.moveDownloadFilesWhenEndedOrRemoved(true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean moveDownloadFilesWhenEndedOrRemoved(boolean removing, boolean torrent_file_exists) {
        try {
            MoveDownloadInfo mdi;
            boolean ending;
            this.start_stop_mon.enter();
            boolean bl = ending = !removing;
            if (ending) {
                if (this.alreadyMoved) {
                    boolean bl2 = false;
                    return bl2;
                }
                this.alreadyMoved = true;
            }
            if ((mdi = DiskManagerImpl.getMoveDownloadInfo(removing, this.download_manager, this)) == null) {
                boolean bl3 = false;
                return bl3;
            }
            this.moveFiles(mdi.location, mdi.move_torrent && torrent_file_exists, true);
            boolean bl4 = true;
            return bl4;
        }
        finally {
            this.start_stop_mon.exit();
            if (!removing) {
                try {
                    this.saveResumeData(false);
                }
                catch (Throwable e) {
                    this.setFailed("Resume data save fails: " + Debug.getNestedExceptionMessage(e));
                }
            }
        }
    }

    public void moveDataFiles(File new_parent_dir) {
        this.moveFiles(new_parent_dir.toString(), false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void moveFiles(String move_to_dir, boolean move_torrent, boolean change_to_read_only) {
        boolean move_files = !this.isFileDestinationIsItself(move_to_dir);
        try {
            this.start_stop_mon.enter();
            boolean files_moved = true;
            if (move_files) {
                files_moved = this.moveDataFiles0(move_to_dir, change_to_read_only);
            }
            if (move_torrent && files_moved) {
                this.moveTorrentFile0(move_to_dir);
            }
        }
        catch (Exception e) {
            Debug.printStackTrace(e);
        }
        finally {
            this.start_stop_mon.exit();
        }
    }

    private boolean isFileDestinationIsItself(String move_to_dir) {
        File save_location = this.download_manager.getAbsoluteSaveLocation();
        String move_from_dir = save_location.getParent();
        try {
            File from_file = new File(move_from_dir).getCanonicalFile();
            File to_file = new File(move_to_dir).getCanonicalFile();
            save_location = save_location.getCanonicalFile();
            move_from_dir = from_file.getPath();
            move_to_dir = to_file.getPath();
            if (from_file.equals(to_file)) {
                return true;
            }
            if (!this.download_manager.getTorrent().isSimpleTorrent() && to_file.getPath().startsWith(save_location.getPath())) {
                String msg = "Target is sub-directory of files";
                Logger.log(new LogEvent((Object)this, LOGID, 3, msg));
                Logger.logTextResource(new LogAlert(true, 3, "DiskManager.alert.movefilefails"), new String[]{save_location.toString(), msg});
                return true;
            }
        }
        catch (Throwable e) {
            Debug.out(e);
        }
        return false;
    }

    private boolean moveDataFiles0(String move_to_dir, boolean change_to_read_only) throws Exception {
        int i;
        File save_location = this.download_manager.getAbsoluteSaveLocation();
        String move_from_dir = save_location.getParent();
        try {
            File from_file = new File(move_from_dir).getCanonicalFile();
            File to_file = new File(move_to_dir).getCanonicalFile();
            save_location = save_location.getCanonicalFile();
            move_from_dir = from_file.getPath();
            move_to_dir = to_file.getPath();
            if (from_file.equals(to_file)) {
                return true;
            }
            if (!this.download_manager.getTorrent().isSimpleTorrent() && to_file.getPath().startsWith(save_location.getPath())) {
                String msg = "Target is sub-directory of files";
                Logger.log(new LogEvent((Object)this, LOGID, 3, msg));
                Logger.logTextResource(new LogAlert(true, 3, "DiskManager.alert.movefilefails"), new String[]{save_location.toString(), msg});
                return true;
            }
        }
        catch (Throwable e) {
            Debug.out(e);
        }
        File[] new_files = new File[this.files.length];
        File[] old_files = new File[this.files.length];
        boolean[] link_only = new boolean[this.files.length];
        for (i = 0; i < this.files.length; ++i) {
            File newFile;
            File old_file = this.files[i].getFile(false);
            File linked_file = FMFileManagerFactory.getSingleton().getFileLink(this.torrent, old_file);
            if (linked_file != old_file) {
                if (save_location.isDirectory()) {
                    if (linked_file.getCanonicalPath().startsWith(save_location.getCanonicalPath())) {
                        old_file = linked_file;
                    } else {
                        link_only[i] = true;
                    }
                } else if (linked_file.getParentFile().getCanonicalPath().equals(save_location.getParentFile().getCanonicalPath())) {
                    old_file = linked_file;
                } else {
                    link_only[i] = true;
                }
            }
            old_files[i] = old_file;
            String fullPath = old_file.getParent();
            String subPath = fullPath.substring(fullPath.indexOf(move_from_dir) + move_from_dir.length());
            if (subPath.startsWith(File.separator)) {
                subPath = subPath.substring(1);
            }
            File destDir = new File(move_to_dir, subPath);
            new_files[i] = newFile = new File(destDir, old_file.getName());
            if (link_only[i]) continue;
            if (newFile.exists()) {
                String msg = "" + linked_file.getName() + " already exists in MoveTo destination dir";
                Logger.log(new LogEvent((Object)this, LOGID, 3, msg));
                Logger.logTextResource(new LogAlert(true, 3, "DiskManager.alert.movefileexists"), new String[]{old_file.getName()});
                Debug.out(msg);
                return false;
            }
            destDir.mkdirs();
        }
        for (i = 0; i < this.files.length; ++i) {
            File new_file = new_files[i];
            try {
                this.files[i].moveFile(new_file, link_only[i]);
                if (!change_to_read_only) continue;
                this.files[i].setAccessMode(1);
                continue;
            }
            catch (CacheFileManagerException e) {
                String msg = "Failed to move " + old_files[i].toString() + " to destination dir";
                Logger.log(new LogEvent((Object)this, LOGID, 3, msg));
                Logger.logTextResource(new LogAlert(true, 3, "DiskManager.alert.movefilefails"), new String[]{old_files[i].toString(), Debug.getNestedExceptionMessage(e)});
                for (int j = 0; j < i; ++j) {
                    try {
                        this.files[j].moveFile(old_files[j], link_only[j]);
                        continue;
                    }
                    catch (CacheFileManagerException f) {
                        Logger.logTextResource(new LogAlert(true, 3, "DiskManager.alert.movefilerecoveryfails"), new String[]{old_files[j].toString(), Debug.getNestedExceptionMessage(f)});
                    }
                }
                return false;
            }
        }
        if (save_location.isDirectory()) {
            TorrentUtils.recursiveEmptyDirDelete(save_location, false);
        }
        this.download_manager.setTorrentSaveDir(move_to_dir);
        return true;
    }

    private void moveTorrentFile0(String move_to_dir) throws Exception {
        String oldFullName = this.download_manager.getTorrentFileName();
        File oldTorrentFile = new File(oldFullName);
        if (oldTorrentFile.exists()) {
            String oldFileName = oldTorrentFile.getName();
            File newTorrentFile = new File(move_to_dir, oldFileName);
            if (!newTorrentFile.equals(oldTorrentFile)) {
                if (TorrentUtils.move(oldTorrentFile, newTorrentFile)) {
                    this.download_manager.setTorrentFileName(newTorrentFile.getCanonicalPath());
                } else {
                    String msg = "Failed to move " + oldTorrentFile.toString() + " to " + newTorrentFile.toString();
                    if (Logger.isEnabled()) {
                        Logger.log(new LogEvent((Object)this, LOGID, 3, msg));
                    }
                    Logger.logTextResource(new LogAlert(true, 3, "DiskManager.alert.movefilefails"), new String[]{oldTorrentFile.toString(), newTorrentFile.toString()});
                    Debug.out(msg);
                }
            }
        } else if (Logger.isEnabled()) {
            Logger.log(new LogEvent((Object)this, LOGID, 1, "Torrent file '" + oldFullName + "' has been deleted, move operation ignored"));
        }
    }

    public TOTorrent getTorrent() {
        return this.torrent;
    }

    public void addListener(DiskManagerListener l) {
        this.listeners.addListener(l);
        int[] params = new int[]{this.getState(), this.getState()};
        this.listeners.dispatch(l, 1, params);
    }

    public void removeListener(DiskManagerListener l) {
        this.listeners.removeListener(l);
    }

    public static void deleteDataFiles(TOTorrent torrent, String torrent_save_dir, String torrent_save_file) {
        block8: {
            if (torrent == null || torrent_save_file == null) {
                return;
            }
            try {
                if (torrent.isSimpleTorrent()) {
                    File target = new File(torrent_save_dir, torrent_save_file);
                    target = FMFileManagerFactory.getSingleton().getFileLink(torrent, target.getCanonicalFile());
                    FileUtil.deleteWithRecycle(target);
                    break block8;
                }
                PlatformManager mgr = PlatformManagerFactory.getPlatformManager();
                if (Constants.isOSX && torrent_save_file.length() > 0 && COConfigurationManager.getBooleanParameter("Move Deleted Data To Recycle Bin") && mgr.hasCapability(PlatformManagerCapabilities.RecoverableFileDelete)) {
                    try {
                        String dir = torrent_save_dir + File.separatorChar + torrent_save_file + File.separatorChar;
                        if (DiskManagerImpl.countFiles(new File(dir)) == DiskManagerImpl.countDataFiles(torrent, torrent_save_dir, torrent_save_file)) {
                            mgr.performRecoverableFileDelete(dir);
                            break block8;
                        }
                        DiskManagerImpl.deleteDataFileContents(torrent, torrent_save_dir, torrent_save_file);
                    }
                    catch (PlatformManagerException ex) {
                        DiskManagerImpl.deleteDataFileContents(torrent, torrent_save_dir, torrent_save_file);
                    }
                    break block8;
                }
                DiskManagerImpl.deleteDataFileContents(torrent, torrent_save_dir, torrent_save_file);
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
    }

    private static int countFiles(File f) {
        if (f.isFile()) {
            return 1;
        }
        int res = 0;
        File[] files = f.listFiles();
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                res += DiskManagerImpl.countFiles(files[i]);
            }
        }
        return res;
    }

    private static int countDataFiles(TOTorrent torrent, String torrent_save_dir, String torrent_save_file) {
        try {
            int res = 0;
            LocaleUtilDecoder locale_decoder = LocaleTorrentUtil.getTorrentEncoding(torrent);
            TOTorrentFile[] files = torrent.getFiles();
            for (int i = 0; i < files.length; ++i) {
                byte[][] path_comps = files[i].getPathComponents();
                String path_str = torrent_save_dir + File.separator + torrent_save_file + File.separator;
                for (int j = 0; j < path_comps.length; ++j) {
                    String comp = locale_decoder.decodeString(path_comps[j]);
                    comp = FileUtil.convertOSSpecificChars(comp);
                    path_str = path_str + (j == 0 ? "" : File.separator) + comp;
                }
                File file = new File(path_str).getCanonicalFile();
                File linked_file = FMFileManagerFactory.getSingleton().getFileLink(torrent, file);
                boolean skip = false;
                if (linked_file != file && !linked_file.getCanonicalPath().startsWith(new File(torrent_save_dir).getCanonicalPath())) {
                    skip = true;
                }
                if (skip || !file.exists() || file.isDirectory()) continue;
                ++res;
            }
            return res;
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
            return -1;
        }
    }

    private static void deleteDataFileContents(TOTorrent torrent, String torrent_save_dir, String torrent_save_file) throws TOTorrentException, UnsupportedEncodingException, LocaleUtilEncodingException {
        LocaleUtilDecoder locale_decoder = LocaleTorrentUtil.getTorrentEncoding(torrent);
        TOTorrentFile[] files = torrent.getFiles();
        String root_path = torrent_save_dir + File.separator + torrent_save_file + File.separator;
        for (int i = 0; i < files.length; ++i) {
            boolean delete;
            byte[][] path_comps = files[i].getPathComponents();
            String path_str = root_path;
            for (int j = 0; j < path_comps.length; ++j) {
                try {
                    String comp = locale_decoder.decodeString(path_comps[j]);
                    comp = FileUtil.convertOSSpecificChars(comp);
                    path_str = path_str + (j == 0 ? "" : File.separator) + comp;
                    continue;
                }
                catch (UnsupportedEncodingException e) {
                    Debug.out("file - unsupported encoding!!!!");
                }
            }
            File file = new File(path_str);
            File linked_file = FMFileManagerFactory.getSingleton().getFileLink(torrent, file);
            if (linked_file == file) {
                delete = true;
            } else {
                try {
                    if (linked_file.getCanonicalPath().startsWith(new File(root_path).getCanonicalPath())) {
                        file = linked_file;
                        delete = true;
                    } else {
                        delete = false;
                    }
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                    delete = false;
                }
            }
            if (!delete || !file.exists() || file.isDirectory()) continue;
            try {
                FileUtil.deleteWithRecycle(file);
                continue;
            }
            catch (Exception e) {
                Debug.out(e.toString());
            }
        }
        TorrentUtils.recursiveEmptyDirDelete(new File(torrent_save_dir, torrent_save_file));
    }

    public void skippedFileSetChanged(DiskManagerFileInfo file) {
        this.skipped_file_set_changed = true;
        this.listeners.dispatch(2, file);
    }

    public void priorityChanged(DiskManagerFileInfo file) {
        this.listeners.dispatch(2, file);
    }

    private void loadFilePriorities() {
        DiskManagerImpl.loadFilePriorities(this.download_manager, this.files);
    }

    private static void loadFilePriorities(DownloadManager download_manager, DiskManagerFileInfo[] files) {
        try {
            if (files == null) {
                return;
            }
            List file_priorities = (List)download_manager.getData("file_priorities");
            if (file_priorities == null) {
                return;
            }
            for (int i = 0; i < files.length; ++i) {
                DiskManagerFileInfo file = files[i];
                if (file == null) {
                    return;
                }
                int priority = ((Long)file_priorities.get(i)).intValue();
                if (priority == 0) {
                    file.setSkipped(true);
                    continue;
                }
                if (priority != 1) continue;
                file.setPriority(true);
            }
        }
        catch (Throwable t) {
            Debug.printStackTrace(t);
        }
    }

    protected void storeFilePriorities() {
        DiskManagerImpl.storeFilePriorities(this.download_manager, this.files);
    }

    protected static void storeFilePriorities(DownloadManager download_manager, DiskManagerFileInfo[] files) {
        if (files == null) {
            return;
        }
        ArrayList<Long> file_priorities = new ArrayList<Long>();
        for (int i = 0; i < files.length; ++i) {
            DiskManagerFileInfo file = files[i];
            if (file == null) {
                return;
            }
            boolean skipped = file.isSkipped();
            boolean priority = file.isPriority();
            int value = -1;
            if (skipped) {
                value = 0;
            } else if (priority) {
                value = 1;
            }
            file_priorities.add(i, new Long(value));
        }
        download_manager.setData("file_priorities", file_priorities);
    }

    protected static void storeFileDownloaded(DownloadManager download_manager, DiskManagerFileInfo[] files, boolean persist) {
        DownloadManagerState state = download_manager.getDownloadState();
        HashMap details = new HashMap();
        ArrayList<Long> downloaded = new ArrayList<Long>();
        details.put("downloaded", downloaded);
        for (int i = 0; i < files.length; ++i) {
            downloaded.add(new Long(files[i].getDownloaded()));
        }
        state.setMapAttribute("filedownloaded", details);
        if (persist) {
            state.save();
        }
    }

    protected static void loadFileDownloaded(DownloadManager download_manager, DiskManagerFileInfoHelper[] files) {
        DownloadManagerState state = download_manager.getDownloadState();
        Map details = state.getMapAttribute("filedownloaded");
        if (details == null) {
            return;
        }
        List downloaded = (List)details.get("downloaded");
        if (downloaded == null) {
            return;
        }
        try {
            for (int i = 0; i < files.length; ++i) {
                files[i].setDownloaded((Long)downloaded.get(i));
            }
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
    }

    public void saveState() {
        this.saveState(true);
    }

    protected void saveState(boolean persist) {
        if (this.files != null) {
            DiskManagerImpl.storeFileDownloaded(this.download_manager, this.files, persist);
            this.storeFilePriorities();
        }
    }

    public DownloadManager getDownloadManager() {
        return this.download_manager;
    }

    public String getInternalName() {
        return this.download_manager.getInternalName();
    }

    public DownloadManagerState getDownloadState() {
        return this.download_manager.getDownloadState();
    }

    public File getSaveLocation() {
        return this.download_manager.getSaveLocation();
    }

    public String[] getStorageTypes() {
        return DiskManagerImpl.getStorageTypes(this.download_manager);
    }

    protected static String[] getStorageTypes(DownloadManager download_manager) {
        DownloadManagerState state = download_manager.getDownloadState();
        String[] types = state.getListAttribute("storetypes");
        if (types.length == 0) {
            types = new String[download_manager.getTorrent().getFiles().length];
            for (int i = 0; i < types.length; ++i) {
                types[i] = "L";
            }
        }
        return types;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected static boolean setFileLink(DownloadManager download_manager, DiskManagerFileInfo[] info, DiskManagerFileInfo file_info, File from_file, File to_link) {
        File existing_link = FMFileManagerFactory.getSingleton().getFileLink(download_manager.getTorrent(), to_link);
        if (!existing_link.equals(to_link) && !from_file.equals(to_link)) {
            Logger.log(new LogAlert(true, 3, "Attempt to link to existing link '" + existing_link.toString() + "'"));
            return false;
        }
        File existing_file = file_info.getFile(true);
        if (to_link.equals(existing_file)) {
            return true;
        }
        for (int i = 0; i < info.length; ++i) {
            if (!to_link.equals(info[i].getFile(true))) continue;
            Logger.log(new LogAlert(true, 3, "Attempt to link to existing file '" + info[i].getFile(true) + "'"));
            return false;
        }
        if (to_link.exists()) {
            if (!existing_file.exists()) {
                download_manager.recheckFile(file_info);
            } else {
                if (!FileUtil.deleteWithRecycle(existing_file)) {
                    Logger.log(new LogAlert(true, 3, "Failed to delete '" + existing_file.toString() + "'"));
                    return false;
                }
                download_manager.recheckFile(file_info);
            }
        } else if (existing_file.exists() && !FileUtil.renameFile(existing_file, to_link)) {
            Logger.log(new LogAlert(true, 3, "Failed to rename '" + existing_file.toString() + "'"));
            return false;
        }
        DownloadManagerState state = download_manager.getDownloadState();
        state.setFileLink(from_file, to_link);
        state.save();
        return true;
    }

    public static DiskManagerFileInfo[] getFileInfoSkeleton(final DownloadManager download_manager, DiskManagerListener listener) {
        TOTorrent torrent = download_manager.getTorrent();
        if (torrent == null) {
            return new DiskManagerFileInfo[0];
        }
        String root_dir = download_manager.getAbsoluteSaveLocation().getParent();
        if (!torrent.isSimpleTorrent()) {
            root_dir = root_dir + File.separator + download_manager.getAbsoluteSaveLocation().getName();
        }
        root_dir = root_dir + File.separator;
        try {
            LocaleUtilDecoder locale_decoder = LocaleTorrentUtil.getTorrentEncoding(torrent);
            TOTorrentFile[] torrent_files = torrent.getFiles();
            long piece_size = torrent.getPieceLength();
            long size_so_far = 0L;
            DiskManagerFileInfo[] res = new DiskManagerFileInfoHelper[torrent_files.length];
            for (int i = 0; i < res.length; ++i) {
                TOTorrentFile torrent_file = torrent_files[i];
                int file_index = i;
                long file_length = torrent_file.getLength();
                int first_piece = (int)(size_so_far / piece_size);
                int last_piece = (int)(((size_so_far += file_length) - 1L) / piece_size);
                String path_str = root_dir + File.separator;
                if (torrent.isSimpleTorrent()) {
                    path_str = path_str + download_manager.getAbsoluteSaveLocation().getName();
                } else {
                    byte[][] path_comps = torrent_file.getPathComponents();
                    for (int j = 0; j < path_comps.length; ++j) {
                        String comp = locale_decoder.decodeString(path_comps[j]);
                        comp = FileUtil.convertOSSpecificChars(comp);
                        path_str = path_str + (j == 0 ? "" : File.separator) + comp;
                    }
                }
                File data_file = new File(path_str);
                String data_name = data_file.getName();
                int separator = data_name.lastIndexOf(".");
                if (separator == -1) {
                    separator = 0;
                }
                String data_extension = data_name.substring(separator);
                DiskManagerFileInfoHelper info = new DiskManagerFileInfoHelper((DiskManagerFileInfoHelper[])res, listener, data_extension, first_piece, last_piece, torrent_file, file_index, data_file){
                    private boolean priority;
                    private boolean skipped;
                    private long downloaded;
                    private CacheFile read_cache_file;
                    final /* synthetic */ DiskManagerFileInfoHelper[] val$res;
                    final /* synthetic */ DiskManagerListener val$listener;
                    final /* synthetic */ String val$data_extension;
                    final /* synthetic */ int val$first_piece;
                    final /* synthetic */ int val$last_piece;
                    final /* synthetic */ TOTorrentFile val$torrent_file;
                    final /* synthetic */ int val$file_index;
                    final /* synthetic */ File val$data_file;
                    {
                        this.val$res = diskManagerFileInfoHelperArray;
                        this.val$listener = diskManagerListener;
                        this.val$data_extension = string;
                        this.val$first_piece = n;
                        this.val$last_piece = n2;
                        this.val$torrent_file = tOTorrentFile;
                        this.val$file_index = n3;
                        this.val$data_file = file;
                    }

                    public void setPriority(boolean b) {
                        this.priority = b;
                        DiskManagerImpl.storeFilePriorities(download_manager, this.val$res);
                        this.val$listener.filePriorityChanged(this);
                    }

                    public void setSkipped(boolean _skipped) {
                        if (!_skipped && this.getStorageType() == 2 && !this.setStorageType(1)) {
                            return;
                        }
                        this.skipped = _skipped;
                        DiskManagerImpl.storeFilePriorities(download_manager, this.val$res);
                        this.val$listener.filePriorityChanged(this);
                    }

                    public int getAccessMode() {
                        return 1;
                    }

                    public long getDownloaded() {
                        return this.downloaded;
                    }

                    public void setDownloaded(long l) {
                        this.downloaded = l;
                    }

                    public String getExtension() {
                        return this.val$data_extension;
                    }

                    public int getFirstPieceNumber() {
                        return this.val$first_piece;
                    }

                    public int getLastPieceNumber() {
                        return this.val$last_piece;
                    }

                    public long getLength() {
                        return this.val$torrent_file.getLength();
                    }

                    public int getIndex() {
                        return this.val$file_index;
                    }

                    public int getNbPieces() {
                        return this.val$last_piece - this.val$first_piece + 1;
                    }

                    public boolean isPriority() {
                        return this.priority;
                    }

                    public boolean isSkipped() {
                        return this.skipped;
                    }

                    public DiskManager getDiskManager() {
                        return null;
                    }

                    public DownloadManager getDownloadManager() {
                        return download_manager;
                    }

                    public File getFile(boolean follow_link) {
                        File link;
                        if (follow_link && (link = this.getLink()) != null) {
                            return link;
                        }
                        return this.val$data_file;
                    }

                    public TOTorrentFile getTorrentFile() {
                        return this.val$torrent_file;
                    }

                    public boolean setLink(File link_destination) {
                        return DiskManagerImpl.setFileLink(download_manager, this.val$res, this, this.val$data_file, link_destination);
                    }

                    public File getLink() {
                        return download_manager.getDownloadState().getFileLink(this.val$data_file);
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public boolean setStorageType(int type) {
                        boolean bl;
                        int old_type;
                        String[] types = DiskManagerImpl.getStorageTypes(download_manager);
                        int n = old_type = types[this.val$file_index].equals("L") ? 1 : 2;
                        if (type == old_type) {
                            return true;
                        }
                        boolean set_skipped = false;
                        try {
                            File target_file = this.getFile(true);
                            if (target_file.exists()) {
                                CacheFile cache_file = CacheFileManagerFactory.getSingleton().createFile(new CacheFileOwner(){

                                    public String getCacheFileOwnerName() {
                                        return download_manager.getInternalName();
                                    }

                                    public TOTorrentFile getCacheFileTorrentFile() {
                                        return val$torrent_file;
                                    }

                                    public File getCacheFileControlFile(String name) {
                                        return download_manager.getDownloadState().getStateFile(name);
                                    }
                                }, target_file, type == 1 ? 1 : 2);
                                cache_file.close();
                                set_skipped = type == 2 && !this.isSkipped();
                                int cleared = RDResumeHandler.storageTypeChanged(download_manager, this);
                                if (cleared > 0) {
                                    this.downloaded -= (long)cleared * this.val$torrent_file.getTorrent().getPieceLength();
                                    if (this.downloaded < 0L) {
                                        this.downloaded = 0L;
                                    }
                                    DiskManagerImpl.storeFileDownloaded(download_manager, this.val$res, true);
                                }
                            }
                            bl = true;
                            types[this.val$file_index] = type == 1 ? "L" : "C";
                        }
                        catch (Throwable e) {
                            boolean bl2;
                            try {
                                Debug.printStackTrace(e);
                                Logger.log(new LogAlert(true, 3, "Failed to change storage type for '" + this.getFile(true) + "': " + Debug.getNestedExceptionMessage(e)));
                                RDResumeHandler.recheckFile(download_manager, this);
                                bl2 = false;
                                types[this.val$file_index] = type == 1 ? "L" : "C";
                            }
                            catch (Throwable throwable) {
                                types[this.val$file_index] = type == 1 ? "L" : "C";
                                DownloadManagerState dm_state = download_manager.getDownloadState();
                                dm_state.setListAttribute("storetypes", types);
                                dm_state.save();
                                if (set_skipped) {
                                    this.setSkipped(true);
                                }
                                throw throwable;
                            }
                            DownloadManagerState dm_state = download_manager.getDownloadState();
                            dm_state.setListAttribute("storetypes", types);
                            dm_state.save();
                            if (set_skipped) {
                                this.setSkipped(true);
                            }
                            return bl2;
                        }
                        DownloadManagerState dm_state = download_manager.getDownloadState();
                        dm_state.setListAttribute("storetypes", types);
                        dm_state.save();
                        if (set_skipped) {
                            this.setSkipped(true);
                        }
                        return bl;
                    }

                    public int getStorageType() {
                        String[] types = DiskManagerImpl.getStorageTypes(download_manager);
                        return types[this.val$file_index].equals("L") ? 1 : 2;
                    }

                    public void flushCache() {
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public DirectByteBuffer read(long offset, int length) throws IOException {
                        block7: {
                            try {
                                cache_read_mon.enter();
                                if (this.read_cache_file != null) break block7;
                                try {
                                    String[] types = DiskManagerImpl.getStorageTypes(download_manager);
                                    int type = types[this.val$file_index].equals("L") ? 1 : 2;
                                    this.read_cache_file = CacheFileManagerFactory.getSingleton().createFile(new CacheFileOwner(){

                                        public String getCacheFileOwnerName() {
                                            return download_manager.getInternalName();
                                        }

                                        public TOTorrentFile getCacheFileTorrentFile() {
                                            return val$torrent_file;
                                        }

                                        public File getCacheFileControlFile(String name) {
                                            return download_manager.getDownloadState().getStateFile(name);
                                        }
                                    }, this.getFile(true), type == 1 ? 1 : 2);
                                }
                                catch (Throwable e) {
                                    Debug.printStackTrace(e);
                                    throw new IOException(e.getMessage());
                                }
                            }
                            finally {
                                cache_read_mon.exit();
                            }
                        }
                        DirectByteBuffer buffer = DirectByteBufferPool.getBuffer((byte)6, length);
                        try {
                            this.read_cache_file.read(buffer, offset, (short)1);
                        }
                        catch (Throwable e) {
                            buffer.returnToPool();
                            Debug.printStackTrace(e);
                            throw new IOException(e.getMessage());
                        }
                        return buffer;
                    }

                    public void close() {
                        if (this.read_cache_file != null) {
                            try {
                                this.read_cache_file.close();
                            }
                            catch (Throwable e) {
                                Debug.printStackTrace(e);
                            }
                            this.read_cache_file = null;
                        }
                    }

                    public void addListener(DiskManagerFileInfoListener listener) {
                        if (this.getDownloaded() == this.getLength()) {
                            try {
                                listener.dataWritten(0L, this.getLength());
                                listener.dataChecked(0L, this.getLength());
                            }
                            catch (Throwable e) {
                                Debug.printStackTrace(e);
                            }
                        }
                    }

                    public void removeListener(DiskManagerFileInfoListener listener) {
                    }
                };
                res[i] = info;
            }
            DiskManagerImpl.loadFilePriorities(download_manager, res);
            DiskManagerImpl.loadFileDownloaded(download_manager, (DiskManagerFileInfoHelper[])res);
            return res;
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
            return new DiskManagerFileInfo[0];
        }
    }

    public static void setFileLinks(DownloadManager download_manager, CaseSensitiveFileMap links) {
        try {
            CacheFileManagerFactory.getSingleton().setFileLinks(download_manager.getTorrent(), links);
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
    }

    public String getRelationText() {
        return "TorrentDM: '" + this.download_manager.getDisplayName() + "'";
    }

    public Object[] getQueryableInterfaces() {
        return new Object[]{this.download_manager, this.torrent};
    }

    public DiskManagerRecheckScheduler getRecheckScheduler() {
        return recheck_scheduler;
    }

    public boolean isInteresting(int pieceNumber) {
        return this.pieces[pieceNumber].isInteresting();
    }

    public boolean isDone(int pieceNumber) {
        return this.pieces[pieceNumber].isDone();
    }

    static {
        int max_read_threads = COConfigurationManager.getIntParameter("diskmanager.perf.read.maxthreads");
        int max_read_mb = COConfigurationManager.getIntParameter("diskmanager.perf.read.maxmb");
        int max_write_threads = COConfigurationManager.getIntParameter("diskmanager.perf.write.maxthreads");
        int max_write_mb = COConfigurationManager.getIntParameter("diskmanager.perf.write.maxmb");
        disk_access_controller = DiskAccessControllerFactory.create(max_read_threads, max_read_mb, max_write_threads, max_write_mb);
        if (Logger.isEnabled()) {
            Logger.log(new LogEvent(LOGID, "Disk access controller params: " + max_read_threads + "/" + max_read_mb + "/" + max_write_threads + "/" + max_write_mb));
        }
        recheck_scheduler = new DiskManagerRecheckScheduler();
        allocation_scheduler = new DiskManagerAllocationScheduler();
        start_pool = new ThreadPool("DiskManager:start", 64, true);
        start_pool.setThreadPriority(1);
        cache_read_mon = new AEMonitor("DiskManager:cacheRead");
        listeners_aggregator = ListenerManager.createAsyncManager("DiskM:ListenAggregatorDispatcher", new ListenerManagerDispatcher(){

            public void dispatch(Object _listener, int type, Object value) {
                DiskManagerListener listener = (DiskManagerListener)_listener;
                if (type == 1) {
                    int[] params = (int[])value;
                    listener.stateChanged(params[0], params[1]);
                } else if (type == 2) {
                    listener.filePriorityChanged((DiskManagerFileInfo)value);
                } else if (type == 3) {
                    listener.pieceDoneChanged((DiskManagerPiece)value);
                } else if (type == 4) {
                    Object[] o = (Object[])value;
                    listener.fileAccessModeChanged((DiskManagerFileInfo)o[0], (Integer)o[1], (Integer)o[2]);
                }
            }
        });
        ParameterListener param_listener = new ParameterListener(){

            public void parameterChanged(String str) {
                max_read_block_size = COConfigurationManager.getIntParameter("BT Request Max Block Size");
            }
        };
        COConfigurationManager.addAndFireParameterListener("BT Request Max Block Size", param_listener);
    }

    public static class MoveDownloadInfo {
        public String location = null;
        public boolean move_torrent = false;
    }
}

