/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.plugins.upnp;

import com.aelitis.azureus.plugins.upnp.UPnPMapping;
import com.aelitis.azureus.plugins.upnp.UPnPMappingListener;
import com.aelitis.azureus.plugins.upnp.UPnPMappingManagerListener;
import com.aelitis.azureus.plugins.upnp.UPnPPlugin;
import com.aelitis.net.upnp.services.UPnPWANConnection;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AsyncDispatcher;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.RandomUtils;

public class UPnPMappingManager {
    private static UPnPMappingManager singleton;
    private UPnPPlugin plugin;
    private List mappings = new ArrayList();
    private List listeners = new ArrayList();
    private AsyncDispatcher async_dispatcher = new AsyncDispatcher();

    protected static synchronized UPnPMappingManager getSingleton(UPnPPlugin plugin) {
        if (singleton == null) {
            singleton = new UPnPMappingManager(plugin);
        }
        return singleton;
    }

    protected UPnPMappingManager(UPnPPlugin _plugin) {
        this.plugin = _plugin;
        this.addConfigPort("upnp.mapping.dataport", false, "UDP.Listen.Port.Enable", "UDP.Listen.Port");
        this.addConfigPort("upnp.mapping.trackerclientudp", false, "Server Enable UDP", "UDP.NonData.Listen.Port");
        this.addConfigPort("upnp.mapping.dataport", true, "TCP.Listen.Port.Enable", "TCP.Listen.Port");
        this.addConfigPort("upnp.mapping.tcptrackerport", true, "Tracker Port Enable", "Tracker Port");
        this.addConfigPortX("upnp.mapping.tcptrackerport", true, "Tracker Port Enable", "Tracker Port Backups");
        this.addConfigPort("upnp.mapping.tcpssltrackerport", true, "Tracker Port SSL Enable", "Tracker Port SSL");
        this.addConfigPortX("upnp.mapping.tcpssltrackerport", true, "Tracker Port SSL Enable", "Tracker Port SSL Backups");
        this.addConfigPort("upnp.mapping.udptrackerport", false, "Tracker Port UDP Enable", "Tracker Port");
    }

    protected void serviceFound(UPnPWANConnection service) {
        boolean save_config = false;
        if ((service.getCapabilities() & 1) == 0) {
            UPnPMapping[] maps = this.getMappings();
            for (int i = 0; i < maps.length; ++i) {
                UPnPMapping other;
                int j;
                int new_port;
                List others;
                UPnPMapping map = maps[i];
                if (!map.isEnabled() || !map.isTCP() || (others = this.getMappingEx(false, map.getPort())).size() == 0) continue;
                boolean enabled = false;
                for (int j2 = 0; j2 < others.size(); ++j2) {
                    UPnPMapping other2 = (UPnPMapping)others.get(j2);
                    if (!other2.isEnabled()) continue;
                    enabled = true;
                }
                if (!enabled) continue;
                while (this.getMapping(true, new_port = RandomUtils.generateRandomNetworkListenPort()) != null || this.getMapping(false, new_port) != null) {
                }
                int new_port_1 = new_port;
                while (this.getMapping(true, new_port = RandomUtils.generateRandomNetworkListenPort()) != null || this.getMapping(false, new_port) != null || new_port_1 == new_port) {
                }
                int new_port_2 = new_port;
                String others_str = "";
                for (j = 0; j < others.size(); ++j) {
                    other = (UPnPMapping)others.get(j);
                    if (!other.isEnabled()) continue;
                    others_str = others_str + (others_str.length() == 0 ? "" : ",") + other.getString(new_port_2);
                }
                this.plugin.logAlert(2, "upnp.portchange.alert", new String[]{map.getString(new_port_1), String.valueOf(map.getPort()), others_str, String.valueOf(map.getPort())});
                map.setPort(new_port_1);
                for (j = 0; j < others.size(); ++j) {
                    other = (UPnPMapping)others.get(j);
                    if (!other.isEnabled()) continue;
                    other.setPort(new_port_2);
                }
                save_config = true;
            }
        }
        if (save_config) {
            COConfigurationManager.save();
        }
    }

    protected UPnPMapping addConfigPort(String name_resource, boolean tcp, boolean enabled, final String int_param_name) {
        int value = COConfigurationManager.getIntParameter(int_param_name);
        final UPnPMapping mapping = this.addMapping(name_resource, tcp, value, enabled);
        mapping.addListener(new UPnPMappingListener(){

            public void mappingChanged(UPnPMapping mapping) {
                COConfigurationManager.setParameter(int_param_name, mapping.getPort());
            }

            public void mappingDestroyed(UPnPMapping mapping) {
            }
        });
        this.addConfigListener(int_param_name, new ParameterListener(){

            public void parameterChanged(String name) {
                mapping.setPort(COConfigurationManager.getIntParameter(int_param_name));
            }
        });
        return mapping;
    }

    protected void addConfigPort(String name_resource, boolean tcp, final String enabler_param_name, final String int_param_name) {
        boolean enabled = COConfigurationManager.getBooleanParameter(enabler_param_name);
        final UPnPMapping mapping = this.addConfigPort(name_resource, tcp, enabled, int_param_name);
        mapping.addListener(new UPnPMappingListener(){

            public void mappingChanged(UPnPMapping mapping) {
                COConfigurationManager.setParameter(int_param_name, mapping.getPort());
            }

            public void mappingDestroyed(UPnPMapping mapping) {
            }
        });
        this.addConfigListener(enabler_param_name, new ParameterListener(){

            public void parameterChanged(String name) {
                mapping.setEnabled(COConfigurationManager.getBooleanParameter(enabler_param_name));
            }
        });
    }

    protected void addConfigPortX(final String name_resource, final boolean tcp, final String enabler_param_name, final String string_param_name) {
        final ArrayList config_mappings = new ArrayList();
        ParameterListener l1 = new ParameterListener(){

            public void parameterChanged(String name) {
                int i;
                boolean enabled = COConfigurationManager.getBooleanParameter(enabler_param_name);
                List ports = UPnPMappingManager.this.stringToPorts(COConfigurationManager.getStringParameter(string_param_name));
                for (i = 0; i < ports.size(); ++i) {
                    int port = (Integer)ports.get(i);
                    if (config_mappings.size() <= i) {
                        UPnPMapping mapping = UPnPMappingManager.this.addMapping(name_resource, tcp, port, enabled);
                        mapping.setEnabled(enabled);
                        config_mappings.add(mapping);
                        continue;
                    }
                    ((UPnPMapping)config_mappings.get(i)).setPort(port);
                }
                for (i = ports.size(); i < config_mappings.size(); ++i) {
                    ((UPnPMapping)config_mappings.get(i)).setEnabled(false);
                }
            }
        };
        this.addConfigListener(string_param_name, l1);
        ParameterListener l2 = new ParameterListener(){

            public void parameterChanged(String name) {
                List ports = UPnPMappingManager.this.stringToPorts(COConfigurationManager.getStringParameter(string_param_name));
                boolean enabled = COConfigurationManager.getBooleanParameter(enabler_param_name);
                for (int i = 0; i < (enabled ? ports.size() : config_mappings.size()); ++i) {
                    ((UPnPMapping)config_mappings.get(i)).setEnabled(enabled);
                }
            }
        };
        this.addConfigListener(enabler_param_name, l2);
        l1.parameterChanged(null);
        l2.parameterChanged(null);
    }

    protected List stringToPorts(String str) {
        str = str.replace(',', ';');
        StringTokenizer tok = new StringTokenizer(str, ";");
        ArrayList<Integer> res = new ArrayList<Integer>();
        while (tok.hasMoreTokens()) {
            try {
                res.add(new Integer(tok.nextToken().trim()));
            }
            catch (Throwable e) {
                Debug.out("Invalid port entry in '" + str + "'", e);
            }
        }
        return res;
    }

    public UPnPMapping addMapping(String desc_resource, boolean tcp, int port, boolean enabled) {
        UPnPMapping mapping = new UPnPMapping(desc_resource, tcp, port, enabled);
        this.mappings.add(mapping);
        this.added(mapping);
        return mapping;
    }

    public UPnPMapping[] getMappings() {
        UPnPMapping[] res = new UPnPMapping[this.mappings.size()];
        this.mappings.toArray(res);
        return res;
    }

    public UPnPMapping getMapping(boolean tcp, int port) {
        for (int i = 0; i < this.mappings.size(); ++i) {
            UPnPMapping mapping = (UPnPMapping)this.mappings.get(i);
            if (mapping.isTCP() != tcp || mapping.getPort() != port) continue;
            return mapping;
        }
        return null;
    }

    public List getMappingEx(boolean tcp, int port) {
        ArrayList<UPnPMapping> res = new ArrayList<UPnPMapping>();
        for (int i = 0; i < this.mappings.size(); ++i) {
            UPnPMapping mapping = (UPnPMapping)this.mappings.get(i);
            if (mapping.isTCP() != tcp || mapping.getPort() != port) continue;
            res.add(mapping);
        }
        return res;
    }

    protected void added(UPnPMapping mapping) {
        mapping.addListener(new UPnPMappingListener(){

            public void mappingChanged(UPnPMapping mapping) {
            }

            public void mappingDestroyed(UPnPMapping mapping) {
                UPnPMappingManager.this.mappings.remove(mapping);
            }
        });
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((UPnPMappingManagerListener)this.listeners.get(i)).mappingAdded(mapping);
        }
    }

    public void addListener(UPnPMappingManagerListener l) {
        this.listeners.add(l);
    }

    public void removeListener(UPnPMappingManagerListener l) {
        this.listeners.remove(l);
    }

    protected void addConfigListener(final String param, final ParameterListener listener) {
        COConfigurationManager.addParameterListener(param, new ParameterListener(){

            public void parameterChanged(String name) {
                UPnPMappingManager.this.async_dispatcher.dispatch(new AERunnable(){

                    public void runSupport() {
                        listener.parameterChanged(param);
                    }
                });
            }
        });
    }
}

