/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.security.impl;

import com.aelitis.azureus.core.security.CryptoHandler;
import com.aelitis.azureus.core.security.CryptoManagerException;
import com.aelitis.azureus.core.security.CryptoManagerPasswordException;
import com.aelitis.azureus.core.security.CryptoSTSEngine;
import com.aelitis.azureus.core.security.impl.CryptoManagerImpl;
import com.aelitis.azureus.core.security.impl.CryptoSTSEngineImpl;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import org.bouncycastle.jce.ECNamedCurveTable;
import org.bouncycastle.jce.interfaces.ECPrivateKey;
import org.bouncycastle.jce.interfaces.ECPublicKey;
import org.bouncycastle.jce.provider.JCEIESCipher;
import org.bouncycastle.jce.spec.ECNamedCurveParameterSpec;
import org.bouncycastle.jce.spec.ECPrivateKeySpec;
import org.bouncycastle.jce.spec.ECPublicKeySpec;
import org.bouncycastle.jce.spec.IEKeySpec;
import org.bouncycastle.jce.spec.IESParameterSpec;
import org.bouncycastle.math.ec.ECPoint;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.util.SystemTime;

public class CryptoHandlerECC
implements CryptoHandler {
    private static final ECNamedCurveParameterSpec ECCparam = ECNamedCurveTable.getParameterSpec("prime192v2");
    private static final byte[] ECIES_D = new byte[]{109, -63, 98, 50, 21, 77, 15, 123};
    private static final byte[] ECIES_E = new byte[]{106, 100, -104, -34, 26, -92, -104, -52};
    private static final int TIMEOUT_DEFAULT_SECS = 3600;
    private CryptoManagerImpl manager;
    private String CONFIG_PREFIX = "core.crypto.ecc.";
    private PrivateKey use_method_private_key;
    private PublicKey use_method_public_key;
    private long last_unlock_time;

    protected CryptoHandlerECC(CryptoManagerImpl _manager, int _instance_id) {
        this.manager = _manager;
        this.CONFIG_PREFIX = this.CONFIG_PREFIX + _instance_id + ".";
    }

    public void unlock(char[] password) throws CryptoManagerException {
        this.getMyPrivateKey(password, "");
    }

    public synchronized void lock() {
        this.use_method_private_key = null;
    }

    public int getUnlockTimeoutSeconds() {
        return COConfigurationManager.getIntParameter(this.CONFIG_PREFIX + "timeout", 3600);
    }

    public void setUnlockTimeoutSeconds(int secs) {
        COConfigurationManager.setParameter(this.CONFIG_PREFIX + "timeout", secs);
    }

    public byte[] sign(byte[] data, char[] password) throws CryptoManagerException {
        return this.sign(data, password, null);
    }

    public byte[] sign(byte[] data, String reason) throws CryptoManagerException {
        return this.sign(data, null, reason);
    }

    protected byte[] sign(byte[] data, char[] password, String reason) throws CryptoManagerException {
        PrivateKey priv = this.getMyPrivateKey(password, reason);
        Signature sig = this.getSignature(priv);
        try {
            sig.update(data);
            return sig.sign();
        }
        catch (Throwable e) {
            throw new CryptoManagerException("Signature failed", e);
        }
    }

    public boolean verify(byte[] public_key, byte[] data, byte[] signature) throws CryptoManagerException {
        PublicKey pub = this.rawdataToPubkey(public_key);
        Signature sig = this.getSignature(pub);
        try {
            sig.update(data);
            return sig.verify(signature);
        }
        catch (Throwable e) {
            throw new CryptoManagerException("Signature failed", e);
        }
    }

    public byte[] encrypt(byte[] other_public_key, byte[] data, char[] password) throws CryptoManagerException {
        return this.encrypt(other_public_key, data, password, null);
    }

    public byte[] encrypt(byte[] other_public_key, byte[] data, String reason) throws CryptoManagerException {
        return this.encrypt(other_public_key, data, null, reason);
    }

    protected byte[] encrypt(byte[] other_public_key, byte[] data, char[] password, String reason) throws CryptoManagerException {
        try {
            IEKeySpec key_spec = new IEKeySpec(this.getMyPrivateKey(password, reason), this.rawdataToPubkey(other_public_key));
            IESParameterSpec param = new IESParameterSpec(ECIES_D, ECIES_E, 128);
            InternalECIES cipher = new InternalECIES();
            cipher.internalEngineInit(1, key_spec, param, null);
            return cipher.internalEngineDoFinal(data, 0, data.length);
        }
        catch (CryptoManagerException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new CryptoManagerException("Encrypt failed", e);
        }
    }

    public byte[] decrypt(byte[] other_public_key, byte[] data, char[] password) throws CryptoManagerException {
        return this.decrypt(other_public_key, data, password, null);
    }

    public byte[] decrypt(byte[] other_public_key, byte[] data, String reason) throws CryptoManagerException {
        return this.decrypt(other_public_key, data, null, reason);
    }

    protected byte[] decrypt(byte[] other_public_key, byte[] data, char[] password, String reason) throws CryptoManagerException {
        try {
            IEKeySpec key_spec = new IEKeySpec(this.getMyPrivateKey(password, reason), this.rawdataToPubkey(other_public_key));
            IESParameterSpec param = new IESParameterSpec(ECIES_D, ECIES_E, 128);
            InternalECIES cipher = new InternalECIES();
            cipher.internalEngineInit(2, key_spec, param, null);
            return cipher.internalEngineDoFinal(data, 0, data.length);
        }
        catch (CryptoManagerException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new CryptoManagerException("Decrypt failed", e);
        }
    }

    public CryptoSTSEngine getSTSEngine(char[] password) throws CryptoManagerException {
        return this.getSTSEngine(password, null);
    }

    public CryptoSTSEngine getSTSEngine(String reason) throws CryptoManagerException {
        return this.getSTSEngine(null, reason);
    }

    protected CryptoSTSEngine getSTSEngine(char[] password, String reason) throws CryptoManagerException {
        return new CryptoSTSEngineImpl(this, this.getMyPublicKey(password, reason), this.getMyPrivateKey(password, reason));
    }

    public byte[] getPublicKey(char[] password) throws CryptoManagerException {
        return this.keyToRawdata(this.getMyPublicKey(password, null));
    }

    public byte[] getPublicKey(String reason) throws CryptoManagerException {
        return this.keyToRawdata(this.getMyPublicKey(null, reason));
    }

    protected byte[] getPublicKey(char[] password, String reason) throws CryptoManagerException {
        return this.keyToRawdata(this.getMyPublicKey(password, reason));
    }

    public byte[] getEncryptedPrivateKey(char[] password) throws CryptoManagerException {
        return this.getEncryptedPrivateKey(password, null);
    }

    public byte[] getEncryptedPrivateKey(String reason) throws CryptoManagerException {
        return this.getEncryptedPrivateKey(null, reason);
    }

    protected byte[] getEncryptedPrivateKey(char[] password, String reason) throws CryptoManagerException {
        this.getMyPrivateKey(password, reason);
        byte[] res = COConfigurationManager.getByteParameter(this.CONFIG_PREFIX + "privatekey", null);
        if (res == null) {
            throw new CryptoManagerException("Private key unavailable");
        }
        return res;
    }

    public synchronized void recoverKeys(byte[] public_key, byte[] encrypted_private_key) throws CryptoManagerException {
        this.use_method_private_key = null;
        this.use_method_public_key = null;
        COConfigurationManager.setParameter(this.CONFIG_PREFIX + "publickey", public_key);
        COConfigurationManager.setParameter(this.CONFIG_PREFIX + "privatekey", encrypted_private_key);
        COConfigurationManager.save();
    }

    public synchronized void resetKeys(char[] password) throws CryptoManagerException {
        this.use_method_private_key = null;
        this.use_method_public_key = null;
        COConfigurationManager.removeParameter(this.CONFIG_PREFIX + "publickey");
        COConfigurationManager.removeParameter(this.CONFIG_PREFIX + "privatekey");
        COConfigurationManager.save();
        this.createAndStoreKeys(password, "");
    }

    public synchronized void changePassword(char[] old_password, char[] new_password) throws CryptoManagerException {
        this.use_method_private_key = null;
        this.use_method_public_key = null;
        this.getMyPrivateKey(old_password, "");
        this.getMyPublicKey(old_password, "");
        this.storeKeys(new_password);
    }

    protected synchronized PrivateKey getMyPrivateKey(char[] password, String reason) throws CryptoManagerException {
        int timeout_secs;
        if (this.use_method_private_key != null && (timeout_secs = this.getUnlockTimeoutSeconds()) > 0 && SystemTime.getCurrentTime() - this.last_unlock_time >= (long)(timeout_secs * 1000)) {
            this.use_method_private_key = null;
        }
        if (this.use_method_private_key == null) {
            byte[] encoded = COConfigurationManager.getByteParameter(this.CONFIG_PREFIX + "privatekey", null);
            if (encoded == null) {
                this.createAndStoreKeys(password, reason);
            } else {
                if (password == null) {
                    password = this.manager.getPassword(1, 2, reason);
                }
                this.use_method_private_key = this.rawdataToPrivkey(this.manager.decryptWithPBE(encoded, password));
                this.last_unlock_time = SystemTime.getCurrentTime();
                boolean ok = false;
                try {
                    byte[] test_data = "test".getBytes();
                    ok = this.verify(this.keyToRawdata(this.getMyPublicKey(password, reason)), test_data, this.sign(test_data, password, reason));
                    if (!ok) {
                        throw new CryptoManagerPasswordException();
                    }
                }
                catch (CryptoManagerException e) {
                    throw e;
                }
                catch (Throwable e) {
                    throw new CryptoManagerException("Password incorrect", e);
                }
                finally {
                    if (!ok) {
                        this.use_method_private_key = null;
                    }
                }
            }
        }
        if (this.use_method_private_key == null) {
            throw new CryptoManagerException("Failed to get private key");
        }
        return this.use_method_private_key;
    }

    protected synchronized PublicKey getMyPublicKey(char[] password, String reason) throws CryptoManagerException {
        if (this.use_method_public_key == null) {
            byte[] key_bytes = COConfigurationManager.getByteParameter(this.CONFIG_PREFIX + "publickey", null);
            if (key_bytes == null) {
                this.createAndStoreKeys(password, reason);
            } else {
                this.use_method_public_key = this.rawdataToPubkey(key_bytes);
            }
        }
        if (this.use_method_public_key == null) {
            throw new CryptoManagerException("Failed to get public key");
        }
        return this.use_method_public_key;
    }

    protected void createAndStoreKeys(char[] password, String reason) throws CryptoManagerException {
        if (password == null) {
            password = this.manager.getPassword(1, 1, reason);
        }
        KeyPair keys = this.createKeys();
        this.use_method_public_key = keys.getPublic();
        this.use_method_private_key = keys.getPrivate();
        this.storeKeys(password);
    }

    protected void storeKeys(char[] password) throws CryptoManagerException {
        COConfigurationManager.setParameter(this.CONFIG_PREFIX + "publickey", this.keyToRawdata(this.use_method_public_key));
        byte[] priv_raw = this.keyToRawdata(this.use_method_private_key);
        byte[] priv_enc = this.manager.encryptWithPBE(priv_raw, password);
        COConfigurationManager.setParameter(this.CONFIG_PREFIX + "privatekey", priv_enc);
        COConfigurationManager.save();
    }

    protected KeyPair createKeys() throws CryptoManagerException {
        try {
            KeyPairGenerator keyGen = KeyPairGenerator.getInstance("ECDSA", "BC");
            keyGen.initialize(ECCparam);
            return keyGen.genKeyPair();
        }
        catch (Throwable e) {
            throw new CryptoManagerException("Failed to create keys", e);
        }
    }

    public Signature getSignature(Key key) throws CryptoManagerException {
        try {
            Signature ECCsig = Signature.getInstance("SHA1withECDSA", "BC");
            if (key instanceof ECPrivateKey) {
                ECCsig.initSign((ECPrivateKey)key);
            } else if (key instanceof ECPublicKey) {
                ECCsig.initVerify((ECPublicKey)key);
            } else {
                throw new CryptoManagerException("Invalid Key Type, ECC keys required");
            }
            return ECCsig;
        }
        catch (CryptoManagerException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new CryptoManagerException("Failed to create Signature", e);
        }
    }

    protected byte[] keyToRawdata(PrivateKey privkey) throws CryptoManagerException {
        if (!(privkey instanceof ECPrivateKey)) {
            throw new CryptoManagerException("Invalid private key");
        }
        return ((ECPrivateKey)privkey).getD().toByteArray();
    }

    protected PrivateKey rawdataToPrivkey(byte[] input) throws CryptoManagerException {
        BigInteger D = new BigInteger(input);
        ECPrivateKeySpec keyspec = new ECPrivateKeySpec(D, ECCparam);
        PrivateKey privkey = null;
        try {
            privkey = KeyFactory.getInstance("ECDSA", "BC").generatePrivate(keyspec);
            return privkey;
        }
        catch (Throwable e) {
            throw new CryptoManagerException("Failed to decode private key");
        }
    }

    protected byte[] keyToRawdata(PublicKey pubkey) throws CryptoManagerException {
        if (!(pubkey instanceof ECPublicKey)) {
            throw new CryptoManagerException("Invalid public key");
        }
        return ((ECPublicKey)pubkey).getQ().getEncoded();
    }

    protected PublicKey rawdataToPubkey(byte[] input) throws CryptoManagerException {
        ECPoint W = ECCparam.getCurve().decodePoint(input);
        ECPublicKeySpec keyspec = new ECPublicKeySpec(W, ECCparam);
        try {
            return KeyFactory.getInstance("ECDSA", "BC").generatePublic(keyspec);
        }
        catch (Throwable e) {
            throw new CryptoManagerException("Failed to decode private key");
        }
    }

    class InternalECIES
    extends JCEIESCipher.ECIES {
        InternalECIES() {
        }

        public void internalEngineInit(int opmode, Key key, AlgorithmParameterSpec params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
            this.engineInit(opmode, key, params, random);
        }

        protected byte[] internalEngineDoFinal(byte[] input, int inputOffset, int inputLen) throws IllegalBlockSizeException, BadPaddingException {
            return this.engineDoFinal(input, inputOffset, inputLen);
        }
    }
}

